/*
 * Decompiled with CFR 0.152.
 */
package com.miratech.nE2Link;

import com.miratech.nE2Link.BNanoBaseComponent;
import javax.baja.agent.AgentList;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BNanoComponent
extends BNanoBaseComponent {
    public static final Type TYPE = Sys.loadType(BNanoComponent.class);
    private static final String BACKUP_MANAGER_VIEW = "nE2Link:NanoBackupManager";
    private static final String ANALOG_BINARY_SCHEDULER_VIEW = "nE2Link:NanoScheduleView";
    private static final String CALENDAR_SCHEDULER_VIEW = "nE2Link:NanoCalendarView";
    private static final String SET_TIME_VIEW = "nE2Link:NanoSystemDateTimeEd";

    @Override
    public Type getType() {
        return TYPE;
    }

    public AgentList getAgents(Context cx) {
        AgentList agents = super.getAgents(cx);
        if (this.getIsLibraryComponent()) {
            agents.remove(BACKUP_MANAGER_VIEW);
            agents.remove(ANALOG_BINARY_SCHEDULER_VIEW);
            agents.remove(CALENDAR_SCHEDULER_VIEW);
            agents.remove(SET_TIME_VIEW);
        } else {
            String nanoName;
            switch (nanoName = this.getOriginNameFromLibrary()) {
                case "Framework.Core.SystemServices.BackupService": {
                    agents.toTop(BACKUP_MANAGER_VIEW);
                    agents.remove(ANALOG_BINARY_SCHEDULER_VIEW);
                    agents.remove(CALENDAR_SCHEDULER_VIEW);
                    agents.remove(SET_TIME_VIEW);
                    break;
                }
                case "Library.Schedules.AnalogSchedule": 
                case "Library.Schedules.BinarySchedule": 
                case "Library.Schedules.MultistateSchedule": {
                    agents.toTop(ANALOG_BINARY_SCHEDULER_VIEW);
                    agents.remove(BACKUP_MANAGER_VIEW);
                    agents.remove(CALENDAR_SCHEDULER_VIEW);
                    agents.remove(SET_TIME_VIEW);
                    break;
                }
                case "Library.Schedules.Calendar": {
                    agents.toTop(CALENDAR_SCHEDULER_VIEW);
                    agents.remove(BACKUP_MANAGER_VIEW);
                    agents.remove(ANALOG_BINARY_SCHEDULER_VIEW);
                    agents.remove(SET_TIME_VIEW);
                    break;
                }
                case "Framework.Core.Schema.PlatformTime": {
                    agents.toTop(SET_TIME_VIEW);
                    agents.remove(CALENDAR_SCHEDULER_VIEW);
                    agents.remove(BACKUP_MANAGER_VIEW);
                    agents.remove(ANALOG_BINARY_SCHEDULER_VIEW);
                    break;
                }
                default: {
                    agents.remove(BACKUP_MANAGER_VIEW);
                    agents.remove(ANALOG_BINARY_SCHEDULER_VIEW);
                    agents.remove(CALENDAR_SCHEDULER_VIEW);
                    agents.remove(SET_TIME_VIEW);
                }
            }
        }
        return agents;
    }
}

