/*
 * Decompiled with CFR 0.152.
 */
package com.miratech.nE2Link;

import com.miratech.nE2Link.BLibrary;
import com.miratech.nE2Link.BNanoBaseComponent;
import java.util.Arrays;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.IllegalParentException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="extensionId", type="int", defaultValue="-1", flags=65), @NiagaraProperty(name="isMultipleAllowed", type="boolean", defaultValue="false", flags=1), @NiagaraProperty(name="compatibleComponents", type="String", defaultValue="", flags=1)})
public class BNanoExtension
extends BNanoBaseComponent {
    public static final Property extensionId = BNanoExtension.newProperty((int)65, (int)-1, null);
    public static final Property isMultipleAllowed = BNanoExtension.newProperty((int)1, (boolean)false, null);
    public static final Property compatibleComponents = BNanoExtension.newProperty((int)1, (String)"", null);
    public static final Type TYPE = Sys.loadType(BNanoExtension.class);

    public int getExtensionId() {
        return this.getInt(extensionId);
    }

    public void setExtensionId(int v) {
        this.setInt(extensionId, v, null);
    }

    public boolean getIsMultipleAllowed() {
        return this.getBoolean(isMultipleAllowed);
    }

    public void setIsMultipleAllowed(boolean v) {
        this.setBoolean(isMultipleAllowed, v, null);
    }

    public String getCompatibleComponents() {
        return this.getString(compatibleComponents);
    }

    public void setCompatibleComponents(String v) {
        this.setString(compatibleComponents, v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public boolean isParentLegal(BComponent parent) {
        if (!Sys.isStationStarted()) {
            return true;
        }
        boolean valid = parent instanceof BLibrary && this.getIsLibraryComponent() || this.isValidForParent(parent);
        if (!valid & parent instanceof BNanoBaseComponent) {
            BNanoBaseComponent host = (BNanoBaseComponent)parent;
            throw new IllegalParentException(BNanoExtension.LEX.module.getModuleName(), "ILLEGAL_EXTENSION", new Object[]{this.getDefaultPropertyName(host), String.valueOf(this.getTypeId()), this.getCompatibleComponents(), host.getOriginNameFromLibrary()});
        }
        return valid;
    }

    private boolean isValidForParent(BComponent parent) {
        boolean isValid = false;
        if (parent instanceof BNanoBaseComponent) {
            BNanoBaseComponent parentComponent = (BNanoBaseComponent)parent;
            String compatibleComponents = this.getCompatibleComponents();
            boolean bl = isValid = compatibleComponents.isEmpty() || compatibleComponents.contains(parentComponent.getOriginNameFromLibrary()) || compatibleComponents.contains(parentComponent.getBaseName());
            if (!isValid) {
                isValid = Arrays.stream(parentComponent.getInterfaces().split(";")).anyMatch(interfaceName -> compatibleComponents.contains(interfaceName.trim()));
            }
        }
        return isValid;
    }

    public int makeValidExtensionId(BNanoBaseComponent parent) {
        int extensionId = this.getExtensionId();
        if (extensionId == -1) {
            BNanoExtension[] existingExtensions;
            for (BNanoExtension extension : existingExtensions = (BNanoExtension[])parent.getChildren(BNanoExtension.class)) {
                if (extension.getExtensionId() <= extensionId) continue;
                extensionId = extension.getExtensionId();
            }
            ++extensionId;
        }
        this.setExtensionId(extensionId);
        return extensionId;
    }

    public String getDefaultPropertyName(BNanoBaseComponent parent) {
        String defaultName = this.getOriginNameFromLibrary();
        int lastIndexOfDot = defaultName.lastIndexOf(46) + 1;
        if (defaultName.length() - lastIndexOfDot > 0) {
            defaultName = defaultName.substring(lastIndexOfDot);
        }
        return SlotPath.escape((String)defaultName) + this.makeValidExtensionId(parent);
    }

    public String getPropertyNameOnHost(Property extensionProperty) {
        if (this.getParent() != null && this.getExtensionId() != -1) {
            return "e" + this.getExtensionId() + "_" + extensionProperty.getName();
        }
        return null;
    }
}

