/*
 * Decompiled with CFR 0.152.
 */
package com.miratech.nE2Link;

import com.miratech.nE2Link.BNanoBaseComponent;
import com.miratech.nE2Link.jobs.BLogFilter;
import com.miratech.nE2Link.notifications.BLogFetchNotification;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraActions(value={@NiagaraAction(name="dumpLog", parameterType="BLogFilter", defaultValue="new BLogFilter()", flags=16), @NiagaraAction(name="dumpLogForDateRange", parameterType="BLogFilter", defaultValue="new BLogFilter()", flags=16), @NiagaraAction(name="dumpLogForLast24h", parameterType="BLogFilter", defaultValue="new BLogFilter()", flags=16), @NiagaraAction(name="dumpLogForToday", parameterType="BLogFilter", defaultValue="new BLogFilter()", flags=16), @NiagaraAction(name="dumpLogForLast7Days", parameterType="BLogFilter", defaultValue="new BLogFilter()", flags=16)})
public class BNanoLogService
extends BNanoBaseComponent {
    public static final Action dumpLog = BNanoLogService.newAction((int)16, (BValue)new BLogFilter(), null);
    public static final Action dumpLogForDateRange = BNanoLogService.newAction((int)16, (BValue)new BLogFilter(), null);
    public static final Action dumpLogForLast24h = BNanoLogService.newAction((int)16, (BValue)new BLogFilter(), null);
    public static final Action dumpLogForToday = BNanoLogService.newAction((int)16, (BValue)new BLogFilter(), null);
    public static final Action dumpLogForLast7Days = BNanoLogService.newAction((int)16, (BValue)new BLogFilter(), null);
    public static final Type TYPE = Sys.loadType(BNanoLogService.class);

    public void dumpLog(BLogFilter parameter) {
        this.invoke(dumpLog, (BValue)parameter, null);
    }

    public void dumpLogForDateRange(BLogFilter parameter) {
        this.invoke(dumpLogForDateRange, (BValue)parameter, null);
    }

    public void dumpLogForLast24h(BLogFilter parameter) {
        this.invoke(dumpLogForLast24h, (BValue)parameter, null);
    }

    public void dumpLogForToday(BLogFilter parameter) {
        this.invoke(dumpLogForToday, (BValue)parameter, null);
    }

    public void dumpLogForLast7Days(BLogFilter parameter) {
        this.invoke(dumpLogForLast7Days, (BValue)parameter, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public BValue getActionParameterDefault(Action action) {
        Object actionParameterDefault = super.getActionParameterDefault(action);
        if (action.equals(dumpLog)) {
            BLogFilter logFilter = (BLogFilter)((Object)actionParameterDefault);
            logFilter.setControllerOrd(this.getNe2DeviceExt().getHandleOrd());
            logFilter.setFlags((Slot)BLogFilter.startTime, logFilter.getFlags((Slot)BLogFilter.startTime) | 4);
            logFilter.setFlags((Slot)BLogFilter.endTime, logFilter.getFlags((Slot)BLogFilter.endTime) | 4);
            actionParameterDefault = logFilter;
        } else if (action.equals(dumpLogForDateRange)) {
            BLogFilter logFilter = (BLogFilter)((Object)actionParameterDefault);
            logFilter.setControllerOrd(this.getNe2DeviceExt().getHandleOrd());
            BAbsTime endTime = this.sameTimeAsUTC(BAbsTime.now());
            BAbsTime startTime = endTime.prevDay();
            logFilter.setEndTime(endTime);
            logFilter.setStartTime(startTime);
            actionParameterDefault = logFilter;
        } else if (action.equals(dumpLogForLast24h)) {
            BLogFilter logFilter = (BLogFilter)((Object)actionParameterDefault);
            logFilter.setControllerOrd(this.getNe2DeviceExt().getHandleOrd());
            logFilter.setFlags((Slot)BLogFilter.startTime, logFilter.getFlags((Slot)BLogFilter.startTime) | 4);
            logFilter.setFlags((Slot)BLogFilter.endTime, logFilter.getFlags((Slot)BLogFilter.endTime) | 4);
            BAbsTime endTime = this.sameTimeAsUTC(BAbsTime.now());
            BAbsTime startTime = endTime.prevDay();
            logFilter.setEndTime(endTime);
            logFilter.setStartTime(startTime);
            actionParameterDefault = logFilter;
        } else if (action.equals(dumpLogForToday)) {
            BLogFilter logFilter = (BLogFilter)((Object)actionParameterDefault);
            logFilter.setControllerOrd(this.getNe2DeviceExt().getHandleOrd());
            logFilter.setFlags((Slot)BLogFilter.startTime, logFilter.getFlags((Slot)BLogFilter.startTime) | 4);
            logFilter.setFlags((Slot)BLogFilter.endTime, logFilter.getFlags((Slot)BLogFilter.endTime) | 4);
            BAbsTime endTime = this.sameTimeAsUTC(BAbsTime.now().timeOfDay(23, 59, 59, 999));
            BAbsTime startTime = endTime.timeOfDay(0, 0, 0, 0);
            logFilter.setEndTime(endTime);
            logFilter.setStartTime(startTime);
            actionParameterDefault = logFilter;
        } else if (action.equals(dumpLogForLast7Days)) {
            BLogFilter logFilter = (BLogFilter)((Object)actionParameterDefault);
            logFilter.setControllerOrd(this.getNe2DeviceExt().getHandleOrd());
            logFilter.setFlags((Slot)BLogFilter.startTime, logFilter.getFlags((Slot)BLogFilter.startTime) | 4);
            logFilter.setFlags((Slot)BLogFilter.endTime, logFilter.getFlags((Slot)BLogFilter.endTime) | 4);
            BAbsTime endTime = this.sameTimeAsUTC(BAbsTime.now().nextDay().timeOfDay(0, 0, 0, 0));
            BAbsTime startTime = endTime.subtract(BRelTime.makeDays((int)7));
            logFilter.setEndTime(endTime);
            logFilter.setStartTime(startTime);
            actionParameterDefault = logFilter;
        }
        return actionParameterDefault;
    }

    private BAbsTime sameTimeAsUTC(BAbsTime time) {
        return time.toUtcTime().add(BRelTime.make((long)time.getTimeZone().getCurrentUtcOffset(time.getMillis())));
    }

    public void doDumpLog(BLogFilter logFilter, Context context) {
        BLogFetchNotification logFetchNotification = BLogFetchNotification.make(logFilter);
        logFetchNotification.raise(context);
    }

    public void doDumpLogForDateRange(BLogFilter logFilter, Context context) {
        BLogFetchNotification logFetchNotification = BLogFetchNotification.make(logFilter);
        logFetchNotification.raise(context);
    }

    public void doDumpLogForLast24h(BLogFilter logFilter, Context context) {
        BLogFetchNotification logFetchNotification = BLogFetchNotification.make(logFilter);
        logFetchNotification.raise(context);
    }

    public void doDumpLogForToday(BLogFilter logFilter, Context context) {
        BLogFetchNotification logFetchNotification = BLogFetchNotification.make(logFilter);
        logFetchNotification.raise(context);
    }

    public void doDumpLogForLast7Days(BLogFilter logFilter, Context context) {
        BLogFetchNotification logFetchNotification = BLogFetchNotification.make(logFilter);
        logFetchNotification.raise(context);
    }
}

