/*
 * Decompiled with CFR 0.152.
 */
package com.miratech.nE2Link;

import com.miratech.nE2Link.BNanoBaseComponent;
import com.miratech.nE2Link.BNanoExtension;
import com.miratech.nE2Link.BUnitMap;
import com.tridium.sys.Nre;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.space.BComponentSpace;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BNumber;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.units.BUnitConversion;
import javax.baja.util.BFormat;

@NiagaraType
@NiagaraProperty(name="value", type="double", defaultValue="0.0d")
public class BNanoStatusNumeric
extends BStatusNumeric {
    public static final Property value = BNanoStatusNumeric.newProperty((int)0, (double)0.0, null);
    public static final Type TYPE = Sys.loadType(BNanoStatusNumeric.class);
    private static final BIcon icon = BIcon.std((String)"statusNumeric.png");
    public static final BFormat FORMAT_FOR_DISPLAY_UNIT = BFormat.make((String)"%getDisplayUnit%");
    public static final BFormat FORMAT_FOR_UNIT_ORDINAL = BFormat.make((String)"%parent.units.value.ordinal%");
    private static final String NANO_FORMAT_ATTRIB = "nano_attr_caption";
    private static final String FACET_NAME_DESIRED_UNITS = "desiredUnits";
    private static Map<String, DecimalFormat> valueFormatters = new HashMap<String, DecimalFormat>();
    private static Map<String, BFormat> outputFormatters = new HashMap<String, BFormat>();
    private static Map<BComponent, Map<Property, List<Property>>> dependentProperties = new HashMap<BComponent, Map<Property, List<Property>>>();

    public double getValue() {
        return this.getDouble(value);
    }

    public void setValue(double v) {
        this.setDouble(value, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BNanoStatusNumeric(double value, BStatus status) {
        super(value, status);
    }

    public BNanoStatusNumeric(double value) {
        super(value);
    }

    public BNanoStatusNumeric() {
    }

    public String valueToString(Context context) {
        BComponentSpace componentSpace;
        double value = this.getValue();
        if (context == null || context.getFacet(NANO_FORMAT_ATTRIB) == null) {
            return BDouble.toString((double)value, (Context)context);
        }
        BComponent parentComponent = this.getParentComponent();
        if (null != parentComponent && null != (componentSpace = parentComponent.getComponentSpace()) && componentSpace.isProxyComponentSpace()) {
            parentComponent.lease(1);
        }
        String valueString = "";
        for (int retries = 0; retries < 2; ++retries) {
            BasicContext unitNoShowContext;
            BFormat outputFormat = this.getOutputFormatter(context);
            if (outputFormat == null) {
                return BDouble.toString((double)value, (Context)context);
            }
            BUnit unit = this.getUnit(context);
            BFacets facets = BFacets.make((String)"showUnits", (BIDataValue)BBoolean.FALSE);
            if (unit != null) {
                BUnitConversion unitConversion;
                BUnit desiredUnit;
                facets = BFacets.make((BFacets)facets, (BFacets)BFacets.make((String)"units", (BIDataValue)unit));
                int convert = Nre.unitConversion;
                convert = context.getFacets().geti("unitConversion", convert);
                if (convert != 0 && (desiredUnit = (unitConversion = BUnitConversion.make((int)convert)).getDesiredUnit(unit)) != unit) {
                    facets = BFacets.make((BFacets)facets, (BFacets)BFacets.make((String)FACET_NAME_DESIRED_UNITS, (BIDataValue)desiredUnit));
                }
            }
            if (!(valueString = outputFormat.format((Object)this, (Context)(unitNoShowContext = new BasicContext(context, facets)))).contains("%err:")) {
                return valueString;
            }
            this.removeOutputFormatter(context);
        }
        return valueString;
    }

    public String valueValueToString(Context context) {
        int prec = 2;
        int radix = 10;
        boolean showSeparators = false;
        boolean forceSign = false;
        BUnit unit = null;
        BUnit desiredUnit = null;
        double value = this.getValue();
        if (context != null) {
            BNumber radixFacet;
            BNumber precFacet = (BNumber)context.getFacet("precision");
            if (precFacet != null) {
                prec = precFacet.getInt();
            }
            unit = (BUnit)context.getFacet("units");
            desiredUnit = (BUnit)context.getFacet(FACET_NAME_DESIRED_UNITS);
            if (desiredUnit == null) {
                desiredUnit = unit;
            }
            if ((radixFacet = (BNumber)context.getFacet("radix")) != null) {
                radix = radixFacet.getInt();
            }
            showSeparators = context.getFacets().getb("showSeparators", showSeparators);
            forceSign = context.getFacets().getb("forceSign", forceSign);
        }
        if (unit != null && unit != desiredUnit) {
            value = unit.convertTo(desiredUnit, value);
        }
        String s = "";
        if (value == Double.POSITIVE_INFINITY) {
            s = s + "+inf";
        } else if (value == Double.NEGATIVE_INFINITY) {
            s = s + "-inf";
        } else if (Double.isNaN(value)) {
            s = s + "nan";
        } else if (radix != 10) {
            if ((long)Math.abs(value) >= 0x20000000000000L) {
                BigInteger number = BigDecimal.valueOf(value).toBigInteger();
                s = s + number.toString(radix);
            } else {
                s = (long)Math.abs(value) >= Integer.MAX_VALUE ? (radix == 2 ? s + Long.toBinaryString((int)value) : (radix == 8 ? s + Long.toOctalString((int)value) : (radix == 16 ? s + Long.toHexString((int)value) : s + Long.toString((long)value, radix)))) : (radix == 2 ? s + Integer.toBinaryString((int)value) : (radix == 8 ? s + Integer.toOctalString((int)value) : (radix == 16 ? s + Integer.toHexString((int)value) : s + Integer.toString((int)value, radix))));
            }
        } else if (Math.IEEEremainder(value, 1.0) == 0.0) {
            s = s + BNanoStatusNumeric.addForcedSign(forceSign, value);
            boolean useScientificNotation = (long)Math.abs(value) >= 0x20000000000000L;
            s = s + BNanoStatusNumeric.getValueFormatter(prec, showSeparators, useScientificNotation, context).format(value);
        } else {
            s = s + BNanoStatusNumeric.addForcedSign(forceSign, value);
            s = s + BNanoStatusNumeric.getValueFormatter(prec, showSeparators, false, context).format(value);
        }
        return s;
    }

    public String getDisplayUnit(Context context) {
        BUnit desiredUnit = (BUnit)context.getFacet(FACET_NAME_DESIRED_UNITS);
        BUnit unit = (BUnit)context.getFacet("units");
        if (desiredUnit != null) {
            return !desiredUnit.isNull() ? desiredUnit.getSymbol(context) : "";
        }
        if (unit != null && !unit.isNull()) {
            return unit.getSymbol(context);
        }
        return "";
    }

    public BUnit getUnit(Context context) {
        BUnit niagaraUnit = null;
        BUnit nanoUnit = null;
        BUnit unit = null;
        if (context != null) {
            BFormat outputFormat;
            niagaraUnit = (BUnit)context.getFacet("units");
            if (niagaraUnit != null && niagaraUnit.isNull()) {
                niagaraUnit = null;
            }
            if ((outputFormat = this.getOutputFormatter(context)) != null && outputFormat.getFormat().contains(FORMAT_FOR_DISPLAY_UNIT.getFormat())) {
                try {
                    Integer ordinal = Integer.valueOf(FORMAT_FOR_UNIT_ORDINAL.format((Object)this));
                    nanoUnit = BUnitMap.getNiagaraUnit(ordinal);
                }
                catch (Exception e) {
                    nanoUnit = null;
                }
            }
            unit = null != nanoUnit ? nanoUnit : niagaraUnit;
        }
        return unit;
    }

    static String addForcedSign(boolean forceSign, double value) {
        return forceSign && value > 0.0 ? "+" : "";
    }

    static DecimalFormat getValueFormatter(int precision, boolean showSeparators, boolean useScientificNotation, Context cx) {
        String userLang = Context.getLanguageTag((Context)cx);
        String key = "" + precision + showSeparators + useScientificNotation + userLang;
        DecimalFormat formatter = valueFormatters.get(key);
        if (formatter == null) {
            StringBuilder pattern = new StringBuilder(16);
            if (useScientificNotation) {
                pattern.append("0.###############E0");
            } else {
                if (showSeparators) {
                    pattern.append("#,##0");
                } else {
                    pattern.append("#0");
                }
                if (precision > 0) {
                    pattern.append('.');
                    for (int i = 0; i < precision; ++i) {
                        pattern.append('0');
                    }
                }
            }
            formatter = !userLang.equals("") ? new DecimalFormat(pattern.toString(), DecimalFormatSymbols.getInstance(Locale.forLanguageTag(userLang))) : new DecimalFormat(pattern.toString());
            valueFormatters.put(key, formatter);
        }
        return formatter;
    }

    private void removeOutputFormatter(Context cx) {
        String nanoFormatString = cx != null ? cx.getFacets().gets(NANO_FORMAT_ATTRIB, null) : null;
        BComplex parent = this.getParent();
        if (nanoFormatString == null || nanoFormatString.isEmpty() || parent == null) {
            return;
        }
        String key = nanoFormatString + "@" + (parent instanceof BComponent ? ((BComponent)parent).getHandleOrd().toString() : parent.toDebugString());
        outputFormatters.remove(key);
    }

    private BFormat getOutputFormatter(Context cx) {
        String nanoFormatString = cx != null ? cx.getFacets().gets(NANO_FORMAT_ATTRIB, null) : null;
        BComplex parent = this.getParent();
        if (nanoFormatString == null || nanoFormatString.isEmpty() || parent == null) {
            return null;
        }
        String key = nanoFormatString + "@" + (parent instanceof BComponent ? ((BComponent)parent).getHandleOrd().toString() : parent.toDebugString());
        BFormat outputFormat = outputFormatters.get(key);
        if (outputFormat == null) {
            int processingIndex = 0;
            String outputFormatString = "";
            Property me = this.getPropertyInParent();
            while (processingIndex < nanoFormatString.length()) {
                int scriptStart = nanoFormatString.indexOf(123, processingIndex);
                if (scriptStart != -1) {
                    int scriptEnd = nanoFormatString.indexOf(125, processingIndex);
                    if (scriptEnd > -1) {
                        String niagaraScript;
                        String script = nanoFormatString.substring(scriptStart, scriptEnd + 1);
                        String regex = "\\{slot:(.*?)<(.*?)>(.*?)\\}";
                        String prefix = script.replaceAll(regex, "$1");
                        String slotName = script.replaceAll(regex, "$2");
                        String suffix = script.replaceAll(regex, "$3");
                        Property property = null;
                        switch (slotName) {
                            case "this": {
                                niagaraScript = prefix + "%valueValueToString%" + suffix;
                                break;
                            }
                            case "units": {
                                niagaraScript = prefix + "%getDisplayUnit%" + suffix;
                                property = null != parent ? parent.getProperty(slotName) : null;
                                break;
                            }
                            default: {
                                Property property2 = property = null != parent ? parent.getProperty(slotName) : null;
                                if (property == null && null != parent) {
                                    BNanoExtension[] extensions;
                                    for (BNanoExtension extension : extensions = (BNanoExtension[])((BComponent)parent).getChildren(BNanoExtension.class)) {
                                        Property extProperty = extension.getProperty(slotName);
                                        if (extProperty == null) continue;
                                        slotName = extension.getPropertyNameOnHost(extProperty);
                                        if (slotName != null) {
                                            property = parent.getProperty(slotName);
                                            break;
                                        }
                                        property = this.searchExtensionPropertyOnHost(parent, extProperty);
                                        if (property == null) break;
                                        slotName = property.getName();
                                        break;
                                    }
                                }
                                if (property != null && property.getTypeAccess() == 7) {
                                    niagaraScript = "parent." + slotName;
                                    if (property.getType().is(BStatusValue.TYPE)) {
                                        niagaraScript = niagaraScript + ".valueToString";
                                    }
                                } else {
                                    niagaraScript = "";
                                }
                                if (niagaraScript.isEmpty()) break;
                                niagaraScript = prefix + '%' + niagaraScript + '%' + suffix;
                            }
                        }
                        if (!niagaraScript.isEmpty() && !slotName.equals("this") && parent instanceof BNanoBaseComponent) {
                            ((BNanoBaseComponent)parent).addTriggerProperty(property.getName(), me.getName(), cx);
                        }
                        String literalsBeforeScript = nanoFormatString.substring(processingIndex, scriptStart);
                        outputFormatString = outputFormatString + literalsBeforeScript + niagaraScript;
                        processingIndex = scriptEnd + 1;
                        continue;
                    }
                    processingIndex = nanoFormatString.length();
                    continue;
                }
                outputFormatString = outputFormatString + nanoFormatString.substring(processingIndex);
                processingIndex = nanoFormatString.length();
            }
            outputFormat = BFormat.make((String)outputFormatString);
            outputFormatters.put(key, outputFormat);
        }
        return outputFormat;
    }

    public Property searchExtensionPropertyOnHost(BComplex parent, Property propInExtension) {
        Property[] properties;
        String propNameInExtension = propInExtension.getName();
        for (Property property : properties = parent.getDynamicPropertiesArray()) {
            if (!property.getName().matches("e\\d_" + propNameInExtension + ".*")) continue;
            return property;
        }
        return null;
    }
}

