/*
 * Decompiled with CFR 0.152.
 */
package com.miratech.nE2Link;

import com.miratech.nE2Link.IBitsAsInteger;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Objects;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BBitString;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

@NiagaraType
public final class BSlotMetaDataFlags
extends BBitString
implements IBitsAsInteger {
    private static final Lexicon LEX = Lexicon.make(BSlotMetaDataFlags.class);
    private static final String BITS_LEAD_IN = "bits:";
    private static final int FLAGS_MASK = 255;
    public static final int HAS_VALUE = 1;
    public static final int IS_HIDDEN = 2;
    public static final int IS_NULLABLE = 4;
    public static final int IS_READONLY = 8;
    public static final int IS_PERSISTENT = 16;
    public static final BSlotMetaDataFlags hasValue = (BSlotMetaDataFlags)new BSlotMetaDataFlags(1).intern();
    public static final BSlotMetaDataFlags isHidden = (BSlotMetaDataFlags)new BSlotMetaDataFlags(2).intern();
    public static final BSlotMetaDataFlags isNullable = (BSlotMetaDataFlags)new BSlotMetaDataFlags(4).intern();
    public static final BSlotMetaDataFlags isReadOnly = (BSlotMetaDataFlags)new BSlotMetaDataFlags(8).intern();
    public static final BSlotMetaDataFlags isPersistent = (BSlotMetaDataFlags)new BSlotMetaDataFlags(16).intern();
    public static final BSlotMetaDataFlags NULL;
    public static final BSlotMetaDataFlags DEFAULT;
    private final int _bits;
    private static final BBitString.Support support;
    public static final Type TYPE;

    private BSlotMetaDataFlags(int bits) {
        this._bits = bits & 0xFF;
    }

    public static BSlotMetaDataFlags make(int bits) {
        if (bits == BSlotMetaDataFlags.NULL._bits) {
            return NULL;
        }
        if (bits == BSlotMetaDataFlags.DEFAULT._bits) {
            return DEFAULT;
        }
        return new BSlotMetaDataFlags(bits);
    }

    public static BSlotMetaDataFlags make(BSlotMetaDataFlags orig, int bitToChange, boolean newBitState) {
        int newBits;
        int n = newBits = newBitState ? orig._bits | bitToChange : orig._bits & ~bitToChange;
        if (orig._bits == newBits) {
            return orig;
        }
        return BSlotMetaDataFlags.make(newBits);
    }

    public static BSlotMetaDataFlags makeHasValue(BSlotMetaDataFlags orig, boolean bitState) {
        return BSlotMetaDataFlags.make(orig, 1, bitState);
    }

    public static BSlotMetaDataFlags makeHidden(BSlotMetaDataFlags orig, boolean bitState) {
        return BSlotMetaDataFlags.make(orig, 2, bitState);
    }

    public static BSlotMetaDataFlags makeNullable(BSlotMetaDataFlags orig, boolean bitState) {
        return BSlotMetaDataFlags.make(orig, 4, bitState);
    }

    public static BSlotMetaDataFlags makeReadOnly(BSlotMetaDataFlags orig, boolean bitState) {
        return BSlotMetaDataFlags.make(orig, 8, bitState);
    }

    public static BSlotMetaDataFlags makePersistent(BSlotMetaDataFlags orig, boolean bitState) {
        return BSlotMetaDataFlags.make(orig, 16, bitState);
    }

    public boolean hasValue() {
        return (this._bits & 1) != 0;
    }

    public boolean isHidden() {
        return (this._bits & 2) != 0;
    }

    public boolean isNullable() {
        return (this._bits & 4) != 0;
    }

    public boolean isReadOnly() {
        return (this._bits & 8) != 0;
    }

    public boolean isPersistent() {
        return (this._bits & 0x10) != 0;
    }

    public boolean getBit(int ordinal) {
        return (this._bits & ordinal) != 0;
    }

    public boolean getBit(String tag) {
        return this.getBit(this.tagToOrdinal(tag));
    }

    public int[] getOrdinals() {
        return support.getOrdinals();
    }

    public boolean isOrdinal(int ordinal) {
        return support.isOrdinal(ordinal);
    }

    public String getTag(int ordinal) {
        return support.getTag(ordinal);
    }

    public String getDisplayTag(int ordinal, Context cx) {
        return support.getDisplayTag(ordinal, cx);
    }

    public BBitString getInstance(int[] ordinals) {
        int mask = 0;
        for (int i = 0; i < ordinals.length; ++i) {
            mask |= ordinals[i];
        }
        return BSlotMetaDataFlags.make(mask);
    }

    public boolean isTag(String tag) {
        return support.isTag(tag);
    }

    public int tagToOrdinal(String tag) {
        return support.tagToOrdinal(tag);
    }

    public boolean isEmpty() {
        return this._bits == 0;
    }

    public String getEmptyTag() {
        return "none";
    }

    @Override
    public int getBits() {
        return this._bits;
    }

    public String getShortDisplayTag(int ordinal, Context cx) {
        return LEX.getText(TYPE.getTypeName() + "." + this.getTag(ordinal) + "_short");
    }

    public void encode(DataOutput out) throws IOException {
        out.writeInt(this._bits);
    }

    public BObject decode(DataInput in) throws IOException {
        return BSlotMetaDataFlags.make(in.readInt());
    }

    public String encodeToString() throws IOException {
        return BITS_LEAD_IN + Integer.toHexString(this._bits);
    }

    public BObject decodeFromString(String s) throws IOException {
        try {
            return BSlotMetaDataFlags.make(Integer.parseUnsignedInt(s.replace(BITS_LEAD_IN, ""), 16));
        }
        catch (Exception e) {
            throw new IOException("Invalid bits: " + s);
        }
    }

    public int hashCode() {
        return Objects.hash(this._bits);
    }

    public boolean equals(Object obj) {
        if (obj instanceof BSlotMetaDataFlags) {
            return ((BSlotMetaDataFlags)obj)._bits == this._bits;
        }
        return false;
    }

    public String toString(Context context) {
        if (this._bits == 0) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder("{");
        int[] ordinals = this.getOrdinals();
        for (int i = 0; i < ordinals.length; ++i) {
            int ordinal = ordinals[i];
            if (!this.getBit(ordinal)) continue;
            sb.append(this.getShortDisplayTag(ordinal, context));
            sb.append(", ");
        }
        sb.setLength(sb.length() - 2);
        sb.append("}");
        return sb.toString();
    }

    public Type getType() {
        return TYPE;
    }

    static {
        DEFAULT = NULL = new BSlotMetaDataFlags(0);
        support = new BBitString.Support((BBitString)DEFAULT);
        support.add(1, "hasValue");
        support.add(2, "isHidden");
        support.add(4, "isNullable");
        support.add(8, "isReadOnly");
        support.add(16, "isPersistent");
        TYPE = Sys.loadType(BSlotMetaDataFlags.class);
    }
}

