/*
 * Decompiled with CFR 0.152.
 */
package com.miratech.nE2Link;

import com.miratech.nE2Link.BNanoBase;
import com.miratech.nE2Link.parser.xml.XParserEx;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import javax.baja.file.types.text.BXmlFile;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BDimension;
import javax.baja.units.BUnit;
import javax.baja.units.UnitException;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;

@NiagaraType
public class BUnitMap
extends BNanoBase {
    public static final Type TYPE = Sys.loadType(BUnitMap.class);
    public static final String ELEM_NAME_UNIT = "unit";
    public static final String ATTRIB_NAME_NANO = "nano";
    public static final String ATTRIB_NAME_NIAGARA = "niagara";
    public static final String ATTRIB_SYMBOL_NIAGARA = "s";
    public static final String ATTRIB_SCALE_NIAGARA = "scale";
    public static final String ATTRIB_DIMENSION_NIAGARA = "dim";
    public static final String ATTRIB_DIMENSION_M_NIAGARA = "dim-m";
    public static final String ATTRIB_DIMENSION_KG_NIAGARA = "dim-kg";
    public static final String ATTRIB_DIMENSION_S_NIAGARA = "dim-s";
    public static final String ATTRIB_DIMENSION_A_NIAGARA = "dim-A";
    public static final String ATTRIB_DIMENSION_K_NIAGARA = "dim-K";
    public static final String ATTRIB_DIMENSION_MOL_NIAGARA = "dim-mol";
    public static final String ATTRIB_DIMENSION_CD_NIAGARA = "dim-cd";
    public static final String ATTRIB_DIMENSION_DOL_NIAGARA = "dim-dol";
    private static boolean _isInitialized = false;
    private static HashMap<Integer, BUnit> _nanoToNiagaraMap = new HashMap();
    private static HashMap<BUnit, Integer> _niagaraToNanoMap = new HashMap();

    @Override
    public Type getType() {
        return TYPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void initialize() {
        BXmlFile applicationFile;
        String moduleName = TYPE.getModule().getModuleName();
        BOrd mapOrd = BOrd.make((String)("module://" + moduleName + "/rc/conversion/unitMap.xml"));
        XElem xmlRoot = null;
        try {
            applicationFile = (BXmlFile)mapOrd.resolve().get();
        }
        catch (Exception e) {
            LOGGER.severe("CANNOT FIND FILE '" + mapOrd + "'");
            throw e;
        }
        try {
            XParser xParser = XParser.make((InputStream)applicationFile.getInputStream());
            xmlRoot = xParser.parse();
        }
        catch (Exception e) {
            LOGGER.severe("Failed to parse unitMap XML File\n     File Space: " + applicationFile.getFileSpace() + "\n     File Name: " + applicationFile.getFileName() + "\n     File Path: " + applicationFile.getFilePath());
        }
        finally {
            try {
                applicationFile.getInputStream().close();
            }
            catch (IOException e) {}
        }
        if (xmlRoot == null) {
            LOGGER.severe("No content in unitMap XML File");
            return;
        }
        XElem[] xmlUnits = xmlRoot.elems(ELEM_NAME_UNIT);
        if (xmlUnits.length == 0) {
            LOGGER.warning("Empty unitMap XML File: No units defined");
            return;
        }
        for (XElem xmlUnit : xmlUnits) {
            Integer nanoUnitId = XParserEx.readIntegerFromXMLAttribute(xmlUnit, ATTRIB_NAME_NANO);
            String niagaraUnitName = XParserEx.readStringFromXMLAttribute(xmlUnit, ATTRIB_NAME_NIAGARA);
            if (nanoUnitId == null || niagaraUnitName == null || niagaraUnitName.length() == 0) {
                LOGGER.severe("Cannot load unit from unitMap. \nSkipping XML Element: " + xmlUnit);
                continue;
            }
            BUnit niagaraUnit = BUnitMap.checkNiagaraUnitExistence(niagaraUnitName);
            if (niagaraUnit.isNull()) {
                niagaraUnit = BUnitMap.addMissingUnit(xmlUnit);
            }
            _nanoToNiagaraMap.put(nanoUnitId, niagaraUnit);
            _niagaraToNanoMap.put(niagaraUnit, nanoUnitId);
        }
        _isInitialized = true;
    }

    public static Integer getNanoUnitId(BUnit niagaraUnit) {
        if (!_isInitialized) {
            BUnitMap.initialize();
        }
        return _niagaraToNanoMap.get(niagaraUnit);
    }

    public static BUnit getNiagaraUnit(Integer nanoUnitId) {
        if (!_isInitialized) {
            BUnitMap.initialize();
        }
        return _nanoToNiagaraMap.get(nanoUnitId);
    }

    private static BUnit addMissingUnit(XElem xmlUnit) {
        String niagaraUnitName = XParserEx.readStringFromXMLAttribute(xmlUnit, ATTRIB_NAME_NIAGARA);
        String niagaraSymbol = XParserEx.readStringFromXMLAttribute(xmlUnit, ATTRIB_SYMBOL_NIAGARA);
        Double niagaraScale = XParserEx.readDoubleFromXMLAttribute(xmlUnit, ATTRIB_SCALE_NIAGARA);
        String niagaraDimension = XParserEx.readStringFromXMLAttribute(xmlUnit, ATTRIB_DIMENSION_NIAGARA);
        int niagaraDimensionM = XParserEx.readIntegerFromXMLAttribute(xmlUnit, ATTRIB_DIMENSION_M_NIAGARA);
        int niagaraDimensionKg = XParserEx.readIntegerFromXMLAttribute(xmlUnit, ATTRIB_DIMENSION_KG_NIAGARA);
        int niagaraDimensionS = XParserEx.readIntegerFromXMLAttribute(xmlUnit, ATTRIB_DIMENSION_S_NIAGARA);
        int niagaraDimensionA = XParserEx.readIntegerFromXMLAttribute(xmlUnit, ATTRIB_DIMENSION_A_NIAGARA);
        int niagaraDimensionK = XParserEx.readIntegerFromXMLAttribute(xmlUnit, ATTRIB_DIMENSION_K_NIAGARA);
        int niagaraDimensionMol = XParserEx.readIntegerFromXMLAttribute(xmlUnit, ATTRIB_DIMENSION_MOL_NIAGARA);
        int niagaraDimensionCd = XParserEx.readIntegerFromXMLAttribute(xmlUnit, ATTRIB_DIMENSION_CD_NIAGARA);
        int niagaraDimensionDol = XParserEx.readIntegerFromXMLAttribute(xmlUnit, ATTRIB_DIMENSION_DOL_NIAGARA);
        BDimension dim = BDimension.make((int)niagaraDimensionM, (int)niagaraDimensionKg, (int)niagaraDimensionS, (int)niagaraDimensionA, (int)niagaraDimensionK, (int)niagaraDimensionMol, (int)niagaraDimensionCd, (int)niagaraDimensionDol);
        LOGGER.info("The <" + niagaraUnitName + "> added to the niagara units.");
        return BUnit.make((String)niagaraUnitName, (String)niagaraSymbol, (BDimension)dim, (double)niagaraScale);
    }

    private static BUnit checkNiagaraUnitExistence(String niagaraUnitName) {
        try {
            return BUnit.getUnit((String)niagaraUnitName);
        }
        catch (UnitException e) {
            LOGGER.warning("<" + niagaraUnitName + "> do not exist in the niagara units space");
            return BUnit.NULL;
        }
    }
}

