/*
 * Decompiled with CFR 0.152.
 */
package com.miratech.nE2Link.jobs;

import com.miratech.nE2Link.BNe2DeviceExt;
import com.miratech.nE2Link.jobs.BLogFilter;
import com.miratech.nE2Link.jobs.BLogSeverityEnum;
import com.miratech.nE2Link.parser.binary.FileData;
import com.miratech.nE2Link.parser.binary.FolderData;
import com.miratech.nE2Link.parser.binary.GetFileRequest;
import com.miratech.nE2Link.parser.binary.GetFileResponse;
import com.miratech.nE2Link.parser.binary.GetFolderRequest;
import com.miratech.nE2Link.parser.binary.GetFolderResponse;
import com.miratech.nE2Link.parser.binary.ResponseCode;
import com.miratech.nE2Link.utils.BFileDataArgs;
import com.tridium.util.TimeFormat;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.baja.data.BIDataValue;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.job.BSimpleJob;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BFacets;
import javax.baja.sys.BMonth;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.InvalidEnumException;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.util.Lexicon;
import org.jetbrains.annotations.NotNull;

@NiagaraType
@NiagaraProperty(name="filter", type="BLogFilter", defaultValue="new BLogFilter()")
@NiagaraActions(value={@NiagaraAction(name="getResultAsString", returnType="BString", flags=4), @NiagaraAction(name="dumpToConsole", flags=4), @NiagaraAction(name="dumpToFile", returnType="BString", flags=4)})
public class BRetrieveLogDataJob
extends BSimpleJob {
    public static final Property filter = BRetrieveLogDataJob.newProperty((int)0, (BValue)new BLogFilter(), null);
    public static final Action getResultAsString = BRetrieveLogDataJob.newAction((int)4, null);
    public static final Action dumpToConsole = BRetrieveLogDataJob.newAction((int)4, null);
    public static final Action dumpToFile = BRetrieveLogDataJob.newAction((int)4, null);
    public static final Type TYPE = Sys.loadType(BRetrieveLogDataJob.class);
    Lexicon LEX;
    Logger LOGGER = Logger.getLogger(TYPE.getModule().getModuleName());
    BNe2DeviceExt controller;
    List<LogEntry> filteredResult;
    private static String LOG_DIR_NAME = "logs";
    private static String LOG_FILE_NAME = "logFile.txt";
    private static char COLUMN_SEPARATOR = (char)9;
    private static String TIMESTAMP_FORMAT_PATTERN = "DD.MM.YYYY HH:mm:ss.SSS";
    private static String DATE_FORMAT_PATTERN = "DD.MM.YYYY";
    private static String TIME_FORMAT_PATTERN = "HH:mm:ss.SSS";

    public BLogFilter getFilter() {
        return (BLogFilter)this.get(filter);
    }

    public void setFilter(BLogFilter v) {
        this.set(filter, (BValue)v, null);
    }

    public BString getResultAsString() {
        return (BString)this.invoke(getResultAsString, null, null);
    }

    public void dumpToConsole() {
        this.invoke(dumpToConsole, null, null);
    }

    public BString dumpToFile() {
        return (BString)this.invoke(dumpToFile, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BRetrieveLogDataJob() {
    }

    public BRetrieveLogDataJob(BLogFilter logFilter) {
        this();
        this.setFilter(logFilter);
    }

    public void run(Context context) throws Exception {
        this.updateProgress(0, 0, 100);
        BLogFilter filter = this.getFilter();
        String module = TYPE.getModule().getModuleName();
        this.LEX = Lexicon.make((String)module, (Context)context);
        try {
            this.controller = (BNe2DeviceExt)filter.getControllerOrd().get((BObject)this);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.controller == null) {
            throw new LocalizableRuntimeException(module, "LogData.noController");
        }
        if (!this.controller.isConnected()) {
            throw new RuntimeException(this.LEX.getText("LogData.noConnection", new Object[]{this.controller.getConfig().getCommunicationSettings().getAddress()}));
        }
        this.log().start(this.LEX.getText("LogData.start", new Object[]{this.controller.getConfig().getCommunicationSettings().getAddress()}));
        System.out.println("Job is running: " + this.getName());
        String logPath = "/log";
        String logFileName = "logs.txt";
        String logPathAndFileName = logPath + '/' + logFileName;
        GetFolderRequest folderRequest = GetFolderRequest.make(this.controller, logPath);
        GetFolderResponse folderResponse = folderRequest.postRequest(this.controller.getRemoteDevice());
        if (folderResponse.getResponseCode() != ResponseCode.OK) {
            throw new RuntimeException(folderResponse.getLocalizedMessage());
        }
        FolderData folderData = folderResponse.getResponseData();
        if (!folderResponse.getResponseData().getPath().equals(logPath)) {
            throw new RuntimeException(this.LEX.getText("LogData.folderNotFound", new Object[]{logPath}));
        }
        this.log().message(this.LEX.getText("LogData.folderFound", new Object[]{logPath}));
        if (!folderData.containsFile(logFileName)) {
            throw new RuntimeException(this.LEX.getText("LogData.fileNotFound", new Object[]{logPathAndFileName}));
        }
        this.log().message(this.LEX.getText("LogData.fileFound", new Object[]{logPathAndFileName}));
        int offset = 0;
        int chunkSize = 65536;
        int receivedDataSize = 65536;
        int maxForProgress = 2 * chunkSize;
        boolean error = false;
        String errorMsg = "";
        byte[] logData = new byte[]{};
        while (receivedDataSize >= chunkSize && !error) {
            BFileDataArgs fileDataArgs = new BFileDataArgs(logPath, logFileName, offset, chunkSize);
            GetFileRequest fileRequest = GetFileRequest.make(this.controller, fileDataArgs);
            GetFileResponse response = fileRequest.postRequest(this.controller.getRemoteDevice());
            boolean bl = error = response.getResponseCode() != ResponseCode.OK;
            if (!error) {
                FileData fileData = response.getResponseData();
                byte[] receivedData = fileData.getFileContent();
                receivedDataSize = receivedData.length;
                logData = Arrays.copyOf(logData, logData.length + receivedDataSize);
                System.arraycopy(receivedData, 0, logData, offset, receivedDataSize);
                this.updateProgress(offset += receivedDataSize, 0, maxForProgress += receivedDataSize);
                continue;
            }
            errorMsg = response.getLocalizedMessage();
        }
        if (error) {
            throw new RuntimeException(errorMsg);
        }
        this.log().message(this.LEX.getText("LogData.allDataReceived", new Object[]{logPathAndFileName, logData.length}));
        String rawLogResult = new String(logData, StandardCharsets.UTF_8);
        List<LogEntry> logEntries = this.parseLogResults(rawLogResult);
        this.filteredResult = this.filter(logEntries, this.getFilter());
        int size = this.filteredResult.size();
        this.updateProgress(100, 0, 100);
    }

    public BString doGetResultAsString() {
        StringBuilder sb = new StringBuilder();
        for (LogEntry entry : this.filteredResult) {
            sb.append(entry.toString()).append("\n");
        }
        return BString.make((String)sb.toString());
    }

    public void doDumpToConsole() {
        System.out.println(this.LEX.getText("LogData.consoleDump", new Object[]{this.controller.getConfig().getCommunicationSettings().getAddress()}));
        System.out.println(this.getResultAsString().getString());
    }

    public BString doDumpToFile(Context context) {
        BAbsTime now = BAbsTime.now();
        String logFileName = now.getYear() + "_" + now.getMonth().getMonthOfYear() + "_" + now.getDay() + "_" + String.format("%02d%02d%02d%03d", now.getHour(), now.getMinute(), now.getSecond(), now.getMillisecond()) + "_" + LOG_FILE_NAME;
        BOrd logDirOrd = BOrd.make((BOrd)BNe2DeviceExt.NANO_SHARED_DIR_ORD, (String)("file:" + LOG_DIR_NAME));
        BOrd logFileOrd = BOrd.make((BOrd)logDirOrd, (String)("file:" + logFileName));
        logFileOrd = logFileOrd.normalize();
        FilePath logFilePath = (FilePath)logFileOrd.parse()[0];
        try {
            BIFile logFile = BFileSystem.INSTANCE.makeFile(logFilePath);
            PrintWriter writer = new PrintWriter((Writer)new OutputStreamWriter(logFile.getOutputStream(), StandardCharsets.UTF_8), true);
            int line = 0;
            String colHeaderLine = this.LEX.get("LogData.colHeaderLine", "#");
            String colHeaderDate = this.LEX.get("LogData.colHeaderDate", "Date");
            String colHeaderTime = this.LEX.get("LogData.colHeaderTime", "Time");
            String colHeaderChannel = this.LEX.get("LogData.colHeaderChannel", "Channel");
            String colHeaderSeverity = this.LEX.get("LogData.colHeaderSeverity", "Severity");
            String colHeaderMessage = this.LEX.get("LogData.colHeaderMessage", "Message");
            String colHeaderDetail = this.LEX.get("LogData.colHeaderDetail", "Detail");
            String lineFormat = "%s" + COLUMN_SEPARATOR + "%s" + COLUMN_SEPARATOR + "%s" + COLUMN_SEPARATOR + "%s" + COLUMN_SEPARATOR + "%s" + COLUMN_SEPARATOR + "%s" + COLUMN_SEPARATOR + "%s";
            String header = String.format(lineFormat, colHeaderLine, colHeaderDate, colHeaderTime, colHeaderChannel, colHeaderSeverity, colHeaderMessage, colHeaderDetail);
            writer.println(header);
            for (LogEntry entry : this.filteredResult) {
                String logFileOutput = String.format(lineFormat, ++line, entry.getFormattedDate(), entry.getFormattedTime(), entry.getChannel(), entry.getSeverity().getDisplayTag(context), entry.getMainMessage(), entry.getDetailMessage());
                writer.println(logFileOutput);
            }
            writer.close();
            return BString.make((String)logFilePath.toString());
        }
        catch (IOException e) {
            throw new RuntimeException(this.LEX.getText("LogData.fileError", new Object[]{logFilePath.toString(), e.getMessage()}));
        }
    }

    private List<LogEntry> parseLogResults(String rawLogResult) {
        int minProgress = this.getProgress();
        String[] rawLogMessages = rawLogResult.split("\n");
        ArrayList<LogEntry> logEntries = new ArrayList<LogEntry>(rawLogMessages.length);
        for (int i = rawLogMessages.length - 1; i >= 0; --i) {
            String rawLogMessage = rawLogMessages[i];
            LogEntry logEntry = LogEntry.parse(rawLogMessage);
            if (logEntry != null) {
                logEntries.add(logEntry);
            } else {
                this.log().message(this.LEX.getText("LogData.invalidLogFormat", new Object[]{rawLogMessage}));
            }
            this.updateProgress(i, 0, rawLogMessages.length - 1, minProgress, 98);
        }
        return logEntries;
    }

    private List<LogEntry> filter(List<LogEntry> unfilteredLogResult, BLogFilter filter) {
        return unfilteredLogResult.stream().filter(logEntry -> !(!filter.getSeverity().equals((Object)BLogSeverityEnum.All) && !logEntry.severity.equals((Object)BLogSeverityEnum.All) && !logEntry.severity.equals((Object)filter.getSeverity()) || (!filter.getStartTime().equals((Object)BAbsTime.NULL) || !filter.getEndTime().equals((Object)BAbsTime.NULL)) && (!logEntry.timestamp.isAfter(filter.getStartTime()) && !logEntry.timestamp.equals((Object)filter.getStartTime()) || !logEntry.getTimestamp().isBefore(filter.getEndTime()) && !logEntry.timestamp.equals((Object)filter.getEndTime())))).collect(Collectors.toList());
    }

    private void updateProgress(int current, int min, int max) {
        int calcProgress = min != max ? 100 / (max - min) * (current - min) : 100;
        if ((calcProgress = Math.min(100, Math.max(0, calcProgress))) > this.getProgress()) {
            this.progress(calcProgress);
        }
    }

    private void updateProgress(int current, int min, int max, int minProgress, int maxProgress) {
        int calcProgress = min != max ? (maxProgress - minProgress) / (max - min) * (current - min) + minProgress : maxProgress;
        if ((calcProgress = Math.min(maxProgress, Math.max(minProgress, calcProgress))) > this.getProgress()) {
            this.progress(calcProgress);
        }
    }

    public static class LogEntry
    implements Comparable<LogEntry> {
        BAbsTime timestamp;
        String channel;
        BLogSeverityEnum severity;
        String message;
        public static final Context TIME_FORMAT_MILLIS_CONTEXT = new BasicContext(Context.NULL, BFacets.make((String[])new String[]{"showSeconds", "showMilliseconds"}, (BIDataValue[])new BIDataValue[]{BBoolean.TRUE, BBoolean.TRUE}));

        public BAbsTime getTimestamp() {
            return this.timestamp;
        }

        public String getChannel() {
            return this.channel;
        }

        public BLogSeverityEnum getSeverity() {
            return this.severity;
        }

        public String getMessage() {
            return this.message;
        }

        public String getMainMessage() {
            String detailMessage = this.getDetailMessage();
            return detailMessage.isEmpty() ? this.message : this.message.replace(detailMessage, "").trim();
        }

        public String getDetailMessage() {
            int openingBracePos = this.message.indexOf(123);
            int closingBracePos = this.message.indexOf(125);
            return openingBracePos != -1 && closingBracePos != -1 ? this.message.substring(openingBracePos, closingBracePos + 1) : (openingBracePos != -1 ? this.message.substring(openingBracePos) : "");
        }

        public LogEntry(BAbsTime timestamp, String channel, BLogSeverityEnum severity, String message) {
            this.timestamp = timestamp;
            this.channel = channel;
            this.severity = severity;
            this.message = message;
        }

        private String getFormattedTimestamp() {
            return TimeFormat.format((BAbsTime)this.timestamp, (String)TIMESTAMP_FORMAT_PATTERN, (Context)TIME_FORMAT_MILLIS_CONTEXT);
        }

        private String getFormattedDate() {
            return TimeFormat.format((BAbsTime)this.timestamp, (String)DATE_FORMAT_PATTERN);
        }

        private String getFormattedTime() {
            return TimeFormat.format((BAbsTime)this.timestamp, (String)TIME_FORMAT_PATTERN, (Context)TIME_FORMAT_MILLIS_CONTEXT);
        }

        public String toString() {
            return String.format("%s [%s] [%s] %s", new Object[]{this.getFormattedTimestamp(), this.channel, this.severity, this.message});
        }

        public static LogEntry parse(String rawLogEntry) {
            BLogSeverityEnum severityEnum;
            int openingBracketPos = rawLogEntry.indexOf(91, rawLogEntry.indexOf("."));
            if (openingBracketPos == -1) {
                return null;
            }
            String timeStr = rawLogEntry.substring(0, openingBracketPos - 1);
            BAbsTime timestamp = BAbsTime.NULL;
            try {
                timestamp = LogEntry.parseTimestamp(timeStr);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
            int closingBracketPos = rawLogEntry.indexOf(93, openingBracketPos);
            if (closingBracketPos == -1) {
                return null;
            }
            String channel = rawLogEntry.substring(openingBracketPos + 1, closingBracketPos).trim();
            openingBracketPos = rawLogEntry.indexOf(91, closingBracketPos);
            if (openingBracketPos == -1) {
                return null;
            }
            closingBracketPos = rawLogEntry.indexOf(93, openingBracketPos);
            if (closingBracketPos == -1) {
                return null;
            }
            String severityStr = rawLogEntry.substring(openingBracketPos + 1, closingBracketPos).trim();
            try {
                severityEnum = BLogSeverityEnum.make(severityStr);
            }
            catch (InvalidEnumException e) {
                severityEnum = BLogSeverityEnum.All;
            }
            String message = rawLogEntry.substring(closingBracketPos + 1).trim();
            return new LogEntry(timestamp, channel, severityEnum, message);
        }

        public static BAbsTime parseTimestamp(String timestamp) {
            try {
                int yearSeparatorPos = timestamp.indexOf(46);
                if (yearSeparatorPos == -1) {
                    throw new IllegalArgumentException("no dot after year");
                }
                int year = Integer.parseInt(timestamp.substring(0, yearSeparatorPos));
                int monthSeparatorPos = timestamp.indexOf(46, yearSeparatorPos + 1);
                if (monthSeparatorPos == -1) {
                    throw new IllegalArgumentException("no dot after month");
                }
                int month = Integer.parseInt(timestamp.substring(yearSeparatorPos + 1, monthSeparatorPos));
                int daySeparatorPos = timestamp.indexOf(32, monthSeparatorPos + 1);
                if (daySeparatorPos == -1) {
                    throw new IllegalArgumentException("no blank after day");
                }
                int day = Integer.parseInt(timestamp.substring(monthSeparatorPos + 1, daySeparatorPos));
                int hourSeparatorPos = timestamp.indexOf(58, daySeparatorPos + 1);
                if (hourSeparatorPos == -1) {
                    throw new IllegalArgumentException("no colon after hour");
                }
                int hour = Integer.parseInt(timestamp.substring(daySeparatorPos + 1, hourSeparatorPos));
                int minuteSeparatorPos = timestamp.indexOf(58, hourSeparatorPos + 1);
                if (minuteSeparatorPos == -1) {
                    throw new IllegalArgumentException("no colon after minute");
                }
                int minute = Integer.parseInt(timestamp.substring(hourSeparatorPos + 1, minuteSeparatorPos));
                int secondSeparatorPos = timestamp.indexOf(46, minuteSeparatorPos + 1);
                if (secondSeparatorPos == -1) {
                    throw new IllegalArgumentException("no dot after second");
                }
                int second = Integer.parseInt(timestamp.substring(minuteSeparatorPos + 1, secondSeparatorPos));
                int milliSecond = Integer.parseInt(timestamp.substring(secondSeparatorPos + 1));
                BMonth niagaraMonth = BMonth.make((int)(month - 1));
                return BAbsTime.make((int)year, (BMonth)niagaraMonth, (int)day, (int)hour, (int)minute, (int)second, (int)milliSecond, (BTimeZone)BTimeZone.UTC);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(String.format("Timestamp '%s' not in format 2024.11.22 13:08:04.429", timestamp), e);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LogEntry logEntry = (LogEntry)o;
            return Objects.equals(this.timestamp, logEntry.timestamp) && Objects.equals(this.channel, logEntry.channel) && Objects.equals((Object)this.severity, (Object)logEntry.severity) && Objects.equals(this.message, logEntry.message);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.timestamp, this.channel, this.severity, this.message});
        }

        @Override
        public int compareTo(@NotNull LogEntry o) {
            this.timestamp.compareTo((Object)o.timestamp);
            return 0;
        }
    }
}

