/*
 * Decompiled with CFR 0.152.
 */
package com.miratech.nE2Link.notifications;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BBitString;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

@NiagaraType
public final class BRefreshTargets
extends BBitString {
    public static final int ACTIVE_VIEW = 1;
    public static final int PROPERTY_SHEET = 2;
    public static final int WIRE_SHEET = 4;
    public static final int SLOT_SHEET = 8;
    public static final int TREE_NODE = 16;
    public static final BRefreshTargets DEFAULT = new BRefreshTargets(1);
    public static final BRefreshTargets NULL = new BRefreshTargets(0);
    public static final BRefreshTargets activeView = BRefreshTargets.make(1);
    public static final BRefreshTargets propertySheet = BRefreshTargets.make(2);
    public static final BRefreshTargets treeNode = BRefreshTargets.make(16);
    private static final Lexicon LEX = Lexicon.make(BRefreshTargets.class);
    private int _bits;
    private static BBitString.Support support = new BBitString.Support((BBitString)DEFAULT);
    public static final Type TYPE;

    private BRefreshTargets(int bits) {
        this._bits = bits;
    }

    public static BRefreshTargets make(int bits) {
        if (bits == BRefreshTargets.NULL._bits) {
            return NULL;
        }
        return (BRefreshTargets)new BRefreshTargets(bits).intern();
    }

    public static BRefreshTargets make(BRefreshTargets orig, int bitToChange, boolean newBitState) {
        int newBits;
        int n = newBits = newBitState ? orig._bits | bitToChange : orig._bits & ~bitToChange;
        if (orig._bits == newBits) {
            return orig;
        }
        return BRefreshTargets.make(newBits);
    }

    public boolean isActiveView() {
        return (this._bits & 1) != 0;
    }

    public boolean isPropertySheet() {
        return (this._bits & 2) != 0;
    }

    public boolean isWireSheet() {
        return (this._bits & 4) != 0;
    }

    public boolean isSlotSheet() {
        return (this._bits & 8) != 0;
    }

    public boolean isTreeNode() {
        return (this._bits & 0x10) != 0;
    }

    public boolean getBit(int ordinal) {
        return (this._bits & ordinal) != 0;
    }

    public boolean getBit(String tag) {
        return this.getBit(this.tagToOrdinal(tag));
    }

    public int[] getOrdinals() {
        return support.getOrdinals();
    }

    public boolean isOrdinal(int ordinal) {
        return support.isOrdinal(ordinal);
    }

    public String getTag(int ordinal) {
        return support.getTag(ordinal);
    }

    public String getDisplayTag(int ordinal, Context cx) {
        return support.getDisplayTag(ordinal, cx);
    }

    public BRefreshTargets getInstance(int[] ordinals) {
        int mask = 0;
        for (int i = 0; i < ordinals.length; ++i) {
            mask |= ordinals[i];
        }
        return BRefreshTargets.make(mask);
    }

    public boolean isTag(String tag) {
        return support.isTag(tag);
    }

    public int tagToOrdinal(String tag) {
        return support.tagToOrdinal(tag);
    }

    public boolean isEmpty() {
        return this._bits == 0;
    }

    public String getEmptyTag() {
        return "empty";
    }

    public int getBits() {
        return this._bits;
    }

    public String getShortDisplayTag(int ordinal, Context cx) {
        return LEX.getText(TYPE.getTypeName() + "." + this.getTag(ordinal) + ".short");
    }

    public void encode(DataOutput out) throws IOException {
        out.writeInt(this._bits);
    }

    public BObject decode(DataInput in) throws IOException {
        return BRefreshTargets.make(in.readInt());
    }

    public String encodeToString() throws IOException {
        return Integer.toHexString(this._bits);
    }

    public BObject decodeFromString(String s) throws IOException {
        try {
            return BRefreshTargets.make(Integer.parseUnsignedInt(s, 16));
        }
        catch (Exception e) {
            throw new IOException("Invalid bits: " + s);
        }
    }

    public int hashCode() {
        return this._bits;
    }

    public boolean equals(Object obj) {
        if (obj instanceof BRefreshTargets) {
            return ((BRefreshTargets)((Object)obj))._bits == this._bits;
        }
        return false;
    }

    public String toString(Context context) {
        if (this._bits == 0) {
            return "{}";
        }
        StringBuffer sb = new StringBuffer("{");
        int[] ordinals = this.getOrdinals();
        for (int i = 0; i < ordinals.length; ++i) {
            int ordinal = ordinals[i];
            if (!this.getBit(ordinal)) continue;
            sb.append(this.getShortDisplayTag(ordinal, context));
            sb.append(", ");
        }
        sb.setLength(sb.length() - 2);
        sb.append("}");
        return sb.toString();
    }

    public Type getType() {
        return TYPE;
    }

    static {
        support.add(1, "activeView");
        support.add(2, "propertySheet");
        support.add(4, "wireSheet");
        support.add(8, "slotSheet");
        support.add(16, "treeNode");
        TYPE = Sys.loadType(BRefreshTargets.class);
    }
}

