/*
 * Decompiled with CFR 0.152.
 */
package com.miratech.nE2Link.parser.binary;

import com.miratech.nE2Link.BNe2DeviceExt;
import com.miratech.nE2Link.parser.binary.AbstractNanoData;
import com.miratech.nE2Link.parser.binary.AbstractNanoRequest;
import com.miratech.nE2Link.parser.binary.ResponseCode;
import com.miratech.serialization.DataMarker;
import com.miratech.serialization.SerializableForm;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.baja.util.Lexicon;

public abstract class AbstractNanoResponse {
    public static final Logger LOGGER = Logger.getLogger("nE2Link");
    protected static final Lexicon LEX = Lexicon.make(BNe2DeviceExt.class);
    private final AbstractNanoRequest request;
    private ArrayList<AbstractNanoData> parsedResponseData = new ArrayList();
    private ArrayList<ResponseCode> responseCodes = new ArrayList();
    private ArrayList<String> errorMessages = new ArrayList();
    private ArrayList<String> exceptionMessages = new ArrayList();
    private ArrayList<String> stackTraces = new ArrayList();

    protected AbstractNanoResponse(AbstractNanoRequest request, List<SerializableForm> response) {
        this.request = request;
        this.parseResponseContentElements(response);
    }

    protected AbstractNanoResponse(AbstractNanoRequest request, ResponseCode responseCode) {
        this.request = request;
        this.addResponseData(responseCode, null, "", "", "");
    }

    public AbstractNanoRequest getRequest() {
        return this.request;
    }

    public int getResponseDataSize() {
        return this.parsedResponseData.size();
    }

    public String getErrorMessage(int index) {
        return this.errorMessages.get(index);
    }

    public String getExceptionMessage(int index) {
        return this.exceptionMessages.get(index);
    }

    public String getStackTrace(int index) {
        return this.stackTraces.get(index);
    }

    public ResponseCode getResponseCode(int index) {
        return this.responseCodes.size() > 0 ? this.responseCodes.get(index) : ResponseCode.NO_RESPONSE;
    }

    public AbstractNanoData getResponseData(int index) {
        return this.parsedResponseData.size() > 0 ? this.parsedResponseData.get(index) : null;
    }

    public AbstractNanoData getResponseData() {
        return this.getResponseData(0);
    }

    public ResponseCode getResponseCode() {
        return this.responseCodes.size() > 0 ? this.getResponseCode(0) : ResponseCode.OK;
    }

    public String getErrorMessage() {
        return this.getErrorMessage(0);
    }

    public String getExceptionMessage() {
        return this.getExceptionMessage(0);
    }

    public String getStackTrace() {
        return this.getStackTrace(0);
    }

    public String getLocalizedMessage() {
        return this.getLocalizedMessage(0);
    }

    public abstract String getLocalizedMessage(int var1);

    protected List<SerializableForm> getResponseContentElements(List<SerializableForm> response) {
        if (response == null || response.size() < 1) {
            return new ArrayList<SerializableForm>();
        }
        return response.get((int)0).elements.toSerializableForms();
    }

    protected abstract boolean isMalformedResponse(SerializableForm var1);

    protected boolean isParsedDataInvalid(AbstractNanoData parsedData) {
        return parsedData == null;
    }

    private void parseResponseContentElements(List<SerializableForm> response) {
        SerializableForm responseData;
        SerializableForm serializableForm = responseData = response.size() > 0 ? response.get(0) : null;
        if (this.checkError(responseData)) {
            return;
        }
        List<SerializableForm> responseContentElements = this.getResponseContentElements(response);
        for (int i = 0; i < responseContentElements.size(); ++i) {
            SerializableForm responseContentElement = responseContentElements.get(i);
            ResponseCode responseCode = ResponseCode.OK;
            AbstractNanoData parsedData = null;
            if (responseContentElement == null || this.checkError(responseContentElement)) continue;
            if (this.isMalformedResponse(responseContentElement)) {
                responseCode = ResponseCode.INVALID_RESPONSE;
                this.addResponseData(responseCode, null, "", "", "");
                continue;
            }
            parsedData = this.doParseResponseContentElement(responseContentElement);
            if (this.isParsedDataInvalid(parsedData)) {
                responseCode = ResponseCode.INVALID_RESPONSE;
            }
            this.addResponseData(responseCode, parsedData, "", "", "");
        }
    }

    private boolean checkError(SerializableForm response) {
        boolean error;
        boolean bl = error = response != null && response.marker.equals((Object)DataMarker.ErrorData);
        if (!error) {
            return false;
        }
        String errorMessage = response.data[0] != null ? response.data[0].toString() : "";
        String exceptionMessage = response.data[1] != null ? response.data[1].toString() : "";
        String stackTrace = response.data[2] != null ? response.data[2].toString().replaceAll("\r\n", "\n") : "";
        this.addResponseData(ResponseCode.ERROR, null, errorMessage, exceptionMessage, stackTrace);
        return true;
    }

    protected abstract AbstractNanoData doParseResponseContentElement(SerializableForm var1);

    private void addResponseData(ResponseCode responseCode, AbstractNanoData responseData, String errorMessage, String exceptionMessage, String stackTrace) {
        this.responseCodes.add(responseCode);
        this.parsedResponseData.add(responseData);
        this.errorMessages.add(errorMessage);
        this.exceptionMessages.add(exceptionMessage);
        this.stackTraces.add(stackTrace);
    }
}

