/*
 * Decompiled with CFR 0.152.
 */
package com.miratech.nE2Link.parser.binary;

import com.miratech.nE2Link.BNanoBaseComponent;
import com.miratech.nE2Link.BNanoExtension;
import com.miratech.nE2Link.actions.BNanoAddExtensionArg;
import com.miratech.nE2Link.parser.binary.AbstractNanoData;
import com.miratech.nE2Link.parser.binary.AbstractNanoRequest;
import com.miratech.nE2Link.parser.binary.AbstractNanoResponse;
import com.miratech.nE2Link.parser.binary.AddExtensionRequest;
import com.miratech.nE2Link.parser.binary.ObjectData;
import com.miratech.nE2Link.parser.binary.ResponseCode;
import com.miratech.serialization.DataMarker;
import com.miratech.serialization.SerializableForm;
import java.util.List;

public class AddExtensionResponse
extends AbstractNanoResponse {
    private AddExtensionResponse(AbstractNanoRequest request, ResponseCode responseCode) {
        super(request, responseCode);
    }

    private AddExtensionResponse(AbstractNanoRequest request, List<SerializableForm> response) {
        super(request, response);
    }

    public static AddExtensionResponse make(AbstractNanoRequest request, ResponseCode responseCode) {
        return new AddExtensionResponse(request, responseCode);
    }

    public static AddExtensionResponse parse(AbstractNanoRequest request, List<SerializableForm> response) {
        return new AddExtensionResponse(request, response);
    }

    @Override
    public ObjectData getResponseData() {
        return (ObjectData)super.getResponseData(0);
    }

    @Override
    protected boolean isMalformedResponse(SerializableForm responseContentElement) {
        return !responseContentElement.marker.equals((Object)DataMarker.ObjectData);
    }

    @Override
    protected AbstractNanoData doParseResponseContentElement(SerializableForm responseContentElement) {
        return ObjectData.parse(responseContentElement, this.getRequest().getNe2DeviceExt());
    }

    @Override
    protected boolean isParsedDataInvalid(AbstractNanoData parsedData) {
        ObjectData objectData = (ObjectData)parsedData;
        return super.isParsedDataInvalid(parsedData) || objectData.getExtensions().size() == 0;
    }

    @Override
    public String getLocalizedMessage(int index) {
        BNanoAddExtensionArg requestData = ((AddExtensionRequest)this.getRequest()).getClientRequestData();
        ObjectData objectData = this.getResponseData();
        BNanoBaseComponent parentComponent = requestData.getExtensionParent();
        BNanoExtension extension = requestData.getExtension();
        int parentId = parentComponent.getGlobalIndex();
        int extensionsInResponse = this.getResponseCode() == ResponseCode.OK ? objectData.getExtensions().size() : 0;
        int extensionId = this.getResponseCode() == ResponseCode.OK && extensionsInResponse > 0 ? objectData.getExtensions().get(extensionsInResponse - 1).getExtensionId() : extension.getExtensionId();
        String extTypeName = extension.getOriginNameFromLibrary();
        String extAssemblyName = extension.getAssemblyInfo();
        String parentComponentNavOrd = parentComponent != null ? parentComponent.getNavOrd().toString() : "unresolvable component";
        String extensionNavOrd = extension != null ? extension.getNavOrd().toString() : "unresolvable extension";
        switch (this.getResponseCode()) {
            case OK: {
                return LEX.getText("ADD_EXTENSION_OK", new Object[]{parentComponentNavOrd, parentId, extensionNavOrd, extensionId, extTypeName, extAssemblyName});
            }
            case ERROR: {
                return LEX.getText("ADD_EXTENSION_ERROR", new Object[]{parentComponentNavOrd, parentId, extensionNavOrd, extensionId, extTypeName, extAssemblyName, this.getErrorMessage(), this.getExceptionMessage(), this.getStackTrace()});
            }
            case NOT_CONNECTED: {
                return LEX.getText("ADD_EXTENSION_NOT_CONNECTED", new Object[]{parentComponentNavOrd, parentId, extensionNavOrd, extensionId, extTypeName, extAssemblyName});
            }
            case NO_RESPONSE: {
                return LEX.getText("ADD_EXTENSION_NO_RESPONSE", new Object[]{parentComponentNavOrd, parentId, extensionNavOrd, extensionId, extTypeName, extAssemblyName});
            }
            case INVALID_RESPONSE: {
                return LEX.getText("ADD_EXTENSION_INVALID_RESPONSE", new Object[]{parentComponentNavOrd, parentId, extensionNavOrd, extensionId, extTypeName, extAssemblyName});
            }
        }
        return LEX.getText("ILLEGAL_RESPONSE_CODE");
    }
}

