/*
 * Decompiled with CFR 0.152.
 */
package com.miratech.nE2Link.parser.binary;

import com.miratech.nE2Link.BLibrary;
import com.miratech.nE2Link.BMarkerEnum;
import com.miratech.nE2Link.parser.binary.AbstractNanoData;
import com.miratech.serialization.DataMarker;
import com.miratech.serialization.SerializableForm;

public class AssemblyInfoData
extends AbstractNanoData {
    BLibrary library;

    private AssemblyInfoData(SerializableForm serializedAssemblyInfoData) {
        super(serializedAssemblyInfoData);
    }

    public static AssemblyInfoData parse(SerializableForm serializedAssemblyInfoData) {
        DataMarker marker = serializedAssemblyInfoData.marker;
        if (marker.getValue() != 91) {
            LOGGER.severe(String.format("[AssemblyInfoData.parse()]: Unexpected Data type: marker: '%s'.\nSkipping data processing.", new Object[]{marker}));
            return null;
        }
        String[] assemblyNameAndVersion = serializedAssemblyInfoData.data[0].toString().split(",");
        LOGGER.info(String.format("[AssemblyInfoData.parse()]: Processing Library '%s' '%s'", assemblyNameAndVersion[0], assemblyNameAndVersion[1]));
        BLibrary library = null;
        try {
            library = new BLibrary(BMarkerEnum.AssemblyInfoData, Byte.toUnsignedInt((Byte)serializedAssemblyInfoData.data[1]), assemblyNameAndVersion[0].trim(), assemblyNameAndVersion[1].replaceFirst("Version=", "").trim());
        }
        catch (Exception exception) {
            // empty catch block
        }
        AssemblyInfoData aid = new AssemblyInfoData(serializedAssemblyInfoData);
        aid.library = library;
        return aid;
    }

    public BLibrary getLibrary() {
        return this.library;
    }
}

