/*
 * Decompiled with CFR 0.152.
 */
package com.miratech.nE2Link.parser.binary;

import com.miratech.nE2Link.parser.binary.AbstractNanoData;
import com.miratech.nE2Link.parser.binary.AbstractNanoRequest;
import com.miratech.nE2Link.parser.binary.AbstractNanoResponse;
import com.miratech.nE2Link.parser.binary.DeleteFileRequest;
import com.miratech.nE2Link.parser.binary.FileData;
import com.miratech.nE2Link.parser.binary.ResponseCode;
import com.miratech.nE2Link.utils.BFileDataArgs;
import com.miratech.serialization.DataMarker;
import com.miratech.serialization.SerializableForm;
import java.util.List;

public class DeleteFileResponse
extends AbstractNanoResponse {
    private DeleteFileResponse(AbstractNanoRequest request, ResponseCode responseCode) {
        super(request, responseCode);
    }

    private DeleteFileResponse(AbstractNanoRequest request, List<SerializableForm> response) {
        super(request, response);
    }

    public static DeleteFileResponse make(AbstractNanoRequest request, ResponseCode responseCode) {
        return new DeleteFileResponse(request, responseCode);
    }

    public static DeleteFileResponse parse(AbstractNanoRequest request, List<SerializableForm> response) {
        return new DeleteFileResponse(request, response);
    }

    @Override
    public AbstractNanoData getResponseData() {
        return super.getResponseData();
    }

    @Override
    protected boolean isMalformedResponse(SerializableForm responseContentElement) {
        return !responseContentElement.marker.equals((Object)DataMarker.FileData);
    }

    @Override
    protected AbstractNanoData doParseResponseContentElement(SerializableForm responseContentElement) {
        return FileData.parse(responseContentElement);
    }

    @Override
    protected boolean isParsedDataInvalid(AbstractNanoData parsedData) {
        FileData fileData = (FileData)parsedData;
        return super.isParsedDataInvalid(parsedData);
    }

    @Override
    public String getLocalizedMessage(int index) {
        BFileDataArgs requestData = ((DeleteFileRequest)this.getRequest()).getClientRequestData();
        String folderPath = requestData.getFolderPath();
        String filePath = requestData.getFilePath();
        String message = "";
        switch (this.getResponseCode()) {
            case OK: {
                message = LEX.getText("DELETE_FILE_OK", new Object[]{folderPath, filePath});
                break;
            }
            case ERROR: {
                message = LEX.getText("DELETE_FILE_ERROR", new Object[]{folderPath, filePath});
                break;
            }
            case NOT_CONNECTED: {
                message = LEX.getText("DELETE_FILE_NOT_CONNECTED", new Object[]{folderPath, filePath});
                break;
            }
            case NO_RESPONSE: {
                message = LEX.getText("DELETE_FILE_NO_RESPONSE", new Object[]{folderPath, filePath});
                break;
            }
            case INVALID_RESPONSE: {
                message = LEX.getText("DELETE_FILE_INVALID_RESPONSE", new Object[]{folderPath, filePath});
                break;
            }
            default: {
                return LEX.getText("ILLEGAL_RESPONSE_CODE");
            }
        }
        return message;
    }
}

