/*
 * Decompiled with CFR 0.152.
 */
package com.miratech.nE2Link.parser.binary;

import com.miratech.nE2Link.BMarkerEnum;
import com.miratech.nE2Link.BNanoBaseComponent;
import com.miratech.nE2Link.BNanoExtension;
import com.miratech.nE2Link.parser.binary.AbstractNanoData;
import com.miratech.nE2Link.parser.binary.Attributes;
import com.miratech.nE2Link.parser.binary.Slots;
import com.miratech.serialization.DataMarker;
import com.miratech.serialization.SerializableForm;
import java.util.List;
import javax.baja.sys.BFacets;

public class ExtensionSchema
extends AbstractNanoData {
    private BNanoExtension nanoExtension;

    private ExtensionSchema(SerializableForm extensionData) {
        super(extensionData);
    }

    public static ExtensionSchema parse(SerializableForm extensionData) {
        DataMarker marker = extensionData.marker;
        if (marker.getValue() != 47) {
            LOGGER.severe(String.format("[ExtensionSchema.parse()]: Unexpected Data type: marker: '%s'.\nSkipping data processing.", new Object[]{marker}));
            return null;
        }
        BNanoBaseComponent nanoExtension = null;
        BMarkerEnum markerEnum = BMarkerEnum.ExtensionSchema;
        int libraryId = -1;
        String nanoName = "";
        String baseName = "";
        boolean isMultipleAllowed = false;
        String compatibleComponents = "";
        int typeId = -1;
        Attributes attributes = null;
        try {
            markerEnum = BMarkerEnum.make(marker.getValue());
            libraryId = Byte.toUnsignedInt((Byte)extensionData.data[0]);
            nanoName = extensionData.data[1].toString().trim();
            baseName = extensionData.data[2].toString().trim();
            attributes = Attributes.parse(extensionData.data[3]);
            isMultipleAllowed = (Boolean)extensionData.data[4];
            compatibleComponents = extensionData.data[5].toString().trim();
            typeId = Short.toUnsignedInt((Short)extensionData.data[6]);
            nanoExtension = new BNanoExtension();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (nanoExtension != null) {
            nanoExtension.setMarker(markerEnum);
            nanoExtension.setLibraryId(libraryId);
            nanoExtension.setTypeId(typeId);
            nanoExtension.setNanoName(nanoName);
            nanoExtension.setOriginNameFromLibrary(nanoName);
            nanoExtension.setBaseName(baseName);
            ((BNanoExtension)nanoExtension).setIsMultipleAllowed(isMultipleAllowed);
            ((BNanoExtension)nanoExtension).setCompatibleComponents(compatibleComponents);
            nanoExtension.setIsLibraryComponent(true);
            nanoExtension.setComponentFacets(attributes != null ? attributes.getAttributesAsFacets() : BFacets.NULL);
            List<SerializableForm> serializedSlots = extensionData.elements.toSerializableForms();
            Slots.addNanoSlots(serializedSlots, nanoExtension);
        }
        ExtensionSchema extensionSchema = new ExtensionSchema(extensionData);
        extensionSchema.nanoExtension = nanoExtension;
        return extensionSchema;
    }

    public BNanoBaseComponent getNanoExtension() {
        return this.nanoExtension;
    }
}

