/*
 * Decompiled with CFR 0.152.
 */
package com.miratech.nE2Link.parser.binary;

import com.miratech.nE2Link.parser.binary.AbstractNanoData;
import com.miratech.nE2Link.parser.binary.AbstractNanoRequest;
import com.miratech.nE2Link.parser.binary.AbstractNanoResponse;
import com.miratech.nE2Link.parser.binary.ExistingLinkData;
import com.miratech.nE2Link.parser.binary.ResponseCode;
import com.miratech.serialization.DataMarker;
import com.miratech.serialization.SerializableForm;
import java.util.List;

public class LinkResponse
extends AbstractNanoResponse {
    protected LinkResponse(AbstractNanoRequest request, ResponseCode responseCode) {
        super(request, responseCode);
    }

    private LinkResponse(AbstractNanoRequest request, List<SerializableForm> response) {
        super(request, response);
    }

    public static LinkResponse make(AbstractNanoRequest request, ResponseCode responseCode) {
        return new LinkResponse(request, responseCode);
    }

    public static LinkResponse parse(AbstractNanoRequest request, List<SerializableForm> response) {
        return new LinkResponse(request, response);
    }

    @Override
    protected boolean isMalformedResponse(SerializableForm responseContentElement) {
        return !responseContentElement.marker.equals((Object)DataMarker.ExisitingLinkData);
    }

    @Override
    protected AbstractNanoData doParseResponseContentElement(SerializableForm responseContentElement) {
        return ExistingLinkData.parse(responseContentElement);
    }

    @Override
    public ExistingLinkData getResponseData() {
        return (ExistingLinkData)super.getResponseData();
    }

    @Override
    public String getLocalizedMessage(int index) {
        ExistingLinkData requestData = (ExistingLinkData)this.getRequest().getRequestData();
        int sourceComponentId = requestData.getSourceObjectId();
        int sourceSlotId = requestData.getSourceSlotId();
        int targetComponentId = requestData.getTargetObjectId();
        int targetSlotId = requestData.getTargetSlotId();
        switch (this.getResponseCode()) {
            case OK: {
                return LEX.getText("LINK_OK", new Object[]{this.getResponseData().getSourceObjectId(), this.getResponseData().getSourceSlotId(), this.getResponseData().getTargetObjectId(), this.getResponseData().getTargetSlotId()});
            }
            case ERROR: {
                return LEX.getText("LINK_ERROR", new Object[]{sourceComponentId, sourceSlotId, targetComponentId, targetSlotId, this.getErrorMessage(), this.getExceptionMessage(), this.getStackTrace()});
            }
            case NOT_CONNECTED: {
                return LEX.getText("LINK_NOT_CONNECTED", new Object[]{sourceComponentId, sourceSlotId, targetComponentId, targetSlotId});
            }
            case NO_RESPONSE: {
                return LEX.getText("LINK_NO_RESPONSE", new Object[]{sourceComponentId, sourceSlotId, targetComponentId, targetSlotId});
            }
            case INVALID_RESPONSE: {
                return LEX.getText("LINK_INVALID_RESPONSE", new Object[]{sourceComponentId, sourceSlotId, targetComponentId, targetSlotId});
            }
        }
        return LEX.getText("ILLEGAL_RESPONSE_CODE");
    }
}

