/*
 * Decompiled with CFR 0.152.
 */
package com.miratech.nE2Link.parser.binary;

import com.miratech.ifnetclient.model.scheduleLogic.Category;
import com.miratech.ifnetclient.model.scheduleLogic.DayOfMonth;
import com.miratech.ifnetclient.model.scheduleLogic.DaysFromCalendar;
import com.miratech.ifnetclient.model.scheduleLogic.DoubleComparer;
import com.miratech.ifnetclient.model.scheduleLogic.ExceptionalDays;
import com.miratech.ifnetclient.model.scheduleLogic.ISchedule;
import com.miratech.ifnetclient.model.scheduleLogic.Month;
import com.miratech.ifnetclient.model.scheduleLogic.ScheduleEvent;
import com.miratech.ifnetclient.model.scheduleLogic.WeekOfMonth;
import com.miratech.nE2Link.BNanoBaseComponent;
import com.miratech.nE2Link.BNanoComponent;
import com.miratech.nE2Link.BNanoExtension;
import com.miratech.nE2Link.BNanoStatusNumeric;
import com.miratech.nE2Link.BNe2DeviceExt;
import com.miratech.nE2Link.BUnitMap;
import com.miratech.nE2Link.actions.BNanoAction;
import com.miratech.nE2Link.actions.BNanoLinkInfoArg;
import com.miratech.nE2Link.choice.BDynamicChoice;
import com.miratech.nE2Link.choice.BDynamicChoiceRange;
import com.miratech.nE2Link.choice.BStatusDynamicChoice;
import com.miratech.nE2Link.parser.binary.AbstractNanoData;
import com.miratech.nE2Link.parser.binary.AttributeData;
import com.miratech.nE2Link.parser.binary.CustomUserData;
import com.miratech.nE2Link.parser.binary.ExistingLinkData;
import com.miratech.nE2Link.parser.binary.ExtensionData;
import com.miratech.nE2Link.parser.binary.SlotMetaData;
import com.miratech.nE2Link.parser.binary.SlotsMetaData;
import com.miratech.nE2Link.parser.binary.SlotsValuesData;
import com.miratech.nE2Link.schedules.BNanoCalendar;
import com.miratech.nE2Link.schedules.BNanoDateRangeSchedule;
import com.miratech.nE2Link.schedules.BNanoDateSchedule;
import com.miratech.nE2Link.schedules.BNanoSchedule;
import com.miratech.nE2Link.schedules.BNanoWeekAndDaySchedule;
import com.miratech.nE2Link.schedules.BNanoWeekSchedule;
import com.miratech.nE2Link.schedules.utils.BNanoBacnetPriorityEnum;
import com.miratech.nE2Link.schedules.utils.ScheduleUtils;
import com.miratech.serialization.DataMarker;
import com.miratech.serialization.SerializableForm;
import java.time.DayOfWeek;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.UUID;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.baja.data.BIDataValue;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.schedule.BAbstractSchedule;
import javax.baja.schedule.BCompositeSchedule;
import javax.baja.schedule.BDailySchedule;
import javax.baja.schedule.BScheduleReference;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sync.ProxyBroker;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BLink;
import javax.baja.sys.BMonth;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Knob;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Subscriber;
import javax.baja.units.BUnit;
import javax.baja.util.BFormat;

public class ObjectData
extends AbstractNanoData {
    private int typeId = -1;
    private String nanoName = "";
    private int globalIndex = -1;
    private int parentGlobalIndex = -1;
    private String persistentId;
    private SlotsValuesData slotsValuesData = null;
    private SlotsMetaData slotsMetaData = null;
    private ArrayList<ExistingLinkData> links = new ArrayList();
    private ArrayList<ExtensionData> extensions = new ArrayList();
    private ArrayList<CustomUserData> customUserData = new ArrayList();
    private HashMap<String, BDynamicChoiceRange> dynamicChoiceRanges = new HashMap();

    private ObjectData(SerializableForm serializableForm) {
        super(serializableForm);
    }

    public static ObjectData parse(SerializableForm objectData, BNe2DeviceExt controller) {
        return ObjectData.parse(objectData, controller, true);
    }

    public static ObjectData parse(SerializableForm objectData, BNe2DeviceExt controller, boolean updateSlots) {
        ObjectData object;
        block16: {
            DataMarker marker = objectData.marker;
            if (marker.getValue() != 74) {
                LOGGER.severe(String.format("[ObjectData.parse()]): Unexpected Data type: Expected marker: '%s', Received marker: '%s'.\nSkipping data processing.", new Object[]{DataMarker.ObjectData, marker}));
                return null;
            }
            try {
                object = new ObjectData(objectData);
                object.setTypeId(Short.toUnsignedInt((Short)objectData.data[0]));
                object.setNanoName(objectData.data[1].toString());
                object.setGlobalIndex(Short.toUnsignedInt((Short)objectData.data[2]));
                object.setParentGlobalIndex(((Short)objectData.data[3] & 0xFFFF) == 65535 ? -1 : Short.toUnsignedInt((Short)objectData.data[3]));
                object.setPersistentId(objectData.data.length > 4 ? objectData.data[4].toString() : "");
                if (!updateSlots) break block16;
                List<SerializableForm> serializedObjectElements = objectData.elements.toSerializableForms();
                block10: for (SerializableForm serializedObjectElement : serializedObjectElements) {
                    marker = serializedObjectElement.marker;
                    switch (Byte.toUnsignedInt(marker.getValue())) {
                        case 71: {
                            object.setSlotsValuesData(SlotsValuesData.parse(serializedObjectElement));
                            break;
                        }
                        case 92: {
                            object.setSlotsMetaData(SlotsMetaData.parse(serializedObjectElement));
                            break;
                        }
                        case 68: {
                            ExistingLinkData existingLinkData = ExistingLinkData.parse(serializedObjectElement);
                            if (existingLinkData == null) continue block10;
                            object.links.add(existingLinkData);
                            break;
                        }
                        case 79: {
                            ExtensionData extensionData = ExtensionData.parse(serializedObjectElement);
                            if (extensionData == null) continue block10;
                            object.extensions.add(extensionData);
                            break;
                        }
                        case 204: {
                            BDynamicChoiceRange range = BDynamicChoiceRange.parse(serializedObjectElement, object.getPersistentId());
                            if (range == null || range.getOwnerSlotId() == -1) continue block10;
                            object.dynamicChoiceRanges.put(range.getGenuineId(), range);
                            break;
                        }
                        case 254: {
                            BNanoBaseComponent libComponent = controller.getLibraries().getLibraryComponentsCache().get(object.getTypeId());
                            CustomUserData customUserData = CustomUserData.parse(serializedObjectElement, libComponent);
                            if (customUserData != null) {
                                object.customUserData.add(customUserData);
                            }
                            BValue niagaraObject = customUserData.getNiagaraObject();
                            assert (niagaraObject != null) : "invalid custom user data for component " + object.nanoName;
                            if (niagaraObject != null && niagaraObject.isComponent()) {
                                BDynamicChoiceRange[] customUserDataRanges;
                                for (BDynamicChoiceRange customUserDataRange : customUserDataRanges = (BDynamicChoiceRange[])((BComponent)niagaraObject).getChildren(BDynamicChoiceRange.class)) {
                                    object.dynamicChoiceRanges.put(customUserDataRange.getGenuineId(), customUserDataRange);
                                }
                                continue block10;
                            }
                            if (!(niagaraObject instanceof BDynamicChoiceRange)) continue block10;
                            BDynamicChoiceRange dynamicChoiceRange = (BDynamicChoiceRange)niagaraObject;
                            object.dynamicChoiceRanges.put(dynamicChoiceRange.getGenuineId(), dynamicChoiceRange);
                            break;
                        }
                        default: {
                            LOGGER.severe(String.format("[ObjectData.parse()]: Unexpected Data type: marker: '%s'.\nIgnoring this part of object data and proceeding with other data.", new Object[]{marker}));
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        return object;
    }

    public int getTypeId() {
        return this.typeId;
    }

    private void setTypeId(int typeId) {
        this.typeId = typeId;
    }

    public String getNanoName() {
        return this.nanoName;
    }

    public void setNanoName(String nanoName) {
        this.nanoName = nanoName;
    }

    public int getGlobalIndex() {
        return this.globalIndex;
    }

    private void setGlobalIndex(int globalIndex) {
        this.globalIndex = globalIndex;
    }

    public int getParentGlobalIndex() {
        return this.parentGlobalIndex;
    }

    private void setParentGlobalIndex(int parentGlobalIndex) {
        this.parentGlobalIndex = parentGlobalIndex;
    }

    public String getPersistentId() {
        return this.persistentId;
    }

    private void setPersistentId(String persistentId) {
        this.persistentId = persistentId;
    }

    public SlotsValuesData getSlotsValuesData() {
        return this.slotsValuesData;
    }

    private void setSlotsValuesData(SlotsValuesData slotsValuesData) {
        this.slotsValuesData = slotsValuesData;
    }

    public SlotsMetaData getSlotsMetaData() {
        return this.slotsMetaData;
    }

    private void setSlotsMetaData(SlotsMetaData slotsMetaData) {
        this.slotsMetaData = slotsMetaData;
    }

    public ArrayList<ExistingLinkData> getLinks() {
        return this.links;
    }

    private void setLinks(ArrayList<ExistingLinkData> links) {
        this.links = links;
    }

    public ArrayList<ExtensionData> getExtensions() {
        return this.extensions;
    }

    private void setExtensions(ArrayList<ExtensionData> links) {
        this.extensions = this.extensions;
    }

    public void updateNiagaraComponent(BNe2DeviceExt targetController, BNanoBaseComponent existingNiagaraComponent, boolean updateNiagaraLinks) {
        if (existingNiagaraComponent == null) {
            LOGGER.severe("[ObjectData.updateNiagaraComponent()]: Component to update not found in station.\nSkipping Component Update");
            return;
        }
        boolean newInstance = existingNiagaraComponent.getGlobalIndex() == -1;
        existingNiagaraComponent.setNanoName(this.nanoName);
        existingNiagaraComponent.setGlobalIndex(this.globalIndex);
        existingNiagaraComponent.setParentGlobalIndex(this.parentGlobalIndex);
        existingNiagaraComponent.setPersistentId(this.persistentId);
        Property parentSlot = existingNiagaraComponent.getPropertyInParent();
        if (parentSlot != null) {
            BNanoBaseComponent parent = (BNanoBaseComponent)existingNiagaraComponent.getParent();
            if (!parentSlot.getName().equals(SlotPath.escape((String)this.nanoName))) {
                parent.rename(parentSlot, SlotPath.escape((String)this.nanoName), null);
            }
        }
        this.updateNiagaraExtensions(targetController, existingNiagaraComponent, newInstance);
        this.updateCustomUserData(targetController, existingNiagaraComponent, newInstance);
        this.updateNiagaraProperties(existingNiagaraComponent);
        if (updateNiagaraLinks) {
            this.updateNiagaraLinks(existingNiagaraComponent, targetController);
        }
        targetController.getComponentCache().put(existingNiagaraComponent);
    }

    public BNanoBaseComponent createNiagaraComponent(BNe2DeviceExt targetController) {
        BNanoBaseComponent component = targetController.getLibraries().getLibraryComponentsCache().get(this.typeId);
        if (component == null) {
            LOGGER.severe("[ObjectData.createNiagaraComponent()]: Component with typeId '" + this.typeId + "' not found in any library.\nSkipping Component Creation for " + this.nanoName);
            return null;
        }
        component = (BNanoBaseComponent)component.newCopy();
        this.updateNiagaraComponent(targetController, component, true);
        if (this.parentGlobalIndex != -1) {
            BNanoBaseComponent parent = targetController.getComponentCache().getValidParent(component);
            if (parent != null) {
                if (component.getParentGlobalIndex() != parent.getGlobalIndex()) {
                    component.setParentGlobalIndex(parent.getGlobalIndex());
                }
                if (parent.get(component.getDefaultPropertyName()) == null) {
                    if (component.isInvisibleInTree()) {
                        parent.add(component.getDefaultPropertyName(), (BValue)component, 4, Context.decoding);
                    } else {
                        parent.add(component.getDefaultPropertyName(), (BValue)component, Context.decoding);
                    }
                } else {
                    parent.set(component.getDefaultPropertyName(), (BValue)component);
                }
                component = (BNanoBaseComponent)parent.get(component.getDefaultPropertyName());
            } else {
                LOGGER.info(String.format("[ObjectData.createNiagaraComponent()]: Parent component with globalIndex=%d not found.\nChild Component '%s' with globalIndex %d not added.", this.parentGlobalIndex, component.getNanoName(), component.getGlobalIndex()));
            }
        }
        targetController.getComponentCache().put(component);
        if (!targetController.getNanoSubscriptionHandler().isSubscribed(component) && component.isNanoChildOf(targetController.getNanoSubscriptionHandler().getLastParentSubscribed())) {
            component.requestNanoSubscription();
        }
        return component;
    }

    public void updateNiagaraLinks(BNanoBaseComponent existingNiagaraComponent, BNe2DeviceExt targetController) {
        List existingNiagaraLinks = Arrays.stream(existingNiagaraComponent.getLinks()).map(link -> ExistingLinkData.make(link)).collect(Collectors.toList());
        for (ExistingLinkData linkInController : this.links) {
            if (existingNiagaraLinks.contains(linkInController)) {
                existingNiagaraLinks.remove(linkInController);
                continue;
            }
            targetController.getLinkCache().put(existingNiagaraComponent, linkInController);
        }
        for (ExistingLinkData linkInNiagaraButNotInController : existingNiagaraLinks) {
            existingNiagaraComponent.removeLink(linkInNiagaraButNotInController.getTargetSlotId());
        }
    }

    public void updateNiagaraExtensions(BNe2DeviceExt targetController, BNanoBaseComponent hostComponent, boolean wasCopied) {
        BNanoExtension[] existingNiagaraExtensions = (BNanoExtension[])hostComponent.getChildren(BNanoExtension.class);
        List existingNiagaraExtensionData = Arrays.stream(existingNiagaraExtensions).map(existingExtension -> ExtensionData.make(existingExtension)).collect(Collectors.toList());
        int index = 0;
        boolean reloadNeeded = false;
        while (index < this.extensions.size()) {
            ExtensionData controllerExtensionData = this.extensions.get(index);
            if (index > existingNiagaraExtensionData.size() - 1) {
                BNanoExtension nanoExtension = controllerExtensionData.createNiagaraNanoExtension(targetController);
                if (nanoExtension == null) {
                    LOGGER.severe("[ObjectData.updateNiagaraExtensions()]: Extension with typeId '" + controllerExtensionData.getTypeId() + "' not found in any library.\nSkipping Extension Creation for " + this.nanoName);
                    ++index;
                    continue;
                }
                try {
                    String extName = SlotPath.escape((String)UUID.randomUUID().toString());
                    if (!hostComponent.extensionExists(nanoExtension.getExtensionId())) {
                        hostComponent.add(extName, (BValue)nanoExtension, Context.decoding);
                        this.addExtensionSlots(hostComponent, nanoExtension, Context.decoding);
                        existingNiagaraExtensionData.add(index, controllerExtensionData);
                        reloadNeeded = true;
                    }
                }
                catch (Exception e) {
                    LOGGER.severe("FAILED TO ADD EXTENSION TO NIAGARA");
                    e.printStackTrace();
                }
                ++index;
                continue;
            }
            if (existingNiagaraExtensions[index].getExtensionId() == -1) {
                BNanoExtension addedExtension = existingNiagaraExtensions[index];
                addedExtension.setExtensionId(controllerExtensionData.getExtensionId());
                if (!wasCopied) {
                    this.addExtensionSlots(hostComponent, addedExtension, Context.decoding);
                    existingNiagaraExtensionData.add(index, ExtensionData.make(addedExtension));
                    reloadNeeded = true;
                }
                ++index;
                continue;
            }
            if (controllerExtensionData.equals(existingNiagaraExtensionData.get(index))) {
                ++index;
                continue;
            }
            if (controllerExtensionData.equals(existingNiagaraExtensionData.get(index))) continue;
            ExtensionData extensionDataToRemove = (ExtensionData)existingNiagaraExtensionData.get(index);
            Property extensionPropertyToRemove = hostComponent.getNanoExtensionProperty(extensionDataToRemove.getExtensionId());
            BNanoExtension extensionToRemove = (BNanoExtension)hostComponent.get(extensionPropertyToRemove);
            hostComponent.remove((BComplex)extensionToRemove);
            this.removeExtensionSlots(hostComponent, extensionToRemove, Context.decoding);
            existingNiagaraExtensions = (BNanoExtension[])hostComponent.getChildren(BNanoExtension.class);
            existingNiagaraExtensionData = Arrays.stream(existingNiagaraExtensions).map(existingExtension -> ExtensionData.make(existingExtension)).collect(Collectors.toList());
            reloadNeeded = true;
        }
        existingNiagaraExtensions = (BNanoExtension[])hostComponent.getChildren(BNanoExtension.class);
        while (index < existingNiagaraExtensions.length) {
            BNanoExtension extensionToRemove = existingNiagaraExtensions[index];
            hostComponent.remove((BComplex)extensionToRemove);
            this.removeExtensionSlots(hostComponent, extensionToRemove, Context.decoding);
            ++index;
            reloadNeeded = true;
        }
        if (this.fixExtensionNames(hostComponent)) {
            reloadNeeded = true;
        }
        if (reloadNeeded && !targetController.getApplicationIsLoading()) {
            targetController.doUpdateWbUi(hostComponent);
        }
    }

    public void updateCustomUserData(BNe2DeviceExt targetController, BNanoBaseComponent hostComponent, boolean wasCopied) {
        for (CustomUserData controllerCustomUserData : this.customUserData) {
            BValue niagaraCustomUserDataObject = controllerCustomUserData.getNiagaraObject();
            String propName = null;
            BFacets facets = null;
            if (niagaraCustomUserDataObject == null) {
                LOGGER.severe("[ObjectData.updateCustomUserData()]: CustomUserData is null '\nSkipping CustomUserData Creation for " + this.nanoName);
                continue;
            }
            if (niagaraCustomUserDataObject.getType().is(BAbstractSchedule.TYPE)) {
                BAbstractSchedule schedule = (BAbstractSchedule)niagaraCustomUserDataObject;
                this.updateWeeklyAndSpecialEvents(targetController, hostComponent, schedule);
                propName = null != schedule.getName() ? schedule.getName() : (schedule.getType().is(BNanoCalendar.TYPE) ? "NanoCalendar" : "NanoWeeklySchedule");
            } else if (niagaraCustomUserDataObject.getType().is(BDynamicChoiceRange.TYPE)) {
                facets = BFacets.make((String)"nano_type", (String)"multistateRange");
                propName = ((BDynamicChoiceRange)niagaraCustomUserDataObject).getGenuineId();
            } else {
                LOGGER.severe("[ObjectData.updateCustomUserData()]: CustomUserData for base library '" + controllerCustomUserData.getBaseLibraryName() + "' not found.\nSkipping CustomUserData Creation for " + this.nanoName);
                continue;
            }
            try {
                if (hostComponent.get(propName) == null) {
                    hostComponent.add(propName, niagaraCustomUserDataObject, 0, facets, Context.decoding);
                    continue;
                }
                hostComponent.set(propName, niagaraCustomUserDataObject);
            }
            catch (Exception e) {
                LOGGER.severe("FAILED TO ADD CustomUserData TO NIAGARA");
                e.printStackTrace();
            }
        }
    }

    private void updateWeeklyAndSpecialEvents(BNe2DeviceExt targetController, BNanoBaseComponent hostComponent, BAbstractSchedule abstractSchedule) {
        BNanoWeekSchedule weekSchedule = new BNanoWeekSchedule();
        this.updateWeeklyEvents(abstractSchedule, weekSchedule);
        BCompositeSchedule specialEventsSchedule = new BCompositeSchedule();
        this.updateSpecialEvents(targetController, hostComponent, abstractSchedule, specialEventsSchedule);
        if (abstractSchedule instanceof BNanoSchedule) {
            ((BNanoSchedule)abstractSchedule).setWeekSchedule(weekSchedule);
            ((BNanoSchedule)abstractSchedule).setSpecialEvents(specialEventsSchedule);
        }
    }

    private void updateWeeklyEvents(BAbstractSchedule abstractSchedule, BNanoWeekSchedule weekSchedule) {
        BNanoSchedule schedule;
        int count;
        if (abstractSchedule instanceof BNanoSchedule && (count = (schedule = (BNanoSchedule)abstractSchedule).getScheduleEventsList().size()) > 0) {
            block5: for (int i = 0; i < count; ++i) {
                ScheduleEvent scheduleEvent = schedule.getScheduleEventsList().get(i);
                int weekDay = scheduleEvent.start.getDayOfWeek().getValue();
                BTime start = BTime.make((int)scheduleEvent.start.toLocalTime().getHour(), (int)scheduleEvent.start.toLocalTime().getMinute(), (int)scheduleEvent.start.toLocalTime().getSecond());
                BTime finish = BTime.make((int)scheduleEvent.end.toLocalTime().getHour(), (int)scheduleEvent.end.toLocalTime().getMinute(), (int)scheduleEvent.end.toLocalTime().getSecond());
                switch (schedule.getScheduleType().getOrdinal()) {
                    case 0: {
                        weekSchedule.schedule(weekDay).getDay().add(start, finish, (BStatusValue)new BStatusNumeric(scheduleEvent.getNumericValue()), Context.decoding);
                        continue block5;
                    }
                    case 1: {
                        weekSchedule.schedule(weekDay).getDay().add(start, finish, (BStatusValue)new BStatusBoolean(scheduleEvent.getBinaryValue()), Context.decoding);
                        continue block5;
                    }
                    case 2: {
                        weekSchedule.schedule(weekDay).getDay().add(start, finish, (BStatusValue)new BStatusEnum((BEnum)BDynamicEnum.make((int)((int)scheduleEvent.getNumericValue()))), Context.decoding);
                        continue block5;
                    }
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateSpecialEvents(BNe2DeviceExt targetController, BNanoBaseComponent hostComponent, BAbstractSchedule schedule, BCompositeSchedule specialEventsSchedule) {
        List<ISchedule> specialEventsList = schedule instanceof BNanoSchedule ? ((BNanoSchedule)schedule).getSpecialEventsList() : ((BNanoCalendar)schedule).getSpecialEventsList();
        Iterator<ISchedule> iterator = specialEventsList.iterator();
        while (iterator.hasNext()) {
            ISchedule specialEvent = iterator.next();
            try {
                void var17_27;
                BDailySchedule dailySchedule;
                block39: {
                    block37: {
                        Month startMonthOfYear;
                        Category category;
                        block40: {
                            block38: {
                                int dayOfWeek;
                                dailySchedule = new BDailySchedule();
                                if (schedule instanceof BNanoSchedule) {
                                    long[] secondsOfChange = specialEvent.getValues().GetChangeTimes();
                                    double[] scheduledValues = specialEvent.getValues().GetValues();
                                    int i = 0;
                                    while (i < secondsOfChange.length) {
                                        try {
                                            BStatusNumeric value = new BStatusNumeric(scheduledValues[i]);
                                            BTime start = BTime.make((int)((int)(secondsOfChange[i] / 3600L)), (int)((int)(secondsOfChange[i] % 3600L / 60L)), (int)((int)(secondsOfChange[i] % 60L)));
                                            BTime finish = secondsOfChange[++i] / 3600L == 24L ? BTime.MIDNIGHT : BTime.make((int)((int)(secondsOfChange[i] / 3600L)), (int)((int)(secondsOfChange[i] % 3600L / 60L)), (int)((int)(secondsOfChange[i] % 60L)));
                                            switch (((BNanoSchedule)schedule).getScheduleType().getOrdinal()) {
                                                case 0: {
                                                    BFacets facets;
                                                    try {
                                                        BUnit unit = BUnitMap.getNiagaraUnit(((BStatusEnum)hostComponent.get("units")).getEnum().getOrdinal());
                                                        if (unit != null) {
                                                            facets = BFacets.make((String)"units", (BIDataValue)unit);
                                                            schedule.setFacets(schedule.getSlot("facets"), facets);
                                                        }
                                                    }
                                                    catch (Exception unit) {
                                                        // empty catch block
                                                    }
                                                    dailySchedule.add(start, finish, (BStatusValue)value, Context.decoding);
                                                    break;
                                                }
                                                case 1: {
                                                    BFacets facets;
                                                    BDynamicChoiceRange labels = schedule instanceof BNanoSchedule ? ((BNanoSchedule)schedule).getLabels() : ((BNanoCalendar)schedule).getLabels();
                                                    BFacets bFacets = facets = null != labels ? labels.asFacets(BBoolean.TYPE, null) : null;
                                                    if (null != facets) {
                                                        schedule.setFacets(schedule.getSlot("facets"), facets);
                                                    }
                                                    BStatusBoolean bStatusBoolean = new BStatusBoolean(value.getValue() > 0.0, BStatus.ok);
                                                    dailySchedule.add(start, finish, (BStatusValue)bStatusBoolean, Context.decoding);
                                                    break;
                                                }
                                                case 2: {
                                                    BFacets facets;
                                                    BDynamicChoiceRange labels = schedule instanceof BNanoSchedule ? ((BNanoSchedule)schedule).getLabels() : ((BNanoCalendar)schedule).getLabels();
                                                    BFacets bFacets = facets = null != labels ? labels.asFacets(BEnum.TYPE, null) : null;
                                                    if (null != facets) {
                                                        schedule.setFacets(schedule.getSlot("facets"), facets);
                                                    }
                                                    BStatusEnum bStatusEnum = new BStatusEnum((BEnum)BDynamicEnum.make((int)((int)value.getValue())), BStatus.ok);
                                                    dailySchedule.add(start, finish, (BStatusValue)bStatusEnum, Context.decoding);
                                                    break;
                                                }
                                            }
                                            if (!DoubleComparer.IsEqualTo(scheduledValues[i], Double.NaN)) continue;
                                            ++i;
                                        }
                                        catch (Exception e) {
                                            e.printStackTrace();
                                            System.out.println("Caught an exception! stop processing. Exception: " + e.getMessage());
                                            break;
                                        }
                                    }
                                }
                                Object var17_31 = null;
                                if (!(specialEvent instanceof ExceptionalDays)) break block37;
                                category = ((ExceptionalDays)specialEvent).Kind();
                                if (!category.equals((Object)Category.DatePattern)) break block38;
                                try {
                                    DayOfWeek weekDay = ((ExceptionalDays)specialEvent).getChosenDayOfWeek();
                                    dayOfWeek = weekDay.equals(DayOfWeek.SUNDAY) ? 0 : weekDay.getValue();
                                }
                                catch (Exception e) {
                                    dayOfWeek = -1;
                                }
                                DayOfMonth startDayOfMonth = ((ExceptionalDays)specialEvent).getStartDateDayOfMonth();
                                startMonthOfYear = ((ExceptionalDays)specialEvent).getStartDateMonthOfYear();
                                int startYear = ((ExceptionalDays)specialEvent).getStartDateYear();
                                int startDay = startDayOfMonth != null ? startDayOfMonth.getValue() : -1;
                                int startMonthValue = startMonthOfYear != null ? startMonthOfYear.getValue() - 1 : -1;
                                BNanoDateSchedule bNanoDateSchedule = new BNanoDateSchedule();
                                bNanoDateSchedule.setWeekday(dayOfWeek);
                                bNanoDateSchedule.setDay(startDay);
                                bNanoDateSchedule.setMonth(startMonthValue);
                                bNanoDateSchedule.setYear(startYear);
                                break block39;
                            }
                            if (!category.equals((Object)Category.DateRange)) break block40;
                            DayOfMonth startDayOfMonth = ((ExceptionalDays)specialEvent).getStartDateDayOfMonth();
                            startMonthOfYear = ((ExceptionalDays)specialEvent).getStartDateMonthOfYear();
                            int startYear = ((ExceptionalDays)specialEvent).getStartDateYear();
                            int startDay = startDayOfMonth != null ? startDayOfMonth.getValue() : -1;
                            BMonth startMonth = startMonthOfYear != null ? BMonth.make((int)(startMonthOfYear.getValue() - 1)) : BMonth.DEFAULT;
                            BNanoDateSchedule startDateSchedule = new BNanoDateSchedule(startDay, startMonth, startYear);
                            DayOfMonth endDayOfMonth = ((ExceptionalDays)specialEvent).getEndDateDayOfMonth();
                            Month endMonthOfYear = ((ExceptionalDays)specialEvent).getEndDateMonthOfYear();
                            int endYear = ((ExceptionalDays)specialEvent).getEndDateYear();
                            int endDay = endDayOfMonth != null ? endDayOfMonth.getValue() : -1;
                            BMonth endMonth = endMonthOfYear != null ? BMonth.make((int)(endMonthOfYear.getValue() - 1)) : BMonth.DEFAULT;
                            BNanoDateSchedule endDateSchedule = new BNanoDateSchedule(endDay, endMonth, endYear);
                            BNanoDateRangeSchedule bNanoDateRangeSchedule = new BNanoDateRangeSchedule();
                            bNanoDateRangeSchedule.setStart(startDateSchedule);
                            bNanoDateRangeSchedule.setEnd(endDateSchedule);
                            break block39;
                        }
                        if (category.equals((Object)Category.WeekAndDay)) {
                            int dayOfWeek;
                            try {
                                DayOfWeek weekDay = ((ExceptionalDays)specialEvent).getChosenDayOfWeek();
                                dayOfWeek = weekDay.equals(DayOfWeek.SUNDAY) ? 0 : weekDay.getValue();
                            }
                            catch (Exception e) {
                                dayOfWeek = -1;
                            }
                            WeekOfMonth weekOfMonth = ((ExceptionalDays)specialEvent).getChosenWeekOfMonth();
                            startMonthOfYear = ((ExceptionalDays)specialEvent).getStartDateMonthOfYear();
                            BNanoWeekAndDaySchedule bNanoWeekAndDaySchedule = new BNanoWeekAndDaySchedule(dayOfWeek, weekOfMonth, startMonthOfYear);
                            break block39;
                        } else if (!category.equals((Object)Category.Custom)) {
                            // empty if block
                        }
                        break block39;
                    }
                    if (specialEvent instanceof DaysFromCalendar) {
                        BScheduleReference bScheduleReference = new BScheduleReference();
                        String persistentId = String.valueOf(((DaysFromCalendar)specialEvent).getCalendarPersistentId());
                        if (!persistentId.equals("0")) {
                            BNanoComponent refCalendar = null;
                            BOrd compOrd = targetController.doGetNanoComponentByPersistentId(BString.make((String)persistentId));
                            if (compOrd != BOrd.DEFAULT) {
                                refCalendar = (BNanoComponent)compOrd.get((BObject)targetController);
                            }
                            if (null == refCalendar) {
                                refCalendar = (BNanoComponent)targetController.getComponentCache().get(persistentId);
                            }
                            if (refCalendar != null) {
                                BOrd refOrd = BOrd.DEFAULT;
                                if (refCalendar.getSlotPathOrd() != null) {
                                    refOrd = BOrd.make((String)(refCalendar.getSlotPathOrd().toString() + "/NanoCalendar"));
                                } else {
                                    Vector<String> parents = new Vector<String>();
                                    BNanoBaseComponent parent = targetController.getComponentCache().getValidParent(refCalendar);
                                    while (parent.getParentGlobalIndex() != -1) {
                                        parents.add(parent.getNanoName());
                                        parent = targetController.getComponentCache().getValidParent(parent);
                                    }
                                    refOrd = BOrd.make((String)(targetController.getSlotPathOrd().toString() + "/Root"));
                                    StringBuilder sb = new StringBuilder(refOrd.toString());
                                    for (int i = parents.size() - 1; i >= 0; --i) {
                                        sb.append("/").append((String)parents.get(i));
                                    }
                                    sb.append("/").append(SlotPath.escape((String)refCalendar.getNanoName())).append("/").append("NanoCalendar");
                                    refOrd = BOrd.make((String)sb.toString());
                                }
                                bScheduleReference.setRef(refOrd);
                            }
                        }
                    }
                }
                BNanoBacnetPriorityEnum bacPriorityEnum = BNanoBacnetPriorityEnum.DEFAULT;
                try {
                    bacPriorityEnum = BNanoBacnetPriorityEnum.make(specialEvent.getPriority());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                var17_27.add(ScheduleUtils.BACNET_PRIORITY, (BValue)bacPriorityEnum, 4);
                if (schedule instanceof BNanoSchedule) {
                    dailySchedule.setDays((BAbstractSchedule)var17_27);
                    specialEventsSchedule.add(SlotPath.escape((String)specialEvent.getScheduleName()), (BValue)dailySchedule);
                    continue;
                }
                ((BNanoCalendar)schedule).add(SlotPath.escape((String)specialEvent.getScheduleName()), (BValue)var17_27);
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
        return;
    }

    public void updateNiagaraProperties(BNanoBaseComponent component) {
        if (this.slotsValuesData != null && this.slotsMetaData != null && this.slotsValuesData.size() == this.slotsMetaData.size()) {
            boolean needsRefresh = false;
            boolean valueUpdateSucceeded = true;
            for (int i = 0; i < this.slotsMetaData.size(); ++i) {
                SlotMetaData slotMetaData = this.slotsMetaData.getSlotMetaData(i);
                Property slot = component.getNanoSlot(slotMetaData.getSlotId());
                if (slot != null) {
                    if (!ObjectData.updateNiagaraPropertyValue(component, (Slot)slot, this.slotsValuesData.getSlotValueData(i), this.dynamicChoiceRanges)) {
                        valueUpdateSucceeded = false;
                    }
                    if (!ObjectData.updateNiagaraSlotDef(component, (Slot)slot, slotMetaData)) continue;
                    needsRefresh = true;
                    continue;
                }
                LOGGER.severe(String.format("[ObjectData.updateNiagaraProperties()]: Invalid SlotsMetaData: Slot with slotId=%d not found in component %s with global id=%d .\nSkipping update of this slot.", slotMetaData.getSlotId(), component.getNanoName(), component.getGlobalIndex()));
            }
            if (valueUpdateSucceeded) {
                component.setInitComplete(true);
            }
        } else {
            LOGGER.severe("[ObjectData.updateNiagaraProperties()]: SlotsMetaData or SlotsValuesData unavailable or invalid size.\nSkipping tree component flag & facet update.");
        }
    }

    public static boolean updateNiagaraPropertyValue(BNanoBaseComponent targetComponent, Slot targetSlot, Object nanoValue, Map<String, BDynamicChoiceRange> dynamicChoiceRanges) {
        if (!targetSlot.isProperty()) {
            return false;
        }
        Property targetProp = targetSlot.asProperty();
        AttributeData nullableAttribute = targetComponent.getNanoAttribute(targetSlot, "nullable");
        if (!(nanoValue != null || nullableAttribute != null && nullableAttribute.getAttrValue().equals("true") || targetProp.getType().is(BDynamicChoice.TYPE) || targetProp.getType().is(BStatusDynamicChoice.TYPE))) {
            LOGGER.severe(String.format("BinaryApplicationParser.updateNiagaraPropertyValue(): Cannot update Niagara Component targetSlot '%s.%s' with a value of null. .\nSkipping value update.", targetComponent.getNanoName(), targetSlot));
            return false;
        }
        BStatus status = nanoValue != null ? BStatus.ok : BStatus.nullStatus;
        switch (targetProp.getTypeAccess()) {
            case 0: {
                if (nanoValue == null) {
                    return false;
                }
                Boolean booleanValue = (Boolean)nanoValue;
                targetComponent.setBoolean(targetProp, booleanValue);
                return true;
            }
            case 5: {
                if (nanoValue == null) {
                    return false;
                }
                Double doubleValue = (Double)nanoValue;
                if (doubleValue != null) {
                    targetComponent.setDouble(targetProp, doubleValue);
                }
                return true;
            }
            case 4: {
                if (nanoValue == null) {
                    return false;
                }
                Float floatValue = (Float)nanoValue;
                targetComponent.setFloat(targetProp, floatValue.floatValue());
                return true;
            }
            case 2: {
                if (nanoValue == null) {
                    return false;
                }
                Integer intValue = (Integer)nanoValue;
                targetComponent.setInt(targetProp, intValue);
                return true;
            }
            case 3: {
                if (nanoValue == null) {
                    return false;
                }
                Long longValue = (Long)nanoValue;
                targetComponent.setLong(targetProp, longValue);
                return true;
            }
            case 6: {
                if (nanoValue == null) {
                    return false;
                }
                String stringValue = (String)nanoValue;
                targetComponent.setString(targetProp, stringValue);
                return true;
            }
            case 7: {
                try {
                    if (targetProp.getType().is(BNanoStatusNumeric.TYPE)) {
                        Double doubleValue;
                        BNanoStatusNumeric newValue;
                        BNanoStatusNumeric currentValue = (BNanoStatusNumeric)targetComponent.get(targetProp);
                        if (!currentValue.equivalent((Object)(newValue = new BNanoStatusNumeric(doubleValue = Double.valueOf(nanoValue != null ? (Double)nanoValue : 0.0), status)))) {
                            targetComponent.set(targetProp, (BValue)newValue);
                        }
                    } else if (targetProp.getType().is(BStatusNumeric.TYPE)) {
                        Double doubleValue;
                        BStatusNumeric newValue;
                        BStatusNumeric currentValue = (BStatusNumeric)targetComponent.get(targetProp);
                        if (!currentValue.equivalent((Object)(newValue = new BStatusNumeric((doubleValue = Double.valueOf(nanoValue != null ? (Double)nanoValue : 0.0)).doubleValue(), status)))) {
                            targetComponent.set(targetProp, (BValue)newValue);
                        }
                    } else if (targetProp.getType().is(BStatusEnum.TYPE)) {
                        Integer intValue;
                        BStatusEnum newValue;
                        BStatusEnum currentValue = (BStatusEnum)targetComponent.get(targetProp);
                        if (!currentValue.equivalent((Object)(newValue = new BStatusEnum((BEnum)BDynamicEnum.make((int)(intValue = Integer.valueOf(nanoValue != null ? ((Double)nanoValue).intValue() : 0))), status)))) {
                            targetComponent.set(targetProp, (BValue)newValue);
                        }
                    } else if (targetProp.getType().is(BStatusBoolean.TYPE)) {
                        Boolean booleanValue;
                        BStatusBoolean newValue;
                        BStatusBoolean currentValue = (BStatusBoolean)targetComponent.get(targetProp);
                        if (!currentValue.equivalent((Object)(newValue = new BStatusBoolean((booleanValue = Boolean.valueOf(nanoValue != null ? (Boolean)nanoValue : false)).booleanValue(), status)))) {
                            targetComponent.set(targetProp, (BValue)newValue);
                        }
                    } else if (targetProp.getType().is(BStatusString.TYPE)) {
                        String stringValue;
                        BStatusString newValue;
                        BStatusString currentValue = (BStatusString)targetComponent.get(targetProp);
                        if (!currentValue.equivalent((Object)(newValue = new BStatusString(stringValue = nanoValue != null ? (String)nanoValue : "", status)))) {
                            targetComponent.set(targetProp, (BValue)newValue);
                        }
                    } else if (targetProp.getType().is(BDynamicChoice.TYPE) || targetProp.getType().is(BStatusDynamicChoice.TYPE)) {
                        BDynamicChoice choiceValue;
                        String dynamicChoiceName;
                        BDynamicChoiceRange rangeForSlot = null;
                        AttributeData enumeratedAttribute = targetComponent.getNanoAttribute(targetSlot, "enumerated");
                        String string = dynamicChoiceName = enumeratedAttribute != null ? enumeratedAttribute.getAttrValue().replaceFirst("\\$:", "").trim() : null;
                        if (dynamicChoiceName != null && (rangeForSlot = dynamicChoiceRanges.get(dynamicChoiceName)) == null) {
                            rangeForSlot = (BDynamicChoiceRange)targetComponent.get(dynamicChoiceName);
                        }
                        if (rangeForSlot == null) {
                            String slotId = String.valueOf(targetComponent.getNanoSlotId(targetProp));
                            rangeForSlot = dynamicChoiceRanges.get(slotId);
                        }
                        if (rangeForSlot == null) {
                            rangeForSlot = targetProp.getType().is(BDynamicChoice.TYPE) ? ((BDynamicChoice)targetComponent.get(targetProp)).getRange() : ((BStatusDynamicChoice)targetComponent.get(targetProp)).getValue().getRange();
                        }
                        BDynamicChoice bDynamicChoice = choiceValue = rangeForSlot != null ? rangeForSlot.getChoiceForKey(nanoValue) : BDynamicChoice.DEFAULT;
                        if (targetProp.getType().is(BDynamicChoice.TYPE)) {
                            if (!targetComponent.get(targetProp).equivalent((Object)choiceValue)) {
                                targetComponent.set(targetProp, (BValue)choiceValue);
                            }
                        } else {
                            BStatusDynamicChoice newValue = new BStatusDynamicChoice(choiceValue, status);
                            if (!targetComponent.get(targetProp).equivalent((Object)newValue)) {
                                targetComponent.set(targetProp, (BValue)newValue);
                            }
                        }
                    }
                }
                catch (Exception e) {
                    LOGGER.severe(String.format("[ObjectData.updateNiagaraPropertyValue()]: Cannot update Niagara Component targetSlot '%s.%s' with a value of '%s'. .\nSkipping value update.", targetComponent.getNanoName(), targetSlot, nanoValue));
                    return false;
                }
                return true;
            }
        }
        LOGGER.severe(String.format("[ObjectData.updateNiagaraPropertyValue()]: Cannot update Niagara Component targetSlot '%s.%s' with a value of '%s'. .\nSkipping value update.", targetComponent.getNanoName(), targetSlot, nanoValue));
        return false;
    }

    public static boolean updateNiagaraSlotDef(BNanoBaseComponent targetComponent, Slot targetSlot, SlotMetaData metaData) {
        int originFlags;
        int newFlags = originFlags = targetComponent.getOriginFlags(targetSlot);
        int currentFlags = targetComponent.getFlags(targetSlot);
        BFacets facets = targetComponent.getSlotFacets(targetSlot);
        if (metaData.getMetaDataFlags().isHidden()) {
            newFlags = Flags.add((int)newFlags, (int[])new int[]{4});
        }
        if (metaData.getMetaDataFlags().isReadOnly()) {
            newFlags = Flags.add((int)newFlags, (int[])new int[]{1});
        }
        if (metaData.getMetaDataFlags().isNullable()) {
            facets = BFacets.make((BFacets)facets, (BFacets)BFacets.make((String)"allowNull", (boolean)metaData.getMetaDataFlags().isNullable()));
        }
        facets = BFacets.make((BFacets)facets, (BFacets)BFacets.make((String)"precision", (int)metaData.getPrecision()));
        facets = BFacets.make((BFacets)facets, (BFacets)metaData.asFacets());
        boolean changed = false;
        if (newFlags != currentFlags) {
            targetComponent.setFlags(targetSlot, newFlags);
            changed = true;
        }
        targetComponent.setFacets(targetSlot, facets);
        return changed;
    }

    public String toDebugString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Object Data           = " + this.getNanoName());
        sb.append("\n  TypeId            = " + this.getTypeId());
        sb.append("\n  GlobalIndex       = " + this.getGlobalIndex());
        sb.append("\n  ParentGlobalIndex = " + this.getParentGlobalIndex());
        sb.append("\n  PersistentId      = " + this.getPersistentId());
        return sb.toString();
    }

    private void saveAndRemoveIncomingLinks(BNanoBaseComponent existingNiagaraComponent) {
        Knob[] knobs;
        ArrayList<ExistingLinkData> linkDataList = new ArrayList<ExistingLinkData>();
        for (Knob knob : knobs = existingNiagaraComponent.getKnobs()) {
            BLink link = knob.getLink();
            BNanoBaseComponent targetComponent = (BNanoBaseComponent)link.getTargetComponent();
            int sourceComponentGlobalIndex = existingNiagaraComponent.getGlobalIndex();
            int targetComponentGlobalIndex = targetComponent.getGlobalIndex();
            int sourceSlotId = existingNiagaraComponent.getNanoSlotId(link.getSourceSlot().asProperty());
            int targetSlotId = targetComponent.getNanoSlotId(link.getTargetSlot().asProperty());
            BNanoLinkInfoArg linkInfoArg = new BNanoLinkInfoArg(sourceComponentGlobalIndex, sourceSlotId, targetComponentGlobalIndex, targetSlotId);
            linkDataList.add(ExistingLinkData.make(linkInfoArg));
            targetComponent.remove(link.getPropertyInParent(), Context.decoding);
        }
    }

    private void notifyPropertyAdded(BNanoBaseComponent component, Property slot) {
        Subscriber[] subscribers;
        for (Subscriber subscriber : subscribers = component.getSubscribers()) {
            if (!ProxyBroker.class.isAssignableFrom(subscriber.getClass())) continue;
            BComponentEvent event = new BComponentEvent(1, (BComponent)component, (Slot)slot, null);
            subscriber.event(event);
        }
    }

    private void notifyPropertyRemoved(BNanoBaseComponent component, Property slot) {
        Subscriber[] subscribers;
        for (Subscriber subscriber : subscribers = component.getSubscribers()) {
            if (!ProxyBroker.class.isAssignableFrom(subscriber.getClass())) continue;
            BComponentEvent event = new BComponentEvent(2, (BComponent)component, (Slot)slot, null);
            subscriber.event(event);
        }
    }

    private void notifyPropertyRenamed(BNanoBaseComponent component, Property slot, String oldName) {
        Subscriber[] subscribers;
        for (Subscriber subscriber : subscribers = component.getSubscribers()) {
            if (!ProxyBroker.class.isAssignableFrom(subscriber.getClass())) continue;
            BComponentEvent event = new BComponentEvent(3, (BComponent)component, (Slot)slot, (BValue)BString.make((String)oldName));
            subscriber.event(event);
        }
    }

    public void addExtensionSlots(BNanoBaseComponent hostComponent, BNanoExtension addedExtension, Context context) {
        String propName;
        if (addedExtension == null) {
            return;
        }
        int extensionId = addedExtension.makeValidExtensionId(hostComponent);
        int maxParentSlotId = hostComponent.getMaxNanoSlotId();
        TreeMap extensionSlotsSortedById = new TreeMap(addedExtension.nanoSlotsByOrdinal);
        for (Map.Entry extensionSlotEntry : extensionSlotsSortedById.entrySet()) {
            Property extensionProperty = (Property)extensionSlotEntry.getValue();
            BFacets extensionFacets = addedExtension.getSlotFacets((Slot)extensionProperty);
            int extensionSlotId = (Integer)extensionSlotEntry.getKey() + maxParentSlotId + 1;
            extensionFacets = BFacets.make((BFacets)extensionFacets, (String)"nano_slotId", (BIDataValue)BInteger.make((int)extensionSlotId));
            propName = "e" + extensionId + "_" + extensionProperty.getName();
            BValue extensionPropVal = addedExtension.get(extensionProperty).newCopy();
            BValue parentPropVal = hostComponent.get(propName);
            if (!(parentPropVal == null || parentPropVal.getType().equals(extensionPropVal.getType()) && hostComponent.getSlotFacets((Slot)extensionProperty).equivalent((Object)extensionFacets))) {
                hostComponent.remove(propName);
                parentPropVal = null;
            }
            if (parentPropVal != null) continue;
            Property newProp = hostComponent.add(propName, extensionPropVal, addedExtension.getFlags((Slot)extensionProperty), extensionFacets, context);
            hostComponent.setDisplayName(newProp, BFormat.make((String)extensionProperty.getName()), null);
        }
        for (Map.Entry extensionActionEntry : addedExtension.nanoActionsByName.entrySet()) {
            Property extensionActionProp = (Property)extensionActionEntry.getValue();
            String actionName = (String)extensionActionEntry.getKey();
            BNanoAction extensionAction = (BNanoAction)addedExtension.get(extensionActionProp).newCopy().as(BNanoAction.class);
            propName = "e" + extensionId + "_" + actionName;
            BValue parentAction = hostComponent.get(propName);
            Property parentActionProp = hostComponent.getProperty(propName);
            if (parentAction != null && !parentAction.getType().equals(extensionAction.getType())) {
                hostComponent.remove(propName);
                parentAction = null;
            }
            if (parentAction == null) {
                parentActionProp = hostComponent.add(propName, (BValue)extensionAction, addedExtension.getFlags((Slot)extensionActionProp), addedExtension.getSlotFacets((Slot)extensionActionProp), null);
                hostComponent.setDisplayName(parentActionProp, BFormat.make((String)actionName), null);
            }
            if (parentActionProp.equals(hostComponent.nanoActionsByName.get(actionName))) {
                hostComponent.setFlags((Slot)parentActionProp, hostComponent.getFlags((Slot)parentActionProp) & 0xFFFFFFFB);
                continue;
            }
            hostComponent.setFlags((Slot)parentActionProp, hostComponent.getFlags((Slot)parentActionProp) | 4);
        }
    }

    public void removeExtensionSlots(BNanoBaseComponent hostComponent, BNanoExtension removedExtension, Context ctx) {
        Property parentProp;
        String propName;
        int removedExtensionId = removedExtension.makeValidExtensionId(hostComponent);
        TreeMap extensionSlotsSortedById = new TreeMap(removedExtension.nanoSlotsByOrdinal);
        int slotIdCorrection = extensionSlotsSortedById.size() == 0 ? 0 : (Integer)extensionSlotsSortedById.lastKey() + 1;
        for (Map.Entry extensionSlotEntry : extensionSlotsSortedById.entrySet()) {
            propName = "e" + removedExtensionId + "_" + ((Property)extensionSlotEntry.getValue()).getName();
            parentProp = hostComponent.getProperty(propName);
            if (parentProp == null) continue;
            hostComponent.remove(parentProp);
        }
        for (Map.Entry extensionActionEntry : removedExtension.nanoActionsByName.entrySet()) {
            propName = "e" + removedExtensionId + "_" + ((Property)extensionActionEntry.getValue()).getName();
            parentProp = hostComponent.getProperty(propName);
            if (parentProp == null) continue;
            hostComponent.remove(parentProp);
        }
        BNanoExtension[] existingExtensions = (BNanoExtension[])hostComponent.getChildren(BNanoExtension.class);
        int updatedExtensions = 0;
        for (BNanoExtension existingExtension : existingExtensions) {
            int existingExtensionId = existingExtension.getExtensionId();
            if (existingExtensionId > removedExtensionId) {
                Property[] parentProperties;
                int newId = removedExtensionId + updatedExtensions;
                ++updatedExtensions;
                existingExtension.setExtensionId(newId);
                for (Property property : parentProperties = hostComponent.getDynamicPropertiesArray()) {
                    String propertyName = property.getName();
                    if (!hostComponent.isNanoSlot((Slot)property) || !propertyName.startsWith("e" + existingExtensionId + "_")) continue;
                    hostComponent.rename(property, propertyName.replaceFirst("e" + existingExtensionId + "_", "e" + newId + "_"), null);
                    hostComponent.setDisplayName(property, BFormat.make((String)BNanoBaseComponent.getOriginNameFromProperty(property)), ctx);
                    int currentSlotId = hostComponent.getNanoSlotId(property);
                    if (currentSlotId <= -1) continue;
                    hostComponent.replaceNanoSlotId(property, currentSlotId - slotIdCorrection);
                }
            }
            Property[] parentProperties = hostComponent.getDynamicPropertiesArray();
            block4: for (String extensionActionName : removedExtension.nanoActionsByName.keySet()) {
                Property cachedActionProperty = hostComponent.nanoActionsByName.get(extensionActionName);
                if (cachedActionProperty != null && BNanoBaseComponent.getIdFromExtensionProperty(cachedActionProperty) != removedExtensionId) continue;
                for (Property actionProperty : parentProperties) {
                    if (!actionProperty.getType().is(BNanoAction.TYPE) || !BNanoBaseComponent.getOriginNameFromProperty(actionProperty).equals(extensionActionName)) continue;
                    hostComponent.nanoActionsByName.put(extensionActionName, actionProperty);
                    hostComponent.setFlags((Slot)actionProperty, hostComponent.getFlags((Slot)actionProperty) & 0xFFFFFFFB, ctx);
                    continue block4;
                }
            }
        }
    }

    private boolean fixExtensionNames(BNanoBaseComponent hostComponent) {
        AtomicBoolean wasUpdated = new AtomicBoolean(false);
        BNanoExtension[] nanoExtensions = (BNanoExtension[])hostComponent.getChildren(BNanoExtension.class);
        Arrays.stream(nanoExtensions).sorted(Comparator.comparing(BNanoExtension::getExtensionId)).forEach(nanoExtension -> {
            Property prop = nanoExtension.getPropertyInParent();
            if (prop != null) {
                String targetName = nanoExtension.getDefaultPropertyName(hostComponent);
                if (!prop.getName().equals(targetName)) {
                    hostComponent.rename(prop, targetName);
                    wasUpdated.set(true);
                }
            }
        });
        return wasUpdated.get();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ObjectData that = (ObjectData)o;
        return this.typeId == that.typeId && this.globalIndex == that.globalIndex && this.parentGlobalIndex == that.parentGlobalIndex && this.nanoName.equals(that.nanoName) && this.persistentId.equals(that.persistentId) && this.slotsValuesData.equals(that.slotsValuesData) && this.slotsMetaData.equals(that.slotsMetaData) && this.links.equals(that.links) && this.extensions.equals(that.extensions) && this.dynamicChoiceRanges.equals(that.dynamicChoiceRanges);
    }

    public int hashCode() {
        return Objects.hash(this.typeId, this.nanoName, this.globalIndex, this.parentGlobalIndex, this.persistentId, this.slotsValuesData, this.slotsMetaData, this.links, this.extensions, this.dynamicChoiceRanges);
    }
}

