/*
 * Decompiled with CFR 0.152.
 */
package com.miratech.nE2Link.parser.binary;

import com.miratech.nE2Link.BNanoBaseComponent;
import com.miratech.nE2Link.BNe2DeviceExt;
import com.miratech.nE2Link.choice.BDynamicChoiceRange;
import com.miratech.nE2Link.parser.binary.AbstractNanoData;
import com.miratech.nE2Link.parser.binary.ExistingLinkData;
import com.miratech.nE2Link.parser.binary.ObjectData;
import com.miratech.nE2Link.parser.binary.SlotMetaData;
import com.miratech.nE2Link.parser.binary.SlotsMetaData;
import com.miratech.nE2Link.parser.binary.SlotsValuesData;
import com.miratech.serialization.SerializableForm;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;

public class PollData
extends AbstractNanoData {
    private int globalId;
    private SlotsValuesData slotsValuesData;
    private SlotsMetaData slotsMetaData;
    private ArrayList<ExistingLinkData> links = new ArrayList();
    private Map<String, BDynamicChoiceRange> dynamicChoiceRanges = new HashMap<String, BDynamicChoiceRange>();

    protected PollData(SerializableForm serializableForm) {
        super(serializableForm);
    }

    public static PollData parse(SerializableForm serializedPollData) {
        PollData pollData = new PollData(serializedPollData);
        pollData.globalId = Short.toUnsignedInt((Short)serializedPollData.data[0]);
        List<SerializableForm> dataElements = serializedPollData.elements.toSerializableForms();
        block6: for (SerializableForm dataElement : dataElements) {
            int marker = Byte.toUnsignedInt(dataElement.marker.getValue());
            switch (marker) {
                case 71: {
                    pollData.slotsValuesData = SlotsValuesData.parse(dataElement);
                    continue block6;
                }
                case 92: {
                    pollData.slotsMetaData = SlotsMetaData.parse(dataElement);
                    continue block6;
                }
                case 68: {
                    ExistingLinkData existingLinkData = ExistingLinkData.parse(dataElement);
                    if (existingLinkData == null) continue block6;
                    pollData.links.add(existingLinkData);
                    continue block6;
                }
                case 204: {
                    BDynamicChoiceRange dynamicChoiceRange = BDynamicChoiceRange.parse(dataElement, null);
                    if (dynamicChoiceRange == null || dynamicChoiceRange.getOwnerSlotId() == -1) continue block6;
                    pollData.dynamicChoiceRanges.put(dynamicChoiceRange.getGenuineId(), dynamicChoiceRange);
                    continue block6;
                }
            }
            LOGGER.severe(String.format("[poll]: Unexpected Data type: marker: '%s'.\nIgnoring this part of object data and proceeding with other data.", marker));
        }
        return pollData;
    }

    public BNanoBaseComponent updateNiagaraComponent(BNe2DeviceExt controller) {
        BNanoBaseComponent nanoComponent = controller.getComponentCache().get(this.globalId);
        if (nanoComponent != null) {
            LOGGER.finest(String.format("[pollData.updateNiagaraComponent] component: %s global index %d", nanoComponent.getNanoName(), nanoComponent.getGlobalIndex()));
            if (this.slotsValuesData != null && this.slotsMetaData != null && this.slotsValuesData.size() == this.slotsMetaData.size()) {
                for (int i = 0; i < this.slotsMetaData.size(); ++i) {
                    SlotMetaData slotMetaData = this.slotsMetaData.getSlotMetaData(i);
                    Property slot = nanoComponent.getNanoSlot(slotMetaData.getSlotId());
                    if (slot != null) {
                        ObjectData.updateNiagaraPropertyValue(nanoComponent, (Slot)slot, this.slotsValuesData.getSlotValueData(i), this.dynamicChoiceRanges);
                        boolean bl = ObjectData.updateNiagaraSlotDef(nanoComponent, (Slot)slot, slotMetaData);
                        continue;
                    }
                    LOGGER.severe(String.format("[pollData.updateNiagaraComponent]: Invalid SlotsMetaData: Slot with slotId=%d not found in component %s with global id=%d .\nSkipping update of this slot.", slotMetaData.getSlotId(), nanoComponent.getNanoName(), nanoComponent.getGlobalIndex()));
                }
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.finest(String.format("[pollData.updateNiagaraComponent] %s", this.toString()));
                }
            } else {
                LOGGER.severe("[pollData.updateNiagaraComponent]: SlotsMetaData or SlotsValuesData unavailable or invalid size.\nSkipping component flag & facet update.");
            }
            return nanoComponent;
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PollData pollData = (PollData)o;
        return this.globalId == pollData.globalId && this.slotsValuesData.equals(pollData.slotsValuesData) && this.slotsMetaData.equals(pollData.slotsMetaData) && this.links.equals(pollData.links) && this.dynamicChoiceRanges.equals(pollData.dynamicChoiceRanges);
    }

    public int hashCode() {
        return Objects.hash(this.globalId, this.slotsValuesData, this.slotsMetaData, this.links, this.dynamicChoiceRanges);
    }

    public String toString() {
        return "PollData{globalId=" + this.globalId + ", slotsValuesData=" + this.slotsValuesData + ", slotsMetaData=" + this.slotsMetaData + ", links=" + this.links + ", dynamicChoiceRanges=" + this.dynamicChoiceRanges + '}';
    }

    public int getGlobalId() {
        return this.globalId;
    }

    public SlotsValuesData getSlotsValuesData() {
        return this.slotsValuesData;
    }

    public SlotsMetaData getSlotsMetaData() {
        return this.slotsMetaData;
    }

    public ArrayList<ExistingLinkData> getLinks() {
        return this.links;
    }

    public Map<String, BDynamicChoiceRange> getDynamicChoiceRanges() {
        return this.dynamicChoiceRanges;
    }
}

