/*
 * Decompiled with CFR 0.152.
 */
package com.miratech.nE2Link.parser.binary;

import com.miratech.nE2Link.BNanoBaseComponent;
import com.miratech.nE2Link.parser.binary.SlotSchema;
import com.miratech.serialization.SerializableForm;
import java.util.List;
import java.util.logging.Logger;
import javax.baja.naming.SlotPath;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Slot;

public class Slots {
    public static final Logger LOGGER = Logger.getLogger("nE2Link");

    public static void addNanoSlots(List<SerializableForm> serializedSlots, BNanoBaseComponent targetComponent) {
        int actions = 0;
        for (int slotIndex = 0; slotIndex < serializedSlots.size(); ++slotIndex) {
            SlotSchema slotSchema = SlotSchema.parse(serializedSlots.get(slotIndex));
            if (slotSchema == null) continue;
            if (slotSchema.isNiagaraAction()) {
                ++actions;
            }
            Slot slot = Slots.createSlot(targetComponent, slotIndex - actions, slotSchema);
        }
    }

    private static Slot createSlot(BNanoBaseComponent targetComponent, int slotIndex, SlotSchema slotSchema) {
        BFacets niagaraFacets = slotSchema.getNiagaraFacets();
        if (!slotSchema.isNiagaraAction()) {
            niagaraFacets = BFacets.make((BFacets)niagaraFacets, (BFacets)BFacets.make((String)"nano_slotId", (int)slotIndex));
        }
        int niagaraFlags = slotSchema.getNiagaraFlags();
        BValue niagaraDefaultValue = slotSchema.makeNiagaraDefaultValue();
        String slotName = slotSchema.getNiagaraSlotName();
        if (slotName == null || !SlotPath.isValidName((String)slotName)) {
            LOGGER.severe("[ComponentSchema.createSlot()]: Could not add slot with name '" + slotName + "' to component '" + (Object)((Object)targetComponent) + "'\nInvalid Slotname");
            return null;
        }
        if (targetComponent.getSlot(slotName) != null) {
            LOGGER.severe("[Slots.createSlot()]: Could not add slot with name '" + slotName + "' to component '" + (Object)((Object)targetComponent) + "'\nSlot already present");
            return null;
        }
        if (niagaraDefaultValue == null) {
            LOGGER.severe("[Slots.createSlot()]: Could not add slot with name '" + slotName + "' to component '" + (Object)((Object)targetComponent) + "'\nDefault value is null. Unknown Slot data type '" + slotSchema.getValueType() + "'.");
            return null;
        }
        if ((targetComponent.getOriginNameFromLibrary().equals("Library.BACnet.AnalogCustomPoint") || targetComponent.getOriginNameFromLibrary().equals("Library.BACnet.BinaryCustomPoint") || targetComponent.getOriginNameFromLibrary().equals("Library.BACnet.StringCustomPoint")) && (slotName.equals("objectType") || slotName.equals("property"))) {
            niagaraFacets = BFacets.make((BFacets)niagaraFacets, (BFacets)BFacets.make((String)"fieldEditor", (String)"nE2Link:NumericJsonListFE"));
        }
        return targetComponent.add(slotName, niagaraDefaultValue, niagaraFlags, niagaraFacets, null);
    }
}

