/*
 * Decompiled with CFR 0.152.
 */
package com.miratech.nE2Link.parser.binary;

import com.miratech.nE2Link.BNanoBaseComponent;
import com.miratech.nE2Link.actions.BNanoLinkInfoArg;
import com.miratech.nE2Link.parser.binary.AbstractNanoData;
import com.miratech.nE2Link.parser.binary.AbstractNanoRequest;
import com.miratech.nE2Link.parser.binary.AbstractNanoResponse;
import com.miratech.nE2Link.parser.binary.ExtinctLinkData;
import com.miratech.nE2Link.parser.binary.ResponseCode;
import com.miratech.nE2Link.parser.binary.UnlinkRequest;
import com.miratech.serialization.DataMarker;
import com.miratech.serialization.SerializableForm;
import java.util.List;

public class UnlinkResponse
extends AbstractNanoResponse {
    protected UnlinkResponse(AbstractNanoRequest request, ResponseCode responseCode) {
        super(request, responseCode);
    }

    private UnlinkResponse(AbstractNanoRequest request, List<SerializableForm> response) {
        super(request, response);
    }

    public static UnlinkResponse make(AbstractNanoRequest request, ResponseCode responseCode) {
        return new UnlinkResponse(request, responseCode);
    }

    public static UnlinkResponse parse(AbstractNanoRequest request, List<SerializableForm> response) {
        return new UnlinkResponse(request, response);
    }

    @Override
    protected boolean isMalformedResponse(SerializableForm responseContentElement) {
        return !responseContentElement.marker.equals((Object)DataMarker.ExtinctLinkData);
    }

    @Override
    protected AbstractNanoData doParseResponseContentElement(SerializableForm responseContentElement) {
        return ExtinctLinkData.parse(responseContentElement);
    }

    @Override
    public ExtinctLinkData getResponseData() {
        return (ExtinctLinkData)super.getResponseData();
    }

    @Override
    public String getLocalizedMessage(int index) {
        BNanoLinkInfoArg requestData = ((UnlinkRequest)this.getRequest()).getClientRequestData();
        int sourceComponentId = requestData.getSourceComponentGlobalIndex();
        int sourceSlotId = requestData.getSourceSlotId();
        int targetComponentId = requestData.getTargetComponentGlobalIndex();
        int targetSlotId = requestData.getTargetSlotId();
        BNanoBaseComponent sourceComponent = this.getRequest().getNe2DeviceExt().getComponentCache().get(sourceComponentId);
        BNanoBaseComponent targetComponent = this.getRequest().getNe2DeviceExt().getComponentCache().get(targetComponentId);
        String sourceComponentNavOrd = sourceComponent != null ? sourceComponent.getNavOrd().toString() : "unresolvable component";
        String targetComponentNavOrd = targetComponent != null ? targetComponent.getNavOrd().toString() : "unresolvable component";
        switch (this.getResponseCode()) {
            case OK: {
                return LEX.getText("UNLINK_OK", new Object[]{this.getResponseData().getSourceObjectId(), this.getResponseData().getSourceSlotId(), this.getResponseData().getTargetObjectId(), this.getResponseData().getTargetSlotId()});
            }
            case ERROR: {
                return LEX.getText("UNLINK_ERROR", new Object[]{sourceComponentId, sourceSlotId, targetComponentId, targetSlotId, this.getErrorMessage(), this.getExceptionMessage(), this.getStackTrace()});
            }
            case NOT_CONNECTED: {
                return LEX.getText("UNLINK_NOT_CONNECTED", new Object[]{sourceComponentId, sourceSlotId, targetComponentId, targetSlotId});
            }
            case NO_RESPONSE: {
                return LEX.getText("UNLINK_NO_RESPONSE", new Object[]{sourceComponentId, sourceSlotId, targetComponentId, targetSlotId});
            }
            case INVALID_RESPONSE: {
                return LEX.getText("UNLINK_INVALID_RESPONSE", new Object[]{sourceComponentId, sourceSlotId, targetComponentId, targetSlotId});
            }
        }
        return LEX.getText("ILLEGAL_RESPONSE_CODE");
    }
}

