/*
 * Decompiled with CFR 0.152.
 */
package com.miratech.nE2Link.parser.binary;

import com.miratech.ifnetclient.model.RemoteDevice;
import com.miratech.nE2Link.BNanoBaseComponent;
import com.miratech.nE2Link.BNe2DeviceExt;
import com.miratech.nE2Link.parser.binary.AbstractNanoRequest;
import com.miratech.nE2Link.parser.binary.ObjectIdsData;
import com.miratech.nE2Link.parser.binary.ResponseCode;
import com.miratech.nE2Link.parser.binary.UnsubscribeResponse;
import com.miratech.serialization.SerializableForm;
import java.util.ArrayList;

public class UnsubscribeRequest
extends AbstractNanoRequest {
    private UnsubscribeRequest(BNe2DeviceExt ne2DeviceExt, BNanoBaseComponent[] clientRequestData, ObjectIdsData requestData) {
        super(ne2DeviceExt, clientRequestData, requestData);
    }

    public static UnsubscribeRequest make(BNe2DeviceExt ne2DeviceExt, BNanoBaseComponent[] toUnsubscribe) {
        return new UnsubscribeRequest(ne2DeviceExt, toUnsubscribe, ObjectIdsData.make(toUnsubscribe));
    }

    @Override
    public ObjectIdsData getRequestData() {
        return (ObjectIdsData)super.getRequestData();
    }

    public BNanoBaseComponent[] getClientRequestData() {
        return (BNanoBaseComponent[])super.getClientRequestData();
    }

    @Override
    public UnsubscribeResponse postRequest(RemoteDevice remoteDevice) {
        if (remoteDevice == null || !remoteDevice.Remote.isConnected()) {
            return UnsubscribeResponse.make(this, ResponseCode.NOT_CONNECTED);
        }
        ArrayList<SerializableForm> response = remoteDevice.Remote.Unsubscribe(this.getRequestData().getSerializableForm());
        if (response == null) {
            return UnsubscribeResponse.make(this, ResponseCode.NO_RESPONSE);
        }
        if (this.isResponseMalformed(response)) {
            return UnsubscribeResponse.make(this, ResponseCode.INVALID_RESPONSE);
        }
        return UnsubscribeResponse.parse(this, response);
    }

    @Override
    public String getLocalizedMessage() {
        StringBuilder sb = new StringBuilder();
        BNanoBaseComponent[] componentsToUnsubscribe = this.getClientRequestData();
        if (componentsToUnsubscribe.length == 0) {
            sb.append(LEX.getText("NONE"));
        } else {
            for (BNanoBaseComponent componentToUnsubscribe : componentsToUnsubscribe) {
                if (null == componentToUnsubscribe.getNavOrd()) continue;
                sb.append(LEX.getText("UNSUBSCRIBE_LIST_ENTRY", new Object[]{componentToUnsubscribe.getGlobalIndex(), componentToUnsubscribe.getNavOrd().toString()})).append('\n');
            }
        }
        return LEX.getText("UNSUBSCRIBE_REQUEST", new Object[]{sb.toString()});
    }
}

