/*
 * Decompiled with CFR 0.152.
 */
package com.miratech.nE2Link.schedules;

import com.miratech.nE2Link.schedules.BNanoDateSchedule;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.schedule.BAbstractSchedule;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="start", type="BNanoDateSchedule", defaultValue="new BNanoDateSchedule()"), @NiagaraProperty(name="end", type="BNanoDateSchedule", defaultValue="new BNanoDateSchedule()")})
public class BNanoDateRangeSchedule
extends BAbstractSchedule {
    public static final Property start = BNanoDateRangeSchedule.newProperty((int)0, (BValue)new BNanoDateSchedule(), null);
    public static final Property end = BNanoDateRangeSchedule.newProperty((int)0, (BValue)new BNanoDateSchedule(), null);
    public static final Type TYPE = Sys.loadType(BNanoDateRangeSchedule.class);

    public BNanoDateSchedule getStart() {
        return (BNanoDateSchedule)this.get(start);
    }

    public void setStart(BNanoDateSchedule v) {
        this.set(start, (BValue)v, null);
    }

    public BNanoDateSchedule getEnd() {
        return (BNanoDateSchedule)this.get(end);
    }

    public void setEnd(BNanoDateSchedule v) {
        this.set(end, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BNanoDateRangeSchedule() {
    }

    public BNanoDateRangeSchedule(BNanoDateSchedule start, BNanoDateSchedule end) {
        this.setStart(start);
        this.setEnd(end);
    }

    public boolean isEffective(BAbsTime t) {
        if (this.getAlwaysEffective()) {
            return true;
        }
        BNanoDateSchedule start = this.getStart();
        BNanoDateSchedule end = this.getEnd();
        int strTo = start.compareTo(t);
        int endTo = end.compareTo(t);
        int tmp = start.getYear();
        int argYear = t.getYear();
        if (tmp >= 0 && tmp > argYear) {
            return false;
        }
        tmp = end.getYear();
        if (tmp >= 0 && tmp < argYear) {
            return false;
        }
        if (start.compareTo(end) <= 0) {
            return strTo <= 0 && endTo >= 0;
        }
        return strTo <= 0 || endTo >= 0;
    }

    public BAbsTime nextEvent(BAbsTime after) {
        BAbsTime startNext = this.getStart().nextEvent(after);
        BAbsTime endNext = this.getEnd().nextEvent(after);
        if (startNext == null) {
            return endNext;
        }
        if (endNext == null) {
            return startNext;
        }
        if (startNext.isAfter(after)) {
            return startNext;
        }
        if (endNext.isBefore(after)) {
            return endNext;
        }
        return after;
    }

    public String toString(Context cx) {
        String s = this.getStart().toString(cx);
        String e = this.getEnd().toString(cx);
        Lexicon l = Lexicon.make(BAbstractSchedule.class);
        return s + " - " + e;
    }
}

