/*
 * Decompiled with CFR 0.152.
 */
package com.miratech.nE2Link.schedules;

import com.miratech.ifnetclient.model.scheduleLogic.DayOfMonth;
import com.miratech.ifnetclient.model.scheduleLogic.Month;
import com.miratech.nE2Link.schedules.utils.ScheduleUtils;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.format.TextStyle;
import java.util.Locale;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.schedule.BDateSchedule;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BMonth;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public class BNanoDateSchedule
extends BDateSchedule {
    public static final Type TYPE = Sys.loadType(BNanoDateSchedule.class);

    public Type getType() {
        return TYPE;
    }

    public BNanoDateSchedule() {
    }

    public BNanoDateSchedule(int day, BMonth month, int year) {
        this.setDay(day);
        this.setMonth(month);
        this.setYear(year);
    }

    public BNanoDateSchedule(DayOfMonth day, Month month, short year) {
        if (day != null) {
            this.setDay(day.getValue());
        }
        if (month != null) {
            this.setMonth(month.getValue() - 1);
        }
        this.setYear(year);
    }

    public BNanoDateSchedule(int dayOfWeek, DayOfMonth day, Month month, short year) {
        this.setWeekday(dayOfWeek);
        if (day != null) {
            this.setDay(day.getValue());
        }
        if (month != null) {
            this.setMonth(month.getValue() - 1);
        }
        this.setYear(year);
    }

    public BAbsTime nextEvent(BAbsTime after) {
        LocalDate localDate = this.getYear() == -1 ? ScheduleUtils.getStartDateWithoutYear(after, this) : ScheduleUtils.getStartDateWithYear(after, this);
        return BAbsTime.make((int)localDate.getYear(), (BMonth)BMonth.make((int)(localDate.getMonthValue() - 1)), (int)localDate.getDayOfMonth());
    }

    public String toString(Context cx) {
        return this.criteriaString(cx);
    }

    protected String criteriaString(Context cx) {
        boolean criteria = false;
        StringBuffer buf = new StringBuffer();
        if (this.getWeekday() >= 0 || this.getDay() >= 0 || this.getMonth() >= 0 || this.getYear() >= 0) {
            int i = this.getWeekday();
            if (i >= 0) {
                if (i == 0) {
                    i = 7;
                }
                DayOfWeek w = DayOfWeek.of(i);
                buf.append(w.getDisplayName(TextStyle.FULL, Locale.getDefault()) + ", ");
                criteria = true;
            }
            if ((i = this.getDay()) >= -1) {
                if (criteria) {
                    buf.append(' ');
                }
                if (i == -1) {
                    buf.append("Any Day");
                } else if (i == 32) {
                    buf.append("Last Day");
                } else if (i == 33) {
                    buf.append("Odd Days");
                } else if (i == 34) {
                    buf.append("Even Days");
                } else {
                    buf.append(i);
                    if (i == 1 || i == 21 || i == 31) {
                        buf.append("st");
                    } else if (i == 2 || i == 22) {
                        buf.append("nd");
                    } else if (i == 3 || i == 23) {
                        buf.append("rd");
                    } else {
                        buf.append("th");
                    }
                }
                criteria = true;
            }
            if ((i = this.getMonth()) >= -1) {
                if (criteria) {
                    buf.append(' ');
                }
                if (i == -1) {
                    buf.append("of Any Month");
                } else if (i == 12) {
                    buf.append("of Odd Months");
                } else if (i == 13) {
                    buf.append("of Even Months");
                } else {
                    BMonth m = BMonth.make((int)i);
                    buf.append(m.getDisplayTag(cx));
                }
                criteria = true;
            }
            if ((i = this.getYear()) >= 0) {
                if (criteria) {
                    buf.append(' ');
                }
                buf.append(i);
                criteria = true;
            }
        }
        return criteria ? buf.toString() : "Every Day";
    }
}

