/*
 * Decompiled with CFR 0.152.
 */
package com.miratech.nE2Link.schedules;

import com.miratech.ifnetclient.model.scheduleLogic.EventsTable;
import com.miratech.ifnetclient.model.scheduleLogic.ISchedule;
import com.miratech.ifnetclient.model.scheduleLogic.RawIScheduleData;
import com.miratech.ifnetclient.model.scheduleLogic.ScheduleEvent;
import com.miratech.ifnetclient.model.scheduleLogic.ScheduleValue;
import com.miratech.nE2Link.BUnitMap;
import com.miratech.nE2Link.choice.BDynamicChoiceRange;
import com.miratech.nE2Link.schedules.BNanoWeekSchedule;
import com.miratech.nE2Link.schedules.utils.BScheduleTypeEnum;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.schedule.BCompositeSchedule;
import javax.baja.schedule.BControlSchedule;
import javax.baja.schedule.BDailySchedule;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BEnum;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Subscriber;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="scheduleType", type="BScheduleTypeEnum", defaultValue="BScheduleTypeEnum.DEFAULT", flags=5), @NiagaraProperty(name="nextTime", type="BAbsTime", defaultValue="BAbsTime.DEFAULT", flags=5), @NiagaraProperty(name="nextVal", type="BStatusValue", defaultValue="new BStatusNumeric()", flags=5), @NiagaraProperty(name="specialEvents", type="BCompositeSchedule", defaultValue="new BCompositeSchedule()"), @NiagaraProperty(name="weekSchedule", type="BNanoWeekSchedule", defaultValue="new BNanoWeekSchedule()")})
public class BNanoSchedule
extends BControlSchedule
implements ISchedule {
    public static final Property scheduleType = BNanoSchedule.newProperty((int)5, (BValue)BScheduleTypeEnum.DEFAULT, null);
    public static final Property nextTime = BNanoSchedule.newProperty((int)5, (BValue)BAbsTime.DEFAULT, null);
    public static final Property nextVal = BNanoSchedule.newProperty((int)5, (BValue)new BStatusNumeric(), null);
    public static final Property specialEvents = BNanoSchedule.newProperty((int)0, (BValue)new BCompositeSchedule(), null);
    public static final Property weekSchedule = BNanoSchedule.newProperty((int)0, (BValue)new BNanoWeekSchedule(), null);
    public static final Type TYPE = Sys.loadType(BNanoSchedule.class);
    Subscriber subscriber = new Subscriber(){

        public void event(BComponentEvent event) {
            if (event.getId() == 0 && event.getSlot().asProperty().getName().equals("default")) {
                BNanoSchedule.this.setDefaultOutput((BStatusValue)BNanoSchedule.this.getParent().get("default").newCopy(true));
            }
        }
    };
    public static final byte defaultBacnetPriority = 16;
    private List<ISchedule> specialEventsList = new ArrayList<ISchedule>();
    private List<ScheduleEvent> scheduleEventsList = new ArrayList<ScheduleEvent>();
    public Class outputType;
    private double defaultValue;
    private EventsTable values;

    public BScheduleTypeEnum getScheduleType() {
        return (BScheduleTypeEnum)this.get(scheduleType);
    }

    public void setScheduleType(BScheduleTypeEnum v) {
        this.set(scheduleType, (BValue)v, null);
    }

    public BAbsTime getNextTime() {
        return (BAbsTime)this.get(nextTime);
    }

    public void setNextTime(BAbsTime v) {
        this.set(nextTime, (BValue)v, null);
    }

    public BStatusValue getNextVal() {
        return (BStatusValue)this.get(nextVal);
    }

    public void setNextVal(BStatusValue v) {
        this.set(nextVal, (BValue)v, null);
    }

    public BCompositeSchedule getSpecialEvents() {
        return (BCompositeSchedule)this.get(specialEvents);
    }

    public void setSpecialEvents(BCompositeSchedule v) {
        this.set(specialEvents, (BValue)v, null);
    }

    public BNanoWeekSchedule getWeekSchedule() {
        return (BNanoWeekSchedule)this.get(weekSchedule);
    }

    public void setWeekSchedule(BNanoWeekSchedule v) {
        this.set(weekSchedule, (BValue)v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BNanoSchedule() {
    }

    public BNanoSchedule(Class withOutputType, ScheduleEvent[] withWeeklyEvents, ISchedule[] withSpecialEvents, BDynamicChoiceRange valueRestrictions, BDynamicChoiceRange availableCalendars, String originNameFromLibrary) {
        this.outputType = withOutputType;
        switch (originNameFromLibrary) {
            case "Library.Schedules.AnalogSchedule": {
                this.setScheduleType(BScheduleTypeEnum.analog);
                break;
            }
            case "Library.Schedules.BinarySchedule": {
                this.setScheduleType(BScheduleTypeEnum.binary);
                break;
            }
            case "Library.Schedules.MultistateSchedule": {
                this.setScheduleType(BScheduleTypeEnum.multistate);
                break;
            }
        }
        List<Object> list = withWeeklyEvents == null ? null : (this.scheduleEventsList = Arrays.asList(withWeeklyEvents) != null ? Arrays.asList(withWeeklyEvents) : new ArrayList());
        List<Object> list2 = withSpecialEvents == null ? null : (this.specialEventsList = Arrays.asList(withSpecialEvents) != null ? Arrays.asList(withSpecialEvents) : new ArrayList());
        if (valueRestrictions == null && this.getScheduleType().equals((Object)BScheduleTypeEnum.multistate)) {
            valueRestrictions = BDynamicChoiceRange.make("labels");
        }
        if (valueRestrictions != null && !valueRestrictions.getId().isEmpty()) {
            this.add(valueRestrictions.getId(), (BValue)valueRestrictions, valueRestrictions.getFlags(), this.getScheduleType().equals((Object)BScheduleTypeEnum.multistate) ? BFacets.make((BFacets)BFacets.make((String)"nano_type", (String)"multistateRange"), (BFacets)BFacets.make((String)"rangeAsSubform", (boolean)true)) : BFacets.make((BFacets)BFacets.make((String)"nano_type", (String)"booleanRange"), (BFacets)BFacets.make((String)"rangeAsSubform", (boolean)true)), Context.decoding);
        }
        if (availableCalendars != null && !availableCalendars.getId().isEmpty()) {
            this.add(availableCalendars.getId(), (BValue)availableCalendars, availableCalendars.getFlags() | 1, BFacets.make((String)"nano_type", (String)"multistateRange"), Context.decoding);
        }
    }

    public void started() throws Exception {
        super.started();
        this.setDefaultOutput((BStatusValue)this.getParent().get("default").newCopy(true));
        switch (this.getScheduleType().getOrdinal()) {
            case 0: {
                BUnit unit = BUnitMap.getNiagaraUnit(((BStatusEnum)this.getParent().get("units")).getEnum().getOrdinal());
                if (unit == null) break;
                this.setFacets(BFacets.make((BFacets)this.getFacets(), (String)"units", (BIDataValue)unit));
                break;
            }
            case 1: {
                BFacets facets = null;
                if (null != this.getLabels()) {
                    facets = this.getLabels().asFacets(BBoolean.TYPE, null);
                }
                this.setFacets(BFacets.make((BFacets)this.getFacets(), facets));
                break;
            }
            case 2: {
                BFacets facets = null;
                if (null != this.getLabels()) {
                    facets = this.getLabels().asFacets(BEnum.TYPE, null);
                }
                this.setFacets(BFacets.make((BFacets)this.getFacets(), facets));
                break;
            }
        }
        this.subscriber.subscribe((BComponent)this.getParent());
    }

    public void stopped() throws Exception {
        super.stopped();
        this.subscriber.unsubscribeAll();
    }

    public void changed(Property p, Context c) {
        if (p.getName().equals("labels")) {
            BDynamicChoiceRange labels = this.getLabels();
            BFacets facets = null != labels ? labels.asFacets(BBoolean.TYPE, null) : null;
            this.setFacets(BFacets.make((BFacets)this.getFacets(), (BFacets)facets));
        }
        super.changed(p, c);
    }

    public final List<ISchedule> getSpecialEventsList() {
        return this.specialEventsList;
    }

    public final List<ScheduleEvent> getScheduleEventsList() {
        return this.scheduleEventsList;
    }

    @Override
    public final String getScheduleName() {
        return "";
    }

    @Override
    public final byte getPriority() {
        return 16;
    }

    @Override
    public final EventsTable getValues() {
        return this.values;
    }

    @Override
    public boolean NearestRelevantDay(LocalDateTime since, LocalDateTime nearestOccurence) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public ScheduleValue Calculate(LocalDateTime forMoment) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean ApplyRawData(RawIScheduleData compressedData) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public RawIScheduleData ExtractRawData() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public void addSpecialEvent(String name, BDailySchedule specialEvent, Context cx) {
        this.getSpecialEvents().add(name, (BValue)specialEvent, cx);
    }

    public BDynamicChoiceRange getLabels() {
        return (BDynamicChoiceRange)this.get("labels");
    }

    public BDynamicChoiceRange getCalendars() {
        return (BDynamicChoiceRange)this.get("calendars");
    }

    public void doExecute() {
    }

    public String toString(Context context) {
        return this.getName();
    }
}

