/*
 * Decompiled with CFR 0.152.
 */
package com.miratech.nE2Link.schedules.utils;

import com.miratech.nE2Link.schedules.BNanoDateSchedule;
import com.miratech.nE2Link.schedules.BNanoWeekAndDaySchedule;
import com.miratech.nE2Link.schedules.utils.BPosixDstWeekEnum;
import java.io.IOException;
import java.time.LocalDate;
import java.util.Objects;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BDate;
import javax.baja.sys.BMonth;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BTime;
import javax.baja.sys.BWeekday;
import javax.baja.sys.Context;
import javax.baja.timezone.BTimeZone;
import javax.baja.timezone.DstRule;
import javax.baja.timezone.TimeZoneDatabase;
import javax.baja.util.Lexicon;

public class ScheduleUtils {
    static int[] oddMonths = new int[]{1, 3, 5, 7, 9, 11};
    static int[] evenMonths = new int[]{2, 4, 6, 8, 10, 12};
    public static String BACNET_PRIORITY = "bacnetPriority";
    private static long NET_TO_UNIX_EPOCH_OFFSET_MILLIS = 62135596800000L;
    public static long NET_TICKS_PER_MILLI = 10000L;
    private static String POSIX_TIME_FORMAT = "%02d:%02d:%02d";
    private static String POSIX_WEEKDAY_RULE_FORMAT = "M%d.%d.%d";

    public static LocalDate getStartDateWithoutYear(BAbsTime after, BNanoDateSchedule start) {
        return start.getMonth() == -1 ? ScheduleUtils.getStartDateWithoutYearWithoutMonth(after, start) : ScheduleUtils.getStartDateWithoutYearWithMonth(after, start);
    }

    public static LocalDate getStartDateWithYear(BAbsTime after, BNanoDateSchedule start) {
        return start.getMonth() == -1 ? ScheduleUtils.getStartDateWithYearWithoutMonth(after, start) : ScheduleUtils.getStartDateWithYearWithMonth(after, start);
    }

    static LocalDate getStartDateWithYearWithoutMonth(BAbsTime after, BNanoDateSchedule start) {
        int weekday = start.getWeekday();
        int day = start.getDay();
        int month = start.getMonth() + 1;
        int year = start.getYear();
        LocalDate today = LocalDate.of(after.getYear(), after.getMonth().getOrdinal() + 1, after.getDay());
        year = start.getYear();
        if (start.getDay() == -1) {
            if (year == today.getYear()) {
                if (weekday != -1) {
                    if (today.getDayOfWeek().getValue() == weekday) {
                        return today;
                    }
                    int diff = Math.abs(today.getDayOfWeek().getValue() - weekday);
                    return today.plusDays(diff);
                }
                return today;
            }
            month = 1;
            day = 1;
        } else {
            if (year > today.getYear()) {
                month = 1;
            } else if (start.getDay() >= today.getDayOfMonth()) {
                month = today.getMonthValue();
            } else {
                month = today.getMonthValue() + 1;
                if (month > 12) {
                    month = 1;
                }
            }
            day = start.getDay();
            if (day == 32) {
                day = ScheduleUtils.getLastDay(month, year);
            } else if (day == 33) {
                day = year > today.getYear() ? 1 : (month > today.getMonthValue() ? 1 : (today.getDayOfMonth() % 2 == 1 ? today.getDayOfMonth() : today.getDayOfMonth() + 1));
            } else if (day == 34) {
                day = year > today.getYear() ? 2 : (month > today.getMonthValue() ? 2 : (today.getDayOfMonth() % 2 == 1 ? today.getDayOfMonth() + 1 : today.getDayOfMonth()));
            } else if (day > ScheduleUtils.getLastDay(month, year)) {
                while (day > ScheduleUtils.getLastDay(month, year)) {
                    if (++month <= 12) continue;
                    month = 1;
                }
            }
        }
        return LocalDate.of(year, month, day);
    }

    static LocalDate getStartDateWithYearWithMonth(BAbsTime after, BNanoDateSchedule start) {
        int day = start.getDay();
        int month = start.getMonth() + 1;
        int year = start.getYear();
        LocalDate today = LocalDate.of(after.getYear(), after.getMonth().getOrdinal() + 1, after.getDay());
        year = start.getYear();
        if (start.getMonth() == 12) {
            if (start.getDay() == -1) {
                if (year > today.getYear()) {
                    month = 1;
                    day = 1;
                } else {
                    int n = month = ScheduleUtils.isOddMonth(today.getMonthValue()) ? today.getMonthValue() : today.getMonthValue() + 1;
                    if (month > 12) {
                        month = 1;
                        day = 1;
                    } else {
                        day = month == today.getMonthValue() ? today.getDayOfMonth() : 1;
                    }
                }
            } else {
                if (year > today.getYear()) {
                    month = 1;
                } else {
                    month = ScheduleUtils.isOddMonth(today.getMonthValue()) ? (start.getDay() >= today.getDayOfMonth() ? today.getMonthValue() : today.getMonthValue() + 2) : today.getMonthValue() + 1;
                    if (month > 12) {
                        month = 1;
                    }
                }
                day = start.getDay();
                if (day == 32) {
                    day = ScheduleUtils.getLastDay(month, year);
                } else if (day == 33) {
                    day = year > today.getYear() ? 1 : (month > today.getMonthValue() ? 1 : (today.getDayOfMonth() % 2 == 1 ? today.getDayOfMonth() : today.getDayOfMonth() + 1));
                } else if (day == 34) {
                    day = year > today.getYear() ? 2 : (month > today.getMonthValue() ? 2 : (today.getDayOfMonth() % 2 == 1 ? today.getDayOfMonth() + 1 : today.getDayOfMonth()));
                } else if (day > ScheduleUtils.getLastDay(month, year)) {
                    while (day > ScheduleUtils.getLastDay(month, year)) {
                        if ((month += 2) <= 12) continue;
                        month = 1;
                    }
                }
            }
        } else if (start.getMonth() == 13) {
            if (start.getDay() == -1) {
                if (year > today.getYear()) {
                    month = 2;
                    day = 1;
                } else {
                    int n = month = ScheduleUtils.isOddMonth(today.getMonthValue()) ? today.getMonthValue() + 1 : today.getMonthValue();
                    if (month > 12) {
                        month = 2;
                        day = 1;
                    } else {
                        day = today.getDayOfMonth();
                    }
                }
            } else {
                if (year > today.getYear()) {
                    month = 2;
                } else {
                    if (ScheduleUtils.isOddMonth(today.getMonthValue())) {
                        month = today.getMonthValue() + 1;
                    } else {
                        int n = month = start.getDay() >= today.getDayOfMonth() ? today.getMonthValue() : today.getMonthValue() + 2;
                    }
                    if (month > 12) {
                        month = 2;
                    }
                }
                day = start.getDay();
                if (day == 32) {
                    day = ScheduleUtils.getLastDay(month, year);
                } else if (day == 33) {
                    day = year > today.getYear() ? 1 : (month > today.getMonthValue() ? 1 : (today.getDayOfMonth() % 2 == 1 ? today.getDayOfMonth() : today.getDayOfMonth() + 1));
                } else if (day == 34) {
                    day = year > today.getYear() ? 2 : (month > today.getMonthValue() ? 2 : (today.getDayOfMonth() % 2 == 1 ? today.getDayOfMonth() + 1 : today.getDayOfMonth()));
                } else if (day > ScheduleUtils.getLastDay(month, year)) {
                    while (day > ScheduleUtils.getLastDay(month, year)) {
                        if ((month += 2) <= 12) continue;
                        month = 2;
                    }
                }
            }
        } else {
            month = start.getMonth() + 1;
            if (start.getDay() == -1) {
                day = year > today.getYear() ? 1 : (month > today.getMonthValue() ? 1 : (month == today.getMonthValue() ? today.getDayOfMonth() : 1));
            } else {
                day = start.getDay();
                if (day == 32) {
                    day = ScheduleUtils.getLastDay(month, year);
                } else if (day == 33) {
                    day = year > today.getYear() ? 1 : (month > today.getMonthValue() ? 1 : (today.getDayOfMonth() % 2 == 1 ? today.getDayOfMonth() : today.getDayOfMonth() + 1));
                } else if (day == 34) {
                    day = year > today.getYear() ? 2 : (month > today.getMonthValue() ? 2 : (today.getDayOfMonth() % 2 == 1 ? today.getDayOfMonth() + 1 : today.getDayOfMonth()));
                }
            }
        }
        return LocalDate.of(year, month, day);
    }

    static LocalDate getStartDateWithoutYearWithoutMonth(BAbsTime after, BNanoDateSchedule start) {
        int weekday = start.getWeekday();
        int day = start.getDay();
        int month = start.getMonth() + 1;
        int year = start.getYear();
        LocalDate today = LocalDate.of(after.getYear(), after.getMonth().getOrdinal() + 1, after.getDay());
        if (start.getDay() == -1) {
            if (weekday != -1) {
                if (today.getDayOfWeek().getValue() == weekday) {
                    return today;
                }
                int diff = Math.abs(today.getDayOfWeek().getValue() - weekday);
                return today.plusDays(diff);
            }
            return today;
        }
        if (start.getDay() >= today.getDayOfMonth()) {
            month = today.getMonthValue();
            year = today.getYear();
        } else {
            month = today.getMonthValue() + 1;
            if (month > 12) {
                month = 1;
                year = today.getYear() + 1;
            } else {
                year = today.getYear();
            }
        }
        day = start.getDay();
        if (day == 32) {
            day = ScheduleUtils.getLastDay(month, year);
        } else if (day == 33) {
            day = year > today.getYear() ? 1 : (month > today.getMonthValue() ? 1 : (today.getDayOfMonth() % 2 == 1 ? today.getDayOfMonth() : today.getDayOfMonth() + 1));
        } else if (day == 34) {
            day = year > today.getYear() ? 2 : (month > today.getMonthValue() ? 2 : (today.getDayOfMonth() % 2 == 1 ? today.getDayOfMonth() + 1 : today.getDayOfMonth()));
        } else if (day > ScheduleUtils.getLastDay(month, year)) {
            while (day > ScheduleUtils.getLastDay(month, year)) {
                if (++month <= 12) continue;
                month = 1;
                if (year != today.getYear()) continue;
                ++year;
            }
        }
        return LocalDate.of(year, month, day);
    }

    static LocalDate getStartDateWithoutYearWithMonth(BAbsTime after, BNanoDateSchedule start) {
        int weekday = start.getWeekday();
        int day = start.getDay();
        int month = start.getMonth() + 1;
        int year = start.getYear();
        LocalDate today = LocalDate.of(after.getYear(), after.getMonth().getOrdinal() + 1, after.getDay());
        if (start.getMonth() == 12) {
            if (start.getDay() == -1) {
                int n = month = ScheduleUtils.isOddMonth(today.getMonthValue()) ? today.getMonthValue() : today.getMonthValue() + 1;
                if (month > 12) {
                    month = 1;
                    year = today.getYear() + 1;
                    day = 1;
                } else {
                    day = month == today.getMonthValue() ? today.getDayOfMonth() : 1;
                    year = today.getYear();
                }
            } else {
                month = ScheduleUtils.isOddMonth(today.getMonthValue()) ? (start.getDay() >= today.getDayOfMonth() ? today.getMonthValue() : today.getMonthValue() + 2) : today.getMonthValue() + 1;
                if (month > 12) {
                    month = 1;
                    year = today.getYear() + 1;
                } else {
                    year = today.getYear();
                }
                day = start.getDay();
                if (day == 32) {
                    day = ScheduleUtils.getLastDay(month, year);
                } else if (day == 33) {
                    day = year > today.getYear() ? 1 : (month > today.getMonthValue() ? 1 : (today.getDayOfMonth() % 2 == 1 ? today.getDayOfMonth() : today.getDayOfMonth() + 1));
                } else if (day == 34) {
                    day = year > today.getYear() ? 2 : (month > today.getMonthValue() ? 2 : (today.getDayOfMonth() % 2 == 1 ? today.getDayOfMonth() + 1 : today.getDayOfMonth()));
                } else if (day > ScheduleUtils.getLastDay(month, year)) {
                    while (day > ScheduleUtils.getLastDay(month, year)) {
                        if ((month += 2) <= 12) continue;
                        month = 2;
                    }
                }
            }
        } else if (start.getMonth() == 13) {
            if (start.getDay() == -1) {
                int n = month = ScheduleUtils.isOddMonth(today.getMonthValue()) ? today.getMonthValue() + 1 : today.getMonthValue();
                if (month > 12) {
                    month = 2;
                    year = today.getYear() + 1;
                    day = 1;
                } else {
                    day = today.getDayOfMonth();
                    year = today.getYear();
                }
            } else {
                if (ScheduleUtils.isOddMonth(today.getMonthValue())) {
                    month = today.getMonthValue() + 1;
                } else {
                    int n = month = start.getDay() >= today.getDayOfMonth() ? today.getMonthValue() : today.getMonthValue() + 2;
                }
                if (month > 12) {
                    month = 2;
                    year = today.getYear() + 1;
                } else {
                    year = today.getYear();
                }
                day = start.getDay();
                if (day == 32) {
                    day = ScheduleUtils.getLastDay(month, year);
                } else if (day == 33) {
                    day = year > today.getYear() ? 1 : (month > today.getMonthValue() ? 1 : (today.getDayOfMonth() % 2 == 1 ? today.getDayOfMonth() : today.getDayOfMonth() + 1));
                } else if (day == 34) {
                    day = year > today.getYear() ? 2 : (month > today.getMonthValue() ? 2 : (today.getDayOfMonth() % 2 == 1 ? today.getDayOfMonth() + 1 : today.getDayOfMonth()));
                } else if (day > ScheduleUtils.getLastDay(month, year)) {
                    while (day > ScheduleUtils.getLastDay(month, year)) {
                        if ((month += 2) <= 12) continue;
                        month = 2;
                        if (year != today.getYear()) continue;
                        ++year;
                    }
                }
            }
        } else {
            month = start.getMonth() + 1;
            if (start.getDay() == -1) {
                if (month > today.getMonthValue()) {
                    day = 1;
                    year = today.getYear();
                } else if (month == today.getMonthValue()) {
                    day = today.getDayOfMonth();
                    year = today.getYear();
                } else {
                    day = 1;
                    year = today.getYear() + 1;
                }
            } else {
                year = month > today.getMonthValue() ? today.getYear() : (month == today.getMonthValue() ? (day >= today.getDayOfMonth() ? today.getYear() : today.getYear() + 1) : today.getYear() + 1);
                day = start.getDay();
                if (day == 32) {
                    day = ScheduleUtils.getLastDay(month, year);
                } else if (day == 33) {
                    day = year > today.getYear() ? 1 : (month > today.getMonthValue() ? 1 : (today.getDayOfMonth() % 2 == 1 ? today.getDayOfMonth() : today.getDayOfMonth() + 1));
                } else if (day == 34) {
                    day = year > today.getYear() ? 2 : (month > today.getMonthValue() ? 2 : (today.getDayOfMonth() % 2 == 1 ? today.getDayOfMonth() + 1 : today.getDayOfMonth()));
                }
            }
        }
        return LocalDate.of(year, month, day);
    }

    public static LocalDate getStartDateWeekAndDay(BAbsTime after, BNanoWeekAndDaySchedule weekAndDaySchedule) {
        int year = -1;
        int month = after.getDate().getMonth().getOrdinal() + 1;
        int week = after.getDay() <= 7 ? 1 : (after.getDay() <= 14 ? 2 : (after.getDay() <= 21 ? 3 : (after.getDay() <= 28 ? 4 : 5)));
        int weekday = weekAndDaySchedule.getWeekday();
        int plusDays = weekAndDaySchedule.getWeekday() == -1 || weekAndDaySchedule.getWeekday() == after.getWeekday().getOrdinal() ? 0 : (weekAndDaySchedule.getWeekday() > after.getWeekday().getOrdinal() ? weekAndDaySchedule.getWeekday() - after.getWeekday().getOrdinal() : 7 - (after.getWeekday().getOrdinal() - weekAndDaySchedule.getWeekday()));
        LocalDate nextEvent = LocalDate.of(after.getYear(), after.getMonth().getOrdinal() + 1, after.getDay());
        if (weekAndDaySchedule.getMonth() + 1 == month || weekAndDaySchedule.getMonth() == -1) {
            if (weekAndDaySchedule.getWeek() == week || weekAndDaySchedule.getWeek() == -1) {
                if (weekAndDaySchedule.getWeekday() == after.getWeekday().getOrdinal() || weekAndDaySchedule.getWeekday() == -1) {
                    nextEvent = LocalDate.of(after.getYear(), month, after.getDay());
                } else {
                    plusDays = weekAndDaySchedule.getWeekday() > after.getWeekday().getOrdinal() ? weekAndDaySchedule.getWeekday() - after.getWeekday().getOrdinal() : 7 - (after.getWeekday().getOrdinal() - weekAndDaySchedule.getWeekday());
                    int monthDays = after.getDay() + plusDays;
                    if (monthDays <= ScheduleUtils.getLastDay(month, after.getYear())) {
                        nextEvent = LocalDate.of(after.getYear(), month, after.getDay()).plusDays(plusDays);
                    } else {
                        int dayOfMonth = weekAndDaySchedule.getWeek() == -1 ? 1 : (weekAndDaySchedule.getWeek() <= 5 ? (weekAndDaySchedule.getWeek() - 1) * 7 + 1 : (weekAndDaySchedule.getWeek() == 6 ? 1 : (weekAndDaySchedule.getWeek() == 7 ? 8 : (weekAndDaySchedule.getWeek() == 8 ? 15 : 22))));
                        int nextMonth = weekAndDaySchedule.getMonth() == -1 ? month + 1 : weekAndDaySchedule.getMonth() + 1 + 12;
                        int nextYear = nextMonth > 12 ? after.getYear() + 1 : after.getYear();
                        BWeekday firstDayOfMonth = BAbsTime.getWeekday((int)nextYear, (BMonth)BMonth.make((int)((nextMonth %= 12) - 1)), (int)1);
                        plusDays = weekAndDaySchedule.getWeekday() == -1 || weekAndDaySchedule.getWeekday() == firstDayOfMonth.getOrdinal() ? 0 : (weekAndDaySchedule.getWeekday() > firstDayOfMonth.getOrdinal() ? weekAndDaySchedule.getWeekday() - firstDayOfMonth.getOrdinal() : 7 - (firstDayOfMonth.getOrdinal() - weekAndDaySchedule.getWeekday()));
                        nextEvent = LocalDate.of(nextYear, nextMonth, dayOfMonth).plusDays(plusDays);
                    }
                }
            } else if (weekAndDaySchedule.getWeek() > week) {
                int days = plusDays;
                if (weekAndDaySchedule.getWeek() <= 5) {
                    days += (weekAndDaySchedule.getWeek() - 1) * 7 + 1 - after.getDay();
                } else {
                    switch (weekAndDaySchedule.getWeek()) {
                        case 6: {
                            break;
                        }
                        case 7: {
                            if (week >= 2) break;
                            days += 8 - after.getDay();
                            break;
                        }
                        case 8: {
                            if (week >= 3) break;
                            days += 15 - after.getDay();
                            break;
                        }
                        default: {
                            if (week >= 4) break;
                            days += 22 - after.getDay();
                        }
                    }
                }
                int monthDays = after.getDay() + days;
                if (monthDays <= ScheduleUtils.getLastDay(month, after.getYear())) {
                    nextEvent = LocalDate.of(after.getYear(), month, after.getDay()).plusDays(days);
                } else {
                    days += ScheduleUtils.getStartDayOfMonth(weekAndDaySchedule.getWeek());
                    if (weekAndDaySchedule.getMonth() + 1 == month) {
                        nextEvent = LocalDate.of(after.getYear() + 1, month, days);
                    } else {
                        int nextMonth = month + 1;
                        int nextYear = nextMonth <= 12 ? after.getYear() : after.getYear() + 1;
                        nextEvent = LocalDate.of(nextYear, nextMonth %= 12, days);
                    }
                }
            } else if (weekAndDaySchedule.getWeek() < week) {
                int day = ScheduleUtils.getStartDayOfMonth(weekAndDaySchedule.getWeek());
                int nextMonth = weekAndDaySchedule.getMonth() == -1 ? month + 1 : weekAndDaySchedule.getMonth() + 1 + 12;
                int nextYear = nextMonth > 12 ? after.getYear() + 1 : after.getYear();
                BWeekday firstDayOfMonth = BAbsTime.getWeekday((int)nextYear, (BMonth)BMonth.make((int)((nextMonth %= 12) - 1)), (int)1);
                plusDays = weekAndDaySchedule.getWeekday() == -1 || weekAndDaySchedule.getWeekday() == firstDayOfMonth.getOrdinal() ? 0 : (weekAndDaySchedule.getWeekday() > firstDayOfMonth.getOrdinal() ? weekAndDaySchedule.getWeekday() - firstDayOfMonth.getOrdinal() : 7 - (firstDayOfMonth.getOrdinal() - weekAndDaySchedule.getWeekday()));
                nextEvent = LocalDate.of(nextYear, nextMonth, day).plusDays(plusDays);
            }
        } else if (weekAndDaySchedule.getMonth() + 1 > month) {
            int day = ScheduleUtils.getStartDayOfMonth(weekAndDaySchedule.getWeek());
            nextEvent = LocalDate.of(after.getYear(), weekAndDaySchedule.getMonth() + 1, day).plusDays(plusDays);
        } else {
            int day = ScheduleUtils.getStartDayOfMonth(weekAndDaySchedule.getWeek());
            nextEvent = LocalDate.of(after.getYear() + 1, weekAndDaySchedule.getMonth() + 1, day).plusDays(plusDays);
        }
        return nextEvent;
    }

    private static int getStartDayOfMonth(int weekday) {
        int startDayOfMonth = 1;
        if (weekday <= 5) {
            startDayOfMonth = (weekday - 1) * 7 + 1;
        } else {
            switch (weekday) {
                case 6: {
                    break;
                }
                case 7: {
                    startDayOfMonth = 8;
                    break;
                }
                case 8: {
                    startDayOfMonth = 15;
                    break;
                }
                default: {
                    startDayOfMonth = 22;
                }
            }
        }
        return startDayOfMonth;
    }

    static boolean isOddMonth(int month) {
        boolean found = false;
        for (int i : oddMonths) {
            if (month != i) continue;
            found = true;
            break;
        }
        return found;
    }

    static boolean isEvenMonth(int month) {
        return !ScheduleUtils.isOddMonth(month);
    }

    static int getLastDay(int month, int year) {
        return BAbsTime.getDaysInMonth((int)year, (BMonth)BMonth.make((int)(month + 1)));
    }

    static boolean isLeapYear(int year) {
        return BAbsTime.isLeapYear((int)year);
    }

    public static long unixToDotnetEpochMillis(long unixMillis) {
        return unixMillis + NET_TO_UNIX_EPOCH_OFFSET_MILLIS;
    }

    public static long dotnetToUnixEpochMillis(long dotnetMillis) {
        return dotnetMillis - NET_TO_UNIX_EPOCH_OFFSET_MILLIS;
    }

    public static long niagaraTimeToNanoUtcMillis(BAbsTime niagaraTime) {
        return ScheduleUtils.unixToDotnetEpochMillis(niagaraTime.toUtcTime().getMillis());
    }

    public static long niagaraTimeToNanoUtcTicks(BAbsTime niagaraTime) {
        return ScheduleUtils.niagaraTimeToNanoUtcMillis(niagaraTime) * NET_TICKS_PER_MILLI;
    }

    public static String timeZoneToPosix(BTimeZone timeZone, Context cx) {
        StringBuilder sb = new StringBuilder(ScheduleUtils.makeTimeZoneAbbreviation(timeZone.getShortDisplayName(false, cx)));
        sb.append(ScheduleUtils.offsetMillisToPosix(timeZone.getUtcOffset()));
        if (timeZone.getDaylightStartRule() != null && timeZone.getDaylightEndRule() != null) {
            sb.append(ScheduleUtils.makeTimeZoneAbbreviation(timeZone.getShortDisplayName(true, cx)));
            sb.append(ScheduleUtils.offsetMillisToPosix(timeZone.getUtcOffset() + timeZone.getDaylightAdjustment()));
            String dstRules = ScheduleUtils.dstRulesToPosix(timeZone);
            sb.append(dstRules);
        }
        return sb.toString();
    }

    private static String makeTimeZoneAbbreviation(String shortDisplayName) {
        if (shortDisplayName.contains(":") || shortDisplayName.contains("+") || shortDisplayName.contains("-")) {
            return '<' + shortDisplayName + '>';
        }
        return shortDisplayName;
    }

    private static String offsetMillisToPosix(int offset) {
        BRelTime utcOffsetRel = BRelTime.make((long)offset).abs();
        String utcOffset = String.format(POSIX_TIME_FORMAT, utcOffsetRel.getHoursPart(), utcOffsetRel.getMinutesPart(), utcOffsetRel.getSecondsPart());
        if (offset > 0) {
            utcOffset = '-' + utcOffset;
        }
        return utcOffset;
    }

    private static String timeToPosix(BTime time) {
        if (time == null) {
            return "";
        }
        String timeString = String.format(POSIX_TIME_FORMAT, time.getHour(), time.getMinute(), time.getSecond());
        return timeString;
    }

    private static String dstRulesToPosix(BTimeZone timeZone) {
        DstRule dstEndRule;
        DstRule dstStartRule = timeZone.getDaylightStartRule() != null ? timeZone.getDaylightStartRule().asWallTimeRule(0, timeZone) : null;
        DstRule dstRule = dstEndRule = timeZone.getDaylightEndRule() != null ? timeZone.getDaylightEndRule().asWallTimeRule(1, timeZone) : null;
        if (dstStartRule == null || dstEndRule == null) {
            return "";
        }
        String posixStartRule = ScheduleUtils.dstRuleToPosix(dstStartRule);
        String posixEndRule = ScheduleUtils.dstRuleToPosix(dstEndRule);
        return "," + posixStartRule + ',' + posixEndRule;
    }

    private static String dstRuleToPosix(DstRule dstRule) {
        String dstRuleString = "invalid dstRule";
        try {
            dstRuleString = dstRule.encodeToString();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        int monthOfYear = dstRule.getMonth().getMonthOfYear();
        String posixRule = "";
        switch (dstRule.getDayMode()) {
            case 0: {
                BMonth month = dstRule.getMonth();
                int year = BDate.today().getYear();
                int day = dstRule.getDay();
                BDate dstDate = BDate.make((int)year, (BMonth)month, (int)day);
                int dayOfYear = dstDate.getDayOfYear();
                if (dstDate.isLeapDay()) {
                    posixRule = String.valueOf(dayOfYear - 1);
                    break;
                }
                if (BAbsTime.isLeapYear((int)year) && dstDate.isAfter(BDate.make((int)year, (BMonth)BMonth.february, (int)28))) {
                    posixRule = "J" + String.valueOf(dayOfYear - 1);
                    break;
                }
                posixRule = "J" + String.valueOf(dayOfYear);
                break;
            }
            case -1: 
            case 1: {
                int weekday = dstRule.getWeekday().getOrdinal();
                BPosixDstWeekEnum weekEnum = ScheduleUtils.getWeekdayOccurrance(dstRule);
                posixRule = String.format(POSIX_WEEKDAY_RULE_FORMAT, monthOfYear, weekEnum.getOrdinal(), weekday);
                break;
            }
            default: {
                throw new IllegalStateException("[getDstRuleToPosix]: Unsupported dayMode for " + dstRuleString);
            }
        }
        posixRule = posixRule + '/' + ScheduleUtils.timeToPosix(dstRule.getTime());
        return posixRule;
    }

    private static BPosixDstWeekEnum getWeekdayOccurrance(DstRule dstRule) {
        String dstRuleString = "invalid dstRule";
        try {
            dstRuleString = dstRule.encodeToString();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        int dayMode = dstRule.getDayMode();
        switch (dayMode) {
            case -1: {
                int week = dstRule.getWeek() + 1;
                if (week < 0 || week > 5) {
                    throw new IllegalStateException("[getWeekdayOccurrance]: Unsupported week for " + dstRuleString);
                }
                return BPosixDstWeekEnum.make(week);
            }
            case 1: {
                BDate firstMatchingDate;
                int firstMatchingDay;
                BWeekday dstTargetWeekday = dstRule.getWeekday();
                int day = dstRule.getDay();
                BMonth month = dstRule.getMonth();
                int currentYear = BDate.today().getYear();
                BDate dstDate = BDate.make((int)currentYear, (BMonth)month, (int)day);
                BWeekday dstDateWeekday = dstDate.getWeekday();
                int dayDiff = dstTargetWeekday.getOrdinal() - dstDateWeekday.getOrdinal();
                if (dayDiff < 0) {
                    dayDiff += 7;
                }
                if (1 <= (firstMatchingDay = (firstMatchingDate = dstDate.add(dayDiff)).getDay()) && firstMatchingDay <= 7) {
                    return BPosixDstWeekEnum.first;
                }
                if (8 <= firstMatchingDay && firstMatchingDay <= 14) {
                    return BPosixDstWeekEnum.second;
                }
                if (15 <= firstMatchingDay && firstMatchingDay <= 21) {
                    return BPosixDstWeekEnum.third;
                }
                if (22 <= firstMatchingDay && firstMatchingDay <= 28) {
                    BDate nextMatchingDate = firstMatchingDate.add(7);
                    if (nextMatchingDate.getMonth().equals((Object)firstMatchingDate.getMonth())) {
                        return BPosixDstWeekEnum.fourth;
                    }
                    return BPosixDstWeekEnum.last;
                }
                if (firstMatchingDay <= 28) break;
                return BPosixDstWeekEnum.last;
            }
        }
        throw new IllegalStateException("[getWeekdayOccurrance]: Unsupported day mode for " + dstRuleString);
    }

    public static String[] getNiagaraTimeZoneInfo(Context context, boolean showDebugOutput) throws IOException {
        String[] timeZoneIds = TimeZoneDatabase.getAllSupportedZoneIds();
        if (showDebugOutput) {
            for (String timeZoneId : timeZoneIds) {
                BTimeZone timeZone = TimeZoneDatabase.getTimeZone((String)timeZoneId);
                System.out.println(String.format("-------------------------------------------\ntime zone id: '%s', UTC offset: '%s', Java time zone: '%s', tz-support: '%s',\ndisplayName not in DST: '%s', displayName in DST: '%s'\nshortDisplayName not in DST: '%s', shortDisplayName in DST: '%s'\nDstStartRule: '%s', DstEndRule: : '%s'\nposix Time Zone format: '%s'", timeZoneId, timeZone.getUtcOffset(), timeZone.isJavaTimeZone(), timeZone.tzSupport(), timeZone.getDisplayName(false, context), timeZone.getDisplayName(true, context), timeZone.getShortDisplayName(false, context), timeZone.getShortDisplayName(true, context), timeZone.getDaylightStartRule() != null ? timeZone.getDaylightStartRule().encodeToString() : "no daylight start rule", timeZone.getDaylightEndRule() != null ? timeZone.getDaylightEndRule().encodeToString() : "no daylight end rule", ScheduleUtils.timeZoneToPosix(timeZone, context)));
            }
        }
        return timeZoneIds;
    }

    public static class DateDiff {
        int years;
        int months;
        int days;

        public int getYears() {
            return this.years;
        }

        public int getMonths() {
            return this.months;
        }

        public int getDays() {
            return this.days;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DateDiff dateDiff = (DateDiff)o;
            return this.years == dateDiff.years && this.months == dateDiff.months && this.days == dateDiff.days;
        }

        public int hashCode() {
            return Objects.hash(this.years, this.months, this.days);
        }

        private DateDiff(int years, int months, int days) {
            this.years = years;
            this.months = months;
            this.days = days;
        }

        public static DateDiff make(BAbsTime start, BAbsTime end) {
            int yearDiff = 0;
            int monthDiff = 0;
            int dayDiff = 0;
            BAbsTime startAsUtc = null;
            BAbsTime endAsUtc = null;
            boolean invert = start.isAfter(end);
            if (!invert) {
                startAsUtc = start.toUtcTime();
                endAsUtc = end.toUtcTime();
            } else {
                startAsUtc = end.toUtcTime();
                endAsUtc = start.toUtcTime();
            }
            yearDiff = endAsUtc.getYear() - startAsUtc.getYear();
            monthDiff = endAsUtc.getMonth().getMonthOfYear() - startAsUtc.getMonth().getMonthOfYear();
            if (monthDiff < 0 && yearDiff >= 1) {
                --yearDiff;
                monthDiff += 12;
            }
            if ((dayDiff = endAsUtc.getDay() - startAsUtc.getDay()) < 0 && monthDiff >= 1) {
                int adjustedMonthOrdinal = (endAsUtc.getMonth().getOrdinal() + --monthDiff) % 11;
                BMonth adjustedMonth = BMonth.make((int)adjustedMonthOrdinal);
                int adjustedYear = startAsUtc.getYear() + yearDiff + (endAsUtc.getMonth().getOrdinal() + monthDiff) / 11;
                int daysInMonth = BAbsTime.getDaysInMonth((int)adjustedYear, (BMonth)adjustedMonth);
                dayDiff = daysInMonth - startAsUtc.getDay() + endAsUtc.getDay();
            }
            if (invert) {
                yearDiff *= -1;
                monthDiff *= -1;
                dayDiff *= -1;
            }
            return new DateDiff(yearDiff, monthDiff, dayDiff);
        }

        public String toString() {
            String yearTag = this.years != 0 ? this.years + " years" : "";
            String monthTag = this.months > 0 ? this.months + " months" : "";
            String dayTag = this.days > 0 ? this.days + " days" : "";
            return yearTag + (!yearTag.isEmpty() ? ", " + monthTag : monthTag) + (!monthTag.isEmpty() ? ", " + dayTag : dayTag);
        }

        public String toString(Context cx) {
            Lexicon lex = Lexicon.make((String)"nE2Link", (Context)cx);
            if (this.years == 0 && this.months == 0 && this.days == 0) {
                return lex.get("ScheduleUtils.today", "Today");
            }
            if (this.years == 0 && this.months == 0 && this.days == 1) {
                return lex.get("ScheduleUtils.tomorrow", "Tomorrow");
            }
            if (this.years < 0 || this.months < 0 || this.days < 0) {
                return lex.get("ScheduleUtils.past", "Past");
            }
            String yearTag = this.years != 0 ? this.years + " " + lex.get("ScheduleUtils.years", "years") : "";
            String monthTag = this.months > 0 ? this.months + " " + lex.get("ScheduleUtils.months", "months") : "";
            String dayTag = this.days > 0 ? this.days + " " + lex.get("ScheduleUtils.days", "days") : "";
            return lex.get("ScheduleUtils.occursIn", "Occurs in") + " " + yearTag + (!yearTag.isEmpty() ? ", " + monthTag : monthTag) + (!monthTag.isEmpty() ? ", " + dayTag : dayTag);
        }
    }
}

