/*
 * Decompiled with CFR 0.152.
 */
package com.miratech.nE2Link.security;

import com.miratech.nE2Link.security.CipherInfo;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.util.Arrays;
import java.util.Base64;
import javax.baja.nre.util.ByteArrayUtil;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;

public class AesUtil {
    public static SecretKey generateKey(int n) throws NoSuchAlgorithmException {
        KeyGenerator keyGenerator = KeyGenerator.getInstance("AES");
        keyGenerator.init(n);
        SecretKey key = keyGenerator.generateKey();
        return key;
    }

    public static SecretKey generateKeyFromPassphrase(String passphrase, String salt) throws NoSuchAlgorithmException, InvalidKeySpecException {
        return AesUtil.generateKeyFromPassphrase(passphrase, salt.getBytes());
    }

    public static SecretKey generateKeyFromPassphrase(String passphrase, byte[] salt) throws NoSuchAlgorithmException, InvalidKeySpecException {
        return AesUtil.generateKeyFromPassphrase(passphrase, salt, 65536, 256);
    }

    public static SecretKey generateKeyFromPassphrase(String passphrase, byte[] salt, int iterations, int keyLength) throws NoSuchAlgorithmException, InvalidKeySpecException {
        SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA256");
        PBEKeySpec spec = new PBEKeySpec(passphrase.toCharArray(), salt, iterations, keyLength);
        SecretKeySpec secret = new SecretKeySpec(factory.generateSecret(spec).getEncoded(), "AES");
        return secret;
    }

    public static IvParameterSpec generateIv() {
        byte[] iv = new byte[16];
        new SecureRandom().nextBytes(iv);
        return new IvParameterSpec(iv);
    }

    public static byte[] generateRandomSalt(int size) {
        byte[] salt = new byte[size];
        new SecureRandom().nextBytes(salt);
        return salt;
    }

    public static byte[] generateCombinedCipher(byte[] iv, byte[] salt, boolean successfullyEncrypted, byte[] cipherText) {
        int integerSize = 4;
        int booleanSize = 1;
        int requiredLength = integerSize + iv.length + integerSize + salt.length + booleanSize + cipherText.length;
        byte[] cipherWithIvAndSalt = new byte[requiredLength];
        ByteArrayUtil.writeInt((byte[])cipherWithIvAndSalt, (int)0, (int)iv.length);
        System.arraycopy(iv, 0, cipherWithIvAndSalt, integerSize, iv.length);
        ByteArrayUtil.writeInt((byte[])cipherWithIvAndSalt, (int)(integerSize + iv.length), (int)salt.length);
        System.arraycopy(salt, 0, cipherWithIvAndSalt, integerSize + iv.length + integerSize, salt.length);
        cipherWithIvAndSalt[integerSize + iv.length + integerSize + salt.length] = successfullyEncrypted ? (byte)1 : 0;
        System.arraycopy(cipherText, 0, cipherWithIvAndSalt, integerSize + iv.length + integerSize + salt.length + booleanSize, cipherText.length);
        return cipherWithIvAndSalt;
    }

    public static CipherInfo extractCipherInfo(byte[] combinedCipher) {
        int ivLength = ByteArrayUtil.readInt((byte[])combinedCipher, (int)0);
        int integerSize = 4;
        int booleanSize = 1;
        byte[] iv = Arrays.copyOfRange(combinedCipher, integerSize, integerSize + ivLength);
        int saltLength = ByteArrayUtil.readInt((byte[])combinedCipher, (int)(integerSize + ivLength));
        byte[] salt = Arrays.copyOfRange(combinedCipher, integerSize + ivLength + integerSize, integerSize + ivLength + integerSize + saltLength);
        boolean isCipherEncrypted = combinedCipher[integerSize + ivLength + integerSize + saltLength] == 1;
        byte[] cipherText = Arrays.copyOfRange(combinedCipher, integerSize + ivLength + integerSize + saltLength + booleanSize, combinedCipher.length);
        return new CipherInfo(iv, salt, isCipherEncrypted, cipherText);
    }

    public static byte[] encrypt(String algorithm, String input, SecretKey key, IvParameterSpec iv) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException {
        return AesUtil.encrypt(algorithm, input.getBytes(), key, iv);
    }

    public static byte[] encrypt(String algorithm, byte[] input, SecretKey key, IvParameterSpec iv) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException {
        Cipher cipher = Cipher.getInstance(algorithm);
        cipher.init(1, (Key)key, iv);
        byte[] cipherText = cipher.doFinal(input);
        return cipherText;
    }

    public static byte[] decrypt(String algorithm, byte[] encryptedInput, SecretKey key, IvParameterSpec iv) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException, InvalidKeySpecException {
        Cipher cipher = Cipher.getInstance(algorithm);
        cipher.init(2, (Key)key, iv);
        byte[] decodedValue = cipher.doFinal(encryptedInput);
        return decodedValue;
    }

    public static byte[] decrypt(String algorithm, String encryptedInput, SecretKey key, IvParameterSpec iv) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, InvalidKeyException, BadPaddingException, IllegalBlockSizeException, InvalidKeySpecException {
        return AesUtil.decrypt(algorithm, encryptedInput.getBytes(), key, iv);
    }

    public static String encodeToBase64(byte[] input) {
        return Base64.getEncoder().encodeToString(input);
    }

    public static byte[] decodeFromBase64(String input) {
        return Base64.getDecoder().decode(input);
    }
}

