/*
 * Decompiled with CFR 0.152.
 */
package com.miratech.nE2Link.threading;

import java.util.logging.Logger;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.NotRunningException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BThreadPoolWorker;
import javax.baja.util.CoalesceQueue;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;
import javax.baja.util.Queue;
import javax.baja.util.ThreadPoolWorker;
import javax.baja.util.Worker;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="maxQueueSize", type="int", defaultValue="100"), @NiagaraProperty(name="isCoalescing", type="boolean", defaultValue="false")})
public class BMultiThreadPoolWorker
extends BThreadPoolWorker {
    public static final Property maxQueueSize = BMultiThreadPoolWorker.newProperty((int)0, (int)100, null);
    public static final Property isCoalescing = BMultiThreadPoolWorker.newProperty((int)0, (boolean)false, null);
    public static final Type TYPE = Sys.loadType(BMultiThreadPoolWorker.class);
    protected static Logger LOGGER = Logger.getLogger(TYPE.getTypeSpec().getModuleName());
    private ThreadPoolWorker _worker;
    private Worker _criticalTaskWorker;
    protected final Object instanceLock = new Object();

    public int getMaxQueueSize() {
        return this.getInt(maxQueueSize);
    }

    public void setMaxQueueSize(int v) {
        this.setInt(maxQueueSize, v, null);
    }

    public boolean getIsCoalescing() {
        return this.getBoolean(isCoalescing);
    }

    public void setIsCoalescing(boolean v) {
        this.setBoolean(isCoalescing, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BMultiThreadPoolWorker() {
    }

    public BMultiThreadPoolWorker(int maxThreads, int maxQueueSize, boolean isCoalescing) {
        this();
        this.setIsCoalescing(isCoalescing);
        this.setMaxQueueSize(maxQueueSize);
        this.setMaxThreads(maxThreads);
    }

    public Worker getWorker() {
        return this._worker != null ? this._worker : this.createWorkerWithQueue();
    }

    public Worker getCriticalTaskWorker() {
        return this._criticalTaskWorker != null ? this._criticalTaskWorker : this.createCriticalTaskWorker(500);
    }

    public void postAsync(Runnable r, boolean isCriticalTask) {
        Queue queue;
        Queue queue2 = queue = isCriticalTask ? (Queue)this.getCriticalTaskWorker().getTodo() : (Queue)this.getWorker().getTodo();
        if (queue == null) {
            throw new NotRunningException();
        }
        queue.enqueue((Object)r);
    }

    public void postAsync(Runnable r) {
        this.postAsync(r, false);
    }

    public IFuture post(Action action, BValue argument, Context cx) {
        this.postAsync((Runnable)new Invocation((BComponent)this, action, argument, cx), true);
        return null;
    }

    public void started() throws Exception {
        this.createWorkerWithQueue();
        this.createCriticalTaskWorker(500);
        LOGGER.finest("Worker for async operations started: " + this.toString(null));
    }

    public void changed(Property prop, Context cx) {
        Worker worker;
        if (!this.isRunning()) {
            return;
        }
        if (prop.equals(maxQueueSize) || prop.equals(isCoalescing)) {
            this.createWorkerWithQueue();
        }
        if (prop.equals(maxThreads) && (worker = this.getWorker()) instanceof ThreadPoolWorker) {
            ((ThreadPoolWorker)worker).setMaxThreads(this.getMaxThreads());
        }
    }

    public String toString(Context context) {
        return '[' + (this.isMounted() ? this.getNavOrd().relativizeToHost().toString() : ((Object)((Object)this)).getClass().getSimpleName()) + "]: maxThreads=" + this.getMaxThreads() + "; queueSize=" + this.getMaxQueueSize() + "; " + (!this.getIsCoalescing() ? "non-" : "") + "coalescing";
    }

    public void doUpdateQueueStatus() {
        Queue queue;
        int currentQueueSize = 0;
        if (this._worker != null && (queue = (Queue)this._worker.getTodo()) != null) {
            currentQueueSize = queue.size();
        }
    }

    protected Worker createCriticalTaskWorker(int maxQueueSize) {
        Queue queue = new Queue(maxQueueSize);
        this._criticalTaskWorker = new Worker((Worker.ITodo)queue);
        this._criticalTaskWorker.start(this.getName() + ".criticalTaskWorker");
        return this._criticalTaskWorker;
    }

    protected Worker createWorkerWithQueue() {
        this.eraseWorker();
        Object newQueue = this.getIsCoalescing() ? new CoalesceQueue(this.getMaxQueueSize()) : new Queue(this.getMaxQueueSize());
        this._worker = new ThreadPoolWorker((Worker.ITodo)newQueue);
        this._worker.setMaxThreads(this.getMaxThreads());
        LOGGER.finer("Created new worker for async operations: " + this.toString(null));
        this._worker.start(this.getWorkerThreadName());
        return this._worker;
    }

    protected void eraseWorker() {
        Queue queue = null;
        if (this._worker != null) {
            queue = (Queue)this._worker.getTodo();
            this._worker.stop();
        }
        if (queue != null) {
            queue.clear();
        }
        this._worker = null;
    }
}

