/*
 * Decompiled with CFR 0.152.
 */
package com.miratech.nE2Link.utils;

import com.miratech.nE2Link.BNe2DeviceExt;
import com.miratech.nE2Link.utils.BFileTransfer;
import com.miratech.nE2Link.utils.ManifestHelper;
import com.miratech.nE2Link.utils.javabeans.FlatManifest;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;

public class OsUpdateHelper {
    BNe2DeviceExt ne2DeviceExt = null;

    public OsUpdateHelper(BNe2DeviceExt ne2DeviceExt) {
        this.ne2DeviceExt = ne2DeviceExt;
    }

    public static boolean createOSUpdate(BNe2DeviceExt ne2DeviceExt, BDirectory tempDirectory) {
        System.out.println("OsUpdateHelper.createOSUpdate");
        boolean ok = false;
        try {
            String osTempDirPath = tempDirectory.toPathString() + "/updateOSTemp";
            String osTempDirFullPath = osTempDirPath + "/system/update";
            String coreVersion = ManifestHelper.getHierarchicalManifest(tempDirectory).getCoreVersion();
            FilePath osFileFullName = OsUpdateHelper.getOSFileFullName(coreVersion);
            if (null != osFileFullName) {
                BOrd osTempDirFullPathOrd = BOrd.make((String)(osTempDirFullPath + "/update.bin"));
                OrdQuery[] queries = osTempDirFullPathOrd.normalize().parse();
                FilePath filePath = (FilePath)queries[queries.length - 1];
                BIFile osFile = BFileSystem.INSTANCE.findFile(osFileFullName);
                BIFile updateFile = BFileSystem.INSTANCE.makeFile(filePath);
                InputStream is = osFile.getInputStream();
                byte[] fileContent = new byte[is.available()];
                is.read(fileContent);
                is.close();
                OutputStream out = updateFile.getOutputStream();
                out.write(fileContent);
                out.flush();
                out.close();
                BFileTransfer fileTransfer = new BFileTransfer(ne2DeviceExt);
                fileTransfer.filePut("/system/update", updateFile.getFileName(), updateFile.read());
                OsUpdateHelper.deleteTemp(osTempDirPath);
                ok = true;
                System.out.println("OsUpdateHelper.createOSUpdate OS binary file transferred!: " + osFileFullName);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return ok;
    }

    private static void deleteTemp(String osTempDirPath) throws IOException {
        BOrd osTempDirFullPathOrd = BOrd.make((String)osTempDirPath);
        OrdQuery[] queries = osTempDirFullPathOrd.normalize().parse();
        FilePath filePath = (FilePath)queries[queries.length - 1];
        BFileSystem.INSTANCE.delete(filePath);
    }

    private static FilePath getOSFileFullName(String coreVersion) {
        try {
            OrdQuery[] queries = BNe2DeviceExt.OS_FILE_ORD.normalize().parse();
            FilePath filePath = (FilePath)queries[queries.length - 1];
            BDirectory librariesFolder = BFileSystem.INSTANCE.makeDir(filePath);
            for (BIFile file : librariesFolder.listFiles()) {
                if (!file.getExtension().equals("bin")) continue;
                try {
                    String fileName = file.getFileName().substring(0, file.getFileName().indexOf(file.getExtension()) - 1);
                    String[] libNameAndVersion = fileName.split("-");
                    String osVersion = libNameAndVersion[1];
                    if (!osVersion.equals(coreVersion)) continue;
                    return file.getFilePath();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static final boolean isOSUpdateInBackup(BDirectory tempDirectory) {
        boolean[] ok = new boolean[1];
        FlatManifest flatManifest = ManifestHelper.getFilesManifestFile(tempDirectory);
        flatManifest.getArchive().forEach(a -> a.getFiles().forEach(f -> {
            if (f.getFileName().equals("/system/update/update.bin")) {
                ok[0] = true;
            }
        }));
        System.out.println("does backup contains an OS file: " + ok[0]);
        return ok[0];
    }
}

