/*
 * Decompiled with CFR 0.152.
 */
package com.miratech.nE2Link.ui;

import com.miratech.nE2Link.ui.BSwitchableView;
import com.tridium.sys.registry.NModuleInfo;
import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.baja.gx.BImage;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.platform.RuntimeProfile;
import javax.baja.registry.ModuleInfo;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BDate;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BLabel;
import javax.baja.ui.BPicture;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.pane.BGridPane;

@NiagaraType(agent={@AgentOn(types={"nE2Link:Ne2DeviceExt"}, defaultAgent=AgentOn.Preference.PREFERRED)})
public class BAbout
extends BSwitchableView {
    public static final Type TYPE = Sys.loadType(BAbout.class);

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public void doLoadValue(BObject value, Context context) throws Exception {
        BPicture pic = new BPicture();
        pic.setImage(BImage.make((String)"module://nE2Link/rc/images/about.png"));
        StringBuilder sb = new StringBuilder("").append(LEX.get("About.headline")).append('\n').append(LEX.getText("About.version", new Object[]{BAbout.getVersion()})).append('\n').append('\n').append(LEX.getText("About.copyright", new Object[]{BAbout.getBuildTime()})).append('\n').append('\n').append(LEX.getText("About.technicalSupport")).append('\n').append(LEX.getText("About.technicalSupportEMail")).append('\n').append('\n').append('\n').append(LEX.getText("About.contact")).append('\n').append(LEX.getText("About.contactCompany")).append('\n').append(LEX.getText("About.contactStreet")).append('\n').append(LEX.getText("About.contactCity")).append('\n').append('\n');
        BLabel aboutLabel = new BLabel(sb.toString());
        BGridPane linkPane = new BGridPane(2);
        linkPane.setValign(BValign.center);
        linkPane.add(null, (BValue)new BLabel(LEX.get("About.website.label", "Visit our ")));
        linkPane.add(null, (BValue)new BButton((Command)new HyperlinkCommand((BWidget)this, LEX.get("About.website.button", "Website"), "https://ismacontrolli.com"), true, false));
        BGridPane globalPane = new BGridPane(1);
        globalPane.setValign(BValign.center);
        globalPane.setColumnAlign(BHalign.center);
        globalPane.add(null, (BValue)pic);
        globalPane.add(null, (BValue)aboutLabel);
        globalPane.add(null, (BValue)linkPane);
        this.setContent((BWidget)globalPane);
        super.doLoadValue(value, context);
    }

    public static String getVersion() {
        ModuleInfo mi = Sys.getRegistry().getModule("nE2Link", RuntimeProfile.rt);
        return mi.getVendorVersion().toString();
    }

    public static String getBuildTime() {
        ModuleInfo mi = Sys.getRegistry().getModule("nE2Link", RuntimeProfile.rt);
        long buildTime = ((NModuleInfo)mi).getBuildTime();
        return String.valueOf(BDate.make((BAbsTime)BAbsTime.make((long)buildTime)).getYear());
    }

    @Override
    public void handleComponentEvent(BComponentEvent event) {
        super.handleComponentEvent(event);
    }

    @Override
    public void deactivated() {
        super.deactivated();
        this.unregisterForAllComponentEvents();
    }

    class HyperlinkCommand
    extends Command {
        String url;
        private BAbout manager;

        HyperlinkCommand(BWidget manager, String name, String url) {
            super(manager, "Website");
            this.url = url;
            this.manager = (BAbout)manager;
        }

        public CommandArtifact doInvoke() throws IOException, URISyntaxException {
            if (Desktop.isDesktopSupported()) {
                Desktop.getDesktop().browse(new URI(this.url));
            } else {
                Runtime runtime = Runtime.getRuntime();
                runtime.exec("/usr/bin/firefox -new-window " + this.url);
            }
            return null;
        }
    }
}

