/*
 * Decompiled with CFR 0.152.
 */
package com.miratech.nE2Link.ui;

import com.miratech.nE2Link.BNanoComponent;
import com.miratech.nE2Link.BNe2DeviceExt;
import com.miratech.nE2Link.actions.BBackupRestoreArgs;
import com.miratech.nE2Link.ui.BNanoDownloadBackupDialog;
import com.miratech.nE2Link.ui.BNanoRestoreDialog;
import com.miratech.nE2Link.ui.NanoBackupsTableModel;
import com.miratech.nE2Link.utils.BBackupStatus;
import com.miratech.nE2Link.utils.BConnectionStatus;
import com.miratech.nE2Link.utils.BSoftwareManager;
import com.tridium.ui.theme.Theme;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import javax.baja.gx.BInsets;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatusEnum;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BOrientation;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BSplitPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.table.TableSelection;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.view.BWbComponentView;

@NiagaraType(agent={@AgentOn(types={"nE2Link:NanoComponent"}, defaultAgent=AgentOn.Preference.PREFERRED)})
public class BNanoBackupManager
extends BWbComponentView {
    public static final Type TYPE = Sys.loadType(BNanoBackupManager.class);
    BNe2DeviceExt ne2DeviceExt = null;
    BNanoComponent backups = null;
    NanoBackupsTableModel localBackupsModel = null;
    NanoBackupsTableModel onDeviceBackupsModel = null;
    BTable localBackupsTable = null;
    BTable onDeviceBackupsTable = null;
    BackupCmd backupCmd = null;
    DownloadBackupCmd downloadBackupCmd = null;
    DeleteBackupCmd deleteBackupCmd = null;
    RestoreCmd restoreCmd = null;
    protected static final Lexicon lex = Lexicon.make(BNanoBackupManager.class);
    BDialog backupInProgressDlg = null;
    BDialog restoreInProgressDlg = null;
    BDialog downloadInProgressDlg = null;

    public Type getType() {
        return TYPE;
    }

    public void doLoadValue(BObject value, Context context) throws Exception {
        super.doLoadValue(value, context);
        this.backups = (BNanoComponent)value;
        this.backups.requestNanoSubscription();
        this.ne2DeviceExt = this.backups.getNe2DeviceExt();
        BLabel localBackups = new BLabel("Local Backups", Theme.widget().getBoldText(), BHalign.center);
        BGridPane localBackupsHeader = new BGridPane(1, new BWidget[]{localBackups});
        localBackupsHeader.setHalign(BHalign.center);
        BLabel onDeviceBackups = new BLabel("On Device Backups", Theme.widget().getBoldText(), BHalign.center);
        BGridPane onDeviceBackupsHeader = new BGridPane(1, new BWidget[]{onDeviceBackups});
        onDeviceBackupsHeader.setHalign(BHalign.center);
        this.localBackupsModel = new NanoBackupsTableModel(this.ne2DeviceExt, new String[]{"Backup Name", "Timestamp", "DeviceModel"}, true);
        this.onDeviceBackupsModel = new NanoBackupsTableModel(this.ne2DeviceExt, new String[]{"Backup Name", "Timestamp", "DeviceModel"}, false);
        this.localBackupsTable = new BTable((TableModel)this.localBackupsModel, (TableController)new NanoBackupsTableController(this.localBackupsModel), (TableSelection)new SlotSelection());
        this.localBackupsTable.setMultipleSelection(false);
        this.onDeviceBackupsTable = new BTable((TableModel)this.onDeviceBackupsModel, (TableController)new NanoBackupsTableController(this.onDeviceBackupsModel), (TableSelection)new SlotSelection());
        this.onDeviceBackupsTable.setMultipleSelection(false);
        BEdgePane localBackupsPane = new BEdgePane();
        localBackupsPane.setTop((BWidget)new BBorderPane((BWidget)localBackupsHeader, BBorder.inset, BInsets.make((double)10.0, (double)0.0, (double)0.0, (double)10.0)));
        localBackupsPane.setCenter((BWidget)new BBorderPane((BWidget)this.localBackupsTable, BBorder.inset, BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0)));
        this.backupCmd = new BackupCmd((BWidget)this, true);
        this.downloadBackupCmd = new DownloadBackupCmd((BWidget)this, false);
        this.deleteBackupCmd = new DeleteBackupCmd((BWidget)this, false);
        this.restoreCmd = new RestoreCmd((BWidget)this, false);
        BGridPane commandsPane = new BGridPane(4, new BWidget[]{new BButton((Command)this.backupCmd, true, true), new BButton((Command)this.downloadBackupCmd, true, true), new BButton((Command)this.deleteBackupCmd, true, true), new BButton((Command)this.restoreCmd, true, true)});
        commandsPane.setHalign(BHalign.right);
        BEdgePane onDeviceBackupsPane = new BEdgePane();
        onDeviceBackupsPane.setTop((BWidget)new BBorderPane((BWidget)onDeviceBackupsHeader, BBorder.inset, BInsets.make((double)10.0, (double)0.0, (double)0.0, (double)10.0)));
        onDeviceBackupsPane.setCenter((BWidget)new BBorderPane((BWidget)this.onDeviceBackupsTable, BBorder.inset, BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0)));
        onDeviceBackupsPane.setBottom((BWidget)new BBorderPane((BWidget)commandsPane, BBorder.inset, BInsets.make((double)10.0, (double)0.0, (double)0.0, (double)10.0)));
        BSplitPane splitPane = new BSplitPane(BOrientation.vertical, 50.0);
        splitPane.setMoveableDivider(true);
        splitPane.setWidget1((BWidget)localBackupsPane);
        splitPane.setWidget2((BWidget)onDeviceBackupsPane);
        BEdgePane globalPane = new BEdgePane();
        globalPane.setCenter((BWidget)splitPane);
        this.setContent((BWidget)globalPane);
        this.registerForComponentEvents((BComponent)this.backups);
        this.registerForComponentEvents((BComponent)this.ne2DeviceExt.getConfig(), 2);
        BStatusEnum action = (BStatusEnum)this.backups.get("action");
        this.handleBackupAction(action);
    }

    public void handleComponentEvent(BComponentEvent event) {
        int eventId = event.getId();
        if (eventId == 0) {
            if (event.getSourceComponent().equals((Object)this.backups)) {
                if (event.getSlotName().equals("action")) {
                    BStatusEnum action = (BStatusEnum)this.backups.get("action");
                    this.handleBackupAction(action);
                } else if (event.getSlotName().equals("download")) {
                    BBackupStatus action = (BBackupStatus)this.backups.get("download");
                    this.handleDownloadBackupAction(action);
                }
            } else if (event.getSourceComponent().equals((Object)this.ne2DeviceExt.getConfig().getCommunicationSettings())) {
                BConnectionStatus connectionStatus = this.ne2DeviceExt.getConfig().getCommunicationSettings().getStatus();
                switch (connectionStatus.getOrdinal()) {
                    case 0: {
                        break;
                    }
                    default: {
                        if (this.restoreInProgressDlg == null) break;
                        this.restoreInProgressDlg.close();
                        this.restoreInProgressDlg = null;
                    }
                }
            }
        }
        super.handleComponentEvent(event);
    }

    private void handleBackupAction(BStatusEnum action) {
        switch (action.getEnum().getOrdinal()) {
            case 1: {
                BNanoBackupManager thisManager = this;
                Thread t = new Thread(() -> {
                    if (this.backupInProgressDlg == null) {
                        this.backupInProgressDlg = new BDialog((BWidget)thisManager, lex.get("NanoBackupManager.messageBackupInProgressTitle"), true, (BWidget)new BLabel(lex.get("NanoBackupManager.messageBackupInProgress")));
                        this.backupInProgressDlg.setBoundsCenteredOnOwner();
                        this.backupInProgressDlg.open(this.backupInProgressDlg.getScreenBounds().x(), this.backupInProgressDlg.getScreenBounds().y(), 200.0, 100.0);
                    }
                });
                t.start();
                break;
            }
            default: {
                if (this.backupInProgressDlg == null || !this.backupInProgressDlg.isRunning()) break;
                this.backupInProgressDlg.close();
                this.backupInProgressDlg = null;
                try {
                    this.localBackupsModel.makeRows();
                    this.onDeviceBackupsModel.makeRows();
                    break;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private void handleDownloadBackupAction(BBackupStatus action) {
        switch (action.getEnum().getOrdinal()) {
            case 1: {
                BNanoBackupManager thisManager = this;
                Thread t = new Thread(() -> {
                    if (this.downloadInProgressDlg == null) {
                        this.downloadInProgressDlg = new BDialog((BWidget)thisManager, lex.get("NanoBackupManager.messageDownloadInProgressTitle"), true, (BWidget)new BLabel(lex.get("NanoBackupManager.messageDownloadInProgress")));
                        this.downloadInProgressDlg.setBoundsCenteredOnOwner();
                        this.downloadInProgressDlg.open(this.downloadInProgressDlg.getScreenBounds().x(), this.downloadInProgressDlg.getScreenBounds().y(), 200.0, 100.0);
                    }
                });
                t.start();
                break;
            }
            default: {
                if (this.downloadInProgressDlg == null || !this.downloadInProgressDlg.isRunning()) break;
                this.downloadInProgressDlg.close();
                this.downloadInProgressDlg = null;
                try {
                    this.localBackupsModel.makeRows();
                    this.onDeviceBackupsModel.makeRows();
                    break;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public void doSaveValue(BWidgetEvent arg, Context cx) throws Exception {
        super.doSaveValue((BObject)arg, cx);
    }

    class RestoreCmd
    extends Command {
        private BNanoBackupManager manager;

        RestoreCmd(BWidget manager, boolean enabled) {
            super(manager, "Restore");
            this.manager = (BNanoBackupManager)manager;
            this.setEnabled(enabled);
        }

        public CommandArtifact doInvoke() {
            BNanoRestoreDialog restoreDlg;
            String backupName;
            final int srow = BNanoBackupManager.this.localBackupsModel.getSelection().getRow();
            int trow = BNanoBackupManager.this.onDeviceBackupsModel.getSelection().getRow();
            String string = srow >= 0 ? (String)BNanoBackupManager.this.localBackupsModel.getValueAt(srow, 0) : (backupName = trow >= 0 ? (String)BNanoBackupManager.this.onDeviceBackupsModel.getValueAt(trow, 0) : "");
            if (!backupName.equals("") && (restoreDlg = new BNanoRestoreDialog()).prompt((BWidget)this.manager, "Restore") == 1) {
                final boolean ipSettings = restoreDlg.getSelected()[4];
                int confirm = BDialog.confirm((BWidget)this.manager, (String)lex.get("NanoBackupManager.continue"), (Object)lex.get("NanoBackupManager.messageRestoreBackup"));
                if (confirm == 4) {
                    Thread t = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            boolean takeFromDevice = srow < 0;
                            ((RestoreCmd)RestoreCmd.this).manager.ne2DeviceExt.restoreBackup(new BBackupRestoreArgs(backupName + ":" + ipSettings, takeFromDevice));
                        }
                    });
                    t.start();
                    if (BNanoBackupManager.this.restoreInProgressDlg == null) {
                        String title = lex.get("NanoBackupManager.messageRestoreInProgressTitle");
                        String message = lex.getText("NanoBackupManager.messageRestoreInProgress", new Object[]{backupName});
                        BNanoBackupManager.this.restoreInProgressDlg = new BDialog((BWidget)this.manager, title, true, (BWidget)new BLabel(message));
                        BNanoBackupManager.this.restoreInProgressDlg.setBoundsCenteredOnOwner();
                        BNanoBackupManager.this.restoreInProgressDlg.open(BNanoBackupManager.this.restoreInProgressDlg.getScreenBounds().x(), BNanoBackupManager.this.restoreInProgressDlg.getScreenBounds().y(), 400.0, 100.0);
                    }
                }
            }
            return null;
        }
    }

    class DeleteBackupCmd
    extends Command {
        private BNanoBackupManager manager;

        DeleteBackupCmd(BWidget manager, boolean enabled) {
            super(manager, "Delete Backup");
            this.manager = (BNanoBackupManager)manager;
            this.setEnabled(enabled);
        }

        public CommandArtifact doInvoke() {
            boolean takeFromDevice;
            boolean ok;
            int confirm;
            String backupName;
            int srow = BNanoBackupManager.this.localBackupsModel.getSelection().getRow();
            int trow = BNanoBackupManager.this.onDeviceBackupsModel.getSelection().getRow();
            String string = srow >= 0 ? (String)BNanoBackupManager.this.localBackupsModel.getValueAt(srow, 0) : (backupName = trow >= 0 ? (String)BNanoBackupManager.this.onDeviceBackupsModel.getValueAt(trow, 0) : "");
            if (!backupName.equals("") && (confirm = BDialog.confirm((BWidget)this.manager, (Object)(backupName + "-" + lex.get("NanoBackupManager.messageDeleteBackup")))) == 4 && (ok = this.manager.ne2DeviceExt.deleteBackup(new BBackupRestoreArgs(backupName, takeFromDevice = srow < 0)).getBoolean())) {
                try {
                    BNanoBackupManager.this.localBackupsModel.makeRows();
                    BNanoBackupManager.this.onDeviceBackupsModel.makeRows();
                    ((BWbShell)this.getShell()).getRefreshCommand().invoke();
                    BNanoBackupManager.this.localBackupsModel.getSelection().deselectAll();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return null;
        }
    }

    class DownloadBackupCmd
    extends Command {
        private BNanoBackupManager manager;

        DownloadBackupCmd(BWidget manager, boolean enabled) {
            super(manager, "Download Backup");
            this.manager = (BNanoBackupManager)manager;
            this.setEnabled(enabled);
        }

        public CommandArtifact doInvoke() throws Exception {
            String value = this.getDefaultBackupName();
            BNanoDownloadBackupDialog downloadBackupDialog = new BNanoDownloadBackupDialog();
            final String localBackupName = downloadBackupDialog.prompt((BWidget)this.manager, lex.get("NanoBackupManager.messageSetBackupName"), value);
            if (!localBackupName.equals("")) {
                Thread t = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        ((DownloadBackupCmd)DownloadBackupCmd.this).manager.ne2DeviceExt.downloadBackup(new BBackupRestoreArgs(localBackupName, true));
                    }
                });
                t.start();
                if (BNanoBackupManager.this.downloadInProgressDlg == null) {
                    String title = lex.get("NanoBackupManager.messageDownloadInProgressTitle");
                    String message = lex.getText("NanoBackupManager.messageDownloadInProgress", new Object[]{localBackupName});
                    BNanoBackupManager.this.downloadInProgressDlg = new BDialog((BWidget)this.manager, title, true, (BWidget)new BLabel(message));
                    BNanoBackupManager.this.downloadInProgressDlg.setBoundsCenteredOnOwner();
                    BNanoBackupManager.this.downloadInProgressDlg.open(BNanoBackupManager.this.downloadInProgressDlg.getScreenBounds().x(), BNanoBackupManager.this.downloadInProgressDlg.getScreenBounds().y(), 400.0, 100.0);
                }
            }
            return null;
        }

        private String getDefaultBackupName() {
            BSoftwareManager softwareManager = BNanoBackupManager.this.ne2DeviceExt.getSoftwareManager();
            String delimiter = "_";
            String deviceModel = softwareManager.getModel();
            String serialNumber = "SN" + (long)softwareManager.getSerialNumber();
            String ipAddress = softwareManager.getIpAddress();
            String date = LocalDate.now().format(DateTimeFormatter.ofPattern("yyyyMMdd"));
            String time = LocalTime.now().format(DateTimeFormatter.ofPattern("HHmmss"));
            return deviceModel + "_" + serialNumber + "_" + ipAddress + "_" + date + "_" + time;
        }
    }

    class BackupCmd
    extends Command {
        private BNanoBackupManager manager;

        BackupCmd(BWidget manager, boolean enabled) {
            super(manager, "Backup");
            this.manager = (BNanoBackupManager)manager;
            this.setEnabled(enabled);
        }

        public CommandArtifact doInvoke() {
            int confirm = BDialog.confirm((BWidget)this.manager, (String)lex.get("NanoBackupManager.overwrite"), (Object)lex.get("NanoBackupManager.messageConfirmBackup"));
            if (confirm == 4) {
                BNanoBackupManager.this.backups.requestNanoSubscription();
                Action createBackup = BNanoBackupManager.this.backups.getAction("CreateBackup");
                BNanoBackupManager.this.backups.invoke(createBackup, null, null);
            }
            return null;
        }
    }

    class SlotSelection
    extends TableSelection {
        public void updateTable() {
            super.updateTable();
            TableModel model = this.getModel();
            if (model.equals((Object)BNanoBackupManager.this.onDeviceBackupsModel)) {
                BNanoBackupManager.this.downloadBackupCmd.setEnabled(model.getSelection().getRow() >= 0);
                if (BNanoBackupManager.this.localBackupsModel.getSelection().getRow() == -1) {
                    BNanoBackupManager.this.deleteBackupCmd.setEnabled(model.getSelection().getRow() >= 0);
                    BNanoBackupManager.this.restoreCmd.setEnabled(model.getSelection().getRow() >= 0);
                }
            }
            if (model.equals((Object)BNanoBackupManager.this.localBackupsModel) && BNanoBackupManager.this.onDeviceBackupsModel.getSelection().getRow() == -1) {
                BNanoBackupManager.this.deleteBackupCmd.setEnabled(model.getSelection().getRow() >= 0);
                BNanoBackupManager.this.restoreCmd.setEnabled(model.getSelection().getRow() >= 0);
            }
        }
    }

    public class NanoBackupsTableController
    extends TableController {
        private NanoBackupsTableModel tableModel;

        public NanoBackupsTableController(NanoBackupsTableModel tableModel) {
            NanoBackupsTableModel finalTableModel = this.tableModel = tableModel;
            Thread t = new Thread(() -> {
                try {
                    Thread.sleep(200L);
                    if (finalTableModel.getRowCount() > 0) {
                        this.cellPressed(new BMouseEvent(), 0, 0);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            });
            t.start();
        }

        protected void cellPressed(BMouseEvent event, int row, int col) {
            this.getSelection().deselectAll();
            this.getSelection().select(row);
            this.cellEntered(event, row, col);
            if (((Object)((Object)this.tableModel)).equals((Object)BNanoBackupManager.this.localBackupsModel)) {
                BNanoBackupManager.this.onDeviceBackupsModel.getSelection().deselectAll();
                BNanoBackupManager.this.downloadBackupCmd.setEnabled(false);
            } else {
                BNanoBackupManager.this.localBackupsModel.getSelection().deselectAll();
                BNanoBackupManager.this.downloadBackupCmd.setEnabled(true);
            }
            if (this.tableModel.getSelection().getRow() >= 0) {
                BNanoBackupManager.this.deleteBackupCmd.setEnabled(true);
                BNanoBackupManager.this.restoreCmd.setEnabled(true);
            }
        }
    }
}

