/*
 * Decompiled with CFR 0.152.
 */
package com.miratech.nE2Link.ui;

import com.miratech.nE2Link.BLibrary;
import com.miratech.nE2Link.BNe2DeviceExt;
import com.miratech.nE2Link.actions.BSoftwareManagerArgs;
import com.miratech.nE2Link.ui.BNanoSelectVersionDialog;
import com.miratech.nE2Link.ui.NanoSoftwareManagerTableModel;
import com.miratech.nE2Link.utils.BSoftwareManager;
import com.miratech.nE2Link.utils.javabeans.LibraryComp;
import com.tridium.ui.theme.Theme;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.gx.Graphics;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.style.IStylable;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableCellRenderer;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableHeaderRenderer;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.table.TableSelection;
import javax.baja.util.Lexicon;
import javax.baja.workbench.view.BWbComponentView;

@NiagaraType(agent={@AgentOn(types={"nE2Link:SoftwareManager"}, defaultAgent=AgentOn.Preference.PREFERRED)})
public class BNanoSoftwareManager
extends BWbComponentView {
    public static final Type TYPE = Sys.loadType(BNanoSoftwareManager.class);
    BSoftwareManager softwareManager = null;
    BNe2DeviceExt ne2DeviceExt = null;
    NanoSoftwareManagerTableModel softwareManagerModel = null;
    BTable softwareManagerTable = null;
    UpgradeAllCmd upgradeAllCmd = null;
    UpdateDeviceCmd updateDeviceCmd = null;
    protected static final Lexicon lex = Lexicon.make(BNanoSoftwareManager.class);
    BDialog upgradeAllInProgressDlg = null;
    BDialog updateDeviceInProgressDlg = null;
    final int onDeviceColumn = 0;
    final int nameColumn = 1;
    final int latestLocalColumn = 2;
    final int installedColumn = 3;
    final int selectedColumn = 4;
    final int statusColumn = 5;

    public Type getType() {
        return TYPE;
    }

    public void doLoadValue(BObject value, Context context) throws Exception {
        super.doLoadValue(value, context);
        this.softwareManager = (BSoftwareManager)value;
        this.ne2DeviceExt = (BNe2DeviceExt)this.softwareManager.getParent();
        this.upgradeAllCmd = new UpgradeAllCmd((BWidget)this, true);
        this.updateDeviceCmd = new UpdateDeviceCmd((BWidget)this, false);
        BGridPane commandsPane = new BGridPane(2, new BWidget[]{new BButton((Command)this.upgradeAllCmd, true, true), new BButton((Command)this.updateDeviceCmd, true, true)});
        commandsPane.setHalign(BHalign.right);
        this.softwareManagerModel = new NanoSoftwareManagerTableModel(this.ne2DeviceExt, new String[]{"On Device", "Name", "Latest Local", "Installed", "Selected", "Status"});
        this.softwareManagerTable = new BTable((TableModel)this.softwareManagerModel, (TableController)new NanoSoftwareManagerTableController(this.softwareManagerModel), new TableSelection(), new TableHeaderRenderer(), (TableCellRenderer)new NanoTableCellRenderer());
        BEdgePane softwareManagerPane = new BEdgePane();
        softwareManagerPane.setTop((BWidget)new BBorderPane((BWidget)commandsPane, BBorder.inset, BInsets.make((double)10.0, (double)0.0, (double)0.0, (double)10.0)));
        softwareManagerPane.setCenter((BWidget)new BBorderPane((BWidget)this.softwareManagerTable, BBorder.inset, BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0)));
        this.setContent((BWidget)softwareManagerPane);
        this.registerForComponentEvents((BComponent)this.softwareManager);
    }

    private int compareVersions(String version1, String version2) {
        int ret = 0;
        String[] version1Parts = version1.split("\\.");
        String[] version2Parts = version2.split("\\.");
        int length = Math.max(version1Parts.length, version2Parts.length);
        for (int i = 0; i < length; ++i) {
            int version2Part;
            int version1Part = i < version1Parts.length ? Integer.parseInt(version1Parts[i]) : 0;
            int n = version2Part = i < version2Parts.length ? Integer.parseInt(version2Parts[i]) : 0;
            if (version1Part > version2Part) {
                ret = 1;
                break;
            }
            if (version1Part >= version2Part) continue;
            ret = 2;
            break;
        }
        return ret;
    }

    class UpdateDeviceCmd
    extends Command {
        private BNanoSoftwareManager manager;

        UpdateDeviceCmd(BWidget manager, boolean enabled) {
            super(manager, "Update Device");
            this.manager = (BNanoSoftwareManager)manager;
            this.setEnabled(enabled);
        }

        public CommandArtifact doInvoke() throws Exception {
            BNanoSoftwareManager.this.softwareManager.loadSlots();
            StringBuilder sb = new StringBuilder(BNanoSoftwareManager.this.softwareManager.getIpAddress()).append(":").append(BNanoSoftwareManager.this.softwareManager.getIFnetPort());
            int confirm = BDialog.confirm((BWidget)this.manager, (String)sb.toString(), (Object)lex.get("NanoSoftwareManager.messageConfirmUpdate"));
            if (confirm == 4) {
                for (int i = 0; i < this.manager.softwareManagerModel.getRowCount(); ++i) {
                    String selectedVersion = this.manager.softwareManagerModel.getValueAt(i, 4).toString();
                    String statusValue = this.manager.softwareManagerModel.getValueAt(i, 5).toString();
                    String libName = this.manager.softwareManagerModel.getValueAt(i, 1).toString();
                    if (!selectedVersion.equals("") && (statusValue.equals("Install") || statusValue.equals("Upgrade") || statusValue.equals("Downgrade") || statusValue.equals("Out Of Date"))) {
                        String folderName = libName.equals("OS") ? "" : libName + "/";
                        String fileName = libName.equals("OS") ? "os" : libName;
                        String extension = libName.equals("OS") ? ".bin" : ".pe";
                        sb = new StringBuilder(folderName).append(fileName).append("-").append(selectedVersion).append(extension);
                        BNanoSoftwareManager.this.softwareManager.installFile(new BSoftwareManagerArgs(sb.toString()));
                    }
                    if (!statusValue.equals("Uninstall")) continue;
                    sb = new StringBuilder(libName).append(".pe");
                    BNanoSoftwareManager.this.softwareManager.uninstallFile(new BSoftwareManagerArgs(sb.toString()));
                }
                BNanoSoftwareManager.this.softwareManager.restartDevice();
            }
            return null;
        }
    }

    class UpgradeAllCmd
    extends Command {
        private BNanoSoftwareManager manager;

        UpgradeAllCmd(BWidget manager, boolean enabled) {
            super(manager, "Upgrade All");
            this.manager = (BNanoSoftwareManager)manager;
            this.setEnabled(enabled);
        }

        public CommandArtifact doInvoke() {
            BNanoSoftwareManager.this.softwareManager.loadSlots();
            boolean upgradeAll = false;
            NanoSoftwareManagerTableModel softwareManagerModel = this.manager.softwareManagerModel;
            for (int i = 0; i < softwareManagerModel.getRowCount(); ++i) {
                String selectedVersion = softwareManagerModel.getValueAt(i, 4).toString();
                String statusValue = softwareManagerModel.getValueAt(i, 5).toString();
                String libName = softwareManagerModel.getValueAt(i, 1).toString();
                String onDevice = softwareManagerModel.getValueAt(i, 0).toString();
                if (!onDevice.equals("true:readonly") && !onDevice.equals("true")) continue;
                Optional<LibraryComp> optional = softwareManagerModel.getLocalLibraries().stream().filter(f -> f.getNanoName().equals(libName)).findFirst();
                if (!optional.isPresent()) {
                    optional = softwareManagerModel.getOsLibraries().stream().filter(f -> f.getNanoName().equals(libName)).findFirst();
                }
                if (!optional.isPresent()) {
                    optional = softwareManagerModel.getOnDeviceLibraries().stream().filter(f -> f.getNanoName().equals(libName)).findFirst();
                }
                if (!optional.isPresent() || !statusValue.contains("Out Of Date")) continue;
                LibraryComp libComp = optional.get();
                String latestLocal = libComp.getLatestLocal();
                softwareManagerModel.set(i, 4, latestLocal);
                softwareManagerModel.set(i, 5, "Upgrade");
                upgradeAll = true;
            }
            if (upgradeAll) {
                BNanoSoftwareManager.this.updateDeviceCmd.setEnabled(true);
            }
            return null;
        }
    }

    public class BLabelButton
    extends BButton {
        public BLabelButton(String text) {
            super(text);
            this.setForeground(BBrush.make((String)String.valueOf(BColor.blue)));
            this.setHalign(BHalign.left);
        }

        public void keyPressed(BKeyEvent event) {
        }

        public boolean isMouseOver() {
            return false;
        }

        public boolean isPressed() {
            return false;
        }
    }

    class NanoTableCellRenderer
    extends TableCellRenderer {
        NanoTableCellRenderer() {
        }

        public BBrush getForeground(TableCellRenderer.Cell cell) {
            TableModel model = this.getTable().getModel();
            if (model.equals((Object)BNanoSoftwareManager.this.softwareManagerModel)) {
                Object obj = model.getValueAt(cell.row, 5);
                if (obj.toString().contains("Latest")) {
                    return BBrush.make((String)String.valueOf(BColor.green));
                }
                if (obj.toString().contains("Install") || obj.toString().contains("Downgrade") || obj.toString().contains("Upgrade")) {
                    return BBrush.make((String)String.valueOf(BColor.blue));
                }
                if (obj.toString().contains("Out Of Date")) {
                    return BBrush.make((String)String.valueOf(BColor.darkGoldenrod));
                }
            }
            return Theme.table().getTextBrush((IStylable)this.getTable());
        }

        public double getPreferredCellWidth(TableCellRenderer.Cell cell) {
            TableModel model = this.getTable().getModel();
            return this.getTable().getWidth() / (double)model.getColumnCount();
        }

        public void paintCell(Graphics g, TableCellRenderer.Cell cell) {
            TableModel model = this.getTable().getModel();
            if (model.equals((Object)BNanoSoftwareManager.this.softwareManagerModel)) {
                if (cell.column > 0) {
                    super.paintCell(g, cell);
                } else {
                    this.paintCellBackground(g, cell);
                    double x = 2.0;
                    double y = (cell.height - 16.0) / 2.0;
                    BImage icon = model.getRowIcon(cell.row);
                    if (icon != null) {
                        g.drawImage(icon, x, y);
                        x += 20.0;
                    } else {
                        x += 20.0;
                    }
                    String s = this.getCellText(cell);
                    BFont font = this.getFont(cell);
                    switch (model.getColumnAlignment(cell.column).getOrdinal()) {
                        case 1: {
                            x = (cell.width - font.width(s)) / 2.0;
                            break;
                        }
                        case 2: {
                            x = cell.width - 2.0 - font.width(s);
                        }
                    }
                    g.setFont(font);
                    if (cell.selected) {
                        g.setBrush(this.getSelectionForeground(cell));
                    } else {
                        g.setBrush(this.getForeground(cell));
                    }
                    BImage cb = s.equals("true:readonly") ? BImage.make((BIcon)BIcon.std((String)"widgets/checkBox.png")) : BImage.make((BIcon)(s.equals("true") ? BIcon.std((String)"widgets/checkBox.png") : BIcon.std((String)"widgets/insetPane.png")));
                    g.drawImage(cb, x, y);
                }
            } else {
                super.paintCell(g, cell);
            }
        }
    }

    public class NanoSoftwareManagerTableController
    extends TableController {
        private NanoSoftwareManagerTableModel tableModel;

        NanoSoftwareManagerTableController() {
        }

        NanoSoftwareManagerTableController(NanoSoftwareManagerTableModel softwareManagerModel) {
            this.tableModel = softwareManagerModel;
        }

        protected void cellPressed(BMouseEvent event, int row, int col) {
            Object obj = this.tableModel.getValueAt(row, col);
            switch (col) {
                case 0: {
                    this.cellOnDevicePressed(row, obj);
                    break;
                }
                case 4: {
                    this.cellSelectedPressed(row, obj);
                    break;
                }
            }
            super.cellPressed(event, row, col);
            boolean enabled = false;
            for (int i = 0; i < this.tableModel.getRowCount(); ++i) {
                obj = this.tableModel.getValueAt(i, 4);
                if (!obj.toString().equals("")) {
                    enabled = true;
                    break;
                }
                obj = this.tableModel.getValueAt(i, 5);
                if (!obj.toString().equals("Uninstall")) continue;
                enabled = true;
                break;
            }
            BNanoSoftwareManager.this.updateDeviceCmd.setEnabled(enabled);
        }

        private void cellOnDevicePressed(int row, Object obj) {
            if (!obj.toString().contains("readonly")) {
                if (obj.toString().equals("true")) {
                    this.tableModel.set(row, 0, "false");
                    this.tableModel.set(row, 4, "");
                    String libName = this.tableModel.getValueAt(row, 1).toString();
                    Optional<BLibrary> optional = this.tableModel.getOnDeviceLibraries().stream().filter(f -> f.getNanoName().equals(libName)).findFirst();
                    this.tableModel.set(row, 5, optional.isPresent() ? "Uninstall" : "");
                } else {
                    this.tableModel.set(row, 0, "true");
                    String latestLocal = this.tableModel.getValueAt(row, 2).toString();
                    String installedVersion = this.tableModel.getValueAt(row, 3).toString();
                    this.tableModel.set(row, 4, latestLocal.equals(installedVersion) ? "" : this.tableModel.getValueAt(row, 2));
                    String libName = this.tableModel.getValueAt(row, 1).toString();
                    Optional<BLibrary> optional = this.tableModel.getOnDeviceLibraries().stream().filter(f -> f.getNanoName().equals(libName)).findFirst();
                    if (optional.isPresent()) {
                        String status = "Latest";
                        if (!this.tableModel.getValueAt(row, 3).toString().equals("")) {
                            String selectedVersion = this.tableModel.getValueAt(row, 4).toString();
                            if (!selectedVersion.equals("")) {
                                if (BNanoSoftwareManager.this.compareVersions(installedVersion, selectedVersion) == 1) {
                                    status = "Downgrade";
                                } else if (BNanoSoftwareManager.this.compareVersions(installedVersion, selectedVersion) == 2) {
                                    status = "Upgrade";
                                } else if (BNanoSoftwareManager.this.compareVersions(installedVersion, selectedVersion) == 0) {
                                    selectedVersion = "";
                                }
                            }
                            this.tableModel.set(row, 5, status);
                        } else {
                            this.tableModel.set(row, 5, "Install");
                        }
                    } else {
                        this.tableModel.set(row, 5, "Install");
                    }
                }
            }
        }

        private void cellSelectedPressed(int row, Object obj) {
            obj = this.tableModel.getValueAt(row, 0);
            String libName = this.tableModel.getValueAt(row, 1).toString();
            if ((!obj.toString().equals("true:readonly") || libName.equals("OS")) && obj.toString().contains("true")) {
                Optional<LibraryComp> optional = this.tableModel.getLocalLibraries().stream().filter(f -> f.getNanoName().equals(libName)).findFirst();
                if (!optional.isPresent()) {
                    optional = this.tableModel.getOsLibraries().stream().filter(f -> f.getNanoName().equals(libName)).findFirst();
                }
                if (!optional.isPresent()) {
                    optional = this.tableModel.getOnDeviceLibraries().stream().filter(f -> f.getNanoName().equals(libName)).findFirst();
                }
                if (optional.isPresent()) {
                    LibraryComp libComp = optional.get();
                    List versions = libComp.getVersions();
                    Collections.sort(versions, Collections.reverseOrder());
                    BNanoSelectVersionDialog selectVersionDialog = new BNanoSelectVersionDialog();
                    String selectedVersion = selectVersionDialog.prompt(null, lex.get("NanoSoftwareManager.messageSelectVersion"), versions);
                    this.tableModel.set(row, 4, selectedVersion);
                    String status = "Latest";
                    if (!this.tableModel.getValueAt(row, 3).toString().equals("")) {
                        String installedVersion = this.tableModel.getValueAt(row, 3).toString();
                        if (BNanoSoftwareManager.this.compareVersions(installedVersion, selectedVersion) == 1) {
                            status = "Downgrade";
                        } else if (BNanoSoftwareManager.this.compareVersions(installedVersion, selectedVersion) == 2) {
                            status = "Upgrade";
                        } else if (BNanoSoftwareManager.this.compareVersions(installedVersion, selectedVersion) == 0) {
                            selectedVersion = "";
                        }
                        this.tableModel.set(row, 4, selectedVersion);
                        if (libName.equals("OS")) {
                            if (!selectedVersion.equals("")) {
                                this.tableModel.set(row, 5, status);
                            } else {
                                String latestLocal = this.tableModel.getValueAt(row, 2).toString();
                                if (BNanoSoftwareManager.this.compareVersions(latestLocal, installedVersion) == 1) {
                                    status = "Out Of Date";
                                    this.tableModel.set(row, 5, status);
                                } else {
                                    status = "Latest";
                                    this.tableModel.set(row, 5, status);
                                }
                            }
                            for (int j = 0; j < this.tableModel.getRowCount(); ++j) {
                                if (!this.tableModel.getValueAt(j, 5).toString().contains("part of OS")) continue;
                                this.tableModel.set(j, 5, status + ", part of OS");
                            }
                        } else if (!selectedVersion.equals("")) {
                            this.tableModel.set(row, 5, status);
                        } else {
                            String latestLocal = this.tableModel.getValueAt(row, 2).toString();
                            if (BNanoSoftwareManager.this.compareVersions(latestLocal, installedVersion) == 1) {
                                status = "Out Of Date";
                                this.tableModel.set(row, 5, status);
                            } else {
                                status = "Latest";
                                this.tableModel.set(row, 5, status);
                            }
                        }
                    }
                }
            }
        }
    }
}

