/*
 * Decompiled with CFR 0.152.
 */
package com.miratech.nE2Link.ui;

import com.miratech.nE2Link.BNanoComponent;
import com.miratech.nE2Link.actions.BNanoTimeChangeArg;
import com.tridium.workbench.fieldeditors.BDateFE;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.baja.data.BIDataValue;
import javax.baja.gx.BImage;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusString;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BLong;
import javax.baja.sys.BMonth;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.ui.BBorder;
import javax.baja.ui.BButton;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BRadioButton;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.ToggleCommandGroup;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.list.ListModel;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.util.BTitlePane;
import javax.baja.util.Lexicon;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;
import javax.baja.workbench.view.BWbComponentView;

@NiagaraType(agent={@AgentOn(types={"nE2Link:NanoComponent"}, defaultAgent=AgentOn.Preference.NORMAL)})
@NiagaraActions(value={@NiagaraAction(name="timeSourceModified"), @NiagaraAction(name="updateValues"), @NiagaraAction(name="setTime")})
public class BNanoSystemDateTimeEd
extends BWbComponentView {
    public static final Action timeSourceModified = BNanoSystemDateTimeEd.newAction((int)0, null);
    public static final Action updateValues = BNanoSystemDateTimeEd.newAction((int)0, null);
    public static final Action setTime = BNanoSystemDateTimeEd.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BNanoSystemDateTimeEd.class);
    private static final BFacets HOUR_MINUTE_SECOND = BFacets.make((String[])new String[]{"timeFormat", "showDate", "showTime", "showSeconds"}, (BIDataValue[])new BIDataValue[]{BString.make((String)"HH:mm"), BBoolean.FALSE, BBoolean.TRUE, BBoolean.FALSE});
    protected final Lexicon lex = this.getLexicon();
    private BNanoComponent platformTime = null;
    private BTimeZone currentUserTimeZone;
    private Context currentUserContext;
    private BGridPane currentSettings;
    private BWbFieldEditor currentTimeEditor;
    private BDateFE currentDateEditor;
    private BTextField currentTimeZoneTF;
    private BCheckBox dstActiveCB;
    private BLabel dstActiveLabel;
    private BGridPane desiredSettingsGP;
    private BListDropDown desiredTimeZoneDropDown;
    private BWbFieldEditor desiredTimeEditor;
    private BDateFE desiredDateEditor;
    private BRadioButton stationTimeBtn;
    private BRadioButton customTimeBtn;
    private BGridPane buttonPane;
    protected boolean saving = false;
    protected boolean loading = false;
    private final String currentTimeProp = "currentTime";
    private final String timezoneProp = "timezone";
    private final String DSTStatusProp = "DSTStatus";

    public void timeSourceModified() {
        this.invoke(timeSourceModified, null, null);
    }

    public void updateValues() {
        this.invoke(updateValues, null, null);
    }

    public void setTime() {
        this.invoke(setTime, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BNanoSystemDateTimeEd() {
        this.autoRegisterForComponentEvents = true;
        this.currentSettings = new BGridPane(2);
        this.currentSettings.setHalign(BHalign.left);
        this.currentSettings.setValign(BValign.top);
        this.currentSettings.setColumnGap(20.0);
        this.currentSettings.setRowGap(6.0);
        this.currentSettings.setColorRows(false);
        this.currentTimeEditor = BWbFieldEditor.makeFor((BObject)BAbsTime.DEFAULT, (Context)HOUR_MINUTE_SECOND);
        this.currentTimeEditor.setReadonly(true);
        this.currentTimeEditor.setBounds(this.currentTimeEditor.getX(), this.currentTimeEditor.getY(), 30.0, this.currentTimeEditor.getHeight());
        this.currentSettings.add(null, (BValue)new BLabel(this.lex.get("NanoSystemDateTimeEd.time")));
        this.currentSettings.add(null, (BValue)this.currentTimeEditor);
        this.currentDateEditor = new BDateFE();
        this.currentDateEditor.setReadonly(true);
        this.currentDateEditor.setBounds(this.currentDateEditor.getX(), this.currentDateEditor.getY(), 30.0, this.currentDateEditor.getHeight());
        this.currentSettings.add(null, (BValue)new BLabel(this.lex.get("NanoSystemDateTimeEd.date")));
        this.currentSettings.add(null, (BValue)this.currentDateEditor);
        this.currentTimeZoneTF = new BTextField();
        this.currentTimeZoneTF.setEditable(false);
        this.currentTimeZoneTF.setVisibleColumns(35);
        this.currentSettings.add(null, (BValue)new BLabel(this.lex.get("NanoSystemDateTimeEd.timeZone")));
        this.currentSettings.add(null, (BValue)this.currentTimeZoneTF);
        this.dstActiveCB = new BCheckBox();
        this.dstActiveCB.setEnabled(false);
        this.dstActiveLabel = new BLabel(this.lex.get("NanoSystemDateTimeEd.dstActive"));
        this.currentSettings.add(null, (BValue)this.dstActiveLabel);
        this.currentSettings.add(null, (BValue)this.dstActiveCB);
        BBorderPane currentSettingsBP = new BBorderPane((BWidget)this.currentSettings, 5.0, 5.0, 5.0, 5.0);
        double width = 200.0;
        double height = 80.0;
        currentSettingsBP.setSize(width, height);
        currentSettingsBP.setBorder(BBorder.make((String)"solid"));
        ToggleCommandGroup toggleCommands = new ToggleCommandGroup();
        this.stationTimeBtn = new BRadioButton(toggleCommands, this.lex.get("NanoSystemDateTimeEd.timeFromNiagaraStation"), false);
        this.customTimeBtn = new BRadioButton(toggleCommands, this.lex.get("NanoSystemDateTimeEd.customTime"), false);
        BGridPane radioButtons = new BGridPane(2);
        radioButtons.setColumnGap(20.0);
        radioButtons.add(null, (BValue)this.stationTimeBtn);
        radioButtons.add(null, (BValue)this.customTimeBtn);
        BBorderPane radioButtonsBP = new BBorderPane((BWidget)radioButtons, 5.0, 5.0, 5.0, 5.0);
        this.linkTo(null, (BComponent)this.stationTimeBtn, (Slot)BRadioButton.actionPerformed, (Slot)timeSourceModified);
        this.linkTo(null, (BComponent)this.customTimeBtn, (Slot)BRadioButton.actionPerformed, (Slot)timeSourceModified);
        this.desiredSettingsGP = new BGridPane(2);
        this.desiredSettingsGP.setHalign(BHalign.left);
        this.desiredSettingsGP.setValign(BValign.top);
        this.desiredSettingsGP.setColumnGap(20.0);
        this.desiredSettingsGP.setRowGap(6.0);
        this.desiredSettingsGP.setColorRows(false);
        this.desiredTimeEditor = BWbFieldEditor.makeFor((BObject)BAbsTime.DEFAULT, (Context)HOUR_MINUTE_SECOND);
        this.desiredTimeEditor.setBounds(this.desiredTimeEditor.getX(), this.desiredTimeEditor.getY(), 30.0, this.desiredTimeEditor.getHeight());
        this.desiredSettingsGP.add(null, (BValue)new BLabel(this.lex.get("NanoSystemDateTimeEd.time")));
        this.desiredSettingsGP.add(null, (BValue)this.desiredTimeEditor);
        this.desiredDateEditor = new BDateFE();
        this.desiredDateEditor.setBounds(this.desiredDateEditor.getX(), this.desiredDateEditor.getY(), 30.0, this.desiredDateEditor.getHeight());
        this.desiredSettingsGP.add(null, (BValue)new BLabel(this.lex.get("NanoSystemDateTimeEd.date")));
        this.desiredSettingsGP.add(null, (BValue)this.desiredDateEditor);
        this.desiredTimeZoneDropDown = new BListDropDown();
        this.desiredTimeZoneDropDown.setBounds(this.desiredTimeZoneDropDown.getX(), this.desiredTimeZoneDropDown.getY(), 60.0, this.desiredTimeZoneDropDown.getHeight());
        this.desiredTimeZoneDropDown.getList().setMultipleSelection(false);
        this.desiredSettingsGP.add(null, (BValue)new BLabel(this.lex.get("NanoSystemDateTimeEd.timeZone")));
        this.desiredSettingsGP.add(null, (BValue)this.desiredTimeZoneDropDown);
        this.buttonPane = new BGridPane(1);
        BButton setTimeBtn = new BButton(BImage.make((BIcon)BIcon.std((String)"save.png")), "Set Time");
        this.buttonPane.add(null, (BValue)setTimeBtn);
        this.linkTo((BComponent)setTimeBtn, (Slot)BButton.actionPerformed, (Slot)setTime);
        BBorderPane borderPane = new BBorderPane((BWidget)this.desiredSettingsGP, 5.0, 5.0, 5.0, 5.0);
        borderPane.setBorder(BBorder.make((String)"solid"));
        BGridPane desiredSettingsGP = new BGridPane(1);
        desiredSettingsGP.add(null, (BValue)radioButtonsBP);
        desiredSettingsGP.add(null, (BValue)borderPane);
        BGridPane content = new BGridPane(1);
        content.setValign(BValign.center);
        content.setHalign(BHalign.center);
        content.setRowGap(30.0);
        content.add(null, (BValue)new BTitlePane(this.lex.get("NanoSystemDateTimeEd.currentNanoControllerTime"), (BWidget)currentSettingsBP));
        content.add(null, (BValue)new BTitlePane(this.lex.get("NanoSystemDateTimeEd.desiredNanoControllerTime"), (BWidget)desiredSettingsGP));
        content.add(null, (BValue)this.buttonPane);
        this.setContent((BWidget)content);
    }

    protected void doLoadValue(BObject value, Context contextIn) {
        this.platformTime = (BNanoComponent)value;
        this.currentUserContext = contextIn == null ? new BasicContext() : contextIn;
        boolean loadingRestore = this.loading;
        this.loading = true;
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy.MM.dd HH:mm:ss");
        LocalDateTime ldt = LocalDateTime.parse(((BStatusString)this.platformTime.get("currentTime")).getValue(), formatter);
        this.currentTimeZoneTF.setText(((BStatusString)this.platformTime.get("timezone")).getValue());
        if (this.platformTime.get("DSTStatus") != null) {
            this.dstActiveCB.setSelected(((BStatusEnum)this.platformTime.get("DSTStatus")).getEnum().getOrdinal() > 0);
        } else {
            this.dstActiveCB.setVisible(false);
            this.dstActiveLabel.setVisible(false);
        }
        this.loadCurrentTimeEditors(this.localDateTimeToMillis(ldt, BTimeZone.DEFAULT), BTimeZone.DEFAULT, this.currentUserContext);
        BLong milliseconds = this.platformTime.getNe2DeviceExt().getStationCurrentTime();
        LocalDateTime stationCurrentTime = Instant.ofEpochMilli(milliseconds.getLong()).atZone(ZoneId.systemDefault()).toLocalDateTime();
        String userTimeZone = contextIn.getFacets().get("TimeZone").toString().replaceAll("\\(.*?\\)", "").trim();
        this.currentUserTimeZone = BTimeZone.getTimeZone((String)userTimeZone);
        ZoneListModel listModel = new ZoneListModel(this.getAllTimeZones(OffsetBase.UTC));
        this.desiredTimeZoneDropDown.getList().setModel((ListModel)listModel);
        this.desiredTimeZoneDropDown.setSelectedItem((Object)this.currentUserTimeZone);
        this.loadDesiredTimeEditors(this.localDateTimeToMillis(stationCurrentTime, this.currentUserTimeZone), this.currentUserTimeZone, this.currentUserContext);
        this.getContent().relayout();
        this.loading = loadingRestore;
        this.desiredSettingsGP.setEnabled(!this.stationTimeBtn.isSelected());
        Clock.schedulePeriodically((BComponent)this, (BRelTime)BRelTime.SECOND, (Action)updateValues, null);
        this.platformTime.requestNanoSubscription();
    }

    protected void loadDesiredTimeEditors(long millis, BTimeZone tz, Context contextIn) {
        Context cx = contextIn == null ? new BasicContext() : contextIn;
        BAbsTime time = BAbsTime.make((long)millis, (BTimeZone)tz);
        BasicContext feContext = new BasicContext(cx, BFacets.make((BFacets)HOUR_MINUTE_SECOND, (String)"TimeZone", (BIDataValue)tz));
        this.desiredTimeEditor.loadValue((BObject)time, (Context)feContext);
        feContext = new BasicContext(cx, BFacets.make((String)"TimeZone", (BIDataValue)tz));
        this.desiredDateEditor.loadValue((BObject)time, (Context)feContext);
        this.desiredTimeZoneDropDown.setSelectedItem((Object)this.currentUserTimeZone);
        this.getContent().relayout();
    }

    protected void loadCurrentTimeEditors(long millis, BTimeZone tz, Context contextIn) {
        Context cx = contextIn == null ? new BasicContext() : contextIn;
        BAbsTime time = BAbsTime.make((long)millis, (BTimeZone)tz);
        BasicContext feContext = new BasicContext(cx, BFacets.make((BFacets)HOUR_MINUTE_SECOND, (String)"TimeZone", (BIDataValue)tz));
        this.currentTimeEditor.loadValue((BObject)time, (Context)feContext);
        feContext = new BasicContext(cx, BFacets.make((String)"TimeZone", (BIDataValue)tz));
        this.currentDateEditor.loadValue((BObject)time, (Context)feContext);
        this.getContent().relayout();
    }

    private long localDateTimeToMillis(LocalDateTime ldt, BTimeZone tz) {
        ZonedDateTime zdt = ldt.atZone(ZoneId.of(tz.getId()));
        long millis = zdt.toInstant().toEpochMilli();
        return millis;
    }

    private List<String> getAllTimeZones(OffsetBase base) {
        LocalDateTime now = LocalDateTime.now();
        return ZoneId.getAvailableZoneIds().stream().map(ZoneId::of).sorted(new ZoneComparator()).map(id -> String.format("(%s%s) %s", new Object[]{base, this.getOffset(now, (ZoneId)id), id.getId()})).collect(Collectors.toList());
    }

    private String getOffset(LocalDateTime dateTime, ZoneId id) {
        return dateTime.atZone(id).getOffset().getId().replace("Z", "+00:00");
    }

    public void doTimeSourceModified() {
        this.desiredSettingsGP.setEnabled(!this.stationTimeBtn.isSelected());
        if (this.stationTimeBtn.isSelected()) {
            BLong milliseconds = this.platformTime.getNe2DeviceExt().getStationCurrentTime();
            LocalDateTime stationCurrentTime = Instant.ofEpochMilli(milliseconds.getLong()).atZone(ZoneId.systemDefault()).toLocalDateTime();
            this.loadDesiredTimeEditors(this.localDateTimeToMillis(stationCurrentTime, this.currentUserTimeZone), this.currentUserTimeZone, this.currentUserContext);
        }
    }

    public void doUpdateValues() {
        if (!this.saving) {
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy.MM.dd HH:mm:ss");
            LocalDateTime ldt = LocalDateTime.parse(((BStatusString)this.platformTime.get("currentTime")).getValue(), formatter);
            this.currentTimeZoneTF.setText(((BStatusString)this.platformTime.get("timezone")).getValue());
            if (this.platformTime.get("DSTStatus") != null) {
                this.dstActiveCB.setSelected(((BStatusEnum)this.platformTime.get("DSTStatus")).getEnum().getOrdinal() > 0);
            } else {
                this.dstActiveCB.setVisible(false);
                this.dstActiveLabel.setVisible(false);
            }
            this.loadCurrentTimeEditors(this.localDateTimeToMillis(ldt, BTimeZone.DEFAULT), BTimeZone.DEFAULT, this.currentUserContext);
            if (this.stationTimeBtn.isSelected()) {
                BLong milliseconds = this.platformTime.getNe2DeviceExt().getStationCurrentTime();
                LocalDateTime stationCurrentTime = Instant.ofEpochMilli(milliseconds.getLong()).atZone(ZoneId.systemDefault()).toLocalDateTime();
                this.loadDesiredTimeEditors(this.localDateTimeToMillis(stationCurrentTime, this.currentUserTimeZone), this.currentUserTimeZone, this.currentUserContext);
            }
        }
        this.getContent().relayout();
    }

    public void doSetTime() throws Exception {
        int confirm = BDialog.confirm((BWidget)this, (String)this.lex.get("NanoSystemDateTimeEd.confirmTitle"), (Object)this.lex.get("NanoSystemDateTimeEd.confirmMessage"), (int)14);
        if (confirm != 2) {
            boolean restartDevice = confirm == 4;
            this.saving = true;
            BAbsTime date = (BAbsTime)this.desiredDateEditor.saveValue();
            BAbsTime time = (BAbsTime)this.desiredTimeEditor.saveValue();
            BAbsTime desiredTime = BAbsTime.make((int)date.getYear(), (BMonth)date.getMonth(), (int)date.getDay(), (int)time.getHour(), (int)time.getMinute(), (int)0, (int)0, (BTimeZone)((BTimeZone)this.desiredTimeZoneDropDown.getSelectedItem()));
            if (desiredTime != BAbsTime.NULL) {
                String desiredTimezone = ((BTimeZone)this.desiredTimeZoneDropDown.getSelectedItem()).toString();
                this.platformTime.getNe2DeviceExt().setNanoTime(new BNanoTimeChangeArg(desiredTime, desiredTimezone, restartDevice));
            }
            this.saving = false;
        }
    }

    class SaveCmd
    extends Command {
        private BNanoSystemDateTimeEd owner;

        SaveCmd(BWidget owner) {
            super(owner, "Save");
            this.owner = (BNanoSystemDateTimeEd)owner;
        }

        public CommandArtifact doInvoke() {
            return null;
        }
    }

    class RefreshCmd
    extends Command {
        private BNanoSystemDateTimeEd owner;

        RefreshCmd(BWidget owner) {
            super(owner, "Refresh");
            this.owner = (BNanoSystemDateTimeEd)owner;
        }

        public CommandArtifact doInvoke() {
            return null;
        }
    }

    private static class ZoneListModel
    extends ListModel {
        String[] items;

        public ZoneListModel(List<String> items) {
            this.items = (String[])items.stream().toArray(String[]::new);
        }

        public int getItemCount() {
            return this.items.length;
        }

        public BTimeZone getTimeZone(int row) {
            String id = this.items[row].replaceAll("\\(.*?\\)", "").trim();
            return BTimeZone.getTimeZone((String)id);
        }

        public Object getItem(int row) {
            return this.getTimeZone(row);
        }
    }

    private class ZoneComparator
    implements Comparator<ZoneId> {
        private ZoneComparator() {
        }

        @Override
        public int compare(ZoneId zoneId1, ZoneId zoneId2) {
            LocalDateTime now = LocalDateTime.now();
            ZoneOffset offset1 = now.atZone(zoneId1).getOffset();
            ZoneOffset offset2 = now.atZone(zoneId2).getOffset();
            return offset1.compareTo(offset2);
        }
    }

    private static enum OffsetBase {
        GMT,
        UTC;

    }
}

