/*
 * Decompiled with CFR 0.152.
 */
package com.miratech.nE2Link.ui;

import com.miratech.nE2Link.BLibraries;
import com.miratech.nE2Link.BLibrary;
import com.miratech.nE2Link.BNe2DeviceExt;
import com.miratech.nE2Link.ui.NanoTableModel;
import com.miratech.nE2Link.utils.BListOfLibraryFiles;
import com.miratech.nE2Link.utils.BSoftwareManager;
import com.miratech.nE2Link.utils.javabeans.LibraryComp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.baja.sys.BString;

public class NanoSoftwareManagerTableModel
extends NanoTableModel {
    List<LibraryComp> localLibraries = new ArrayList<LibraryComp>();
    List<LibraryComp> osLibraries = new ArrayList<LibraryComp>();
    List<BLibrary> onDeviceLibraries = new ArrayList<BLibrary>();

    public NanoSoftwareManagerTableModel(BNe2DeviceExt ne2DeviceExt, String[] columnNames) {
        this.ne2DeviceExt = ne2DeviceExt;
        this.columnNames = columnNames;
        this.updateTable();
    }

    @Override
    public NanoTableModel.Row[] makeRows() {
        int i;
        int statusColumn;
        int verColumn;
        int nameColumn;
        boolean ok;
        String libVersion;
        String childVersion;
        String status;
        String onDevice;
        this.removeAllRows();
        this.rows = new NanoTableModel.Row[0];
        BLibraries libraries = this.ne2DeviceExt.getLibraries();
        libraries.loadSlots();
        Arrays.asList(libraries.getChildren(BLibrary.class)).stream().forEach(f -> this.onDeviceLibraries.add((BLibrary)f));
        BSoftwareManager softwareManager = this.ne2DeviceExt.getSoftwareManager();
        softwareManager.loadSlots();
        this.onDeviceLibraries.add(new BLibrary(0, "OS", softwareManager.getOSVersion()));
        this.osLibraries = BListOfLibraryFiles.decodeFromString((BString)this.ne2DeviceExt.getOsLibraries());
        for (LibraryComp library : this.osLibraries) {
            onDevice = "false";
            status = library.getNanoName().equals("OS") ? "Latest" : "Latest, part of OS";
            for (BLibrary child : this.onDeviceLibraries) {
                child.loadSlots();
                if (!library.getNanoName().equals(child.getNanoName())) continue;
                onDevice = "true:readonly";
                childVersion = softwareManager.getOSVersion();
                if (this.compareVersions(childVersion, libVersion = library.getLatestLocal()) == 2) {
                    status = library.getNanoName().equals("OS") ? "Out Of Date" : "Out Of Date, part of OS";
                }
                ok = false;
                nameColumn = 1;
                verColumn = 2;
                statusColumn = 5;
                for (i = 0; i < this.getRowCount(); ++i) {
                    if (!this.getValueAt(i, nameColumn).toString().equals(library.getNanoName())) continue;
                    this.set(i, verColumn, library.getLatestLocal());
                    this.set(i, statusColumn, status);
                    ok = true;
                    break;
                }
                if (ok) break;
                this.addRow(new Object[]{onDevice, library.getNanoName(), library.getLatestLocal(), childVersion, "", status});
                break;
            }
            if (!onDevice.equals("false")) continue;
            onDevice = "false:readonly";
            this.addRow(new Object[]{onDevice, library.getNanoName(), library.getLatestLocal(), "", "", "Not Installed, part of OS"});
        }
        this.localLibraries = BListOfLibraryFiles.decodeFromString((BString)this.ne2DeviceExt.getLocalLibraries());
        for (LibraryComp library : this.localLibraries) {
            onDevice = "false";
            status = "Latest";
            for (BLibrary child : this.onDeviceLibraries) {
                child.loadSlots();
                if (!library.getNanoName().equals(child.getNanoName())) continue;
                onDevice = "true";
                childVersion = child.getVersion();
                if (this.compareVersions(childVersion, libVersion = library.getLatestLocal()) == 2) {
                    status = "Out Of Date";
                }
                ok = false;
                nameColumn = 1;
                verColumn = 2;
                statusColumn = 5;
                for (i = 0; i < this.getRowCount(); ++i) {
                    if (!this.getValueAt(i, nameColumn).toString().equals(library.getNanoName())) continue;
                    this.set(i, verColumn, library.getLatestLocal());
                    this.set(i, statusColumn, status);
                    ok = true;
                    break;
                }
                if (ok) break;
                this.addRow(new Object[]{onDevice, library.getNanoName(), library.getLatestLocal(), child.getVersion(), "", status});
                break;
            }
            if (!onDevice.equals("false")) continue;
            this.addRow(new Object[]{onDevice, library.getNanoName(), library.getLatestLocal(), "", "", ""});
        }
        return this.rows;
    }

    private int compareVersions(String version1, String version2) {
        int ret = 0;
        String[] version1Parts = version1.split("\\.");
        String[] version2Parts = version2.split("\\.");
        int length = Math.max(version1Parts.length, version2Parts.length);
        for (int i = 0; i < length; ++i) {
            int version2Part;
            int version1Part;
            int n = version1Parts[i].equals("") ? 0 : (version1Part = i < version1Parts.length ? Integer.parseInt(version1Parts[i]) : 0);
            int n2 = version2Parts[i].equals("") ? 0 : (version2Part = i < version2Parts.length ? Integer.parseInt(version2Parts[i]) : 0);
            if (version1Part > version2Part) {
                ret = 1;
                break;
            }
            if (version1Part >= version2Part) continue;
            ret = 2;
            break;
        }
        return ret;
    }

    List<LibraryComp> getLocalLibraries() {
        return this.localLibraries;
    }

    List<LibraryComp> getOsLibraries() {
        return this.osLibraries;
    }

    List<BLibrary> getOnDeviceLibraries() {
        return this.onDeviceLibraries;
    }
}

