/*
 * Decompiled with CFR 0.152.
 */
package com.miratech.nE2Link.ui.agents;

import com.miratech.nE2Link.BNanoApplication;
import com.miratech.nE2Link.BNanoApplicationContainer;
import com.miratech.nE2Link.BNanoBaseComponent;
import com.miratech.nE2Link.BNe2DeviceExt;
import com.miratech.nE2Link.ui.commands.AddNanoComponentCommand;
import com.miratech.nE2Link.ui.commands.NanoHelpGuideOnTargetCommand;
import com.tridium.workbench.nav.BComponentMenuAgent;
import com.tridium.workbench.nav.BFileMenuAgent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BMenu;
import javax.baja.ui.BMenuItem;
import javax.baja.ui.BSubMenuItem;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.menu.BIMenu;
import javax.baja.ui.menu.BIMenuItem;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.BWsAnnotation;
import javax.baja.util.Lexicon;

@NiagaraType(agent={@AgentOn(types={"nE2Link:Ne2DeviceExt", "nE2Link:AsyncConfig", "nE2Link:NanoProgramConfig", "nE2Link:NanoPollScheduler", "nE2Link:SoftwareManager", "nE2Link:NanoBase"}, defaultAgent=AgentOn.Preference.PREFERRED)})
@NiagaraSingleton
public class BContextMenuAgent
extends BComponentMenuAgent {
    public static final BContextMenuAgent INSTANCE = new BContextMenuAgent();
    public static final Type TYPE = Sys.loadType(BContextMenuAgent.class);
    protected static String[] ALLOW_RENAME_OF_PROTECTED_COMPONENTS = new String[]{"Library.BACnet.LocalDevice", "Library.Modbus.LocalDevice"};
    protected static final Logger logger = Logger.getLogger(TYPE.getTypeSpec().getModuleName());
    protected static final Lexicon lex = Lexicon.make(BContextMenuAgent.class);
    protected static final int[] typeIdsForAdd = new int[]{23, 26, 32, 74, 75, 76, 29, 30};
    static boolean disable = BFileMenuAgent.disable;

    public Type getType() {
        return TYPE;
    }

    protected BMenu doMakeMenu(BWidget owner, BObject target, Context cx) {
        BMenu menu = super.doMakeMenu(owner, target, cx);
        BContextMenuAgent.removeMenuItem(menu, target, cx, "new");
        UiLexicon bajaUILex = UiLexicon.bajaui();
        BContextMenuAgent.removeMenuItem(menu, target, cx, "ActionMenuItem", bajaUILex.get("commands.editTags.label"));
        BContextMenuAgent.removeMenuItem(menu, target, cx, "ActionMenuItem1", bajaUILex.get("commands.makeTemplate.label"));
        BContextMenuAgent.removeMenuItem(menu, target, cx, "relationMark");
        BContextMenuAgent.removeMenuItem(menu, target, cx, "relateFrom");
        BContextMenuAgent.removeMenuItem(menu, target, cx, "relateTo");
        BContextMenuAgent.removeMenuItem(menu, target, cx, "reorder");
        BContextMenuAgent.removeMenuItem(menu, target, cx, "setDisplayName");
        BContextMenuAgent.removeMenuItem(menu, target, cx, "composite");
        BContextMenuAgent.removeMenuItem(menu, target, cx, "pinSlots");
        BContextMenuAgent.handleAddMenu(menu, owner, target, null);
        if (target instanceof BNanoBaseComponent) {
            BIMenuItem helpGuideMenuItem;
            if (Arrays.stream(ALLOW_RENAME_OF_PROTECTED_COMPONENTS).anyMatch(((BNanoBaseComponent)target).getOriginNameFromLibrary()::equals)) {
                menu.getItem("rename").getCommand().setEnabled(true);
            }
            BContextMenuAgent.removeMenuItem(menu, target, cx, "cut");
            BIMenuItem viewMenuItem = menu.getItem("views");
            if (viewMenuItem instanceof BSubMenuItem && (helpGuideMenuItem = ((BSubMenuItem)viewMenuItem).getMenu().getItem("helpGuide")) instanceof BMenuItem) {
                ((BMenuItem)helpGuideMenuItem).setCommand((Command)new NanoHelpGuideOnTargetCommand(owner));
            }
        }
        return menu;
    }

    public static void handleAddMenu(BMenu menu, BWidget owner, BObject target, BWsAnnotation wsAnnotation) {
        if (target instanceof BNanoBaseComponent) {
            BNanoBaseComponent nano = (BNanoBaseComponent)target;
            BNanoApplication nanoApplication = BContextMenuAgent.getParentNanoApplication((BComponent)nano);
            if (null == nanoApplication) {
                return;
            }
            BNe2DeviceExt controller = nano.getNe2DeviceExt();
            ArrayList<BNanoBaseComponent> componentsForAdd = new ArrayList<BNanoBaseComponent>();
            for (int i = 0; i < typeIdsForAdd.length; ++i) {
                BNanoBaseComponent child = controller.getLibraries().getComponentByTypeId(BInteger.make((int)typeIdsForAdd[i]));
                if (null == child) continue;
                componentsForAdd.add(child);
            }
            BContextMenuAgent.addAddMenu(menu, owner, (BComponent)nano, componentsForAdd, wsAnnotation);
        }
    }

    private static void addAddMenu(BMenu menu, BWidget owner, BComponent comp, List<BNanoBaseComponent> componentsForAdd, BWsAnnotation wsAnnotation) {
        if (componentsForAdd.isEmpty()) {
            return;
        }
        BMenu newMenu = BContextMenuAgent.makeAddMenu(owner, comp, wsAnnotation, componentsForAdd);
        if (newMenu == null) {
            return;
        }
        Property p = menu.add("new", (BValue)new BSubMenuItem((BIMenu)newMenu));
        menu.reorderToTop(p);
    }

    private static BMenu makeAddMenu(BWidget owner, BComponent parent, BWsAnnotation anno, List<BNanoBaseComponent> componentsForAdd) {
        try {
            if (parent.getType().getTypeSpec().toString().equals("nsedona:SedonaComponent")) {
                return null;
            }
            BMenu menu = new BMenu(lex.get("ContextMenu.Add", "Add"));
            for (int i = 0; i < componentsForAdd.size(); ++i) {
                BContextMenuAgent.attachAddCommandToAddMenu(owner, menu, parent, componentsForAdd.get(i), anno);
            }
            return menu;
        }
        catch (UnresolvedException e) {
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static void attachAddCommandToAddMenu(BWidget owner, BMenu menu, BComponent parent, BNanoBaseComponent child, BWsAnnotation anno) {
        String[] splitted = child.getNanoName().split("[.]");
        String name = splitted[splitted.length - 1];
        menu.add(name, (Command)new AddNanoComponentCommand(owner, parent, child, anno, name));
    }

    public static void removeMenuItem(BMenu menu, BObject target, Context cx, String menuItem) {
        BIMenuItem removedItem;
        if (null != menu.getItem(menuItem) && null == (removedItem = menu.removeItem(menuItem))) {
            String targetTypeString = null != target ? target.getTypeDisplayName(cx) : "unknown";
            logger.warning(() -> MessageFormat.format("could not remove menu item from {0} menuItem: {1}", targetTypeString, menuItem));
        }
    }

    public static void removeMenuItem(BMenu menu, BObject target, Context cx, String menuItem, String menuItemText) {
        BIMenuItem item;
        BValue itemtoRemove = menu.get(menuItem);
        if (itemtoRemove instanceof BIMenuItem && !menuItemText.equals((item = (BIMenuItem)itemtoRemove).getText())) {
            logger.warning(() -> MessageFormat.format(" cannot remove menu item {0} because expected itemText {1} but got {2}", menuItem, menuItemText, item.getText()));
            return;
        }
        BContextMenuAgent.removeMenuItem(menu, target, cx, menuItem);
    }

    public static BNanoApplication getParentNanoApplication(BComponent component) {
        if (null == component || component instanceof BNanoApplicationContainer) {
            return null;
        }
        if (component instanceof BNanoApplication) {
            return (BNanoApplication)component;
        }
        return BContextMenuAgent.getParentNanoApplication((BComponent)component.getParent());
    }
}

