/*
 * Decompiled with CFR 0.152.
 */
package com.miratech.nE2Link.ui.schedules;

import com.miratech.nE2Link.BNanoBaseComponent;
import com.miratech.nE2Link.schedules.BNanoCalendar;
import com.miratech.nE2Link.schedules.BNanoDateRangeSchedule;
import com.miratech.nE2Link.schedules.BNanoDateSchedule;
import com.miratech.nE2Link.schedules.BNanoWeekAndDaySchedule;
import com.miratech.nE2Link.schedules.utils.BNanoBacnetPriorityEnum;
import com.miratech.nE2Link.schedules.utils.ScheduleUtils;
import com.miratech.nE2Link.ui.schedules.BNanoAbstractScheduleView;
import com.miratech.nE2Link.ui.schedules.BNanoAddEditEventDlg;
import com.miratech.nE2Link.ui.schedules.BNanoDayEd;
import com.miratech.nE2Link.ui.schedules.Utils;
import com.tridium.schedule.ui.BCalendarWidget;
import com.tridium.schedule.ui.BCompositeEd;
import com.tridium.schedule.ui.BDayEd;
import com.tridium.ui.theme.Theme;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import javax.baja.gx.BBrush;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.gx.Graphics;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.schedule.BAbstractSchedule;
import javax.baja.schedule.BCompositeSchedule;
import javax.baja.schedule.BDailySchedule;
import javax.baja.schedule.BDaySchedule;
import javax.baja.schedule.BScheduleReference;
import javax.baja.schedule.BTimeSchedule;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BDate;
import javax.baja.sys.BIcon;
import javax.baja.sys.BMonth;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Subscriber;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BAccelerator;
import javax.baja.ui.BActionMenuItem;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BMenu;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BOrientation;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BSplitPane;
import javax.baja.ui.style.IStylable;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableCellRenderer;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableHeaderRenderer;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.table.TableSelection;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraActions(value={@NiagaraAction(name="addEvent"), @NiagaraAction(name="editEvent"), @NiagaraAction(name="increasePrio"), @NiagaraAction(name="decreasePrio"), @NiagaraAction(name="deleteEvent"), @NiagaraAction(name="removeAllEvents"), @NiagaraAction(name="clearIrrelevant"), @NiagaraAction(name="selected"), @NiagaraAction(name="setModified"), @NiagaraAction(name="filterActionPerformed")})
public class BNanoCompositeEd
extends BCompositeEd {
    public static final Action addEvent = BNanoCompositeEd.newAction((int)0, null);
    public static final Action editEvent = BNanoCompositeEd.newAction((int)0, null);
    public static final Action increasePrio = BNanoCompositeEd.newAction((int)0, null);
    public static final Action decreasePrio = BNanoCompositeEd.newAction((int)0, null);
    public static final Action deleteEvent = BNanoCompositeEd.newAction((int)0, null);
    public static final Action removeAllEvents = BNanoCompositeEd.newAction((int)0, null);
    public static final Action clearIrrelevant = BNanoCompositeEd.newAction((int)0, null);
    public static final Action selected = BNanoCompositeEd.newAction((int)0, null);
    public static final Action setModified = BNanoCompositeEd.newAction((int)0, null);
    public static final Action filterActionPerformed = BNanoCompositeEd.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BNanoCompositeEd.class);
    Subscriber subscriber = new Subscriber(){

        public void event(BComponentEvent event) {
        }
    };
    BAbstractSchedule absSchedule;
    BCalendarWidget calendar;
    Context context;
    BAbstractSchedule current;
    BNanoDayEd daySlider;
    String lastSelected;
    BCompositeSchedule schedule;
    BTable table;
    BButton addButton;
    BButton clearIrrelevantButton;
    BLabel eventName;
    boolean showCalendar;
    boolean controlSchedule;
    private BListDropDown filterDropDown;
    private ArrayList<BAbstractSchedule> schedules = new ArrayList();
    BNanoAbstractScheduleView owner;
    private BAbsTime controllerTime;
    private final int COLUMN_0 = 0;
    private final int COLUMN_1 = 1;
    private final int COLUMN_2 = 2;
    private final int COLUMN_3 = 3;
    private final int FILTER_All_EVENTS = 0;
    private final int FILTER_NEXT_7_DAYS = 1;
    private final int FILTER_NEXT_30_DAYS = 2;
    private final int FILTER_NEXT_6_MONTHS = 3;
    private static final int MAX_SCHEDULE_SPECIAL_EVENTS = 24;
    private static final int MAX_CALENDAR_SPECIAL_EVENTS = 100;
    private static final String ICON_BASE_PATH = "module://nE2Link/rc/icons/scheduleIcons/";
    private static final BImage EVENT_OUTDATED_ICON = BImage.make((BIcon)BIcon.make((String)"module://nE2Link/rc/icons/scheduleIcons/icn-black-sign-warning_1.svg"));
    private static final BImage EVENT_INVALID_ICON = BImage.make((BIcon)BIcon.make((String)"module://nE2Link/rc/icons/scheduleIcons/icn-black-helper-close.svg"));
    private static final BImage EVENT_HAPPENING_ICON = BImage.make((BIcon)BIcon.make((String)"module://nE2Link/rc/icons/scheduleIcons/icn-black-helper-ok.svg"));
    private final Lexicon lex = this.getLexicon();

    public void addEvent() {
        this.invoke(addEvent, null, null);
    }

    public void editEvent() {
        this.invoke(editEvent, null, null);
    }

    public void increasePrio() {
        this.invoke(increasePrio, null, null);
    }

    public void decreasePrio() {
        this.invoke(decreasePrio, null, null);
    }

    public void deleteEvent() {
        this.invoke(deleteEvent, null, null);
    }

    public void removeAllEvents() {
        this.invoke(removeAllEvents, null, null);
    }

    public void clearIrrelevant() {
        this.invoke(clearIrrelevant, null, null);
    }

    public void selected() {
        this.invoke(selected, null, null);
    }

    public void setModified() {
        this.invoke(setModified, null, null);
    }

    public void filterActionPerformed() {
        this.invoke(filterActionPerformed, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BNanoCompositeEd(BNanoAbstractScheduleView owner, boolean controlSchedule) {
        this(owner, controlSchedule, true);
    }

    public BNanoCompositeEd(BNanoAbstractScheduleView owner, boolean controlSchedule, boolean showCalendar) {
        super(controlSchedule, showCalendar);
        this.owner = owner;
        this.lastSelected = "";
        this.controlSchedule = controlSchedule;
        this.showCalendar = showCalendar;
        BEdgePane widget1 = new BEdgePane();
        this.filterDropDown = new BListDropDown();
        this.filterDropDown.getList().addItem((Object)this.lex.get("NanoScheduler.filter.allEvents"));
        this.filterDropDown.getList().addItem((Object)this.lex.get("NanoScheduler.filter.next7Days"));
        this.filterDropDown.getList().addItem((Object)this.lex.get("NanoScheduler.filter.next30Days"));
        this.filterDropDown.getList().addItem((Object)this.lex.get("NanoScheduler.filter.next6Months"));
        this.filterDropDown.getList().setSelectedIndex(0);
        this.linkTo((BComponent)this.filterDropDown, (Slot)BListDropDown.listActionPerformed, (Slot)filterActionPerformed);
        widget1.setTop((BWidget)this.filterDropDown);
        widget1.setCenter((BWidget)new BBorderPane(this.makeTable(), 0.0, 0.0, 0.0, 0.0));
        BEdgePane widget2 = new BEdgePane();
        if (showCalendar) {
            this.calendar = new BCalendarWidget(false);
            widget2.setCenter((BWidget)this.calendar);
        }
        if (controlSchedule) {
            this.eventName = new BLabel("");
            this.daySlider = new BNanoDayEd(true);
            this.linkTo((BComponent)this.daySlider, (Slot)BDayEd.modified, (Slot)setModified);
            widget2.setTop((BWidget)this.eventName);
            widget2.setCenter((BWidget)new BBorderPane((BWidget)this.daySlider, 10.0, 0.0, 0.0, 10.0));
        }
        BSplitPane splitPane = new BSplitPane(BOrientation.horizontal, 70.0);
        splitPane.setMoveableDivider(true);
        splitPane.setWidget1((BWidget)widget1);
        splitPane.setWidget2((BWidget)widget2);
        this.setContent((BWidget)splitPane);
    }

    public void doAddEvent() {
        int maxSpecialEvents;
        int n = maxSpecialEvents = this.controlSchedule ? 24 : 100;
        if (((BAbstractSchedule[])this.schedule.getChildren(BAbstractSchedule.class)).length >= maxSpecialEvents) {
            BDialog.error((BWidget)this, (Object)this.lex.get("NanoScheduler.specialEvents.eventLimitExceeded"));
            return;
        }
        BNanoAddEditEventDlg addEditEvent = new BNanoAddEditEventDlg(this, this.generateName("Event"), null, true, this.context);
        while (true) {
            try {
                block8: {
                    int result;
                    while ((result = BDialog.open((BWidget)this, (String)this.lex.get("NanoScheduler.event"), (Object)((Object)addEditEvent), (int)3, (BImage)null)) == 1) {
                        addEditEvent.validate();
                        String name = addEditEvent.name();
                        if (name == null || name.trim().isEmpty()) {
                            BDialog.error((BWidget)this, (Object)this.lex.get("NanoScheduler.enterName"));
                            continue;
                        }
                        String nameEncoded = SlotPath.escape((String)name);
                        if (this.schedule.get(nameEncoded) != null) {
                            BDialog.error((BWidget)this, (Object)this.lex.get("NanoScheduler.nameAlreadyInUse"));
                            continue;
                        }
                        BAbstractSchedule sch = addEditEvent.getSchedule();
                        if (sch.getType().equals(BScheduleReference.TYPE) && ((BScheduleReference)sch).getRef().equals((Object)BOrd.NULL)) {
                            BDialog.error((BWidget)this, (Object)"Not allowed: please add a calendar as a reference");
                            continue;
                        }
                        Property newProp = this.schedule.add(nameEncoded, (BValue)sch);
                        this.table.getSelection().select(this.table.getModel().getRowCount(), true);
                        this.table.ensureRowIsVisible(this.table.getModel().getRowCount() + 1);
                        this.table.sizeColumnsToFit();
                        this.filterActionPerformed();
                        this.fireModified(null);
                        break block8;
                    }
                    this.updateButtons();
                }
                return;
            }
            catch (Exception e) {
                BDialog.error((BWidget)this, (Object)e.getMessage());
                continue;
            }
            break;
        }
    }

    public void doDeleteEvent() {
        int index = this.table.getSelection().getRow();
        if (null != this.current && this.current.getParent() == this.schedule) {
            this.schedule.remove((BComplex)this.current);
        } else {
            for (BAbstractSchedule child : (BAbstractSchedule[])this.schedule.getChildren(BAbstractSchedule.class)) {
                if (!child.getName().equals(this.current.getName())) continue;
                this.schedule.remove((BComplex)child);
                break;
            }
        }
        this.schedules.remove(this.current);
        this.current = null;
        this.table.getModel().updateTable();
        int size = this.schedules.size();
        if (size == 0) {
            this.table.getSelection().deselectAll();
        } else if (index >= size) {
            this.table.getSelection().select(size - 1, true);
        } else {
            this.table.getSelection().select(index);
        }
        this.filterActionPerformed();
        this.fireModified(null);
    }

    public void doRemoveAllEvents() {
        for (int i = 0; i < this.table.getModel().getRowCount(); ++i) {
            Object[] rowValues = this.table.getModel().getRowValues(i);
            String name = (String)rowValues[1];
            if (name.equals(null)) continue;
            BAbstractSchedule event = (BAbstractSchedule)this.schedule.get(SlotPath.escape((String)name));
            this.schedule.remove((BComplex)event);
        }
        this.fireModified(null);
        this.filterActionPerformed();
    }

    public void doClearIrrelevant() {
        Model model = (Model)this.table.getModel();
        int index = model.getRowCount();
        for (int i = 0; i < index; ++i) {
            BAbstractSchedule event;
            Object[] rowValues = model.getRowValues(i);
            String name = (String)rowValues[1];
            if (name.equals(null) || !model.isInvalid(event = (BAbstractSchedule)this.schedule.get(SlotPath.escape((String)name))) && !model.isOutdated(event)) continue;
            this.schedule.remove((BComplex)event);
        }
        this.fireModified(null);
        this.filterActionPerformed();
    }

    public void doIncreasePrio() {
        this.move(true);
        this.updateButtons();
    }

    public void doDecreasePrio() {
        this.move(false);
        this.updateButtons();
    }

    public void doEditEvent() {
        int row = this.table.getSelection().getRow();
        BAbstractSchedule sch = this.schedules.get(row);
        BAbstractSchedule restore = (BAbstractSchedule)sch.newCopy(true);
        if (sch instanceof BDailySchedule) {
            sch = ((BDailySchedule)sch).getDays();
        }
        BTimeSchedule[] ts = restore instanceof BDailySchedule ? ((BDailySchedule)restore).getDay().getTimesInOrder() : new BTimeSchedule[]{};
        String defaultName = (String)this.table.getModel().getValueAt(row, 1);
        BNanoAddEditEventDlg addEditEvent = new BNanoAddEditEventDlg(this, defaultName, sch, true, this.context);
        block2: while (true) {
            try {
                Property p;
                while (true) {
                    if (1 != BDialog.open((BWidget)this, (String)this.lex.get("NanoScheduler.editEvent"), (Object)((Object)addEditEvent), (int)3, (BImage)null)) {
                        this.current = restore;
                        this.schedule.set(SlotPath.escape((String)this.lastSelected), (BValue)restore);
                        break block2;
                    }
                    addEditEvent.validate();
                    String name = addEditEvent.name();
                    if (name == null || name.trim().isEmpty()) {
                        BDialog.error((BWidget)this, (Object)this.lex("composite.enterName"));
                        continue;
                    }
                    String nameEncoded = SlotPath.escape((String)name);
                    p = this.schedule.getProperty(SlotPath.escape((String)defaultName));
                    if (!nameEncoded.equals(SlotPath.escape((String)defaultName))) {
                        if (this.schedule.get(nameEncoded) != null) {
                            BDialog.error((BWidget)this, (Object)this.lex("composite.nameAlreadyInUse"));
                            continue;
                        }
                        this.schedule.rename(p, nameEncoded, (Context)null);
                        this.table.getModel().updateTable();
                    }
                    this.schedule.set(p, (BValue)addEditEvent.getSchedule());
                    p = this.schedule.getProperty(p.getName());
                    if (!this.schedule.get(p.getName()).getType().equals(BScheduleReference.TYPE) || !((BScheduleReference)sch).getRef().equals((Object)BOrd.NULL)) break;
                    BDialog.error((BWidget)this, (Object)"Not allowed: please add a calendar as a reference");
                }
                if (this.schedule.get(p.getName()).getType().equals(BDailySchedule.TYPE)) {
                    BDailySchedule dailySchedule = (BDailySchedule)this.schedule.get(p.getName());
                    for (BTimeSchedule timeSchedule : ts) {
                        dailySchedule.getDay().add(timeSchedule.getName(), timeSchedule.newCopy(true));
                    }
                }
                this.fireModified(null);
            }
            catch (Exception e) {
                BDialog.error((BWidget)this, (Object)e.getMessage());
                continue;
            }
            break;
        }
        this.filterActionPerformed();
    }

    public void doSelected() {
        int row = this.table.getSelection().getRow();
        if (row >= 0 && this.table.getModel().getRowCount() > 0) {
            try {
                String name = (String)this.table.getModel().getValueAt(row, 1);
                if (name == null) {
                    this.current = null;
                    if (this.controlSchedule) {
                        this.setSlider(null);
                    }
                    if (this.calendar != null) {
                        this.calendar.setSchedule((BAbstractSchedule)this.schedule);
                    }
                    this.updateButtons();
                    this.lastSelected = "";
                } else if (name.equals(this.lastSelected)) {
                    this.current = (BAbstractSchedule)this.schedule.get(SlotPath.escape((String)name));
                    if (this.controlSchedule) {
                        BDailySchedule m = (BDailySchedule)this.current;
                        this.setSlider(m.getDay());
                    }
                    this.updateButtons();
                } else {
                    this.lastSelected = name;
                    this.current = (BAbstractSchedule)this.schedule.get(SlotPath.escape((String)name));
                    if (this.controlSchedule) {
                        BDailySchedule m = (BDailySchedule)this.current;
                        this.setSlider(m.getDay());
                    }
                    if (this.calendar != null) {
                        this.calendar.setSchedule(this.current);
                    }
                    this.updateButtons();
                    if (this.controlSchedule) {
                        this.eventName.setText(SlotPath.escape((String)name));
                    }
                }
            }
            catch (Exception exception) {}
        } else {
            this.current = null;
            if (this.controlSchedule) {
                this.setSlider(null);
            }
            if (this.calendar != null) {
                this.calendar.setSchedule((BAbstractSchedule)this.schedule);
            }
            this.updateButtons();
            this.lastSelected = "";
        }
    }

    public void doSetModified() {
        if (this.calendar != null) {
            this.calendar.setSchedule(this.current);
            this.table.getModel().updateTable();
        }
        this.fireModified(null);
    }

    public void doFilterActionPerformed() {
        if (this.schedule == null) {
            return;
        }
        this.schedules = new ArrayList();
        Model model = (Model)this.table.getModel();
        Arrays.asList(this.schedule.getSchedules()).forEach(s -> {
            BAbstractSchedule sch = s;
            if (s instanceof BDailySchedule) {
                s = ((BDailySchedule)s).getDays();
            }
            BAbsTime nextEvent = this.nextEvent(this.owner, (BAbstractSchedule)s);
            int delta = BDate.today().delta(nextEvent.getDate());
            switch (this.filterDropDown.getSelectedIndex()) {
                case 0: {
                    this.schedules.add(sch);
                    break;
                }
                case 1: {
                    if (delta > 7 || model.isOutdated(s)) break;
                    this.schedules.add(sch);
                    break;
                }
                case 2: {
                    if (delta > 30 || model.isOutdated(s)) break;
                    this.schedules.add(sch);
                    break;
                }
                case 3: {
                    if (delta > 180 || model.isOutdated(s)) break;
                    this.schedules.add(sch);
                }
            }
        });
        this.table.getModel().updateTable();
    }

    public void setReadonly(boolean ro) {
        super.setReadonly(ro);
        this.updateButtons();
        if (this.daySlider != null) {
            this.daySlider.setReadonly(ro);
        }
    }

    private String generateName(String base) {
        String gen = base;
        int i = 0;
        while (this.schedule.getProperty(gen) != null) {
            gen = base + ++i;
        }
        return gen;
    }

    private Property[] getDynamicProperties() {
        Array ret = new Array(Property.class);
        SlotCursor c = this.schedule.getProperties();
        while (c.next()) {
            Property p = c.property();
            if (!p.isDynamic()) continue;
            ret.add((Object)p);
        }
        return (Property[])ret.trim();
    }

    private int indexOf(Property[] props, String name) {
        int i = props.length;
        do {
            if (--i >= 0) continue;
            return -1;
        } while (!props[i].getName().equals(name));
        return i;
    }

    private void move(boolean up) {
        Object[] newValues;
        BAbstractSchedule newEvent;
        int row = this.table.getSelection().getRow();
        String sel = (String)this.table.getModel().getValueAt(row, 1);
        Object[] rowValues = this.table.getModel().getRowValues(row);
        BAbstractSchedule prevEvent = (BAbstractSchedule)this.schedule.get(SlotPath.escape((String)((String)rowValues[1])));
        if (prevEvent instanceof BDailySchedule) {
            prevEvent = ((BDailySchedule)prevEvent).getDays();
        }
        if ((newEvent = (BAbstractSchedule)this.schedule.get(SlotPath.escape((String)((String)(newValues = this.table.getModel().getRowValues(up ? row - 1 : row + 1))[1])))) instanceof BDailySchedule) {
            newEvent = ((BDailySchedule)newEvent).getDays();
        }
        int prevBacnetPriority = ((BNanoBacnetPriorityEnum)prevEvent.get(ScheduleUtils.BACNET_PRIORITY)).getOrdinal();
        int newBacnetPriority = ((BNanoBacnetPriorityEnum)newEvent.get(ScheduleUtils.BACNET_PRIORITY)).getOrdinal();
        if (up) {
            if (newBacnetPriority < prevBacnetPriority) {
                prevEvent.set(ScheduleUtils.BACNET_PRIORITY, (BValue)BNanoBacnetPriorityEnum.make((int)newBacnetPriority));
            }
        } else if (newBacnetPriority > prevBacnetPriority) {
            prevEvent.set(ScheduleUtils.BACNET_PRIORITY, (BValue)BNanoBacnetPriorityEnum.make((int)newBacnetPriority));
        }
        Property[] dyn = this.getDynamicProperties();
        int idx = this.indexOf(dyn, SlotPath.escape((String)sel));
        int newIdx = up ? idx - 1 : idx + 1;
        Property tmp = dyn[idx];
        dyn[idx] = dyn[newIdx];
        dyn[newIdx] = tmp;
        this.schedule.reorder(dyn);
        this.filterActionPerformed();
        TableSelection tableSelection = this.table.getSelection();
        int position = up ? row - 1 : row + 1;
        tableSelection.select(position, true);
        this.fireModified(null);
    }

    private BWidget makeTable() {
        BEdgePane edgePane = new BEdgePane();
        this.table = new BTable((TableModel)new Model(), (TableController)new Controller(), new TableSelection(), new TableHeaderRenderer(), (TableCellRenderer)new CellRenderer());
        this.table.setHeaderVisible(false);
        this.table.setMultipleSelection(false);
        this.linkTo((BComponent)this.table, (Slot)BTable.selectionModified, (Slot)selected);
        BGridPane gp = new BGridPane(2);
        gp.setHalign(BHalign.right);
        this.addButton = new BButton(Utils.imgAdd, this.lex.get("NanoScheduler.addEvent"));
        this.linkTo((BComponent)this.addButton, (Slot)BButton.actionPerformed, (Slot)addEvent);
        this.clearIrrelevantButton = new BButton(Utils.imgDelete, this.lex.get("NanoScheduler.clearIrrelevant"));
        this.linkTo((BComponent)this.clearIrrelevantButton, (Slot)BButton.actionPerformed, (Slot)clearIrrelevant);
        this.addButton.setButtonStyle(BButtonStyle.normal);
        this.clearIrrelevantButton.setButtonStyle(BButtonStyle.normal);
        gp.add((String)null, (BValue)this.addButton);
        gp.add((String)null, (BValue)this.clearIrrelevantButton);
        edgePane.setCenter((BWidget)this.table);
        edgePane.setBottom((BWidget)new BBorderPane((BWidget)gp, 10.0, 0.0, 0.0, 0.0));
        this.updateButtons();
        return edgePane;
    }

    void setSlider(BDaySchedule sch) {
        if (sch == null) {
            this.daySlider.setDaySchedule(this.absSchedule, new BDaySchedule());
        } else {
            this.daySlider.setDaySchedule(this.absSchedule, sch);
        }
        this.daySlider.setReadonly(this.isReadonly() || sch == null);
        this.daySlider.relayout();
    }

    private void updateButtons() {
        this.addButton.setEnabled(!this.isReadonly());
        boolean enabled = !this.isReadonly() && !this.showCalendar;
        this.clearIrrelevantButton.setEnabled(enabled);
    }

    public void setAbsSchedule(BAbstractSchedule absSchedule) {
        this.absSchedule = absSchedule;
    }

    public void setSchedule(BCompositeSchedule specialEvents) {
        this.schedule = specialEvents;
        this.schedules = new ArrayList<BAbstractSchedule>(Arrays.asList(this.schedule.getSchedules()));
        this.subscriber.unsubscribeAll();
        for (BAbstractSchedule sch : this.schedules) {
            if (!(sch instanceof BDailySchedule)) continue;
            try {
                BAbstractSchedule event = ((BDailySchedule)sch).getDays();
                if (!(event instanceof BScheduleReference)) continue;
                BOrd refBase = BOrd.make((String)sch.toString().substring((this.lex.get("NanoScheduler.reference") + ": ").length()).trim());
                BNanoCalendar nanoCalendar = (BNanoCalendar)refBase.resolve((BObject)this.absSchedule).get();
                this.subscriber.subscribe((BComponent)nanoCalendar, 10);
            }
            catch (Exception event) {}
        }
        this.table.getModel().updateTable(true);
        BNanoBaseComponent baseComponent = (BNanoBaseComponent)this.owner.getCurrentValue();
        String controllerTimeStr = baseComponent.getNe2DeviceExt().doGetControllerCurrentTime();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy.MM.dd HH:mm:ss");
        LocalDateTime localDateTime = LocalDateTime.parse(controllerTimeStr, formatter);
        this.controllerTime = BAbsTime.make((int)localDateTime.getYear(), (BMonth)BMonth.make((int)(localDateTime.getMonthValue() - 1)), (int)localDateTime.getDayOfMonth());
    }

    public BCompositeSchedule getSchedule() {
        return this.schedule;
    }

    private BAbsTime nextEvent(BNanoAbstractScheduleView owner, BAbstractSchedule s) {
        BAbsTime nextEvent = BAbsTime.NULL;
        try {
            if (s instanceof BScheduleReference) {
                BScheduleReference scheduleReference = (BScheduleReference)s;
                BNanoCalendar refComponent = (BNanoCalendar)scheduleReference.getRef().resolve((BObject)this.owner.getBase()).getComponent();
                refComponent.loadSlots();
                nextEvent = refComponent.getNextTime();
                if (nextEvent == BAbsTime.NULL) {
                    BAbsTime startEvent;
                    BNanoDateSchedule[] dateSchedules = (BNanoDateSchedule[])refComponent.getChildren(BNanoDateSchedule.class);
                    BNanoDateRangeSchedule[] dateRangeSchedules = (BNanoDateRangeSchedule[])refComponent.getChildren(BNanoDateRangeSchedule.class);
                    BNanoWeekAndDaySchedule[] weekAndDaySchedules = (BNanoWeekAndDaySchedule[])refComponent.getChildren(BNanoWeekAndDaySchedule.class);
                    if (dateSchedules.length == 0 && dateRangeSchedules.length == 0 && weekAndDaySchedules.length == 0) {
                        return nextEvent;
                    }
                    for (BNanoDateSchedule bNanoDateSchedule : dateSchedules) {
                        bNanoDateSchedule.loadSlots();
                        startEvent = bNanoDateSchedule.nextEvent(this.controllerTime);
                        if (nextEvent == BAbsTime.NULL) {
                            nextEvent = startEvent;
                            continue;
                        }
                        if (!startEvent.isBefore(nextEvent)) continue;
                        nextEvent = startEvent;
                    }
                    for (BNanoDateSchedule bNanoDateSchedule : dateRangeSchedules) {
                        bNanoDateSchedule.loadSlots();
                        startEvent = bNanoDateSchedule.nextEvent(this.controllerTime);
                        if (nextEvent == BAbsTime.NULL) {
                            nextEvent = startEvent;
                            continue;
                        }
                        if (!startEvent.isBefore(nextEvent)) continue;
                        nextEvent = startEvent;
                    }
                    for (BNanoDateSchedule bNanoDateSchedule : weekAndDaySchedules) {
                        bNanoDateSchedule.loadSlots();
                        startEvent = bNanoDateSchedule.nextEvent(this.controllerTime);
                        if (nextEvent == BAbsTime.NULL) {
                            nextEvent = startEvent;
                            continue;
                        }
                        if (!startEvent.isBefore(nextEvent)) continue;
                        nextEvent = startEvent;
                    }
                }
            } else {
                nextEvent = s.nextEvent(this.controllerTime);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return nextEvent;
    }

    class CellRenderer
    extends TableCellRenderer {
        CellRenderer() {
        }

        public BBrush getForeground(TableCellRenderer.Cell cell) {
            return Theme.table().getTextBrush((IStylable)this.getTable());
        }

        public double getPreferredCellWidth(TableCellRenderer.Cell cell) {
            switch (cell.column) {
                case 0: {
                    return 50.0;
                }
                case 1: 
                case 2: {
                    return super.getPreferredCellWidth(cell) + 30.0;
                }
            }
            return super.getPreferredCellWidth(cell);
        }

        public void paintCell(Graphics g, TableCellRenderer.Cell cell) {
            Model model = (Model)this.getTable().getModel();
            if (cell.column > 0) {
                super.paintCell(g, cell);
            } else {
                BImage eventIcon = (BImage)model.getValueAt(cell.row, 0);
                if (null != eventIcon) {
                    double x;
                    double margin;
                    double iconsTotalWidth = margin = 2.0;
                    double rowIconWidth = 0.0;
                    iconsTotalWidth += eventIcon.getWidth() + margin;
                    switch (model.getColumnAlignment(cell.column).getOrdinal()) {
                        case 1: {
                            x = (cell.width - iconsTotalWidth) / 2.0;
                            break;
                        }
                        case 2: {
                            x = cell.width - iconsTotalWidth;
                        }
                        default: {
                            x = margin;
                        }
                    }
                    this.paintCellBackground(g, cell);
                    BFont font = this.getFont(cell);
                    g.setFont(font);
                    if (cell.selected) {
                        g.setBrush(this.getSelectionForeground(cell));
                    } else {
                        g.setBrush(this.getForeground(cell));
                    }
                    g.drawImage(eventIcon, x + rowIconWidth + margin, (cell.height - eventIcon.getHeight()) / 2.0);
                }
            }
        }
    }

    class Controller
    extends TableController {
        private Model tableModel;

        Controller() {
        }

        protected void backgroundPopup(BMouseEvent e) {
            if (!BNanoCompositeEd.this.isReadonly()) {
                BMenu menu = new BMenu();
                menu.add((String)null, (Command)new CmdAddEvent());
                menu.add((String)null, (Command)new CmdRemoveAllEvents());
                menu.open((BWidget)this.getTable(), e.getX(), e.getY());
            }
        }

        protected void cellDoubleClicked(BMouseEvent e, int r, int c) {
            BNanoCompositeEd.this.editEvent();
        }

        protected void cellPopup(BMouseEvent e, int row, int column) {
            if (!BNanoCompositeEd.this.isReadonly()) {
                BMenu menu = new BMenu();
                if (BNanoCompositeEd.this.current == null) {
                    menu.add("addItem", (Command)new CmdAddEvent());
                    menu.add("deleteAllItems", (Command)new CmdRemoveAllEvents());
                } else {
                    BActionMenuItem cmd;
                    menu.add("editItem", (Command)new CmdEditEvent());
                    menu.add("increasePrioItem", (Command)new CmdIncreasePriority());
                    menu.add("decreasePrioItem", (Command)new CmdDecreasePriority());
                    menu.add("deleteItem", (Command)new CmdDeleteEvent());
                    if (row == 0 && (cmd = (BActionMenuItem)menu.get("increasePrioItem")) != null) {
                        cmd.setEnabled(false);
                    }
                    if (row == this.getTable().getModel().getRowCount() - 1 && (cmd = (BActionMenuItem)menu.get("decreasePrioItem")) != null) {
                        cmd.setEnabled(false);
                    }
                }
                menu.open((BWidget)this.getTable(), e.getX(), e.getY());
            }
        }
    }

    private class CmdRemoveAllEvents
    extends Command {
        CmdRemoveAllEvents() {
            super((BWidget)BNanoCompositeEd.this, BNanoCompositeEd.this.lex.get("NanoScheduler.removeAllEvents"), Utils.imgDelete, (BAccelerator)null, (String)null);
        }

        public CommandArtifact doInvoke() {
            BNanoCompositeEd.this.doRemoveAllEvents();
            return null;
        }
    }

    private class CmdAddEvent
    extends Command {
        CmdAddEvent() {
            super((BWidget)BNanoCompositeEd.this, BNanoCompositeEd.this.lex.get("NanoScheduler.addEvent"), Utils.imgAdd, (BAccelerator)null, (String)null);
        }

        public CommandArtifact doInvoke() {
            BNanoCompositeEd.this.doAddEvent();
            return null;
        }
    }

    private class CmdDeleteEvent
    extends Command {
        CmdDeleteEvent() {
            super((BWidget)BNanoCompositeEd.this, BNanoCompositeEd.this.lex.get("NanoScheduler.deleteEvent"), Utils.imgDelete, (BAccelerator)null, (String)null);
        }

        public CommandArtifact doInvoke() {
            BNanoCompositeEd.this.doDeleteEvent();
            return null;
        }
    }

    private class CmdDecreasePriority
    extends Command {
        CmdDecreasePriority() {
            super((BWidget)BNanoCompositeEd.this, BNanoCompositeEd.this.lex.get("NanoScheduler.decreasePriority"), Utils.imgDown, (BAccelerator)null, (String)null);
        }

        public CommandArtifact doInvoke() {
            BNanoCompositeEd.this.doDecreasePrio();
            return null;
        }
    }

    private class CmdIncreasePriority
    extends Command {
        CmdIncreasePriority() {
            super((BWidget)BNanoCompositeEd.this, BNanoCompositeEd.this.lex.get("NanoScheduler.increasePriority"), Utils.imgUp, (BAccelerator)null, (String)null);
        }

        public CommandArtifact doInvoke() {
            BNanoCompositeEd.this.doIncreasePrio();
            return null;
        }
    }

    private class CmdEditEvent
    extends Command {
        CmdEditEvent() {
            super((BWidget)BNanoCompositeEd.this, BNanoCompositeEd.this.lex.get("NanoScheduler.editEvent"), Utils.imgEdit, (BAccelerator)null, (String)null);
        }

        public CommandArtifact doInvoke() {
            BNanoCompositeEd.this.doEditEvent();
            return null;
        }
    }

    class Model
    extends TableModel {
        public int getColumnCount() {
            return 4;
        }

        public String getColumnName(int col) {
            String columnName = "";
            return columnName;
        }

        public BHalign getColumnAlignment(int col) {
            return col == 0 ? BHalign.center : BHalign.left;
        }

        public int getRowCount() {
            return BNanoCompositeEd.this.schedule == null ? 0 : BNanoCompositeEd.this.schedules.size();
        }

        public Object getValueAt(int row, int col) {
            Object value = null;
            try {
                BAbstractSchedule s = (BAbstractSchedule)BNanoCompositeEd.this.schedules.get(row);
                switch (col) {
                    case 0: {
                        value = this.getIconToDisplay(s);
                        break;
                    }
                    case 1: {
                        value = SlotPath.unescape((String)s.getName());
                        break;
                    }
                    case 2: {
                        value = this.getDaysMarker(s);
                        break;
                    }
                    default: {
                        value = this.getDaysString(s);
                        break;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return value;
        }

        private Object getIconToDisplay(BAbstractSchedule s) {
            if (this.isOutdated(s)) {
                return EVENT_OUTDATED_ICON;
            }
            if (this.isInvalid(s)) {
                return EVENT_INVALID_ICON;
            }
            if (this.isHappeningNow(s)) {
                return EVENT_HAPPENING_ICON;
            }
            return null;
        }

        private boolean isInvalid(BAbstractSchedule s) {
            if (s instanceof BDailySchedule) {
                BDailySchedule sch = (BDailySchedule)s;
                BTimeSchedule[] events = sch.getDay().getTimesInOrder();
                return events == null || events.length == 0;
            }
            return false;
        }

        private boolean isHappeningNow(BAbstractSchedule s) {
            return this.getDaysMarker(s).equals(BNanoCompositeEd.this.lex.get("NanoScheduler.now", "Now")) || this.getDaysMarker(s).equals(BNanoCompositeEd.this.lex.get("ScheduleUtils.today", "Today"));
        }

        private boolean isOutdated(BAbstractSchedule s) {
            return this.getDaysMarker(s).equals(BNanoCompositeEd.this.lex.get("ScheduleUtils.past", "Past"));
        }

        private String getDaysString(BAbstractSchedule s) {
            Context cx;
            if (s instanceof BDailySchedule) {
                BDailySchedule sch = (BDailySchedule)s;
                s = sch.getDays();
            }
            if (BNanoCompositeEd.this.context == null && BNanoCompositeEd.this.getView() != null) {
                BNanoCompositeEd.this.context = BNanoCompositeEd.this.getView().getCurrentContext();
            }
            if ((cx = BNanoCompositeEd.this.context) != null) {
                cx = new BasicContext(cx.getUser(), cx.getLanguage());
            }
            if (s instanceof BScheduleReference) {
                String calendarName = null;
                try {
                    String calReference = s.toString().split(":")[2];
                    BOrd refBase = BOrd.make((String)("slot:" + calReference));
                    BNanoCalendar nanoCalendar = (BNanoCalendar)refBase.resolve((BObject)BNanoCompositeEd.this.absSchedule).get();
                    calendarName = SlotPath.unescape((String)nanoCalendar.getParent().getName());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return BNanoCompositeEd.this.lex.get("NanoScheduler.calReference") + ": " + calendarName;
            }
            return s.toString(cx);
        }

        private String getDaysMarker(BAbstractSchedule s) {
            BAbsTime nextEvent;
            String marker = "";
            BAbstractSchedule sch = s;
            if (sch instanceof BDailySchedule) {
                s = ((BDailySchedule)sch).getDays();
            }
            if ((nextEvent = BNanoCompositeEd.this.nextEvent(BNanoCompositeEd.this.owner, s)) == BAbsTime.NULL) {
                marker = "No Events";
                return "No Events";
            }
            try {
                marker = ScheduleUtils.DateDiff.make((BAbsTime)BNanoCompositeEd.this.controllerTime, (BAbsTime)nextEvent).toString(BNanoCompositeEd.this.context);
            }
            catch (Exception e) {
                marker = BNanoCompositeEd.this.lex.get("NanoScheduler.noEvents");
            }
            return marker;
        }
    }
}

