/*
 * Decompiled with CFR 0.152.
 */
package com.miratech.ifnetclient.Internal;

import com.miratech.ifnetclient.utils.IfnetClientLogger;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

public class ManualResetEvent {
    private static final int MAX_WAIT = 1000;
    private static final String TAG = "ManualResetEvent";
    private Semaphore semaphore = new Semaphore(1000, false);
    private volatile boolean signaled = false;
    private volatile int count = 0;

    public ManualResetEvent(boolean signaled) {
        this.signaled = signaled;
        if (!signaled) {
            this.semaphore.drainPermits();
        }
    }

    public boolean waitOne() {
        return this.waitOne(Long.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitOne(long millis) {
        boolean bRc = true;
        if (this.signaled) {
            return true;
        }
        try {
            ++this.count;
            if (this.count > 1000) {
                IfnetClientLogger.log(Level.FINEST, String.format("%s, %s", TAG, "More requests than waits: " + String.valueOf(this.count)));
            }
            IfnetClientLogger.log(Level.FINEST, String.format("%s, %s", TAG, "ManualResetEvent WaitOne Entered"));
            bRc = this.semaphore.tryAcquire(millis, TimeUnit.MILLISECONDS);
            IfnetClientLogger.log(Level.FINEST, String.format("%s, %s", TAG, "ManualResetEvent WaitOne=" + String.valueOf(bRc)));
        }
        catch (InterruptedException e) {
            bRc = false;
        }
        finally {
            --this.count;
        }
        IfnetClientLogger.log(Level.FINEST, String.format("%s, %s", TAG, "ManualResetEvent WaitOne Exit"));
        return bRc;
    }

    public void set() {
        IfnetClientLogger.log(Level.FINEST, String.format("%s, %s", TAG, "ManualResetEvent Set"));
        this.signaled = true;
        this.semaphore.release(1000);
    }

    public void reset() {
        this.signaled = false;
        int count = this.semaphore.drainPermits();
        IfnetClientLogger.log(Level.FINEST, String.format("%s, %s", TAG, "ManualResetEvent Reset: Permits drained=" + String.valueOf(count)));
    }
}

