/*
 * Decompiled with CFR 0.152.
 */
package com.miratech.ifnetclient.Internal;

import com.miratech.ifnetclient.model.Choice;
import com.miratech.serialization.DataMarker;
import com.miratech.serialization.SerializableForm;
import java.util.HashMap;
import javax.baja.nre.util.Array;

public final class NotationOfDynamicChoice {
    public static SerializableForm WithChoice(Choice toBeSerialized) {
        return NotationOfDynamicChoice.WithChoice(toBeSerialized, 0L);
    }

    public static SerializableForm WithChoice(Choice toBeSerialized, long persistentId) {
        Byte associatedSlotIndex = -1;
        String lexiconId = "calendars";
        String defaultDisplayName = "null";
        Object[] displayNames = toBeSerialized.AllowedChoicesNames();
        Object[] allowedValues = NotationOfDynamicChoice.GetValuesForNames(toBeSerialized, (String[])displayNames);
        Array allowedValuesArray = new Array(Object.class, allowedValues.length);
        allowedValuesArray.addAll(allowedValues);
        Array displayNamesArray = new Array(String.class, displayNames.length);
        displayNamesArray.addAll(displayNames);
        return new SerializableForm(DataMarker.DynamicChoice, new Object[]{associatedSlotIndex, lexiconId, defaultDisplayName, allowedValuesArray, displayNamesArray});
    }

    private static Double[] GetValuesForNames(Choice choice, String[] displayNames) {
        Double[] values = new Double[displayNames.length];
        for (int i = 0; i < displayNames.length; ++i) {
            values[i] = (Double)choice.ValueForChoice(displayNames[i]);
        }
        return values;
    }

    public static Choice ExtractDynamicChoice(SerializableForm form) {
        Choice extracted = null;
        try {
            if (form.marker != DataMarker.DynamicChoice) {
                throw new IllegalArgumentException("wrong marker");
            }
            byte associatedSlotIndex = (Byte)form.data[0];
            String lexiconId = (String)form.data[1];
            String defaultDisplayName = (String)form.data[2];
            Object[] allowedValues = ((Array)form.data[3]).array();
            String[] displayNames = (String[])((Array)form.data[4]).array();
            boolean areLabelsEditable = NotationOfDynamicChoice.IsEditable(form, lexiconId);
            extracted = new Choice(NotationOfDynamicChoice.CombineValuesAndTheirNames(allowedValues, displayNames), defaultDisplayName, NotationOfDynamicChoice.GenuineId(associatedSlotIndex, lexiconId), areLabelsEditable);
        }
        catch (Exception e) {
            extracted = null;
        }
        return extracted;
    }

    private static HashMap<Object, String> CombineValuesAndTheirNames(Object[] values, String[] names) {
        HashMap<Object, String> combined = new HashMap<Object, String>();
        for (int i = 0; i < values.length; ++i) {
            combined.put(values[i], names[i]);
        }
        return combined;
    }

    static String GenuineId(byte slotIndex, String explicitId) {
        return null == explicitId || explicitId.isEmpty() ? new String(new byte[]{slotIndex}) : explicitId;
    }

    static boolean IsEditable(SerializableForm form, String lexiconId) {
        if (!lexiconId.contains("labels") || form.data.length < 6) {
            return true;
        }
        return (Boolean)form.data[6];
    }
}

