/*
 * Decompiled with CFR 0.152.
 */
package com.miratech.ifnetclient.Internal;

import com.miratech.ifnetclient.model.IValue;
import com.miratech.ifnetclient.model.Tag;
import com.miratech.ifnetclient.model.Value;
import com.miratech.serialization.DataMarker;
import com.miratech.serialization.SerializableCollection;
import com.miratech.serialization.SerializableForm;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;

public final class NotationOfTags {
    public static final HashMap<String, ValueNotationReader> CustomReaders = new HashMap();

    public static SerializableForm WithTags(SerializableForm.StaticExtensionAnchor staticExtensionAnchor, long elementPersistentId, Tag ... tags) {
        SerializableForm setForm = new SerializableForm(DataMarker.SetOfTags, new Object[]{elementPersistentId}, new SerializableCollection());
        for (Tag next : tags) {
            SerializableForm tagForm = new SerializableForm(DataMarker.Tag, new Object[]{next.getName()});
            tagForm.elements = new SerializableCollection(new SerializableForm[]{NotationOfTags.ValueForm(next.getContent())});
            setForm.elements.Add(tagForm);
        }
        return setForm;
    }

    private static SerializableForm ValueForm(IValue toBeSerialized) {
        return new SerializableForm(DataMarker.TagValue, new Object[]{NotationOfTags.RemoteTypeId(toBeSerialized), toBeSerialized.getTheValueObject()});
    }

    private static String RemoteTypeId(IValue ofValue) {
        if (ofValue.getClass().equals(Value.Number.class)) {
            return "NumericConst";
        }
        if (ofValue.getClass().equals(Value.Text.class)) {
            return "TextConst";
        }
        if (ofValue.getClass().equals(Value.Boolean.class)) {
            return "BinaryConst";
        }
        if (ofValue.getClass().equals(Value.Identifier.class)) {
            return "ReferenceConst";
        }
        if (ofValue.getClass().equals(Value.Date.class)) {
            return "TimeConst";
        }
        if (ofValue.getClass().equals(Value.NoValue.class)) {
            return "NoValue";
        }
        return "NoValue";
    }

    public static Tag[] ExtractTags(SerializableForm serializableForm) {
        Tag[] extracted = null;
        if (null != serializableForm && null != serializableForm.data && serializableForm.marker == DataMarker.SetOfTags && serializableForm.data.length == 1) {
            try {
                long persistentId = (Long)serializableForm.data[0];
                ArrayList<Tag> successfullyExtracted = new ArrayList<Tag>();
                for (SerializableForm subform : serializableForm.elements.toSerializableForms()) {
                    Tag newTag;
                    if (!NotationOfTags.ExtractSingleTag(subform, persistentId, newTag = null)) continue;
                    successfullyExtracted.add(newTag);
                }
                extracted = successfullyExtracted.toArray(new Tag[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return extracted;
    }

    private static boolean ExtractSingleTag(SerializableForm anyForm, long persistentId, Tag extracted) {
        String tagName;
        boolean tempVar;
        IValue tagValue = null;
        extracted = null;
        boolean bl = tempVar = !((anyForm.data[0] instanceof String ? (String)anyForm.data[0] : null) instanceof String);
        String string = tempVar ? null : (tagName = anyForm.data[0] instanceof String ? (String)anyForm.data[0] : null);
        if (anyForm == null || anyForm.marker != DataMarker.Tag || anyForm.data == null || anyForm.data.length != 1 || anyForm.elements == null || anyForm.elements.Count != 1 || !NotationOfTags.ExtractValue(anyForm.elements.First(), persistentId, tagValue) || tempVar || null == tagName || tagName.isEmpty()) {
            return false;
        }
        extracted = Tag.Create(tagName, tagValue);
        return true;
    }

    private static boolean ExtractValue(SerializableForm theForm, long persistentId, IValue extracted) {
        extracted = null;
        if (theForm.marker != DataMarker.TagValue) {
            return false;
        }
        try {
            String typeIdentifier;
            switch (typeIdentifier = theForm.data[0] instanceof String ? (String)theForm.data[0] : null) {
                case "BinaryConst": {
                    extracted = new Value.Boolean((boolean)((Boolean)theForm.data[1]));
                    break;
                }
                case "NumericConst": {
                    extracted = new Value.Number((double)((Double)theForm.data[1]));
                    break;
                }
                case "TimeConst": {
                    extracted = new Value.Date((LocalDateTime)theForm.data[1]);
                    break;
                }
                case "TextConst": {
                    extracted = new Value.Text((String)theForm.data[1]);
                    break;
                }
                case "ReferenceConst": {
                    extracted = new Value.Identifier((String)theForm.data[1]);
                    break;
                }
                case "NoValue": {
                    extracted = new Value.NoValue();
                    break;
                }
                default: {
                    extracted = NotationOfTags.TryUseCustomReader(typeIdentifier, persistentId, theForm.data);
                    break;
                }
            }
        }
        catch (Exception e) {
            extracted = null;
        }
        return extracted != null;
    }

    public static IValue TryUseCustomReader(String typeIdentifier, long persistentId, Object[] withData) {
        Value.CustomReadonlyText.ValueDescriptionProvider customValueSource;
        if (!CustomReaders.containsKey(typeIdentifier)) {
            return NotationOfTags.Fallback();
        }
        Value.CustomReadonlyText.ValueDescriptionProvider valueDescriptionProvider = customValueSource = CustomReaders.get(typeIdentifier) == null ? null : CustomReaders.get(typeIdentifier).invoke(withData, persistentId);
        if (null == customValueSource) {
            return NotationOfTags.Fallback();
        }
        return new Value.CustomReadonlyText(customValueSource);
    }

    static IValue Fallback() {
        return new Value.NoValue();
    }

    private static class RemoteTypeIds {
        public static final String constNr = "NumericConst";
        public static final String constBit = "BinaryConst";
        public static final String constTime = "TimeConst";
        public static final String constTxt = "TextConst";
        public static final String constId = "ReferenceConst";
        public static final String nothing = "NoValue";

        private RemoteTypeIds() {
        }
    }

    @FunctionalInterface
    public static interface ValueNotationReader {
        public Value.CustomReadonlyText.ValueDescriptionProvider invoke(Object[] var1, long var2);
    }
}

