/*
 * Decompiled with CFR 0.152.
 */
package com.miratech.ifnetclient.Internal;

import com.miratech.ifnetclient.model.TrendModels.Trend;
import com.miratech.ifnetclient.model.TrendModels.TrendSample;
import com.miratech.ifnetclient.model.TrendModels.TrendSeries;
import com.miratech.ifnetclient.utils.OutObject;
import com.miratech.serialization.DataMarker;
import com.miratech.serialization.SerializableForm;
import com.miratech.serialization.internal.InvalidCastException;
import java.io.IOException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.TimeZone;
import javax.baja.nre.util.ByteBuffer;

public final class NotationOfTrend {
    private static LocalDateTime ConvertTimeStamp(long unixTimestamp) {
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(unixTimestamp / 1000000L), TimeZone.getDefault().toZoneId());
    }

    public Trend ExtractTrend(ArrayList<SerializableForm> dataForms) {
        try {
            if ((dataForms.get(0) == null ? null : Boolean.valueOf(dataForms.get((int)0).data == null || dataForms.get((int)0).marker != DataMarker.TrendData)).booleanValue()) {
                throw new IllegalArgumentException("wrong marker / empty data");
            }
            long firstSequenceNumber = (Long)dataForms.get((int)0).data[1];
            long[] timestamps = (long[])dataForms.get((int)1).data[0];
            DataStructure[] dataArray = (DataStructure[])dataForms.get((int)1).data[1];
            OutObject<Long> tempOut_lastKnownSequenceNumber = new OutObject<Long>();
            ArrayList<TrendSeries> series = this.CreateTrendSeries(firstSequenceNumber, timestamps, dataArray, tempOut_lastKnownSequenceNumber);
            long lastKnownSequenceNumber = (Long)tempOut_lastKnownSequenceNumber.outArgValue;
            Trend trend = new Trend(series);
            trend.setGuid(dataForms.get((int)0).data[0].toString());
            trend.setLastSequenceNumber(lastKnownSequenceNumber);
            return trend;
        }
        catch (InvalidCastException | IOException | RuntimeException error) {
            System.out.println("failed to deserialize trend data: " + error);
            return null;
        }
    }

    private ArrayList<TrendSeries> CreateTrendSeries(long firstSequenceNumber, long[] timestamps, DataStructure[] dataArray, OutObject<Long> lastKnownSequenceNumber) throws InvalidCastException, IOException {
        lastKnownSequenceNumber.outArgValue = firstSequenceNumber;
        ArrayList<TrendSeries> series = new ArrayList<TrendSeries>();
        TrendSeries trendSeries = new TrendSeries(new ArrayList<TrendSample>());
        for (int sampleIndex = 0; sampleIndex < dataArray.length; ++sampleIndex) {
            OutObject<Long> outObject = lastKnownSequenceNumber;
            Long l = (Long)outObject.outArgValue;
            outObject.outArgValue = (Long)outObject.outArgValue + 1L;
            Long l2 = outObject.outArgValue;
            if (this.HasSampleTimeChanged(dataArray, sampleIndex)) {
                trendSeries.AddSample(new TrendSample(NotationOfTrend.ConvertTimeStamp(timestamps[sampleIndex]), (Long)lastKnownSequenceNumber.outArgValue - 1L, this.ConvertedValue(dataArray, sampleIndex), false, true));
                series.add(trendSeries);
                trendSeries = new TrendSeries(new ArrayList<TrendSample>());
                continue;
            }
            if (this.HasSampleBacnetEvent(dataArray, sampleIndex)) {
                trendSeries.AddSample(new TrendSample(NotationOfTrend.ConvertTimeStamp(timestamps[sampleIndex]), (Long)lastKnownSequenceNumber.outArgValue - 1L, this.ConvertedValue(dataArray, sampleIndex), true, false));
                series.add(trendSeries);
                trendSeries = new TrendSeries(new ArrayList<TrendSample>());
                continue;
            }
            trendSeries.AddSample(new TrendSample(NotationOfTrend.ConvertTimeStamp(timestamps[sampleIndex]), (Long)lastKnownSequenceNumber.outArgValue - 1L, this.ConvertedValue(dataArray, sampleIndex), false, false));
        }
        if (!trendSeries.getSamples().isEmpty()) {
            series.add(trendSeries);
        }
        return series;
    }

    boolean HasSampleTimeChanged(DataStructure[] dataArray, int sampleIndex) {
        return dataArray[sampleIndex].type == DataType.timeChange;
    }

    boolean HasSampleBacnetEvent(DataStructure[] dataArray, int sampleIndex) {
        return dataArray[sampleIndex].type == DataType.logStatus;
    }

    double ConvertedValue(DataStructure[] dataArray, int sampleIndex) throws InvalidCastException, IOException {
        double convertedValue;
        if (dataArray[sampleIndex].type.getValue() == DataType.bool.getValue()) {
            convertedValue = !this.ToBoolean(dataArray[sampleIndex].data) ? 0.0 : 1.0;
        } else if (dataArray[sampleIndex].type.getValue() == DataType.timeChange.getValue()) {
            convertedValue = this.ToDouble(dataArray[sampleIndex].data);
        } else if (dataArray[sampleIndex].type.getValue() == DataType.logStatus.getValue()) {
            convertedValue = this.BacnetStatusConverter(dataArray[sampleIndex].data);
        } else if (dataArray[sampleIndex].type.getValue() == DataType.double_Keyword.getValue()) {
            convertedValue = this.ToDouble(dataArray[sampleIndex].data);
        } else {
            throw new InvalidCastException("Unsupported type");
        }
        return convertedValue;
    }

    private double ToDouble(byte[] data) throws IOException {
        ByteBuffer stream = new ByteBuffer(data, data.length);
        return stream.readDouble();
    }

    private boolean ToBoolean(byte[] data) throws IOException {
        ByteBuffer stream = new ByteBuffer(data, data.length);
        return stream.readBoolean();
    }

    private int ToInt32(byte[] data) throws IOException {
        ByteBuffer stream = new ByteBuffer(data, data.length);
        return stream.readInt();
    }

    private double BacnetStatusConverter(byte[] dataArray) throws IOException {
        int statusCombination = 4;
        byte[] adjustedArray = this.PadByteArray(dataArray, 4);
        int flags = this.ToInt32(adjustedArray);
        return flags;
    }

    byte[] PadByteArray(byte[] inputByteArray, int statusCombination) {
        if (inputByteArray.length >= statusCombination) {
            return inputByteArray;
        }
        byte[] paddedByteArray = new byte[statusCombination];
        System.arraycopy(inputByteArray, 0, paddedByteArray, 0, inputByteArray.length);
        return paddedByteArray;
    }

    private static class DataStructure {
        public DataType type = DataType.values()[0];
        public short size;
        public byte[] data;

        private DataStructure(byte[] bytes) {
            if (bytes == null || bytes.length < 3) {
                throw new IllegalArgumentException("Invalid byte array.");
            }
            this.type = DataType.forValue(bytes[0]);
            this.size = (short)(bytes[1] << 8 | bytes[2]);
            this.data = new byte[bytes.length - 3];
            int i = 3;
            for (int j = bytes.length - 1; j >= 3; --j) {
                this.data[j - 3] = bytes[i];
                ++i;
            }
        }

        public static DataStructure ConvertFromObject(Object obj) {
            byte[] bytes;
            boolean tempVar = obj instanceof byte[];
            byte[] byArray = bytes = tempVar ? (byte[])obj : null;
            if (tempVar) {
                return new DataStructure(bytes);
            }
            throw new ClassCastException("Cannot convert object to DataStructure.");
        }
    }

    private static enum DataType {
        statusFlag(1),
        null_Keyword(2),
        bool(3),
        double_Keyword(4),
        enumerated(5),
        unsigned(6),
        integer(7),
        bitstring(8),
        failure(9),
        timeChange(10),
        logStatus(11);

        public static final int SIZE = 8;
        private static HashMap<Byte, DataType> mappings;
        private byte byteValue;

        private DataType(byte value) {
            this.byteValue = value;
            DataType.getMappings().put(value, this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static HashMap<Byte, DataType> getMappings() {
            if (mappings != null) return mappings;
            Class<DataType> clazz = DataType.class;
            synchronized (DataType.class) {
                if (mappings != null) return mappings;
                mappings = new HashMap();
                // ** MonitorExit[var0] (shouldn't be in output)
                return mappings;
            }
        }

        public static DataType forValue(byte value) {
            return DataType.getMappings().get(value);
        }

        public byte getValue() {
            return this.byteValue;
        }
    }
}

