/*
 * Decompiled with CFR 0.152.
 */
package com.miratech.ifnetclient.comm;

import com.miratech.ifnetclient.Internal.ManualResetEvent;
import com.miratech.ifnetclient.Internal.RequestComplete;
import com.miratech.ifnetclient.comm.Endpoint;
import com.miratech.ifnetclient.comm.HttpImplementation;
import com.miratech.ifnetclient.comm.Request;
import com.miratech.ifnetclient.comm.RequestExecutionImplementation;
import com.miratech.ifnetclient.comm.RequestsQueue;
import com.miratech.ifnetclient.comm.Response;
import com.miratech.ifnetclient.comm.Server;
import com.miratech.ifnetclient.utils.IfnetClientLogger;
import com.miratech.serialization.DataMarker;
import com.miratech.serialization.SerializableForm;
import java.util.logging.Level;
import javax.baja.util.BUuid;

public class Session {
    public Server target;
    Endpoint endpoint;
    private boolean IsConnected;
    private boolean IsDisposed = false;
    private BUuid ID = BUuid.DEFAULT;
    private RequestsQueue pending;

    public Session(final Server withDevice) {
        this.target = withDevice;
        final Session thisSession = this;
        RequestExecutionImplementation HttpProcessing = new RequestExecutionImplementation(){

            @Override
            public RequestExecutionImplementation invoke(Request next) {
                HttpImplementation http = new HttpImplementation();
                http.OnBadResponse.addListener("ProcessConnectionError", withDevice::ProcessConnectionError);
                return (RequestExecutionImplementation)((Object)http.Execute(thisSession, next));
            }
        };
        this.pending = new RequestsQueue(HttpProcessing);
    }

    public final boolean isConnected() {
        return this.IsConnected;
    }

    private void setConnected(boolean value) {
        this.IsConnected = value;
    }

    public final boolean isDisposed() {
        return this.IsDisposed;
    }

    private void setDisposed(boolean value) {
        this.IsDisposed = value;
    }

    public final BUuid getID() {
        return this.ID;
    }

    private void setID(BUuid value) {
        this.ID = value;
    }

    public final int getPendingRequests() {
        return this.pending.getCount();
    }

    public final void SetId(BUuid newValue) {
        this.setID(newValue);
        this.setConnected(!newValue.isNull());
    }

    public final void Kill() {
        this.pending.Kill();
        this.setID(BUuid.DEFAULT);
        this.setDisposed(true);
        this.setConnected(false);
    }

    public final Response Execute(Endpoint endpoint, SerializableForm ... data) {
        this.endpoint = endpoint;
        Response answer = new Response(endpoint);
        if (!this.CheckConnection()) {
            IfnetClientLogger.log(Level.SEVERE, String.format("Can't execute %1$s when not connected.", endpoint));
            return null;
        }
        ManualResetEvent completionEvent = new ManualResetEvent(false);
        RequestComplete requestComplete = new RequestComplete(answer, completionEvent);
        try {
            if (this.pending.Append(endpoint, requestComplete, data)) {
                completionEvent.waitOne();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        answer = requestComplete.getAnswer();
        return answer;
    }

    boolean CheckConnection() {
        this.IsConnected &= this.endpoint.marker != DataMarker.ConnectRequest;
        return this.IsConnected || this.endpoint.marker == DataMarker.ConnectRequest || this.endpoint.marker == DataMarker.AuthorizationRequest;
    }
}

