/*
 * Decompiled with CFR 0.152.
 */
package com.miratech.ifnetclient.model.CacheModels;

import com.miratech.ifnetclient.model.TrendModels.Trend;
import com.miratech.ifnetclient.model.TrendModels.TrendSample;
import com.miratech.ifnetclient.model.TrendModels.TrendSeries;
import java.util.HashMap;
import java.util.List;

public class TrendsCache {
    public HashMap<String, Trend> cachedTrends = new HashMap();

    public Trend getTrend(String id) {
        if (this.cachedTrends.keySet().contains(id)) {
            return this.cachedTrends.get(id);
        }
        return null;
    }

    public void addOrUpdate(String id, Trend trend) {
        if (null == id || null == trend) {
            return;
        }
        if (this.cachedTrends.keySet().contains(id)) {
            this.patchTrend(id, trend);
        } else {
            this.addTrend(id, trend);
        }
    }

    public void delete(String id) {
        if (null == id) {
            return;
        }
        if (this.cachedTrends.keySet().contains(id)) {
            this.removeTrend(id);
        }
    }

    private void patchTrend(String id, Trend trend) {
        if (!this.hasTrendAnySamples(trend)) {
            return;
        }
        Trend toPatch = this.cachedTrends.get(id);
        if (this.hasLastCachedSampleBreakEvent(toPatch) || !this.hasCachedTrendAnySeries(toPatch)) {
            this.appendSeries(toPatch, trend.getTrendSeries());
        } else {
            this.patchOldestSeriesAndPopFromArrivedData(toPatch, trend.getTrendSeries());
            this.appendRemainingSeries(toPatch, trend.getTrendSeries());
        }
        toPatch.setLastSequenceNumber(trend.getLastSequenceNumber());
    }

    private boolean hasTrendAnySamples(Trend trend) {
        return !trend.getTrendSeries().isEmpty();
    }

    private boolean hasLastCachedSampleBreakEvent(Trend toPatch) {
        if (toPatch.getTrendSeries().isEmpty()) {
            return false;
        }
        TrendSeries lastTrendSeries = toPatch.getTrendSeries().get(toPatch.getTrendSeries().size() - 1);
        if (lastTrendSeries.getSamples().isEmpty()) {
            return false;
        }
        TrendSample lastSample = lastTrendSeries.getSamples().get(lastTrendSeries.getSamples().size() - 1);
        return !lastSample.isTimeChanged() || !lastSample.isBacnetStatus();
    }

    boolean hasCachedTrendAnySeries(Trend toPatch) {
        return !toPatch.getTrendSeries().isEmpty();
    }

    private void addTrend(String id, Trend trend) {
        this.cachedTrends.put(id, trend);
    }

    private void appendSeries(Trend toPatch, List<TrendSeries> trendSeries) {
        for (TrendSeries entry : trendSeries) {
            toPatch.getTrendSeries().add(entry);
        }
    }

    private void appendRemainingSeries(Trend toPatch, List<TrendSeries> trendSeries) {
        this.appendSeries(toPatch, trendSeries);
    }

    private void patchOldestSeriesAndPopFromArrivedData(Trend toPatch, List<TrendSeries> trendSeries) {
        if (trendSeries.isEmpty()) {
            return;
        }
        TrendSeries oldestSeries = trendSeries.get(0);
        trendSeries.remove(0);
        if (!toPatch.getTrendSeries().isEmpty()) {
            TrendSeries last = toPatch.getTrendSeries().get(toPatch.getTrendSeries().size() - 1);
            for (TrendSample sample : oldestSeries.getSamples()) {
                last.getSamples().add(sample);
            }
        } else {
            toPatch.getTrendSeries().add(oldestSeries);
        }
    }

    private void removeTrend(String id) {
        this.cachedTrends.remove(id);
    }
}

