/*
 * Decompiled with CFR 0.152.
 */
package com.miratech.ifnetclient.model;

import com.miratech.ifnetclient.model.ISlotModifier;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class Choice
implements ISlotModifier {
    private static int createdInstances = 1;
    private int instanceNr = 1;
    private HashMap<Object, String> definedChoices;
    private String displayNameForUnknownValue;
    private boolean isEditable;
    private String Id;

    public Choice(HashMap<Object, String> withOptions, String withDefaultName, String withId) {
        new Choice(withOptions, withDefaultName, withId, true);
    }

    public Choice(HashMap<Object, String> withOptions, String withDefaultName, String withId, boolean isEditable) {
        this.definedChoices = withOptions;
        this.displayNameForUnknownValue = withDefaultName;
        this.Id = withId;
        this.instanceNr = createdInstances++;
        this.isEditable = isEditable;
    }

    public static Choice Empty() {
        return Choice.Empty("", true);
    }

    public static Choice Empty(String withId, boolean isEditable) {
        return new Choice(new HashMap<Object, String>(), "", withId, isEditable);
    }

    public static Choice FromRangeAttribute(String attributeData) {
        double currentValue = -1.0;
        HashMap<Object, String> valuesAndNames = new HashMap<Object, String>();
        for (String option : attributeData.split("[,]", -1)) {
            String[] valueAndName = option.split("=");
            currentValue = valueAndName.length > 1 ? Double.parseDouble(valueAndName[0]) : (currentValue += 1.0);
            valuesAndNames.put(currentValue, valueAndName[valueAndName.length - 1]);
        }
        return new Choice(valuesAndNames, "", "range_attribute");
    }

    public String toString() {
        return String.format("%1$s:%2$s", this.getId(), this.instanceNr);
    }

    public boolean isEditable() {
        return this.isEditable;
    }

    public final String getId() {
        return this.Id;
    }

    public final String[] AllowedChoicesNames() {
        return this.definedChoices.values().size() > 0 ? (String[])this.definedChoices.values().toArray() : new String[]{};
    }

    public final String DisplayNameForValue(Object value) {
        if (value == null) {
            return this.displayNameForUnknownValue;
        }
        if (this.definedChoices.containsKey(value)) {
            return this.definedChoices.get(value);
        }
        return this.Count() > 0 ? this.displayNameForUnknownValue : value.toString();
    }

    public final String DisplayNameForUnknownValue() {
        return this.displayNameForUnknownValue;
    }

    public final Object ValueForChoice(String chosenDisplayName) {
        if (this.definedChoices.containsValue(chosenDisplayName)) {
            return this.definedChoices.get(chosenDisplayName);
        }
        return null;
    }

    public int Count() {
        return this.definedChoices.size();
    }

    public boolean IsRestricted() {
        return this.Count() > 0;
    }

    public boolean IsUnrestricted() {
        return this.Count() == 0;
    }

    public int hashCode() {
        int hash = this.getId() != null ? this.getId().hashCode() : 0;
        hash = hash * 397 ^ (this.displayNameForUnknownValue != null ? this.displayNameForUnknownValue.hashCode() : 0);
        for (Map.Entry<Object, String> entry : this.definedChoices.entrySet()) {
            hash = hash * 397 ^ (entry.getKey() != null ? entry.getKey().hashCode() : 0);
            hash = hash * 397 ^ (entry.getValue() != null ? entry.getValue().hashCode() : 0);
        }
        return hash;
    }

    public final boolean equals(Choice other) {
        if (other == null) {
            return false;
        }
        return (this.getId() == other.getId() || this.getId() != null && this.getId().equals(other.getId())) && Objects.equals(this.displayNameForUnknownValue, other.displayNameForUnknownValue) && Objects.equals(this.definedChoices, other.definedChoices);
    }
}

