/*
 * Decompiled with CFR 0.152.
 */
package com.miratech.ifnetclient.model.scheduleLogic;

import com.miratech.ifnetclient.model.scheduleLogic.Dependencies;
import com.miratech.ifnetclient.model.scheduleLogic.ISchedule;
import com.miratech.ifnetclient.model.scheduleLogic.IrregularDays;
import com.miratech.ifnetclient.model.scheduleLogic.ScheduleValue;
import java.math.BigInteger;
import java.time.LocalDateTime;

public class DaysFromCalendar
extends IrregularDays {
    private String CalendarPersistentId;

    public final String getCalendarPersistentId() {
        return this.CalendarPersistentId;
    }

    private void setCalendarPersistentId(String value) {
        this.CalendarPersistentId = value;
    }

    public DaysFromCalendar() {
    }

    public DaysFromCalendar(String persistentId) {
        this.setCalendarPersistentId(persistentId);
    }

    private LocalDateTime NearestActiveDay(LocalDateTime since) {
        if (this.CalendarDisabled() || this.CalendarOverriddenToInactive()) {
            return LocalDateTime.MAX;
        }
        if (since.toLocalDate().equals(Dependencies.LocalNow().toLocalDate())) {
            if (Dependencies.IsCalendarActive(this.getCalendarPersistentId())) {
                return since;
            }
            since.plus(ScheduleValue.dayLength);
        }
        LocalDateTime nearestDay = LocalDateTime.MAX;
        for (ISchedule possibility : Dependencies.DaysForCalendar(this.getCalendarPersistentId())) {
            LocalDateTime nextOccurance = null;
            if (!possibility.NearestRelevantDay(since, nextOccurance) || nextOccurance.isEqual(nearestDay) || nextOccurance.isAfter(nearestDay)) continue;
            if (since.toLocalDate().equals(nextOccurance.toLocalDate())) {
                return nextOccurance;
            }
            nearestDay = nextOccurance;
        }
        return nearestDay;
    }

    private boolean CalendarDisabled() {
        return false == Dependencies.IsCalendarEnabled(this.getCalendarPersistentId());
    }

    private boolean CalendarOverriddenToInactive() {
        return Dependencies.IsCalendarOverridden(this.getCalendarPersistentId()) && false == Dependencies.IsCalendarActive(this.getCalendarPersistentId());
    }

    @Override
    public boolean NearestRelevantDay(LocalDateTime since, LocalDateTime nearestOccurence) {
        nearestOccurence = this.NearestActiveDay(since);
        return nearestOccurence.compareTo(LocalDateTime.MAX) < 0;
    }

    @Override
    protected void SetRawData(Object rawData) {
        this.setCalendarPersistentId(rawData.toString());
    }

    @Override
    protected Object RawData() {
        return this.getCalendarPersistentId();
    }

    @Override
    protected boolean ValidateRawData(Object rawData) {
        try {
            BigInteger casted = (BigInteger)rawData;
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @FunctionalInterface
    public static interface CalendarData {
        public ISchedule[] invoke();
    }
}

