/*
 * Decompiled with CFR 0.152.
 */
package com.miratech.ifnetclient.model.scheduleLogic;

import com.miratech.ifnetclient.model.scheduleLogic.DoubleComparer;
import com.miratech.ifnetclient.model.scheduleLogic.Sorting;
import java.time.Duration;

public class EventsTable {
    private final Object access = new Object();
    public Duration coveredPeriod = Duration.ZERO;
    private long[] changeTimes = new long[0];
    private double[] values = new double[0];
    private static final int DefaultValueAtStart = -1;
    private static final int NoNextValue = -2;
    private static final int Error = -3;

    public final int getCount() {
        return this.changeTimes.length;
    }

    public final boolean isEmpty() {
        return this.getCount() <= 0;
    }

    public EventsTable(Duration forPeriod) {
        this.coveredPeriod = forPeriod;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean ValuesForTime(Duration timeInPeriod, Double actualValue, Duration toNextChange, Double nextValue) {
        Object object = this.access;
        synchronized (object) {
            if (this.getCount() == 0) {
                actualValue = nextValue = Double.valueOf(Double.NaN);
                toNextChange = Duration.ZERO;
                return false;
            }
            int timeInSeconds = (int)timeInPeriod.getSeconds() + 1;
            actualValue = this.ActualValue(this.IndexOfActualValue(timeInSeconds));
            int iNext = this.IndexOfNearestChange(timeInSeconds);
            if (iNext == -2) {
                nextValue = actualValue;
                toNextChange = this.coveredPeriod;
                return true;
            }
            if (iNext == -3) {
                System.out.println("failed to calculate weekly schedule");
                actualValue = nextValue = Double.valueOf(Double.NaN);
                toNextChange = Duration.ZERO;
                return false;
            }
            if (iNext >= this.getCount()) {
                iNext -= this.getCount();
            }
            nextValue = iNext == -1 ? Double.NaN : this.values[iNext];
            toNextChange = this.TimeOfNextChange(iNext).minus(Duration.ofSeconds(timeInSeconds - 1));
            return true;
        }
    }

    Duration TimeOfNextChange(int indexOfNextChange) {
        return indexOfNextChange == -1 ? Duration.ZERO : Duration.ofSeconds(this.changeTimes[indexOfNextChange]);
    }

    private int IndexOfActualValue(int secondsSinceStart) {
        for (int i = 0; i < this.getCount(); ++i) {
            if (this.changeTimes[i] < (long)secondsSinceStart) continue;
            return i - 1;
        }
        return this.changeTimes.length - 1;
    }

    private int IndexOfNearestChange(int secondsSinceStartOfWeek) {
        for (int i = 0; i < this.getCount(); ++i) {
            if (this.changeTimes[i] <= (long)secondsSinceStartOfWeek) continue;
            return i;
        }
        double endValue = this.values[this.getCount() - 1];
        if (this.changeTimes[0] > 0L && !Double.isNaN(endValue)) {
            return -1;
        }
        if (this.changeTimes[0] == 0L && DoubleComparer.IsDifferentThan(endValue, this.values[0])) {
            return 0;
        }
        if (this.IsAllTheSame()) {
            return -2;
        }
        for (int i = 0; i < this.getCount() - 1; ++i) {
            if (DoubleComparer.IsEqualTo(endValue, this.values[i])) continue;
            return i + this.getCount();
        }
        return -3;
    }

    private boolean IsEndTheSameAsStart() {
        return this.getCount() == 0 || DoubleComparer.IsEqualTo(this.InitialValue(), this.EndValue());
    }

    private double InitialValue() {
        return this.changeTimes[0] == 0L ? this.values[0] : Double.NaN;
    }

    private double EndValue() {
        return this.values[this.values.length - 1];
    }

    private boolean IsAllTheSame() {
        if (this.changeTimes.length == 0) {
            return true;
        }
        if (this.changeTimes.length == 1 && this.changeTimes[0] == 0L) {
            return true;
        }
        for (int i = 0; i < this.values.length; ++i) {
            if (!DoubleComparer.IsDifferentThan(this.values[i], this.values[0])) continue;
            return false;
        }
        if (this.changeTimes[0] > 0L) {
            return DoubleComparer.IsEqualTo(this.values[0], Double.NaN);
        }
        return true;
    }

    private double ActualValue(int index) {
        return index < 0 ? Double.NaN : this.values[index];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long[] GetChangeTimes() {
        Object object = this.access;
        synchronized (object) {
            long[] secondsOfChange = new long[this.changeTimes.length];
            System.arraycopy(this.changeTimes, 0, secondsOfChange, 0, this.changeTimes.length);
            return secondsOfChange;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final double[] GetValues() {
        Object object = this.access;
        synchronized (object) {
            double[] scheduledValues = new double[this.values.length];
            System.arraycopy(this.values, 0, scheduledValues, 0, this.values.length);
            return scheduledValues;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean Set(long[] newChangeTimes, double[] newValues) {
        if (!this.Validate(newChangeTimes, newValues)) {
            System.out.println("Wrong data to set in EventsTable");
            return false;
        }
        Sorting.SortChangeTimes(newChangeTimes, newValues);
        Object object = this.access;
        synchronized (object) {
            this.changeTimes = newChangeTimes != null ? newChangeTimes : new long[]{};
            this.values = newValues != null ? newValues : new double[]{};
            return true;
        }
    }

    boolean Validate(long[] newChangeTimes, double[] newValues) {
        return newChangeTimes == null || newChangeTimes.length == newValues.length;
    }
}

