/*
 * Decompiled with CFR 0.152.
 */
package com.miratech.ifnetclient.model.scheduleLogic;

import com.miratech.ifnetclient.model.scheduleLogic.Category;
import com.miratech.ifnetclient.model.scheduleLogic.DayOfMonth;
import com.miratech.ifnetclient.model.scheduleLogic.IrregularDays;
import com.miratech.ifnetclient.model.scheduleLogic.Month;
import com.miratech.ifnetclient.model.scheduleLogic.ScheduleValue;
import com.miratech.ifnetclient.model.scheduleLogic.WeekOfMonth;
import java.time.DayOfWeek;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.YearMonth;
import javax.baja.nre.util.Array;
import javax.baja.sys.BLong;

public class ExceptionalDays
extends IrregularDays {
    private final byte[] daysData = new byte[11];
    public static final int Wildcard = 255;
    public static final int Wildcard16bit = 65535;
    public static final AnchorForVocabulary Vocabulary = new AnchorForVocabulary();

    public ExceptionalDays() {
    }

    private ExceptionalDays(Category ofCategory, DayOfWeek dayOfWeek, WeekOfMonth weekOfMonth, DayOfMonth dayOfMonthForStartDate, Month monthForStartDate, int yearForStartDate, DayOfMonth dayOfMonthForEndDate, Month monthForEndDate) {
        this(ofCategory, dayOfWeek, weekOfMonth, dayOfMonthForStartDate, monthForStartDate, yearForStartDate, dayOfMonthForEndDate, monthForEndDate, 65535);
    }

    private ExceptionalDays(Category ofCategory, DayOfWeek dayOfWeek, WeekOfMonth weekOfMonth, DayOfMonth dayOfMonthForStartDate, Month monthForStartDate, int yearForStartDate, DayOfMonth dayOfMonthForEndDate) {
        this(ofCategory, dayOfWeek, weekOfMonth, dayOfMonthForStartDate, monthForStartDate, yearForStartDate, dayOfMonthForEndDate, Month.Any, 65535);
    }

    private ExceptionalDays(Category ofCategory, DayOfWeek dayOfWeek, WeekOfMonth weekOfMonth, DayOfMonth dayOfMonthForStartDate, Month monthForStartDate, int yearForStartDate) {
        this(ofCategory, dayOfWeek, weekOfMonth, dayOfMonthForStartDate, monthForStartDate, yearForStartDate, DayOfMonth.Any, Month.Any, 65535);
    }

    private ExceptionalDays(Category ofCategory, DayOfWeek dayOfWeek, WeekOfMonth weekOfMonth, DayOfMonth dayOfMonthForStartDate, Month monthForStartDate) {
        this(ofCategory, dayOfWeek, weekOfMonth, dayOfMonthForStartDate, monthForStartDate, 65535, DayOfMonth.Any, Month.Any, 65535);
    }

    private ExceptionalDays(Category ofCategory, DayOfWeek dayOfWeek, WeekOfMonth weekOfMonth, DayOfMonth dayOfMonthForStartDate) {
        this(ofCategory, dayOfWeek, weekOfMonth, dayOfMonthForStartDate, Month.Any, 65535, DayOfMonth.Any, Month.Any, 65535);
    }

    private ExceptionalDays(Category ofCategory, DayOfWeek dayOfWeek, WeekOfMonth weekOfMonth) {
        this(ofCategory, dayOfWeek, weekOfMonth, DayOfMonth.Any, Month.Any, 65535, DayOfMonth.Any, Month.Any, 65535);
    }

    private ExceptionalDays(Category ofCategory, DayOfWeek dayOfWeek) {
        this(ofCategory, dayOfWeek, WeekOfMonth.Any, DayOfMonth.Any, Month.Any, 65535, DayOfMonth.Any, Month.Any, 65535);
    }

    private ExceptionalDays(Category ofCategory) {
        this(ofCategory, DayOfWeek.of(255), WeekOfMonth.Any, DayOfMonth.Any, Month.Any, 65535, DayOfMonth.Any, Month.Any, 65535);
    }

    private ExceptionalDays(Category ofCategory, DayOfWeek dayOfWeek, WeekOfMonth weekOfMonth, DayOfMonth dayOfMonthForStartDate, Month monthForStartDate, int yearForStartDate, DayOfMonth dayOfMonthForEndDate, Month monthForEndDate, int yearForEndDate) {
        this.daysData[0] = (byte)ofCategory.getValue();
        this.daysData[1] = (byte)(dayOfWeek == null ? -1 : (byte)(dayOfWeek.getValue() == 7 ? 0 : (byte)dayOfWeek.getValue()));
        this.daysData[2] = (byte)weekOfMonth.getValue();
        this.daysData[3] = (byte)dayOfMonthForStartDate.getValue();
        this.daysData[4] = (byte)monthForStartDate.getValue();
        this.daysData[5] = (byte)yearForStartDate;
        this.daysData[6] = (byte)(yearForStartDate >>> 8);
        this.daysData[7] = (byte)dayOfMonthForEndDate.getValue();
        this.daysData[8] = (byte)monthForEndDate.getValue();
        this.daysData[9] = (byte)yearForEndDate;
        this.daysData[10] = (byte)(yearForEndDate >>> 8);
    }

    public final Category Kind() {
        return Category.forValue(this.daysData[0]);
    }

    public final DayOfWeek getChosenDayOfWeek() {
        return this.daysData[1] == 0 ? DayOfWeek.of(7) : DayOfWeek.of(this.daysData[1]);
    }

    public final WeekOfMonth getChosenWeekOfMonth() {
        return WeekOfMonth.forValue(this.daysData[2]);
    }

    public final DayOfMonth getStartDateDayOfMonth() {
        return DayOfMonth.forValue(this.daysData[3]);
    }

    public final Month getStartDateMonthOfYear() {
        return Month.forValue(this.daysData[4]);
    }

    public final int getStartDateYear() {
        return this.ReadUshortAtOffset(5);
    }

    public final DayOfMonth getEndDateDayOfMonth() {
        return DayOfMonth.forValue(this.daysData[7]);
    }

    public final Month getEndDateMonthOfYear() {
        return Month.forValue(this.daysData[8]);
    }

    public final int getEndDateYear() {
        return this.ReadUshortAtOffset(9);
    }

    private short ReadUshortAtOffset(int offset) {
        return (short)(((this.daysData[offset + 1] & 0xFF) << 8) + (this.daysData[offset] & 0xFF));
    }

    @Override
    public Object RawData() {
        return this.daysData;
    }

    @Override
    protected boolean ValidateRawData(Object rawData) {
        boolean ok = false;
        try {
            byte[] daysDefinition = (byte[])((Array)rawData).array()[0];
            ok = daysDefinition.length == this.daysData.length;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ok;
    }

    @Override
    protected void SetRawData(Object rawData) {
        byte[] daysDefinition = (byte[])((Array)rawData).array()[0];
        for (int i = 0; i < this.daysData.length; ++i) {
            this.daysData[i] = daysDefinition[i];
        }
    }

    public static ExceptionalDays DatePattern(DayOfWeek weekday, DayOfMonth monthday, Month month, int year) {
        return new ExceptionalDays(Category.DatePattern, weekday, WeekOfMonth.Any, monthday, month, year, monthday, month, year);
    }

    public static ExceptionalDays DayAndWeek(DayOfWeek weekday, WeekOfMonth week, Month month) {
        return new ExceptionalDays(Category.WeekAndDay, weekday, week, DayOfMonth.Any, month, 65535, DayOfMonth.Any, month, 65535);
    }

    public static ExceptionalDays DateRange(DayOfMonth startMonthday, Month startMonth, int startYear, DayOfMonth endMonthday, Month endMonth, int endYear) {
        return new ExceptionalDays(Category.DateRange, null, WeekOfMonth.Any, startMonthday, startMonth, startYear, endMonthday, endMonth, endYear);
    }

    public static ExceptionalDays RepeatableDateRange(DayOfMonth startMonthday, Month startMonth, DayOfMonth endMonthday, Month endMonth) {
        return new ExceptionalDays(Category.DateRange, DayOfWeek.of(255), WeekOfMonth.Any, startMonthday, startMonth, 65535, endMonthday, endMonth, 65535);
    }

    @Override
    public boolean NearestRelevantDay(LocalDateTime someTime, LocalDateTime nearestRelevantDay) {
        for (int i = 0; i < 8; ++i) {
            try {
                LocalDateTime nearestMatch = LocalDateTime.now();
                if (this.Kind().equals((Object)Category.WeekAndDay)) {
                    if (this.CalculateCustom(someTime, nearestRelevantDay)) {
                        nearestRelevantDay = nearestMatch;
                        return true;
                    }
                    if (this.Kind().equals((Object)Category.DatePattern)) {
                        if (this.CalculateCustom(someTime, nearestRelevantDay)) {
                            nearestRelevantDay = nearestMatch;
                            return true;
                        }
                        if (this.Kind().equals((Object)Category.DateRange)) {
                            if (this.CalculateDateRange(someTime, nearestRelevantDay)) {
                                nearestRelevantDay = nearestMatch;
                                return true;
                            }
                            throw new UnsupportedOperationException(String.format("Scheduled event category not supported: %1$s", new Object[]{this.Kind()}));
                        }
                    }
                }
                someTime = nearestMatch;
                continue;
            }
            catch (Exception e) {
                nearestRelevantDay = LocalDateTime.MAX;
                return false;
            }
        }
        nearestRelevantDay = LocalDateTime.MAX;
        return false;
    }

    boolean CalculateCustom(LocalDateTime atSomeTime, LocalDateTime nearestSimilarDay) {
        Duration delay = this.TillMatchForDayOfWeek(atSomeTime);
        delay = delay.plus(this.TillMatchForWeekOfMonth(atSomeTime.plus(delay)));
        delay = delay.plus(this.TillMatchForDayOfMonth(atSomeTime.plus(delay)));
        delay = delay.plus(this.TillMatchForMonth(atSomeTime.plus(delay)));
        if ((delay = delay.plus(this.TillMatchForYear(atSomeTime.plus(delay)))).equals(Duration.ofMillis(BLong.MAX.getLong()))) {
            nearestSimilarDay = LocalDateTime.MAX;
            return false;
        }
        nearestSimilarDay = atSomeTime.plus(delay);
        return delay.compareTo(Duration.ofMillis(BLong.MAX.getLong())) < 0 && this.IsDayOfWeekMatched(nearestSimilarDay) && this.IsWeekOfMonthMatched(nearestSimilarDay) && this.IsDayOfMonthMatched(nearestSimilarDay) && this.IsMonthOfYearMatched(nearestSimilarDay);
    }

    boolean CalculateDateRange(LocalDateTime atSomeTime, LocalDateTime nearestSimilarDay) {
        LocalDateTime start = this.StartDate(atSomeTime);
        LocalDateTime end = this.EndDateForRange(atSomeTime);
        nearestSimilarDay = start.isBefore(atSomeTime) ? atSomeTime : start;
        boolean isAlreadyStarted = start.isBefore(atSomeTime) || start.isEqual(atSomeTime);
        boolean isNotYetFinished = end.isAfter(atSomeTime) || end.isEqual(atSomeTime);
        return isNotYetFinished && isAlreadyStarted;
    }

    private LocalDateTime StartDate(LocalDateTime forMoment) {
        if (this.IsStartWildcard()) {
            return LocalDateTime.MIN;
        }
        if (this.IsNotRepeatableEveryYear()) {
            return LocalDateTime.of(LocalDate.of(this.getStartDateYear(), this.getStartDateMonthOfYear().getValue(), this.getStartDateDayOfMonth().getValue()), LocalTime.MIN);
        }
        if (this.IsWholeEventInOneYear() && this.DidFinishForThisYear(forMoment)) {
            return this.RepeatableStartInYear(forMoment.getYear() + 1);
        }
        if (!this.IsWholeEventInOneYear() && !this.DidFinishForThisYear(forMoment)) {
            return this.RepeatableStartInYear(forMoment.getYear() - 1);
        }
        return this.RepeatableStartInYear(forMoment.getYear());
    }

    boolean IsStartWildcard() {
        return this.getStartDateDayOfMonth() == DayOfMonth.Any && this.getStartDateMonthOfYear() == Month.Any && this.getStartDateYear() == 65535;
    }

    boolean DidFinishForThisYear(LocalDateTime momentInYear) {
        return momentInYear.isAfter(this.RepeatableEndInYear(momentInYear.getYear()));
    }

    private LocalDateTime EndDateForRange(LocalDateTime forMoment) {
        if (this.IsEndWildcard()) {
            return LocalDateTime.MAX;
        }
        if (this.IsNotRepeatableEveryYear()) {
            return LocalDateTime.of(LocalDate.of(this.getEndDateYear(), this.getEndDateMonthOfYear().getValue(), this.getEndDateDayOfMonth().getValue()), LocalTime.MIN);
        }
        if (!this.IsWholeEventInOneYear() && this.DidStartForThisYear(forMoment)) {
            return this.RepeatableEndInYear(forMoment.getYear() + 1);
        }
        return this.RepeatableEndInYear(forMoment.getYear());
    }

    boolean IsEndWildcard() {
        return this.getEndDateDayOfMonth() == DayOfMonth.Any && this.getEndDateMonthOfYear() == Month.Any && this.getEndDateYear() == 65535;
    }

    boolean DidStartForThisYear(LocalDateTime momentInYear) {
        return momentInYear.isAfter(this.RepeatableStartInYear(momentInYear.getYear())) || momentInYear.isEqual(this.RepeatableStartInYear(momentInYear.getYear()));
    }

    private boolean IsNotRepeatableEveryYear() {
        return (this.getStartDateYear() & this.getEndDateYear()) != 65535;
    }

    private LocalDateTime RepeatableEndInYear(int year) {
        return LocalDateTime.of(LocalDate.of(year, this.getEndDateMonthOfYear().getValue(), this.getEndDateDayOfMonth().getValue()), LocalTime.MIN);
    }

    private LocalDateTime RepeatableStartInYear(int year) {
        return LocalDateTime.of(LocalDate.of(year, this.getStartDateMonthOfYear().getValue(), this.getStartDateDayOfMonth().getValue()), LocalTime.MIN);
    }

    private boolean IsWholeEventInOneYear() {
        return this.RepeatableStartInYear(2024).compareTo(this.RepeatableEndInYear(2024)) < 0;
    }

    private Duration TillMatchForDayOfWeek(LocalDateTime someTime) {
        if ((byte)this.getChosenDayOfWeek().getValue() == 255 || someTime.getDayOfWeek() == this.getChosenDayOfWeek()) {
            return Duration.ZERO;
        }
        int difference = this.getChosenDayOfWeek().getValue() - someTime.getDayOfWeek().getValue();
        if (difference < 0) {
            difference += 7;
        }
        LocalDateTime startOfValidDay = someTime.plus(Duration.ofDays(difference));
        return Duration.between(startOfValidDay, someTime);
    }

    private Duration TillMatchForWeekOfMonth(LocalDateTime someTime) {
        if (this.getChosenWeekOfMonth() == WeekOfMonth.Any || this.IsWeekOfMonthMatched(someTime)) {
            return Duration.ZERO;
        }
        LocalDateTime furtherDate = this.FirstDayOfChoosenWeekOfMonth(someTime);
        if (furtherDate.compareTo(someTime) < 0) {
            YearMonth yearMonthObject = YearMonth.of(someTime.getYear(), someTime.getMonthValue());
            int daysTillEndOfMonth = yearMonthObject.lengthOfMonth() - someTime.getDayOfMonth();
            furtherDate = this.FirstDayOfChoosenWeekOfMonth(someTime.plus(Duration.ofDays(daysTillEndOfMonth + 1)));
        }
        int weeksIn8years = 417;
        for (int i = 0; i < weeksIn8years; ++i) {
            if (this.IsWeekOfMonthMatched(furtherDate)) {
                return Duration.between(furtherDate, someTime);
            }
            furtherDate.plus(ScheduleValue.weekLength);
        }
        return Duration.ofMillis(Long.MAX_VALUE);
    }

    private boolean IsDayOfWeekMatched(LocalDateTime atTime) {
        return this.getChosenDayOfWeek() == DayOfWeek.of(255) || this.getChosenDayOfWeek() == atTime.getDayOfWeek();
    }

    private boolean IsWeekOfMonthMatched(LocalDateTime someDate) {
        boolean isWeekOfMonthMatched = false;
        isWeekOfMonthMatched = this.getChosenWeekOfMonth().equals((Object)WeekOfMonth.Days1to7) || this.getChosenWeekOfMonth().equals((Object)WeekOfMonth.Days8to14) || this.getChosenWeekOfMonth().equals((Object)WeekOfMonth.Days15to21) || this.getChosenWeekOfMonth().equals((Object)WeekOfMonth.Days22to28) || this.getChosenWeekOfMonth().equals((Object)WeekOfMonth.Days29to31) ? this.getChosenWeekOfMonth() == this.FullWeekOfMonth(someDate) : (this.getChosenWeekOfMonth().equals((Object)WeekOfMonth.Days1to7tillEnd) || this.getChosenWeekOfMonth().equals((Object)WeekOfMonth.Days8to14tillEnd) || this.getChosenWeekOfMonth().equals((Object)WeekOfMonth.Days15to21tillEnd) || this.getChosenWeekOfMonth().equals((Object)WeekOfMonth.Days22to28tillEnd) ? this.getChosenWeekOfMonth() == this.ReversedWeekOfMonth(someDate) : true);
        return isWeekOfMonthMatched;
    }

    private LocalDateTime FirstDayOfChoosenWeekOfMonth(LocalDateTime sometime) {
        int chosenDayOfMonth = 0;
        if (this.getChosenWeekOfMonth().equals((Object)WeekOfMonth.Days1to7)) {
            chosenDayOfMonth = 1;
        } else if (this.getChosenWeekOfMonth().equals((Object)WeekOfMonth.Days8to14)) {
            chosenDayOfMonth = 8;
        } else if (this.getChosenWeekOfMonth().equals((Object)WeekOfMonth.Days15to21)) {
            chosenDayOfMonth = 15;
        } else if (this.getChosenWeekOfMonth().equals((Object)WeekOfMonth.Days22to28)) {
            chosenDayOfMonth = 22;
        } else if (this.getChosenWeekOfMonth().equals((Object)WeekOfMonth.Days29to31)) {
            chosenDayOfMonth = 29;
        } else if (this.getChosenWeekOfMonth().equals((Object)WeekOfMonth.Days1to7tillEnd)) {
            chosenDayOfMonth = LocalDateTime.of(LocalDate.of(sometime.getYear(), sometime.getMonthValue(), 1), LocalTime.now()).getDayOfMonth() - 6;
        } else if (this.getChosenWeekOfMonth().equals((Object)WeekOfMonth.Days8to14tillEnd)) {
            chosenDayOfMonth = LocalDateTime.of(LocalDate.of(sometime.getYear(), sometime.getMonthValue(), 1), LocalTime.now()).getDayOfMonth() - 13;
        } else if (this.getChosenWeekOfMonth().equals((Object)WeekOfMonth.Days15to21tillEnd)) {
            chosenDayOfMonth = LocalDateTime.of(LocalDate.of(sometime.getYear(), sometime.getMonthValue(), 1), LocalTime.now()).getDayOfMonth() - 20;
        } else if (!this.getChosenWeekOfMonth().equals((Object)WeekOfMonth.Days22to28tillEnd)) {
            chosenDayOfMonth = sometime.getDayOfMonth();
        }
        return LocalDateTime.of(LocalDate.of(sometime.getYear(), sometime.getMonthValue(), chosenDayOfMonth), LocalTime.now());
    }

    Duration TimeToEndOfMonth(LocalDateTime someTime) {
        Duration oneDay = Duration.ofDays(1L);
        Duration days = Duration.ZERO;
        while (someTime.plus(days).getMonth() == someTime.getMonth()) {
            days = days.plus(oneDay);
        }
        return days.minus(Duration.ofMillis(someTime.toLocalTime().getNano() * 1000000));
    }

    WeekOfMonth ReversedWeekOfMonth(LocalDateTime forDate) {
        Duration tillEnd = this.TimeToEndOfMonth(forDate);
        if (tillEnd.toDays() <= 7L) {
            return WeekOfMonth.Days1to7tillEnd;
        }
        if (tillEnd.toDays() <= 14L) {
            return WeekOfMonth.Days8to14tillEnd;
        }
        if (tillEnd.toDays() <= 21L) {
            return WeekOfMonth.Days15to21tillEnd;
        }
        if (tillEnd.toDays() <= 28L) {
            return WeekOfMonth.Days22to28tillEnd;
        }
        return WeekOfMonth.forValue(255);
    }

    WeekOfMonth FullWeekOfMonth(LocalDateTime forDate) {
        if (forDate.getDayOfMonth() <= 7) {
            return WeekOfMonth.Days1to7;
        }
        if (forDate.getDayOfMonth() <= 14) {
            return WeekOfMonth.Days8to14;
        }
        if (forDate.getDayOfMonth() <= 21) {
            return WeekOfMonth.Days15to21;
        }
        if (forDate.getDayOfMonth() <= 28) {
            return WeekOfMonth.Days22to28;
        }
        return WeekOfMonth.Days29to31;
    }

    boolean IsDayOfMonthMatched(LocalDateTime atTime) {
        return this.IsDayOfMonthExactly(this.getStartDateDayOfMonth(), atTime) || this.IsDayOfMonthExactly(this.getEndDateDayOfMonth(), atTime) || this.IsDayOfMonthBetweenStartAndEnd(atTime);
    }

    private boolean IsDayOfMonthExactly(DayOfMonth day, LocalDateTime atTime) {
        return day.equals((Object)DayOfMonth.Any) || day.equals((Object)DayOfMonth.Even) && atTime.getDayOfMonth() % 2 == 0 || day.equals((Object)DayOfMonth.Odd) && atTime.getDayOfMonth() % 2 == 1 || day.equals((Object)DayOfMonth.Last) && YearMonth.of(atTime.getYear(), atTime.getMonthValue()).lengthOfMonth() == atTime.getDayOfMonth() || atTime.getDayOfMonth() == (byte)day.getValue();
    }

    boolean IsDayOfMonthBetweenStartAndEnd(LocalDateTime atTime) {
        return this.getStartDateDayOfMonth().compareTo(this.getEndDateDayOfMonth()) <= 0 ? atTime.getDayOfMonth() >= (byte)this.getStartDateDayOfMonth().getValue() && atTime.getDayOfMonth() <= (byte)this.getEndDateDayOfMonth().getValue() : atTime.getDayOfMonth() >= (byte)this.getEndDateDayOfMonth().getValue() || atTime.getDayOfMonth() <= (byte)this.getStartDateDayOfMonth().getValue();
    }

    boolean IsMonthOfYearMatched(LocalDateTime atTime) {
        return this.IsMonthOfYearExactly(this.getStartDateMonthOfYear(), atTime) || this.IsMonthOfYearExactly(this.getEndDateMonthOfYear(), atTime) || this.IsMonthOfYearBetween(atTime);
    }

    boolean IsMonthOfYearBetween(LocalDateTime atTime) {
        return this.getStartDateMonthOfYear().equals((Object)Month.Any) && this.getEndDateMonthOfYear().compareTo(Month.forValue(atTime.getMonthValue())) >= 0 || this.getStartDateMonthOfYear().compareTo(Month.forValue(atTime.getMonthValue())) <= 0 && this.getEndDateMonthOfYear().equals((Object)Month.Any) || this.getStartDateMonthOfYear().compareTo(Month.forValue(atTime.getMonthValue())) <= 0 && this.getEndDateMonthOfYear().compareTo(Month.forValue(atTime.getMonthValue())) >= 0;
    }

    boolean IsMonthOfYearExactly(Month month, LocalDateTime atTime) {
        return month.equals((Object)Month.Any) || atTime.getMonthValue() == (byte)month.getValue() || month.equals((Object)Month.Even) && atTime.getMonthValue() % 2 == 0 || month.equals((Object)Month.Odd) && atTime.getMonthValue() % 2 == 1;
    }

    Duration TillMatchForDayOfMonth(LocalDateTime someTime) {
        int lastMonthOfYear = 12;
        if (this.IsDayOfMonthMatched(someTime)) {
            return Duration.ZERO;
        }
        LocalDateTime startOfValidDay = LocalDateTime.MIN;
        if (this.getStartDateDayOfMonth().equals((Object)DayOfMonth.Odd) || this.getStartDateDayOfMonth().equals((Object)DayOfMonth.Even) || this.getStartDateDayOfMonth().equals((Object)DayOfMonth.Last)) {
            int daysInSomeTimeMonth = YearMonth.of(someTime.getYear(), someTime.getMonthValue()).lengthOfMonth();
            int daysFromStartOfMonth = this.getStartDateDayOfMonth().equals((Object)DayOfMonth.Last) ? daysInSomeTimeMonth - 1 : (someTime.getDayOfMonth() < daysInSomeTimeMonth ? someTime.getDayOfMonth() : (this.getStartDateDayOfMonth().equals((Object)DayOfMonth.Odd) ? daysInSomeTimeMonth : daysInSomeTimeMonth + 1));
            startOfValidDay = LocalDateTime.of(LocalDate.of(someTime.getYear(), someTime.getMonthValue(), 1), LocalTime.MIN).plus(Duration.ofDays(daysFromStartOfMonth));
        } else if (!(this.IsDateValid(someTime.getYear(), (byte)someTime.getMonthValue(), this.getStartDateDayOfMonth(), startOfValidDay) && startOfValidDay.compareTo(someTime) > 0 || someTime.getMonthValue() >= 12 && this.IsDateValid(someTime.getYear() + 1, (byte)1, this.getStartDateDayOfMonth(), startOfValidDay) || this.IsDateValid(someTime.getYear(), (byte)(someTime.getMonthValue() + 1), this.getStartDateDayOfMonth(), startOfValidDay))) {
            startOfValidDay = LocalDateTime.of(LocalDate.of(someTime.getYear() + 1, 1, 1), LocalTime.MIN);
        }
        return Duration.between(startOfValidDay, someTime);
    }

    Duration TillMatchForMonth(LocalDateTime someTime) {
        if (this.IsMonthOfYearMatched(someTime)) {
            return Duration.ZERO;
        }
        LocalDateTime startOfValidMonth = LocalDateTime.MIN;
        startOfValidMonth = this.getStartDateMonthOfYear().equals((Object)Month.Even) || this.getStartDateMonthOfYear().equals((Object)Month.Odd) ? (someTime.getMonth().getValue() == 12 ? LocalDateTime.of(LocalDate.of(someTime.getYear() + 1, 1, 1), LocalTime.MIN) : LocalDateTime.of(LocalDate.of(someTime.getYear(), (byte)someTime.getMonth().getValue() + 1, 1), LocalTime.MIN)) : LocalDateTime.of(LocalDate.of(someTime.getYear(), (byte)this.getStartDateMonthOfYear().getValue(), 1), LocalTime.MIN);
        if (startOfValidMonth.isBefore(someTime)) {
            startOfValidMonth = LocalDateTime.of(LocalDate.of(someTime.getYear() + 1, (byte)this.getStartDateMonthOfYear().getValue(), 1), LocalTime.MIN);
        }
        return Duration.between(startOfValidMonth, someTime);
    }

    Duration TillMatchForYear(LocalDateTime someTime) {
        if (this.getStartDateYear() == 65535 || someTime.getYear() == this.getStartDateYear()) {
            return Duration.ZERO;
        }
        LocalDateTime startOfValidYear = LocalDateTime.of(LocalDate.of(this.getStartDateYear(), 1, 1), LocalTime.MIN);
        if (startOfValidYear.isBefore(someTime)) {
            return Duration.ofMillis(Long.MAX_VALUE);
        }
        return Duration.between(startOfValidYear, someTime);
    }

    private boolean IsDateValid(int year, byte month, DayOfMonth day, LocalDateTime date) {
        try {
            date = LocalDateTime.of(LocalDate.of(year, month, day.getValue()), LocalTime.MIN);
            return true;
        }
        catch (Exception e) {
            date = LocalDateTime.MAX;
            return false;
        }
    }

    @FunctionalInterface
    public static interface DayFinder {
        public boolean invoke(LocalDateTime var1, LocalDateTime var2);
    }

    public static class AnchorForVocabulary {
    }
}

