/*
 * Decompiled with CFR 0.152.
 */
package com.miratech.ifnetclient.model.scheduleLogic;

import com.miratech.ifnetclient.model.scheduleLogic.DayOfMonth;
import com.miratech.ifnetclient.model.scheduleLogic.ExceptionalDays;
import com.miratech.ifnetclient.model.scheduleLogic.Month;
import com.miratech.ifnetclient.model.scheduleLogic.WeekOfMonth;
import com.miratech.ifnetclient.utils.IfnetClientLogger;
import java.time.DayOfWeek;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Objects;
import java.util.logging.Level;
import java.util.stream.Stream;

public class SchedulesVocabulary {
    private static HashMap<DayOfWeek, String> daysOfWeek = null;
    private static HashMap<WeekOfMonth, String> weeksOfMonth = null;

    public static String[] MonthOfYearOptions(ExceptionalDays.AnchorForVocabulary anchorForVocabulary) {
        ArrayList<String> allOptions = new ArrayList<String>();
        for (Month option : Month.values()) {
            allOptions.add(SchedulesVocabulary.Name(option));
        }
        return allOptions.toArray(new String[0]);
    }

    public static String Name(Month monthOfYear) {
        return monthOfYear.toString();
    }

    public static Month MonthOfYearValue(ExceptionalDays.AnchorForVocabulary anchorForVocabulary, String forName) {
        for (Month option : Month.values()) {
            if (!Objects.equals(SchedulesVocabulary.Name(option).trim().toLowerCase(), forName.toLowerCase().trim())) continue;
            return option;
        }
        IfnetClientLogger.log(Level.SEVERE, String.format("Invalid MonthOfYear: %1$s", forName));
        return Month.Any;
    }

    public static String[] DayOfMonthOptions(ExceptionalDays.AnchorForVocabulary anchorForVocabulary) {
        ArrayList<String> allOptions = new ArrayList<String>();
        for (DayOfMonth option : DayOfMonth.values()) {
            allOptions.add(SchedulesVocabulary.Name(option));
        }
        return allOptions.toArray(new String[0]);
    }

    public static String Name(DayOfMonth dayOfMonth) {
        int dayNumber = 0;
        if (!SchedulesVocabulary.ContainsNumber(dayOfMonth.toString(), dayNumber)) {
            return (Object)((Object)dayOfMonth) + " Days";
        }
        return SchedulesVocabulary.Format(dayNumber);
    }

    private static boolean ContainsNumber(String fromString, Integer extractedNumber) {
        try {
            extractedNumber = Integer.parseInt(fromString);
        }
        catch (NumberFormatException e) {
            extractedNumber = 0;
            return false;
        }
        return true;
    }

    private static String Format(int number) {
        if (number >= 4 && number <= 20 || number >= 24 && number <= 30) {
            return number + "th";
        }
        if (number % 10 == 1) {
            return number + "st";
        }
        if (number % 10 == 2) {
            return number + "nd";
        }
        return number + "rd";
    }

    public static DayOfMonth DayOfMonthValue(ExceptionalDays.AnchorForVocabulary anchorForVocabulary, String forName) {
        for (DayOfMonth option : DayOfMonth.values()) {
            if (!Objects.equals(SchedulesVocabulary.Name(option).trim().toLowerCase(), forName.toLowerCase().trim())) continue;
            return option;
        }
        IfnetClientLogger.log(Level.SEVERE, String.format("Invalid DayOfMonth: %1$s", forName));
        return DayOfMonth.Any;
    }

    public static final HashMap<DayOfWeek, String> getDaysOfWeek() {
        if (null == daysOfWeek) {
            daysOfWeek = new HashMap();
            daysOfWeek.put(DayOfWeek.of(255), "Any Weekday");
            daysOfWeek.put(DayOfWeek.MONDAY, "Monday");
            daysOfWeek.put(DayOfWeek.TUESDAY, "Tuesday");
            daysOfWeek.put(DayOfWeek.WEDNESDAY, "Wednesday");
            daysOfWeek.put(DayOfWeek.THURSDAY, "Thursday");
            daysOfWeek.put(DayOfWeek.FRIDAY, "Friday");
            daysOfWeek.put(DayOfWeek.SATURDAY, "Saturday");
            daysOfWeek.put(DayOfWeek.SUNDAY, "Sunday");
        }
        return daysOfWeek;
    }

    public static String[] DayOfWeekOptions(ExceptionalDays.AnchorForVocabulary anchorForVocabulary) {
        return (String[])SchedulesVocabulary.getDaysOfWeek().values().toArray();
    }

    public static String Name(DayOfWeek value) {
        return SchedulesVocabulary.getDaysOfWeek().containsKey(value) ? SchedulesVocabulary.getDaysOfWeek().get(value) : value.toString();
    }

    public static DayOfWeek DayOfWeekValue(ExceptionalDays.AnchorForVocabulary anchorForVocabulary, String fromName) {
        Stream daysOfWeekStream = SchedulesVocabulary.getDaysOfWeek().entrySet().stream();
        return (DayOfWeek)daysOfWeekStream.filter(kvp -> ((String)kvp.getValue()).trim().toLowerCase() == fromName.trim().toLowerCase()).findFirst().get().getKey();
    }

    public static final HashMap<WeekOfMonth, String> getWeeksOfMonth() {
        if (null == weeksOfMonth) {
            weeksOfMonth = new HashMap();
            weeksOfMonth.put(WeekOfMonth.Any, "Any Week");
            weeksOfMonth.put(WeekOfMonth.Days1to7, "Days 1-7");
            weeksOfMonth.put(WeekOfMonth.Days8to14, "Days 8-14");
            weeksOfMonth.put(WeekOfMonth.Days15to21, "Days 15-21");
            weeksOfMonth.put(WeekOfMonth.Days22to28, "Days 22-28");
            weeksOfMonth.put(WeekOfMonth.Days29to31, "Days after 28th");
            weeksOfMonth.put(WeekOfMonth.Days1to7tillEnd, "1-7 days till end");
            weeksOfMonth.put(WeekOfMonth.Days8to14tillEnd, "8-14 days till end");
            weeksOfMonth.put(WeekOfMonth.Days15to21tillEnd, "15-21 days till end");
            weeksOfMonth.put(WeekOfMonth.Days22to28tillEnd, "22-28 days till end");
        }
        return weeksOfMonth;
    }

    public static String[] WeekOfMonthOptions(ExceptionalDays.AnchorForVocabulary anchorForVocabulary) {
        return (String[])SchedulesVocabulary.getWeeksOfMonth().values().toArray();
    }

    public static String Name(WeekOfMonth value) {
        return SchedulesVocabulary.getWeeksOfMonth().keySet().contains((Object)value) ? SchedulesVocabulary.getWeeksOfMonth().get((Object)value) : value.toString();
    }

    public static WeekOfMonth WeekOfMonthValue(ExceptionalDays.AnchorForVocabulary anchorForVocabulary, String name) {
        Stream weeksOfMonthStream = SchedulesVocabulary.getWeeksOfMonth().entrySet().stream();
        return (WeekOfMonth)((Object)weeksOfMonthStream.filter(kvp -> ((String)kvp.getValue()).trim().toLowerCase() == name.trim().toLowerCase()).findFirst().get().getKey());
    }
}

