/*
 * Decompiled with CFR 0.152.
 */
package com.miratech.ifnetclient.model.scheduleLogic;

import com.miratech.ifnetclient.model.scheduleLogic.EventsTable;
import com.miratech.ifnetclient.model.scheduleLogic.ISchedule;
import com.miratech.ifnetclient.model.scheduleLogic.RawIScheduleData;
import com.miratech.ifnetclient.model.scheduleLogic.ScheduleValue;
import java.time.DayOfWeek;
import java.time.LocalDateTime;
import java.time.Period;

public class WeeklySchedule
implements ISchedule {
    public static final Period LengthOfWeek = Period.ofDays(7);
    private EventsTable Values = new EventsTable(ScheduleValue.weekLength);

    @Override
    public final String getScheduleName() {
        return "Weekly";
    }

    @Override
    public final byte getPriority() {
        return 16;
    }

    @Override
    public final EventsTable getValues() {
        return this.Values;
    }

    @Override
    public boolean NearestRelevantDay(LocalDateTime since, LocalDateTime nearestOccurence) {
        return this.getValues().getCount() > 0;
    }

    @Override
    public final boolean ApplyRawData(RawIScheduleData compressed) {
        return this.getValues().Set(compressed.eventsTimes, compressed.eventsValues);
    }

    @Override
    public final RawIScheduleData ExtractRawData() {
        return null;
    }

    @Override
    public final ScheduleValue Calculate(LocalDateTime now) {
        return null;
    }

    public static LocalDateTime StartOfTheWeek(LocalDateTime someTime) {
        int diff = (7 + (someTime.getDayOfWeek().getValue() - DayOfWeek.MONDAY.getValue())) % 7;
        return someTime.plusDays(-diff);
    }
}

