/*
 * Decompiled with CFR 0.152.
 */
package com.miratech.nE2Link;

import com.miratech.nE2Link.BLibrary;
import com.miratech.nE2Link.BNanoBase;
import com.miratech.nE2Link.BNanoBaseComponent;
import com.miratech.nE2Link.BNe2DeviceExt;
import com.tridium.file.types.bog.BBogSpace;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.space.BComponentSpace;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BInteger;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraAction(name="getComponentByTypeId", parameterType="BInteger", defaultValue="BInteger.DEFAULT", returnType="BNanoBaseComponent", flags=4)
public class BLibraries
extends BNanoBase {
    public static final Action getComponentByTypeId = BLibraries.newAction((int)4, (BValue)BInteger.DEFAULT, null);
    public static final Type TYPE = Sys.loadType(BLibraries.class);
    private LibraryComponentCache libraryComponentsCache = new LibraryComponentCache();

    public BNanoBaseComponent getComponentByTypeId(BInteger parameter) {
        return (BNanoBaseComponent)this.invoke(getComponentByTypeId, (BValue)parameter, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public LibraryComponentCache getLibraryComponentsCache() {
        return this.libraryComponentsCache;
    }

    @Override
    public void started() throws Exception {
        this.getLibraryComponentsCache().init();
    }

    public void checkRemove(Property property, Context context) {
        if (this.checkContext(context)) {
            return;
        }
        BValue val = this.get(property);
        if (val.getType().is(BLibrary.TYPE)) {
            throw new LocalizableRuntimeException(BLibraries.LEX.module.getModuleName(), "DELETE_FORBIDDEN");
        }
        super.checkRemove(property, context);
    }

    public void added(Property property, Context context) {
        if (property.getType().is(BLibrary.TYPE)) {
            BNanoBaseComponent[] components;
            BLibrary lib = (BLibrary)this.get(property);
            for (BNanoBaseComponent component : components = (BNanoBaseComponent[])lib.getChildren(BNanoBaseComponent.class)) {
                this.libraryComponentsCache.put(component);
            }
        }
        super.added(property, context);
    }

    public Property[] addLibraries(BLibrary[] libraries, boolean replaceIfPresent) {
        ArrayList<Property> properties = new ArrayList<Property>();
        for (int i = 0; i < libraries.length; ++i) {
            Property property = this.addLibrary(libraries[i], replaceIfPresent);
            if (property == null) continue;
            properties.add(property);
        }
        return properties.toArray(new Property[0]);
    }

    public Property addLibrary(BLibrary library, boolean replaceIfPresent) {
        Property libProperty = this.getProperty(library.getDefaultPropertyName());
        if (libProperty != null && replaceIfPresent) {
            this.remove(libProperty);
            LOGGER.info("Reloaded library '" + (Object)((Object)library) + "'");
            return this.add(library.getDefaultPropertyName(), (BValue)library, !library.isInvisibleInTree() ? 1 : 5);
        }
        if (libProperty != null) {
            LOGGER.info("Skipped adding library '" + (Object)((Object)library) + "'. Already present.");
            return null;
        }
        LOGGER.info("Added new library '" + (Object)((Object)library) + "'");
        return this.add(library.getDefaultPropertyName(), (BValue)library, !library.isInvisibleInTree() ? 1 : 5);
    }

    public String getDisplayName(Slot slot, Context cx) {
        if (slot.isProperty() && this.get(slot.asProperty()).getType().is(BLibrary.TYPE)) {
            BLibrary lib = (BLibrary)this.get(slot.asProperty());
            if (!Sys.isStation()) {
                lib.lease();
            }
            return lib.toString(cx);
        }
        return super.getDisplayName(slot, cx);
    }

    @Override
    public boolean isChildLegal(BComponent child) {
        return child.getType().is(BLibrary.TYPE);
    }

    @Override
    public boolean isParentLegal(BComponent parent) {
        return parent instanceof BNe2DeviceExt || !parent.isMounted() || parent.getComponentSpace() instanceof BBogSpace;
    }

    public BNanoBaseComponent doGetComponentByTypeId(BInteger typeId) {
        return this.libraryComponentsCache.get(typeId.getInt());
    }

    public class LibraryComponentCache {
        private HashMap<Integer, BNanoBaseComponent> componentsByTypeId = new HashMap();

        private void init() {
            BLibraries thisLibraries = BLibraries.this;
            BComponentSpace componentSpace = thisLibraries.getComponentSpace();
            HashMap existingLibraryComponents = (HashMap)Arrays.stream(componentSpace.getAllComponents()).filter(component -> component instanceof BNanoBaseComponent && ((BNanoBaseComponent)((Object)component)).getIsLibraryComponent() && component.getParent().getParent().equals((Object)thisLibraries)).map(component -> (BNanoBaseComponent)((Object)component)).collect(Collectors.toMap(BNanoBaseComponent::getTypeId, Function.identity()));
            this.componentsByTypeId.putAll(existingLibraryComponents);
        }

        public void clear() {
            this.componentsByTypeId.clear();
        }

        public boolean put(BNanoBaseComponent componentToCache) {
            if (componentToCache == null) {
                return false;
            }
            int typeId = componentToCache.getTypeId();
            if (typeId != -1) {
                this.componentsByTypeId.put(typeId, componentToCache);
                return true;
            }
            return false;
        }

        public BNanoBaseComponent get(int typeId) {
            return this.componentsByTypeId.get(typeId);
        }
    }
}

