/*
 * Decompiled with CFR 0.152.
 */
package com.miratech.nE2Link;

import com.miratech.nE2Link.BNanoBase;
import com.miratech.nE2Link.BNanoBaseComponent;
import com.miratech.nE2Link.BNanoExtension;
import com.miratech.nE2Link.actions.BNanoComponentRenameArg;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperty(name="nanoName", type="String", defaultValue="", flags=1)
public abstract class BNanoBaseNamed
extends BNanoBase {
    public static final Property nanoName = BNanoBaseNamed.newProperty((int)1, (String)"", null);
    public static final Type TYPE = Sys.loadType(BNanoBaseNamed.class);
    public static final String LEX_KEY_RENAME_FORBIDDEN = "RENAME_FORBIDDEN";

    public String getNanoName() {
        return this.getString(nanoName);
    }

    public void setNanoName(String v) {
        this.setString(nanoName, v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public void checkRename(Property property, String newName, Context context) {
        if (this.checkContext(context)) {
            return;
        }
        super.checkRename(property, newName, context);
        if (!this.isRunning()) {
            return;
        }
        if (property.getType().is(BNanoExtension.TYPE)) {
            BNanoBaseComponent parent;
            BNanoExtension extension = (BNanoExtension)this.get(property).as(BNanoExtension.class);
            if (!newName.equals(extension.getDefaultPropertyName(parent = (BNanoBaseComponent)extension.getParent()))) {
                throw new LocalizableRuntimeException(BNanoBaseNamed.LEX.module.getModuleName(), LEX_KEY_RENAME_FORBIDDEN);
            }
            return;
        }
        if (property.getType().is(BNanoBaseComponent.TYPE)) {
            BNanoBaseComponent renamedComponent = (BNanoBaseComponent)this.get(property).as(BNanoBaseComponent.class);
            this.getNe2DeviceExt().doHandleNanoComponentRename(new BNanoComponentRenameArg(renamedComponent.getGlobalIndex(), renamedComponent.getPropertyInParent().getName(), newName));
        }
    }

    public void renamed(Property property, String oldName, Context context) {
        if (Sys.isStation() && property.getType().is(TYPE)) {
            BNanoBaseNamed renamedComp = (BNanoBaseNamed)this.get(property).as(BNanoBaseNamed.class);
            renamedComp.setNanoName(SlotPath.unescape((String)renamedComp.getPropertyInParent().getName()));
        }
        super.renamed(property, oldName, context);
    }

    public String getDefaultPropertyName() {
        return SlotPath.escape((String)this.toString(null));
    }

    public String toString(Context context) {
        return this.getNanoName();
    }
}

