/*
 * Decompiled with CFR 0.152.
 */
package com.miratech.nE2Link;

import com.miratech.ifnetclient.comm.ConnectionResult;
import com.miratech.ifnetclient.comm.Server;
import com.miratech.ifnetclient.model.RemoteDevice;
import com.miratech.nE2Link.BAsyncConfig;
import com.miratech.nE2Link.BConnectionDataArg;
import com.miratech.nE2Link.BLibraries;
import com.miratech.nE2Link.BLibrary;
import com.miratech.nE2Link.BLinkInfo;
import com.miratech.nE2Link.BNanoBaseComponent;
import com.miratech.nE2Link.BNanoComponent;
import com.miratech.nE2Link.BNanoConfig;
import com.miratech.nE2Link.BNanoContainer;
import com.miratech.nE2Link.BNanoExtension;
import com.miratech.nE2Link.BNanoPollScheduler;
import com.miratech.nE2Link.BNiagaraLinkInfo;
import com.miratech.nE2Link.INanoPollable;
import com.miratech.nE2Link.actions.BBackupRestoreArgs;
import com.miratech.nE2Link.actions.BDisplayModeEnum;
import com.miratech.nE2Link.actions.BDynamicChoiceRangeChangedArg;
import com.miratech.nE2Link.actions.BNanoAddExtensionArg;
import com.miratech.nE2Link.actions.BNanoComponentListArg;
import com.miratech.nE2Link.actions.BNanoComponentRenameArg;
import com.miratech.nE2Link.actions.BNanoContextArg;
import com.miratech.nE2Link.actions.BNanoDeleteExtensionArg;
import com.miratech.nE2Link.actions.BNanoInvocationArg;
import com.miratech.nE2Link.actions.BNanoLinkInfoArg;
import com.miratech.nE2Link.actions.BNanoPermanentSubscriptionArg;
import com.miratech.nE2Link.actions.BNanoPermanentUnsubscriptionArg;
import com.miratech.nE2Link.actions.BNanoPropertyChangedArg;
import com.miratech.nE2Link.actions.BNanoScheduleChangedArg;
import com.miratech.nE2Link.actions.BNanoTimeChangeArg;
import com.miratech.nE2Link.notifications.BMessageNotification;
import com.miratech.nE2Link.notifications.BMessageTypeEnum;
import com.miratech.nE2Link.notifications.BRefreshNotification;
import com.miratech.nE2Link.notifications.BRefreshTargets;
import com.miratech.nE2Link.parser.binary.AbstractNanoData;
import com.miratech.nE2Link.parser.binary.AddExtensionRequest;
import com.miratech.nE2Link.parser.binary.AddExtensionResponse;
import com.miratech.nE2Link.parser.binary.AddRequest;
import com.miratech.nE2Link.parser.binary.AddResponse;
import com.miratech.nE2Link.parser.binary.BinaryApplicationParser;
import com.miratech.nE2Link.parser.binary.DeleteExtensionRequest;
import com.miratech.nE2Link.parser.binary.DeleteExtensionResponse;
import com.miratech.nE2Link.parser.binary.DeleteRequest;
import com.miratech.nE2Link.parser.binary.DeleteResponse;
import com.miratech.nE2Link.parser.binary.ExistingLinkData;
import com.miratech.nE2Link.parser.binary.InvokeRequest;
import com.miratech.nE2Link.parser.binary.InvokeResponse;
import com.miratech.nE2Link.parser.binary.LabelsUpdateRequest;
import com.miratech.nE2Link.parser.binary.LabelsUpdateResponse;
import com.miratech.nE2Link.parser.binary.LinkRequest;
import com.miratech.nE2Link.parser.binary.LinkResponse;
import com.miratech.nE2Link.parser.binary.ObjectData;
import com.miratech.nE2Link.parser.binary.PollData;
import com.miratech.nE2Link.parser.binary.PollRequest;
import com.miratech.nE2Link.parser.binary.PollResponse;
import com.miratech.nE2Link.parser.binary.RenameRequest;
import com.miratech.nE2Link.parser.binary.RenameResponse;
import com.miratech.nE2Link.parser.binary.ResponseCode;
import com.miratech.nE2Link.parser.binary.ScheduleRequest;
import com.miratech.nE2Link.parser.binary.ScheduleResponse;
import com.miratech.nE2Link.parser.binary.SubscribeRequest;
import com.miratech.nE2Link.parser.binary.SubscribeResponse;
import com.miratech.nE2Link.parser.binary.TreeData;
import com.miratech.nE2Link.parser.binary.UnlinkRequest;
import com.miratech.nE2Link.parser.binary.UnlinkResponse;
import com.miratech.nE2Link.parser.binary.UnsubscribeRequest;
import com.miratech.nE2Link.parser.binary.UnsubscribeResponse;
import com.miratech.nE2Link.parser.binary.WriteRequest;
import com.miratech.nE2Link.parser.binary.WriteResponse;
import com.miratech.nE2Link.schedules.utils.ScheduleUtils;
import com.miratech.nE2Link.utils.BBackupFile;
import com.miratech.nE2Link.utils.BBackupRestoreManager;
import com.miratech.nE2Link.utils.BBackupStatus;
import com.miratech.nE2Link.utils.BConnectionStatus;
import com.miratech.nE2Link.utils.BListOfBackupFiles;
import com.miratech.nE2Link.utils.BListOfLibraryFiles;
import com.miratech.nE2Link.utils.BSoftwareManager;
import com.miratech.nE2Link.utils.FileUtil;
import com.miratech.nE2Link.utils.OsUpdateHelper;
import com.miratech.serialization.DataMarker;
import com.miratech.serialization.SerializableForm;
import com.tridium.json.JSONArray;
import com.tridium.json.JSONObject;
import com.tridium.modbusTcp.BModbusTcpDevice;
import com.tridium.platform.BPlatformServiceContainer;
import com.tridium.platform.BSystemPlatformService;
import com.tridium.sys.Nre;
import com.tridium.util.ContextThread;
import com.tridium.util.TimeFormat;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.LambdaMetafactory;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.baja.agent.AgentList;
import javax.baja.bacnet.BBacnetDevice;
import javax.baja.bql.BqlQuery;
import javax.baja.collection.BITable;
import javax.baja.collection.TableCursor;
import javax.baja.data.BIDataValue;
import javax.baja.driver.util.BPollFrequency;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.space.BComponentSpace;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusString;
import javax.baja.sync.Transaction;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BLink;
import javax.baja.sys.BLong;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.util.BFormat;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="icon", type="BIcon", defaultValue="ICON_GREY", flags=5), @NiagaraProperty(name="asyncConfig", type="BAsyncConfig", defaultValue="new BAsyncConfig()", flags=4), @NiagaraProperty(name="config", type="BNanoConfig", defaultValue="new BNanoConfig()", flags=4), @NiagaraProperty(name="activity", type="String", defaultValue="Ready", flags=11), @NiagaraProperty(name="applicationIsLoading", type="boolean", defaultValue="false", flags=1), @NiagaraProperty(name="pollScheduler", type="BNanoPollScheduler", defaultValue="new BNanoPollScheduler()"), @NiagaraProperty(name="pollFrequency", type="BPollFrequency", defaultValue="BPollFrequency.normal"), @NiagaraProperty(name="HostModel", type="BString", defaultValue="", flags=1), @NiagaraProperty(name="softwareManager", type="BSoftwareManager", defaultValue="new BSoftwareManager()"), @NiagaraProperty(name="libraries", type="BLibraries", defaultValue="new BLibraries()"), @NiagaraProperty(name="currentDisplayMode", type="BDisplayModeEnum", defaultValue="BDisplayModeEnum.DEFAULT", flags=4)})
@NiagaraActions(value={@NiagaraAction(name="connect", parameterType="BConnectionDataArg", defaultValue="new BConnectionDataArg()", flags=16), @NiagaraAction(name="disconnect", flags=16), @NiagaraAction(name="selectDisplayMode", parameterType="BDisplayModeEnum", defaultValue="BDisplayModeEnum.DEFAULT", flags=16), @NiagaraAction(name="loadSchema", flags=20), @NiagaraAction(name="loadTree", flags=20), @NiagaraAction(name="loadLogs", flags=20), @NiagaraAction(name="enableSubscriptionHandling", parameterType="BBoolean", defaultValue="BBoolean.TRUE", facets={@Facet(name="BFacets.TRUE_TEXT", value="\"%lexicon(nE2Link:Ne2DeviceExt.enableSubscriptionHandling.trueText)%\""), @Facet(name="BFacets.FALSE_TEXT", value="\"%lexicon(nE2Link:Ne2DeviceExt.enableSubscriptionHandling.falseText)%\"")}, flags=4), @NiagaraAction(name="enablePolling", parameterType="BBoolean", defaultValue="BBoolean.TRUE", facets={@Facet(name="BFacets.TRUE_TEXT", value="\"%lexicon(nE2Link:Ne2DeviceExt.enablePolling.trueText)%\""), @Facet(name="BFacets.FALSE_TEXT", value="\"%lexicon(nE2Link:Ne2DeviceExt.enablePolling.falseText)%\"")}, flags=4), @NiagaraAction(name="getPerformanceAnalysis", flags=16), @NiagaraAction(name="getLocalLibraries", returnType="BString", flags=4), @NiagaraAction(name="getOsLibraries", returnType="BString", flags=4), @NiagaraAction(name="getNanoComponentByName", parameterType="BString", defaultValue="BString.DEFAULT", returnType="BValue", flags=4), @NiagaraAction(name="getBackups", parameterType="BBackupRestoreArgs", defaultValue="new BBackupRestoreArgs()", returnType="BString", flags=4), @NiagaraAction(name="downloadBackup", parameterType="BBackupRestoreArgs", defaultValue="new BBackupRestoreArgs()", flags=20), @NiagaraAction(name="deleteBackup", parameterType="BBackupRestoreArgs", defaultValue="new BBackupRestoreArgs()", returnType="BBoolean", flags=4), @NiagaraAction(name="restoreBackup", parameterType="BBackupRestoreArgs", defaultValue="new BBackupRestoreArgs()", flags=20), @NiagaraAction(name="getStationCurrentTime", returnType="BLong", flags=4), @NiagaraAction(name="getNanoComponentByPersistentId", parameterType="BString", defaultValue="BString.DEFAULT", returnType="BOrd", flags=4), @NiagaraAction(name="updateWbUi", parameterType="BComponent", defaultValue="new BComponent()", flags=20), @NiagaraAction(name="requestNanoSubscription", parameterType="BNanoBaseComponent", defaultValue="new BNanoComponent()", flags=20), @NiagaraAction(name="requestNanoPermanentSubscription", parameterType="BNanoPermanentSubscriptionArg", defaultValue="new BNanoPermanentSubscriptionArg()", flags=20), @NiagaraAction(name="requestNanoUnsubscription", parameterType="BNanoBaseComponent", defaultValue="new BNanoComponent()", flags=20), @NiagaraAction(name="requestNanoPermanentUnsubscription", parameterType="BNanoPermanentUnsubscriptionArg", defaultValue="new BNanoPermanentUnsubscriptionArg()", flags=20), @NiagaraAction(name="handleNanoInvocation", parameterType="BNanoInvocationArg", defaultValue="new BNanoInvocationArg()", flags=20), @NiagaraAction(name="handleNanoPropertyValueChange", parameterType="BNanoPropertyChangedArg", defaultValue="new BNanoPropertyChangedArg()", flags=20), @NiagaraAction(name="handleNanoLinkCreation", parameterType="BNanoLinkInfoArg", defaultValue="new BNanoLinkInfoArg()", flags=20), @NiagaraAction(name="handleNanoLinkDeletion", parameterType="BNanoLinkInfoArg", defaultValue="new BNanoLinkInfoArg()", flags=20), @NiagaraAction(name="handleNanoComponentsCreation", parameterType="BNanoComponentListArg", defaultValue="new BNanoComponentListArg()", flags=20), @NiagaraAction(name="handleNanoComponentDeletion", parameterType="BNanoBaseComponent", defaultValue="new BNanoComponent()", flags=20), @NiagaraAction(name="handleNanoComponentRename", parameterType="BNanoComponentRenameArg", defaultValue="new BNanoComponentRenameArg()", flags=20), @NiagaraAction(name="handleNanoExtensionCreation", parameterType="BNanoAddExtensionArg", defaultValue="new BNanoAddExtensionArg()", flags=20), @NiagaraAction(name="handleNanoExtensionDeletion", parameterType="BNanoDeleteExtensionArg", defaultValue="new BNanoDeleteExtensionArg()", flags=20), @NiagaraAction(name="handleNanoScheduleChanged", parameterType="BNanoScheduleChangedArg", defaultValue="new BNanoScheduleChangedArg()", flags=20), @NiagaraAction(name="setNanoTime", parameterType="BNanoTimeChangeArg", defaultValue="new BNanoTimeChangeArg()", flags=20), @NiagaraAction(name="handleNanoLabelsUpdate", parameterType="BDynamicChoiceRangeChangedArg", defaultValue="new BDynamicChoiceRangeChangedArg()", flags=20)})
public class BNe2DeviceExt
extends BComponent
implements INanoPollable {
    public static final String LEX_KEY_ROOT_DISPLAY_NAME = "Ne2DeviceExt.rootDisplayName";
    public static final String MODULE_RESOURCE_PATH = "module://nE2Link/rc";
    private static final BOrd SHARED_DIR_ORD_BASE = BOrd.make((String)"file:^");
    public static final String NANO_TARGET_DIR_NAME = "nE2Link";
    public static final String NANO_EDGE_ENGINE_TARGET_DIR_NAME = "nanoEdgeEngine";
    public static final BOrd NANO_SHARED_DIR_ORD = BOrd.make((BOrd)SHARED_DIR_ORD_BASE, (String)"file:nE2Link");
    public static final BOrd NANO_EDGE_ENGINE_SHARED_DIR_ORD = BOrd.make((BOrd)NANO_SHARED_DIR_ORD, (String)"file:nanoEdgeEngine");
    private static final String LABELS_DIR_NAME = "labels";
    public static BOrd LABELS_MODULE_ORD = BOrd.make((String)"module://nE2Link/rc/labels");
    public static final BOrd LABELS_FILE_ORD = BOrd.make((BOrd)NANO_SHARED_DIR_ORD, (String)"file:labels");
    private static final String CUSTOM_POINTS_DIR_NAME = "BACnetCustomPoints";
    public static BOrd CUSTOM_POINTS_MODULE_ORD = BOrd.make((String)"module://nE2Link/rc/BACnetCustomPoints");
    public static final BOrd CUSTOM_POINTS_FILE_ORD = BOrd.make((BOrd)NANO_SHARED_DIR_ORD, (String)"file:BACnetCustomPoints");
    private static final String OS_DIR_NAME = "os";
    private static final String LIBRARIES_DIR_NAME = "libraries";
    public static BOrd OS_MODULE_ORD = BOrd.make((String)"module://nE2Link/rc/nanoEdgeEngine/os");
    public static BOrd LIBRARIES_MODULE_ORD = BOrd.make((String)"module://nE2Link/rc/nanoEdgeEngine/libraries");
    public static final BOrd OS_FILE_ORD = BOrd.make((BOrd)NANO_EDGE_ENGINE_SHARED_DIR_ORD, (String)"file:os");
    public static final BOrd LIBRARIES_FILE_ORD = BOrd.make((BOrd)NANO_EDGE_ENGINE_SHARED_DIR_ORD, (String)"file:libraries");
    private static final String BACKUPS_DIR_NAME = "backup";
    public static final BOrd BACKUPS_FILE_ORD = BOrd.make((BOrd)NANO_EDGE_ENGINE_SHARED_DIR_ORD, (String)"file:backup");
    private static final String ICONS_BASE_DIR_NAME = "icons";
    private static final String ICONS_X16_DIR_NAME = "x16";
    private static final String CONNECTION_ICONS_DIR_NAME = "connectionIcons";
    private static final BOrd CONNECTION_ICONS_MODULE_ORD = BOrd.make((String)"module://nE2Link/rc/icons/connectionIcons");
    public static BOrd ICONS_X16_MODULE_ORD = BOrd.make((String)"module://nE2Link/rc/icons/x16");
    public static final BOrd ICONS_X16_FILE_ORD = BOrd.make((BOrd)NANO_SHARED_DIR_ORD, (String)"file:icons/x16");
    private static final BIcon ICON_RED = BIcon.make((String)(CONNECTION_ICONS_MODULE_ORD.toString() + "/MISC_UI_LED_RED.svg"));
    private static final BIcon ICON_GREY = BIcon.make((String)(CONNECTION_ICONS_MODULE_ORD.toString() + "/MISC_UI_LED_GREY.svg"));
    private static final BIcon ICON_ORANGE = BIcon.make((String)(CONNECTION_ICONS_MODULE_ORD.toString() + "/MISC_UI_LED_ORANGE.svg"));
    private static final BIcon ICON_YELLOW = BIcon.make((String)(CONNECTION_ICONS_MODULE_ORD.toString() + "/MISC_UI_LED_YELLOW.svg"));
    private static final BIcon ICON_GREEN = BIcon.make((String)(CONNECTION_ICONS_MODULE_ORD.toString() + "/MISC_UI_LED_GREEN.svg"));
    public static final Property icon = BNe2DeviceExt.newProperty((int)5, (BValue)ICON_GREY, null);
    public static final Property asyncConfig = BNe2DeviceExt.newProperty((int)4, (BValue)new BAsyncConfig(), null);
    public static final Property config = BNe2DeviceExt.newProperty((int)4, (BValue)new BNanoConfig(), null);
    public static final Property activity = BNe2DeviceExt.newProperty((int)11, (String)"Ready", null);
    public static final Property applicationIsLoading = BNe2DeviceExt.newProperty((int)1, (boolean)false, null);
    public static final Property pollScheduler = BNe2DeviceExt.newProperty((int)0, (BValue)new BNanoPollScheduler(), null);
    public static final Property pollFrequency = BNe2DeviceExt.newProperty((int)0, (BValue)BPollFrequency.normal, null);
    public static final Property HostModel = BNe2DeviceExt.newProperty((int)1, (String)"", null);
    public static final Property softwareManager = BNe2DeviceExt.newProperty((int)0, (BValue)new BSoftwareManager(), null);
    public static final Property libraries = BNe2DeviceExt.newProperty((int)0, (BValue)new BLibraries(), null);
    public static final Property currentDisplayMode = BNe2DeviceExt.newProperty((int)4, (BValue)BDisplayModeEnum.DEFAULT, null);
    public static final Action connect = BNe2DeviceExt.newAction((int)16, (BValue)new BConnectionDataArg(), null);
    public static final Action disconnect = BNe2DeviceExt.newAction((int)16, null);
    public static final Action selectDisplayMode = BNe2DeviceExt.newAction((int)16, (BValue)BDisplayModeEnum.DEFAULT, null);
    public static final Action loadSchema = BNe2DeviceExt.newAction((int)20, null);
    public static final Action loadTree = BNe2DeviceExt.newAction((int)20, null);
    public static final Action loadLogs = BNe2DeviceExt.newAction((int)20, null);
    public static final Action enableSubscriptionHandling = BNe2DeviceExt.newAction((int)4, (BValue)BBoolean.TRUE, (BFacets)BFacets.make((BFacets)BFacets.make((String)"trueText", (String)"%lexicon(nE2Link:Ne2DeviceExt.enableSubscriptionHandling.trueText)%"), (BFacets)BFacets.make((String)"falseText", (String)"%lexicon(nE2Link:Ne2DeviceExt.enableSubscriptionHandling.falseText)%")));
    public static final Action enablePolling = BNe2DeviceExt.newAction((int)4, (BValue)BBoolean.TRUE, (BFacets)BFacets.make((BFacets)BFacets.make((String)"trueText", (String)"%lexicon(nE2Link:Ne2DeviceExt.enablePolling.trueText)%"), (BFacets)BFacets.make((String)"falseText", (String)"%lexicon(nE2Link:Ne2DeviceExt.enablePolling.falseText)%")));
    public static final Action getPerformanceAnalysis = BNe2DeviceExt.newAction((int)16, null);
    public static final Action getLocalLibraries = BNe2DeviceExt.newAction((int)4, null);
    public static final Action getOsLibraries = BNe2DeviceExt.newAction((int)4, null);
    public static final Action getNanoComponentByName = BNe2DeviceExt.newAction((int)4, (BValue)BString.DEFAULT, null);
    public static final Action getBackups = BNe2DeviceExt.newAction((int)4, (BValue)new BBackupRestoreArgs(), null);
    public static final Action downloadBackup = BNe2DeviceExt.newAction((int)20, (BValue)new BBackupRestoreArgs(), null);
    public static final Action deleteBackup = BNe2DeviceExt.newAction((int)4, (BValue)new BBackupRestoreArgs(), null);
    public static final Action restoreBackup = BNe2DeviceExt.newAction((int)20, (BValue)new BBackupRestoreArgs(), null);
    public static final Action getStationCurrentTime = BNe2DeviceExt.newAction((int)4, null);
    public static final Action getNanoComponentByPersistentId = BNe2DeviceExt.newAction((int)4, (BValue)BString.DEFAULT, null);
    public static final Action updateWbUi = BNe2DeviceExt.newAction((int)20, (BValue)new BComponent(), null);
    public static final Action requestNanoSubscription = BNe2DeviceExt.newAction((int)20, (BValue)new BNanoComponent(), null);
    public static final Action requestNanoPermanentSubscription = BNe2DeviceExt.newAction((int)20, (BValue)new BNanoPermanentSubscriptionArg(), null);
    public static final Action requestNanoUnsubscription = BNe2DeviceExt.newAction((int)20, (BValue)new BNanoComponent(), null);
    public static final Action requestNanoPermanentUnsubscription = BNe2DeviceExt.newAction((int)20, (BValue)new BNanoPermanentUnsubscriptionArg(), null);
    public static final Action handleNanoInvocation = BNe2DeviceExt.newAction((int)20, (BValue)new BNanoInvocationArg(), null);
    public static final Action handleNanoPropertyValueChange = BNe2DeviceExt.newAction((int)20, (BValue)new BNanoPropertyChangedArg(), null);
    public static final Action handleNanoLinkCreation = BNe2DeviceExt.newAction((int)20, (BValue)new BNanoLinkInfoArg(), null);
    public static final Action handleNanoLinkDeletion = BNe2DeviceExt.newAction((int)20, (BValue)new BNanoLinkInfoArg(), null);
    public static final Action handleNanoComponentsCreation = BNe2DeviceExt.newAction((int)20, (BValue)new BNanoComponentListArg(), null);
    public static final Action handleNanoComponentDeletion = BNe2DeviceExt.newAction((int)20, (BValue)new BNanoComponent(), null);
    public static final Action handleNanoComponentRename = BNe2DeviceExt.newAction((int)20, (BValue)new BNanoComponentRenameArg(), null);
    public static final Action handleNanoExtensionCreation = BNe2DeviceExt.newAction((int)20, (BValue)new BNanoAddExtensionArg(), null);
    public static final Action handleNanoExtensionDeletion = BNe2DeviceExt.newAction((int)20, (BValue)new BNanoDeleteExtensionArg(), null);
    public static final Action handleNanoScheduleChanged = BNe2DeviceExt.newAction((int)20, (BValue)new BNanoScheduleChangedArg(), null);
    public static final Action setNanoTime = BNe2DeviceExt.newAction((int)20, (BValue)new BNanoTimeChangeArg(), null);
    public static final Action handleNanoLabelsUpdate = BNe2DeviceExt.newAction((int)20, (BValue)new BDynamicChoiceRangeChangedArg(), null);
    public static final Type TYPE = Sys.loadType(BNe2DeviceExt.class);
    private final Object subscriptionLock = new Object();
    private RemoteDevice remoteDevice = null;
    protected static Logger LOGGER = Logger.getLogger(TYPE.getTypeSpec().getModuleName());
    private XmlLinkCache xmlLinkCache = new XmlLinkCache();
    private LinkCache linkCache = new LinkCache();
    private ComponentCache componentCache = new ComponentCache();
    private final NanoSubscriptionHandler nanoSubscriptionHandler = new NanoSubscriptionHandler();
    public static final Context TIME_FORMAT_MILLIS_CONTEXT = new BasicContext(Context.NULL, BFacets.make((String[])new String[]{"showSeconds", "showMilliseconds"}, (BIDataValue[])new BIDataValue[]{BBoolean.TRUE, BBoolean.TRUE}));
    private BAbsTime startTime;
    private BAbsTime endTime;
    private BAbsTime startTimeConnect;
    private BAbsTime endTimeConnect;
    private BAbsTime startTimeLoadTree;
    private BAbsTime endTimeLoadTree;
    private BAbsTime startTimeParseTree;
    private BAbsTime endTimeParseTree;
    private BAbsTime startTimeLoadSchema;
    private BAbsTime endTimeLoadSchema;
    private BAbsTime startTimeParseSchema;
    private BAbsTime endTimeParseSchema;
    private BAbsTime startTimeParseLinks;
    private BAbsTime endTimeParseLinks;
    private boolean isSubscriptionEnabled = true;
    private final int NE2LINK_MAX_CONNECTIONS = 2;
    private Clock.Ticket retryAfterTicket = Clock.expiredTicket;
    private static Object syncObject = new Object();
    private static boolean processingPatchRequest = false;
    private BNanoBaseComponent[] lastToSubscribe = new BNanoBaseComponent[0];
    protected static final Lexicon LEX = Lexicon.make(BNe2DeviceExt.class);

    public BIcon getIcon() {
        return (BIcon)this.get(icon);
    }

    public void setIcon(BIcon v) {
        this.set(icon, (BValue)v, null);
    }

    public BAsyncConfig getAsyncConfig() {
        return (BAsyncConfig)this.get(asyncConfig);
    }

    public void setAsyncConfig(BAsyncConfig v) {
        this.set(asyncConfig, (BValue)v, null);
    }

    public BNanoConfig getConfig() {
        return (BNanoConfig)this.get(config);
    }

    public void setConfig(BNanoConfig v) {
        this.set(config, (BValue)v, null);
    }

    public String getActivity() {
        return this.getString(activity);
    }

    public void setActivity(String v) {
        this.setString(activity, v, null);
    }

    public boolean getApplicationIsLoading() {
        return this.getBoolean(applicationIsLoading);
    }

    public void setApplicationIsLoading(boolean v) {
        this.setBoolean(applicationIsLoading, v, null);
    }

    public BNanoPollScheduler getPollScheduler() {
        return (BNanoPollScheduler)this.get(pollScheduler);
    }

    public void setPollScheduler(BNanoPollScheduler v) {
        this.set(pollScheduler, (BValue)v, null);
    }

    public BPollFrequency getPollFrequency() {
        return (BPollFrequency)this.get(pollFrequency);
    }

    public void setPollFrequency(BPollFrequency v) {
        this.set(pollFrequency, (BValue)v, null);
    }

    public String getHostModel() {
        return this.getString(HostModel);
    }

    public void setHostModel(String v) {
        this.setString(HostModel, v, null);
    }

    public BSoftwareManager getSoftwareManager() {
        return (BSoftwareManager)this.get(softwareManager);
    }

    public void setSoftwareManager(BSoftwareManager v) {
        this.set(softwareManager, (BValue)v, null);
    }

    public BLibraries getLibraries() {
        return (BLibraries)this.get(libraries);
    }

    public void setLibraries(BLibraries v) {
        this.set(libraries, (BValue)v, null);
    }

    public BDisplayModeEnum getCurrentDisplayMode() {
        return (BDisplayModeEnum)this.get(currentDisplayMode);
    }

    public void setCurrentDisplayMode(BDisplayModeEnum v) {
        this.set(currentDisplayMode, (BValue)v, null);
    }

    public void connect(BConnectionDataArg parameter) {
        this.invoke(connect, (BValue)parameter, null);
    }

    public void disconnect() {
        this.invoke(disconnect, null, null);
    }

    public void selectDisplayMode(BDisplayModeEnum parameter) {
        this.invoke(selectDisplayMode, (BValue)parameter, null);
    }

    public void loadSchema() {
        this.invoke(loadSchema, null, null);
    }

    public void loadTree() {
        this.invoke(loadTree, null, null);
    }

    public void loadLogs() {
        this.invoke(loadLogs, null, null);
    }

    public void enableSubscriptionHandling(BBoolean parameter) {
        this.invoke(enableSubscriptionHandling, (BValue)parameter, null);
    }

    public void enablePolling(BBoolean parameter) {
        this.invoke(enablePolling, (BValue)parameter, null);
    }

    public void getPerformanceAnalysis() {
        this.invoke(getPerformanceAnalysis, null, null);
    }

    public BString getLocalLibraries() {
        return (BString)this.invoke(getLocalLibraries, null, null);
    }

    public BString getOsLibraries() {
        return (BString)this.invoke(getOsLibraries, null, null);
    }

    public BValue getNanoComponentByName(BString parameter) {
        return this.invoke(getNanoComponentByName, (BValue)parameter, null);
    }

    public BString getBackups(BBackupRestoreArgs parameter) {
        return (BString)this.invoke(getBackups, (BValue)parameter, null);
    }

    public void downloadBackup(BBackupRestoreArgs parameter) {
        this.invoke(downloadBackup, (BValue)parameter, null);
    }

    public BBoolean deleteBackup(BBackupRestoreArgs parameter) {
        return (BBoolean)this.invoke(deleteBackup, (BValue)parameter, null);
    }

    public void restoreBackup(BBackupRestoreArgs parameter) {
        this.invoke(restoreBackup, (BValue)parameter, null);
    }

    public BLong getStationCurrentTime() {
        return (BLong)this.invoke(getStationCurrentTime, null, null);
    }

    public BOrd getNanoComponentByPersistentId(BString parameter) {
        return (BOrd)this.invoke(getNanoComponentByPersistentId, (BValue)parameter, null);
    }

    public void updateWbUi(BComponent parameter) {
        this.invoke(updateWbUi, (BValue)parameter, null);
    }

    public void requestNanoSubscription(BNanoBaseComponent parameter) {
        this.invoke(requestNanoSubscription, (BValue)parameter, null);
    }

    public void requestNanoPermanentSubscription(BNanoPermanentSubscriptionArg parameter) {
        this.invoke(requestNanoPermanentSubscription, (BValue)parameter, null);
    }

    public void requestNanoUnsubscription(BNanoBaseComponent parameter) {
        this.invoke(requestNanoUnsubscription, (BValue)parameter, null);
    }

    public void requestNanoPermanentUnsubscription(BNanoPermanentUnsubscriptionArg parameter) {
        this.invoke(requestNanoPermanentUnsubscription, (BValue)parameter, null);
    }

    public void handleNanoInvocation(BNanoInvocationArg parameter) {
        this.invoke(handleNanoInvocation, (BValue)parameter, null);
    }

    public void handleNanoPropertyValueChange(BNanoPropertyChangedArg parameter) {
        this.invoke(handleNanoPropertyValueChange, (BValue)parameter, null);
    }

    public void handleNanoLinkCreation(BNanoLinkInfoArg parameter) {
        this.invoke(handleNanoLinkCreation, (BValue)parameter, null);
    }

    public void handleNanoLinkDeletion(BNanoLinkInfoArg parameter) {
        this.invoke(handleNanoLinkDeletion, (BValue)parameter, null);
    }

    public void handleNanoComponentsCreation(BNanoComponentListArg parameter) {
        this.invoke(handleNanoComponentsCreation, (BValue)parameter, null);
    }

    public void handleNanoComponentDeletion(BNanoBaseComponent parameter) {
        this.invoke(handleNanoComponentDeletion, (BValue)parameter, null);
    }

    public void handleNanoComponentRename(BNanoComponentRenameArg parameter) {
        this.invoke(handleNanoComponentRename, (BValue)parameter, null);
    }

    public void handleNanoExtensionCreation(BNanoAddExtensionArg parameter) {
        this.invoke(handleNanoExtensionCreation, (BValue)parameter, null);
    }

    public void handleNanoExtensionDeletion(BNanoDeleteExtensionArg parameter) {
        this.invoke(handleNanoExtensionDeletion, (BValue)parameter, null);
    }

    public void handleNanoScheduleChanged(BNanoScheduleChangedArg parameter) {
        this.invoke(handleNanoScheduleChanged, (BValue)parameter, null);
    }

    public void setNanoTime(BNanoTimeChangeArg parameter) {
        this.invoke(setNanoTime, (BValue)parameter, null);
    }

    public void handleNanoLabelsUpdate(BDynamicChoiceRangeChangedArg parameter) {
        this.invoke(handleNanoLabelsUpdate, (BValue)parameter, null);
    }

    public Type getType() {
        return TYPE;
    }

    private static void createDefaultFiles() {
        File sharedStationHome = Sys.getStationHome();
        File nanoSharedDir = new File(sharedStationHome, NANO_TARGET_DIR_NAME);
        FileUtil.copyOrdTargetToFile(CUSTOM_POINTS_MODULE_ORD, nanoSharedDir, true, false);
        FileUtil.copyOrdTargetToFile(LABELS_MODULE_ORD, nanoSharedDir, true, false);
        File nanoEdgeEngineSharedDir = new File(nanoSharedDir, NANO_EDGE_ENGINE_TARGET_DIR_NAME);
        FileUtil.copyOrdTargetToFile(OS_MODULE_ORD, nanoEdgeEngineSharedDir, true, false);
        FileUtil.copyOrdTargetToFile(LIBRARIES_MODULE_ORD, nanoEdgeEngineSharedDir, true, false);
    }

    public void started() throws Exception {
        this.getComponentCache().init();
        BNe2DeviceExt.createDefaultFiles();
        this.setIcon(this.getConnectionIcon());
        this.setHostModel(Nre.getHostModel());
    }

    public void stopped() throws Exception {
        this.nanoSubscriptionHandler.shutdown();
        this.getPollScheduler().unsubscribe(this);
    }

    public IFuture post(Action action, BValue argument, Context cx) {
        BNanoContextArg arg;
        if (action.getName().toLowerCase(Locale.ROOT).endsWith("subscription")) {
            this.getAsyncConfig().getSubscriptionWorker().postAsync((Runnable)new Invocation((BComponent)this, action, argument, cx));
            return null;
        }
        if (argument instanceof BNanoContextArg && cx != null && !cx.equals(Context.NULL) && !(arg = (BNanoContextArg)argument).getCallContext().getFacets().equals((Object)BFacets.NULL)) {
            arg.setCallContext(cx.getFacets());
        }
        this.getAsyncConfig().getMainPoolWorker().postAsync((Runnable)new Invocation((BComponent)this, action, argument, cx));
        return null;
    }

    public boolean isParentLegal(BComponent parent) {
        BNe2DeviceExt[] deviceExts;
        if (Sys.isStationStarted() && (deviceExts = (BNe2DeviceExt[])parent.getChildren(BNe2DeviceExt.class)).length > 0) {
            throw new LocalizableRuntimeException(TYPE.getModule().getModuleName(), "Ne2DeviceExt.duplicateExtension");
        }
        return parent.getType().is(BBacnetDevice.TYPE) || parent.getType().is(BModbusTcpDevice.TYPE);
    }

    public boolean isChildLegal(BComponent child) {
        BComponentSpace componentSpace = this.getComponentSpace();
        if (componentSpace == null || componentSpace.isProxyComponentSpace()) {
            return true;
        }
        if (child.getType().is(BNanoContainer.TYPE) && ((BNanoContainer[])this.getChildren(BNanoContainer.class)).length == 0) {
            return true;
        }
        throw new LocalizableRuntimeException(BNe2DeviceExt.LEX.module.getModuleName(), "Ne2DeviceExt.addFailed", new Object[]{child.getType(), this.getDisplayName(null)});
    }

    public AgentList getAgents(Context cx) {
        AgentList agents = super.getAgents(cx);
        BNanoConfig config = null;
        if (Sys.isStation()) {
            config = this.getConfig();
        } else {
            if (!this.isSubscribed()) {
                this.lease();
            }
            if (!(config = this.getConfig()).isSubscribed()) {
                config.lease(1);
            }
        }
        BConnectionStatus connectionStatus = config.getCommunicationSettings().getStatus();
        switch (connectionStatus.getOrdinal()) {
            case 2: 
            case 4: {
                agents.toTop("nE2Link:About");
                break;
            }
            case 0: 
            case 1: 
            case 3: {
                agents.toTop("nE2Link:Info");
                break;
            }
        }
        return agents;
    }

    public BIcon getConnectionIcon() {
        BNanoConfig config = null;
        if (Sys.isStation()) {
            config = this.getConfig();
        } else {
            if (!this.isSubscribed()) {
                this.lease();
            }
            if (!(config = this.getConfig()).isSubscribed()) {
                config.lease(1);
            }
        }
        BConnectionStatus connectionStatus = config.getCommunicationSettings().getStatus();
        switch (connectionStatus.getOrdinal()) {
            case 2: 
            case 4: {
                return ICON_GREY;
            }
            case 1: {
                return ICON_ORANGE;
            }
            case 0: {
                if (this.getApplicationIsLoading()) {
                    return ICON_YELLOW;
                }
                return ICON_GREEN;
            }
        }
        return super.getIcon();
    }

    private String makeDisplayNameWithIp(String ipAndPort, Context cx) {
        String currentDisplayName = this.getDisplayName(cx);
        String destination = "(" + ipAndPort + ")";
        String regexIPPort = "(.*)(\\(.*:.*\\))(.*)";
        if (currentDisplayName.matches(regexIPPort)) {
            return currentDisplayName.replaceFirst(regexIPPort, "$1" + destination + "$3");
        }
        return currentDisplayName.trim() + " " + destination;
    }

    public BValue getActionParameterDefault(Action action) {
        if (action.equals(connect)) {
            if (!Sys.isStation()) {
                this.lease(3);
            }
            BConnectionDataArg connectionData = new BConnectionDataArg();
            connectionData.setIpAddress(this.getConfig().getCommunicationSettings().getIpAddress());
            connectionData.setPort(this.getConfig().getCommunicationSettings().getPort());
            connectionData.setUserName(this.getConfig().getAuthenticationSettings().getUser().getNanoName());
            connectionData.setPassword(this.getConfig().getAuthenticationSettings().getUser().getPassword());
            return connectionData;
        }
        if (action.equals(selectDisplayMode)) {
            switch (this.getCurrentDisplayMode().getOrdinal()) {
                case -1: {
                    return BDisplayModeEnum.Standard;
                }
                case 0: {
                    return BDisplayModeEnum.Developer;
                }
            }
        }
        return super.getActionParameterDefault(action);
    }

    public boolean isConnected() {
        return this.getRemoteDevice() != null && this.getRemoteDevice().Remote.isConnected();
    }

    public void doEnableSubscriptionHandling(BBoolean enabled) {
        this.isSubscriptionEnabled = enabled.getBoolean();
    }

    public boolean isSubscriptionEnabled() {
        return this.isSubscriptionEnabled;
    }

    public NanoSubscriptionHandler getNanoSubscriptionHandler() {
        return this.nanoSubscriptionHandler;
    }

    public void doEnablePolling(BBoolean enabled) {
        this.getPollScheduler().setPollEnabled(enabled.getBoolean());
    }

    public boolean isPollingEnabled() {
        return this.getPollScheduler().getPollEnabled();
    }

    public void doConnect(BConnectionDataArg connectionData, Context cx) throws Exception {
        if (!this.getHostModel().equals("Workstation") && this.doGetTotalnE2LinkConnections() >= 2) {
            BMessageNotification notification = BMessageNotification.make(BMessageTypeEnum.error, LEX.getText("Ne2DeviceExt.maxNE2LinkConnections.title"), LEX.getText("Ne2DeviceExt.maxNE2LinkConnections.message", new Object[]{2}));
            notification.raise(cx);
            return;
        }
        this.doEnablePolling(BBoolean.FALSE);
        this.doEnableSubscriptionHandling(BBoolean.FALSE);
        this.resetPerformanceCounters();
        BRefreshNotification treeRefresh = BRefreshNotification.make(BRefreshTargets.make(22), this);
        if (connectionData.getReloadApplication()) {
            String ipAndPort = connectionData.getAddress();
            ((BComponent)this.getParent()).setDisplayName(this.getPropertyInParent(), BFormat.make((String)this.makeDisplayNameWithIp(ipAndPort, cx)), cx);
            this.setActivity("Deleting application");
            this.clearApplication();
        }
        if (connectionData.getRememberIpAddress()) {
            this.getConfig().getCommunicationSettings().setIpAddress(connectionData.getIpAddress());
            this.getConfig().getCommunicationSettings().setPort(connectionData.getPort());
        }
        if (connectionData.getRememberUserAndPassword()) {
            this.getConfig().getAuthenticationSettings().getUser().setNanoName(connectionData.getUserName());
            this.getConfig().getAuthenticationSettings().getUser().setPassword(connectionData.getPassword());
        }
        this.setActivity("Connecting...");
        this.startTimeConnect = this.startTime = BAbsTime.now();
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("connect");
        }
        this.getConfig().getCommunicationSettings().setStatus(BConnectionStatus.connecting);
        this.remoteDevice = new RemoteDevice(connectionData.getIpAddress(), connectionData.getPort());
        this.remoteDevice.Remote.OnConnectionChange.addListener("MonitorConnection", this::monitorConnection);
        ConnectionResult connectionResult = this.remoteDevice.Connect(connectionData.getUserName(), connectionData.getPassword().getDecryptedPassword());
        boolean isConnected = this.remoteDevice.Remote.isConnected();
        LOGGER.info(() -> "[BIsmaNanoDevice.doConnect] connectionResult: " + (Object)((Object)connectionResult));
        LOGGER.info(() -> "[BIsmaNanoDevice.doConnect] isConnected: " + isConnected);
        this.endTimeConnect = BAbsTime.now();
        switch (connectionResult) {
            case CONNECTED: {
                if (connectionData.getPassword().getDecryptedPassword().equals("admin")) {
                    BMessageNotification notification = BMessageNotification.make(BMessageTypeEnum.error, LEX.getText("Ne2DeviceExt.passwordIsDefault.title"), LEX.getText("Ne2DeviceExt.passwordIsDefault.message", new Object[]{connectionData.getUserName()}));
                    notification.raise(cx);
                }
                if (connectionData.getReloadApplication()) {
                    this.startTimeLoadSchema = this.endTimeConnect;
                    this.setApplicationIsLoading(true);
                    this.setIcon(this.getConnectionIcon());
                    treeRefresh.raise(cx);
                    this.doLoadSchema(cx);
                    this.startTimeLoadTree = this.endTimeConnect;
                    this.doLoadTree(cx);
                }
                this.getPollScheduler().subscribe(this);
                break;
            }
            case NOT_AUTHENTICATED: {
                BMessageNotification notification = BMessageNotification.make(BMessageTypeEnum.error, LEX.getText("Ne2DeviceExt.passwordIsDefault.title"), LEX.getText("Ne2DeviceExt.wrongCredintials.message"));
                notification.raise(cx);
                this.setActivity("Connection failed");
                break;
            }
            default: {
                BMessageNotification notification = BMessageNotification.make(BMessageTypeEnum.error, LEX.getText("Ne2DeviceExt.deviceUnreachable.title"), LEX.getText("Ne2DeviceExt.deviceUnreachable.message"));
                notification.raise(cx);
                this.setActivity("Connection failed");
            }
        }
        this.endTime = BAbsTime.now();
        this.setApplicationIsLoading(false);
        this.getConfig().getCommunicationSettings().setStatus(this.remoteDevice.Remote.isConnected() ? BConnectionStatus.connected : BConnectionStatus.disconnected);
        this.setIcon(this.getConnectionIcon());
        treeRefresh.raise(cx);
        Clock.schedule((BComponent)this, (BRelTime)BRelTime.make((long)200L), (Action)enableSubscriptionHandling, (BValue)BBoolean.TRUE);
        Clock.schedule((BComponent)this, (BRelTime)BRelTime.make((long)200L), (Action)enablePolling, (BValue)BBoolean.TRUE);
    }

    private void clearApplication() {
        BLibrary[] libraries;
        BAbsTime startTime = BAbsTime.now();
        BNanoBaseComponent root = this.getNanoRoot(null);
        if (root != null) {
            this.remove((BComplex)root);
        }
        this.xmlLinkCache.clear();
        this.linkCache.clear();
        this.componentCache.clear();
        this.getLibraries().getLibraryComponentsCache().clear();
        for (BLibrary library : libraries = (BLibrary[])this.getLibraries().getChildren(BLibrary.class)) {
            this.getLibraries().remove(library.getPropertyInParent());
        }
        this.getNanoSubscriptionHandler().clearSubscriberLists();
        BAbsTime endTime = BAbsTime.now();
        System.out.println("---------SUMMARY APPLICATION DELETE TURNAROUND TIME---------\n   Start processing: " + startTime + "\n   End Processing: " + endTime + "\n   Total Time: " + (endTime.getMillis() - startTime.getMillis()) + " ms");
    }

    public void doDisconnect(Context cx) {
        this.clearApplication();
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("disconnect");
        }
        this.getConfig().getCommunicationSettings().setStatus(BConnectionStatus.disconnecting);
        String ipAndPort = this.getConfig().getCommunicationSettings().getAddress();
        ((BComponent)this.getParent()).setDisplayName(this.getPropertyInParent(), BFormat.make((String)this.makeDisplayNameWithIp(ipAndPort, cx)), cx);
        if (this.retryAfterTicket != null) {
            this.retryAfterTicket.cancel();
        }
        if (this.remoteDevice != null) {
            this.remoteDevice.Remote.OnConnectionChange.removeListener("MonitorConnection");
        }
        if (!this.isConnected()) {
            this.remoteDevice.Remote.Disconnect(true);
            this.remoteDevice = null;
        }
        this.setActivity("Permanently Disconnected");
        this.getConfig().getCommunicationSettings().setStatus(BConnectionStatus.permanentlyDisconnected);
        this.getPollScheduler().unsubscribe(this);
    }

    public void doSelectDisplayMode(BDisplayModeEnum displayMode, Context cx) {
        Context tx = Transaction.start((BComponent)this, (Context)cx);
        switch (displayMode.getOrdinal()) {
            case -1: {
                this.setFlags((Slot)config, this.getFlags((Slot)config) & 0xFFFFFFFB, tx);
                this.setFlags((Slot)asyncConfig, this.getFlags((Slot)asyncConfig) & 0xFFFFFFFB, tx);
                break;
            }
            default: {
                this.setFlags((Slot)config, this.getFlags((Slot)config) | 4, tx);
                this.setFlags((Slot)asyncConfig, this.getFlags((Slot)asyncConfig) | 4, tx);
            }
        }
        BNanoBaseComponent root = this.getNanoRoot(cx);
        if (root != null) {
            root.doSelectDisplayMode(displayMode, tx);
        }
        try {
            Transaction.end((BComponent)this, (Context)tx);
            this.setCurrentDisplayMode(displayMode);
        }
        catch (Exception e) {
            throw new BajaRuntimeException("setDisplayMode failed", (Throwable)e);
        }
    }

    public BNanoBaseComponent getNanoRoot(Context cx) {
        BOrd query = BOrd.make((String)("bql:select from " + BNanoBaseComponent.TYPE.getTypeSpec().getTypeInfo() + " where !isLibraryComponent and globalIndex=0"));
        BITable result = (BITable)query.get((BObject)this, cx);
        TableCursor cursor = result.cursor();
        return cursor.next() ? (BNanoBaseComponent)((Object)cursor.get()) : null;
    }

    public void doLoadSchema(Context cx) {
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("getSchema");
        }
        if (this.remoteDevice != null && this.remoteDevice.Remote.isConnected()) {
            this.setActivity("Loading schema...");
            try {
                ArrayList<SerializableForm> schemaData = this.remoteDevice.Remote.Schema();
                this.startTimeParseSchema = this.endTimeLoadSchema = BAbsTime.now();
                BLibrary[] libraries = BinaryApplicationParser.parseLibraries(schemaData);
                this.getLibraries().getLibraryComponentsCache().clear();
                this.getLibraries().addLibraries(libraries, true);
                this.endTimeParseSchema = BAbsTime.now();
                this.setActivity("Ready");
            }
            catch (Exception e) {
                this.setActivity("Loading schema failed");
                e.printStackTrace();
            }
        } else {
            this.setActivity("Disconnected");
            LOGGER.severe("Remote device is not connected! Please connect to device first before invoking this action!");
        }
    }

    public void doLoadTree(Context cx) {
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("getTree");
        }
        if (this.remoteDevice != null && this.remoteDevice.Remote.isConnected()) {
            this.setActivity("Loading tree...");
            ArrayList<SerializableForm> treeData = this.remoteDevice.Remote.Tree();
            this.startTimeParseTree = this.endTimeLoadTree = BAbsTime.now();
            BNanoBaseComponent rootComponent = BinaryApplicationParser.parseTree(treeData, this);
            if (rootComponent != null) {
                this.addComponent(rootComponent, this, true);
                this.setDisplayName(rootComponent.getPropertyInParent(), BFormat.make((String)LEX.get(LEX_KEY_ROOT_DISPLAY_NAME, "Root")), cx);
                this.startTimeParseLinks = this.endTimeParseTree = BAbsTime.now();
                this.linkCache.createLinks();
                this.endTimeParseLinks = BAbsTime.now();
                this.doSelectDisplayMode(this.getCurrentDisplayMode(), cx);
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        BNe2DeviceExt.this.updateSoftwareManager();
                    }
                }).start();
            }
            this.setActivity("Ready");
        } else {
            this.setActivity("Disconnected");
            LOGGER.severe("Remote device is not connected! Please connect to device first before invoking this action!");
        }
    }

    public void doLoadLogs() {
        if (LOGGER.isLoggable(Level.INFO)) {
            LOGGER.info("getLogs");
        }
    }

    private void updateSoftwareManager() {
        BNanoBaseComponent platform = (BNanoBaseComponent)this.getNanoComponentByName(BString.make((String)"Platform"));
        platform.loadSlots();
        BSoftwareManager softwareManager = this.getSoftwareManager();
        softwareManager.setLastConnected(LocalDateTime.now().toString());
        softwareManager.setDeviceName(((BStatusString)platform.get("deviceName")).getValue());
        softwareManager.setModel(((BStatusString)platform.get("modelName")).getValue());
        softwareManager.setOSVersion(((BStatusString)platform.get("oSVersion")).getValue());
        softwareManager.setSerialNumber(((BStatusNumeric)platform.get("serialNumber")).getNumeric());
        BNanoBaseComponent ethernet = (BNanoBaseComponent)platform.get("Ethernet1");
        ethernet.loadSlots();
        softwareManager.setMacAddress(((BStatusString)ethernet.get("mACAddress")).getValue());
        BNanoBaseComponent license = (BNanoBaseComponent)this.getNanoComponentByName(BString.make((String)"License"));
        license.loadSlots();
        softwareManager.setMaximumDataPoints((int)((BStatusNumeric)license.get("maximumDataPoints")).getNumeric());
        softwareManager.setPing(this.getPollFrequency().getTag());
    }

    public BValue doGetNanoComponentByName(BString nanoName) {
        BNanoBaseComponent nanoComponent = null;
        String bqlQuery = "station:|" + this.getSlotPath().toString();
        BOrd queryOrd = BOrd.make((String)(bqlQuery = bqlQuery + "|bql:select * from " + BNanoBaseComponent.TYPE.getTypeSpec().toString() + " where nanoName='" + nanoName.getString() + "'"));
        BITable queryResult = (BITable)queryOrd.resolve((BObject)this).get();
        TableCursor c = queryResult.cursor();
        if (c.next()) {
            nanoComponent = (BNanoBaseComponent)((Object)c.get());
        }
        return nanoComponent;
    }

    public BOrd doGetNanoComponentByPersistentId(BString persistentId) {
        BNanoBaseComponent nanoComponent = null;
        String bqlQuery = "station:|" + this.getSlotPath().toString();
        BOrd queryOrd = BOrd.make((String)(bqlQuery = bqlQuery + "|bql:select * from " + BNanoBaseComponent.TYPE.getTypeSpec().toString() + " where persistentId='" + persistentId.getString() + "'"));
        BITable queryResult = (BITable)queryOrd.resolve((BObject)this).get();
        TableCursor c = queryResult.cursor();
        if (c.next()) {
            nanoComponent = (BNanoBaseComponent)((Object)c.get());
        }
        return null != nanoComponent ? nanoComponent.getSlotPathOrd() : BOrd.DEFAULT;
    }

    public String doGetControllerCurrentTime() {
        BNanoBaseComponent platform = (BNanoBaseComponent)this.getNanoComponentByName(BString.make((String)"Platform"));
        platform.loadSlots();
        BNanoComponent timeComponent = (BNanoComponent)platform.get("Time");
        return ((BStatusString)timeComponent.get("currentTime")).getValue();
    }

    public BLong doGetStationCurrentTime() {
        BLong ldt = BLong.DEFAULT;
        BPlatformServiceContainer platformServiceContainer = (BPlatformServiceContainer)Sys.getService((Type)BPlatformServiceContainer.TYPE);
        if (platformServiceContainer != null) {
            BSystemPlatformService platformService = ((BSystemPlatformService[])platformServiceContainer.getChildren(BSystemPlatformService.class))[0];
            long millis = platformService.getSystemTime().toNormalizedTime().getMillis();
            ZoneId zoneId = ZoneId.of(platformService.getTimeZone().getId());
            ldt = BLong.make((long)(Instant.ofEpochMilli(millis).atZone(zoneId).toEpochSecond() * 1000L));
        }
        return ldt;
    }

    public int doGetTotalnE2LinkConnections() {
        int count = 0;
        String bqlQuery = "station:|slot:/";
        bqlQuery = bqlQuery + "|bql:select * from " + TYPE.getTypeSpec().toString();
        BOrd queryOrd = BOrd.make((String)bqlQuery);
        BITable queryResult = (BITable)queryOrd.resolve((BObject)this).get();
        TableCursor c = queryResult.cursor();
        while (c.next()) {
            BNe2DeviceExt neE2Device = (BNe2DeviceExt)c.get();
            if (this.equals(neE2Device)) continue;
            BNanoConfig config = neE2Device.getConfig();
            config.lease(2);
            BConnectionStatus connectionStatus = config.getCommunicationSettings().getStatus();
            if (connectionStatus.getOrdinal() != 0) continue;
            ++count;
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void poll() {
        Object object = syncObject;
        synchronized (object) {
            PollRequest request = PollRequest.make(this);
            LOGGER.finer(request.getLocalizedMessage());
            PollResponse response = request.postRequest(this.remoteDevice);
            String message = response.getLocalizedMessage();
            for (int i = 0; i < response.getResponseDataSize(); ++i) {
                if (response.getResponseCode(i) != ResponseCode.OK) continue;
                AbstractNanoData responseData = response.getResponseData(i);
                if (responseData instanceof PollData) {
                    PollData pollData = (PollData)responseData;
                    pollData.updateNiagaraComponent(this);
                    continue;
                }
                if (responseData instanceof ObjectData) {
                    ObjectData objectData = (ObjectData)responseData;
                    BNanoBaseComponent updatedComponent = this.componentCache.get(objectData.getGlobalIndex());
                    try {
                        objectData.updateNiagaraComponent(this, updatedComponent, true);
                        LOGGER.fine("Updated component " + updatedComponent.getName());
                    }
                    catch (Exception exception) {}
                    continue;
                }
                if (!(responseData instanceof TreeData)) continue;
                TreeData treeData = (TreeData)responseData;
                treeData.updateNiagaraTree(this);
            }
            switch (response.getResponseCode()) {
                case OK: {
                    this.linkCache.createLinks();
                    LOGGER.finer(message);
                    break;
                }
                case NOT_CONNECTED: {
                    LOGGER.info(message);
                    this.getPollScheduler().unsubscribe(this);
                    break;
                }
                case ERROR: 
                case NO_RESPONSE: 
                case INVALID_RESPONSE: {
                    LOGGER.info(message);
                }
            }
        }
    }

    private void monitorConnection(Server remote) {
        BConnectionStatus connectionStatus = BConnectionStatus.disconnected;
        if (this.isConnected()) {
            connectionStatus = BConnectionStatus.connected;
        } else {
            connectionStatus = BConnectionStatus.permanentlyDisconnected;
            BMessageNotification notification = BMessageNotification.make(BMessageTypeEnum.deviceDisconnected);
            boolean broadcast = !(Thread.currentThread() instanceof ContextThread);
            notification.raise(broadcast);
        }
        this.getConfig().getCommunicationSettings().setStatus(connectionStatus);
    }

    public static String formatTime(BAbsTime time) {
        return TimeFormat.format((BAbsTime)time, (String)"DD-MM-YYYY HH:mm:ss.SSS", (Context)TIME_FORMAT_MILLIS_CONTEXT);
    }

    public void doGetPerformanceAnalysis() {
        System.out.println("---------SUMMARY TURNAROUND TIME---------\n   Start processing: " + BNe2DeviceExt.formatTime(this.startTime) + "\n   Return to Workbench: " + BNe2DeviceExt.formatTime(this.endTime) + "\n   Total Time: " + (this.endTime.getMillis() - this.startTime.getMillis()) + " ms");
        System.out.println("---------DETAILS---------");
        System.out.println("Device connecting time:\n   Start connecting: " + BNe2DeviceExt.formatTime(this.startTimeConnect) + "\n   End connecting: " + BNe2DeviceExt.formatTime(this.endTimeConnect) + "\n   Total Connection / Authentication Time: " + (this.endTimeConnect.getMillis() - this.startTimeConnect.getMillis()) + " ms");
        System.out.println("Schema processing time:\n   Start schema processing: " + BNe2DeviceExt.formatTime(this.startTimeLoadSchema) + "\n   End schema processing: " + BNe2DeviceExt.formatTime(this.endTimeParseSchema) + "\n   Schema loading time: " + (this.endTimeLoadSchema.getMillis() - this.startTimeLoadSchema.getMillis()) + " ms\n   Schema parsing time: " + (this.endTimeParseSchema.getMillis() - this.startTimeParseSchema.getMillis()) + " ms\n   Total Schema Processing Time: " + (this.endTimeParseSchema.getMillis() - this.startTimeLoadSchema.getMillis()) + " ms");
        System.out.println("Tree processing time:\n   Start tree processing: " + BNe2DeviceExt.formatTime(this.startTimeLoadTree) + "\n   End tree processing: " + BNe2DeviceExt.formatTime(this.endTimeParseTree) + "\n   Tree loading time: " + (this.endTimeLoadTree.getMillis() - this.startTimeLoadTree.getMillis()) + " ms\n   Tree parsing time: " + (this.endTimeParseTree.getMillis() - this.startTimeParseTree.getMillis()) + " ms\n   Total Tree Processing Time: " + (this.endTimeParseTree.getMillis() - this.startTimeLoadTree.getMillis()) + " ms");
        System.out.println("Link processing time:\n   Start Link processing: " + BNe2DeviceExt.formatTime(this.startTimeParseLinks) + "\n   End Link processing: " + BNe2DeviceExt.formatTime(this.endTimeParseLinks) + "\n   Total Link Processing Time: " + (this.endTimeParseLinks.getMillis() - this.startTimeParseLinks.getMillis()) + " ms");
        System.out.println("---------PROCESSING TIME TO COMPLETION---------");
        if (this.endTimeConnect.isAfter(this.endTime)) {
            this.endTime = this.endTimeConnect;
        }
        if (this.endTimeParseSchema.isAfter(this.endTime)) {
            this.endTime = this.endTimeParseSchema;
        }
        if (this.endTimeParseTree.isAfter(this.endTime)) {
            this.endTime = this.endTimeParseTree;
        }
        if (this.endTimeParseLinks.isAfter(this.endTime)) {
            this.endTime = this.endTimeParseLinks;
        }
        System.out.println("Total processing time:\n   Start processing: " + BNe2DeviceExt.formatTime(this.startTime) + "\n   End processing: " + BNe2DeviceExt.formatTime(this.endTime) + "\n   Total Processing Time: " + (this.endTime.getMillis() - this.startTime.getMillis()) + " ms");
    }

    private void resetPerformanceCounters() {
        this.startTime = BAbsTime.NULL;
        this.startTimeConnect = BAbsTime.NULL;
        this.startTimeLoadSchema = BAbsTime.NULL;
        this.startTimeParseSchema = BAbsTime.NULL;
        this.startTimeLoadTree = BAbsTime.NULL;
        this.startTimeParseTree = BAbsTime.NULL;
        this.startTimeParseLinks = BAbsTime.NULL;
        this.endTime = BAbsTime.NULL;
        this.endTimeConnect = BAbsTime.NULL;
        this.endTimeLoadSchema = BAbsTime.NULL;
        this.endTimeParseSchema = BAbsTime.NULL;
        this.endTimeLoadTree = BAbsTime.NULL;
        this.endTimeParseTree = BAbsTime.NULL;
        this.endTimeParseLinks = BAbsTime.NULL;
    }

    public Property[] addComponents(BNanoBaseComponent[] componentsToAdd, BComponent targetComponent, boolean replaceIfPresent) {
        ArrayList<Property> properties = new ArrayList<Property>();
        for (BNanoBaseComponent component : componentsToAdd) {
            Property property = this.addComponent(component, targetComponent, replaceIfPresent);
            if (property == null) continue;
            properties.add(property);
        }
        return properties.toArray(new Property[0]);
    }

    public Property addComponent(BNanoBaseComponent componentToAdd, BComponent targetComponent, boolean replaceIfPresent) {
        Property compProperty = targetComponent.getProperty(componentToAdd.getDefaultPropertyName());
        if (compProperty != null && replaceIfPresent) {
            targetComponent.remove(compProperty);
            LOGGER.info("Reloaded component '" + (Object)((Object)componentToAdd) + "' under target '" + targetComponent + "'.");
            return targetComponent.add(componentToAdd.getDefaultPropertyName(), (BValue)componentToAdd, 1);
        }
        if (compProperty != null) {
            LOGGER.info("Skipped adding component '" + (Object)((Object)componentToAdd) + "' under target '" + targetComponent + "'. Already present.");
            return null;
        }
        LOGGER.info("Added new component '" + (Object)((Object)componentToAdd) + "' under target '" + targetComponent + "'.");
        return targetComponent.add(componentToAdd.getDefaultPropertyName(), (BValue)componentToAdd, 1);
    }

    public void doUpdateWbUi(BComponent componentToRefresh) {
        try {
            BRefreshNotification notification = BRefreshNotification.make(BRefreshTargets.make(6), componentToRefresh, "from [BNe2DeviceExt.doUpdateWbUi]");
            boolean broadcast = !(Thread.currentThread() instanceof ContextThread);
            notification.raise(broadcast);
        }
        catch (Exception e) {
            System.out.println("WB REFRESH NOTIFICATION FAILED");
        }
    }

    public void doRequestNanoSubscription(BNanoBaseComponent componentToSubscribe) {
        if (componentToSubscribe != null) {
            LOGGER.finer(String.format("[%s]: ### FORWARDING SUBSCRIPTION TO nE\u00b2; Component: '%s'; Thread: '%s' ", BNe2DeviceExt.formatTime(BAbsTime.now()), componentToSubscribe.isMounted() ? componentToSubscribe.getNavOrd() : componentToSubscribe.getNanoName(), Thread.currentThread().getName()));
            this.nanoSubscriptionHandler.subscribeComponent(componentToSubscribe);
        }
    }

    public void doRequestNanoPermanentSubscription(BNanoPermanentSubscriptionArg componentsToSubscribe) {
        if (componentsToSubscribe != null) {
            LOGGER.finer(String.format("[%s]: ### FORWARDING PERMANENT SUBSCRIPTION TO nE\u00b2; Components: '%s'; Thread: '%s' ", new Object[]{BNe2DeviceExt.formatTime(BAbsTime.now()), componentsToSubscribe, Thread.currentThread().getName()}));
            this.nanoSubscriptionHandler.subscribeComponentsPermanently(componentsToSubscribe);
        }
    }

    public void doRequestNanoPermanentUnsubscription(BNanoPermanentUnsubscriptionArg componentsToUnsubscribe) {
        if (componentsToUnsubscribe != null) {
            LOGGER.finer(String.format("[%s]: ### FORWARDING PERMANENT SUBSCRIPTION TO nE\u00b2; Components: '%s'; Thread: '%s' ", new Object[]{BNe2DeviceExt.formatTime(BAbsTime.now()), componentsToUnsubscribe, Thread.currentThread().getName()}));
            this.nanoSubscriptionHandler.unsubscribeComponentsPermanently(componentsToUnsubscribe);
        }
    }

    public void doRequestNanoUnsubscription(BNanoBaseComponent componentToUnsubscribe) {
        if (componentToUnsubscribe != null) {
            LOGGER.finer(String.format("[%s]: ### NOT IMPLEMENTED!!! NOT FORWARDING UNSUBSCRIPTION TO nE\u00b2; Component: '%s'; Thread: '%s' ", BNe2DeviceExt.formatTime(BAbsTime.now()), componentToUnsubscribe.getNavOrd(), Thread.currentThread().getName()));
        }
    }

    public void doHandleNanoSubscription(BNanoBaseComponent[] toSubscribe) {
        if (toSubscribe == null || toSubscribe.length == 0) {
            return;
        }
        this.lastToSubscribe = toSubscribe;
        StringBuffer sb = new StringBuffer("-----------------SUBSCRIPTION RESULT: ---------------\n");
        SubscribeRequest request = SubscribeRequest.make(this, toSubscribe);
        LOGGER.fine(request.getLocalizedMessage());
        SubscribeResponse response = request.postRequest(this.remoteDevice);
        String message = response.getLocalizedMessage();
        LOGGER.fine(message);
        for (int i = 0; i < response.getResponseDataSize(); ++i) {
            response.getResponseData(i).updateNiagaraComponent(this);
        }
    }

    public List<BNanoBaseComponent> doHandleNanoUnsubscription(BNanoBaseComponent[] toUnsubscribe) {
        UnsubscribeRequest unsubscribeRequest = UnsubscribeRequest.make(this, toUnsubscribe);
        LOGGER.fine(unsubscribeRequest.getLocalizedMessage());
        UnsubscribeResponse response = unsubscribeRequest.postRequest(this.remoteDevice);
        LOGGER.fine(response.getLocalizedMessage());
        return response.getSuccessfullyUnsubscribedComponents();
    }

    public void doHandleNanoInvocation(BNanoInvocationArg invocationArg) {
        InvokeRequest request = InvokeRequest.make(this, invocationArg);
        LOGGER.fine(request.getLocalizedMessage());
        InvokeResponse response = request.postRequest(this.remoteDevice);
        String message = response.getLocalizedMessage();
        LOGGER.fine(message);
        switch (response.getResponseCode()) {
            case OK: {
                break;
            }
            default: {
                LOGGER.info(message);
                String title = LEX.get("INVOKE_ERROR_TITLE", "Action Invocation Error");
                BMessageNotification notification = BMessageNotification.make(BMessageTypeEnum.error, title, message);
                notification.raise((Context)invocationArg.getCallContext());
            }
        }
    }

    public void doHandleNanoPropertyValueChange(BNanoPropertyChangedArg changedArg) {
        WriteRequest request = WriteRequest.make(this, changedArg);
        LOGGER.fine(request.getLocalizedMessage());
        WriteResponse response = request.postRequest(this.remoteDevice);
        String message = response.getLocalizedMessage();
        LOGGER.fine(message);
        switch (response.getResponseCode()) {
            case OK: {
                BNanoBaseComponent updatedComponent = response.getResponseData().updateNiagaraComponent(this);
                break;
            }
            default: {
                BNanoBaseComponent comp = changedArg.getSourceComponent();
                Property changedProp = changedArg.getChangedProperty();
                comp.set(changedProp, changedArg.getOldValue().newCopy(), Context.decoding);
                String title = LEX.get("WRITE_ERROR_TITLE", "Property Value Change Error");
                BMessageNotification notification = BMessageNotification.make(BMessageTypeEnum.error, title, message);
                notification.raise((Context)changedArg.getCallContext());
            }
        }
    }

    public void doHandleNanoLinkCreation(BNanoLinkInfoArg linkInfo) {
        LinkRequest request = LinkRequest.make(this, linkInfo);
        LOGGER.fine(request.getLocalizedMessage());
        LinkResponse response = request.postRequest(this.remoteDevice);
        String message = response.getLocalizedMessage();
        LOGGER.fine(message);
        switch (response.getResponseCode()) {
            case OK: {
                return;
            }
            case NOT_CONNECTED: 
            case ERROR: 
            case NO_RESPONSE: 
            case INVALID_RESPONSE: {
                String title = LEX.get("LINK_ERROR_TITLE", "Link Creation Error");
                BMessageNotification notification = BMessageNotification.make(BMessageTypeEnum.error, title, message);
                notification.raise((Context)linkInfo.getCallContext());
                BNanoBaseComponent targetComponent = this.componentCache.get(linkInfo.getTargetComponentGlobalIndex());
                if (targetComponent == null) break;
                targetComponent.removeLink(linkInfo);
            }
        }
    }

    public void doHandleNanoLinkDeletion(BNanoLinkInfoArg linkInfo) {
        UnlinkRequest request = UnlinkRequest.make(this, linkInfo);
        LOGGER.fine(request.getLocalizedMessage());
        UnlinkResponse response = request.postRequest(this.remoteDevice);
        String message = response.getLocalizedMessage();
        LOGGER.fine(message);
        switch (response.getResponseCode()) {
            case OK: {
                return;
            }
            case ERROR: {
                return;
            }
            case NOT_CONNECTED: 
            case NO_RESPONSE: 
            case INVALID_RESPONSE: {
                throw new LocalizableRuntimeException(BNe2DeviceExt.LEX.module.getModuleName(), message);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doHandleNanoComponentsCreation(BNanoComponentListArg newComponents, Context context) {
        ArrayList<BNanoBaseComponent> successfullyAddedComponents = new ArrayList<BNanoBaseComponent>();
        HashMap linkMap = new HashMap();
        BBoolean wasSubscriptionEnabled = BBoolean.make((boolean)this.isSubscriptionEnabled());
        this.doEnableSubscriptionHandling(BBoolean.FALSE);
        BBoolean wasPollingEnabled = BBoolean.make((boolean)this.isPollingEnabled());
        this.doEnablePolling(BBoolean.FALSE);
        ArrayList<BNanoBaseComponent> componentsToAdd = new ArrayList<BNanoBaseComponent>();
        for (int i = 0; i < newComponents.size(); ++i) {
            BNanoBaseComponent componentToAdd = newComponents.getComponent(i);
            List childComponents = Arrays.stream(componentToAdd.getDescendants(BNanoBaseComponent.class, true, false)).map(niagaraComponent -> {
                ArrayList<BNiagaraLinkInfo> linkInfos = this.getLinkInfos((BNanoBaseComponent)((Object)((Object)niagaraComponent)));
                if (linkInfos.size() > 0) {
                    linkMap.put(niagaraComponent.getNavOrd(), linkInfos);
                }
                return niagaraComponent;
            }).collect(Collectors.toList());
            componentsToAdd.addAll(childComponents);
        }
        StringBuilder logMessage = new StringBuilder(LEX.getText("ADD_REQUEST_SUMMARY", new Object[]{componentsToAdd.size()}));
        StringBuilder userMessage = new StringBuilder();
        ResponseCode lastError = ResponseCode.OK;
        try {
            for (BNanoBaseComponent requestedComponent : componentsToAdd) {
                AddRequest addRequest = AddRequest.make(this, requestedComponent);
                logMessage.append('\n').append(addRequest.getLocalizedMessage());
                AddResponse response = addRequest.postRequest(this.remoteDevice);
                logMessage.append('\n').append(response.getLocalizedMessage());
                userMessage.append(response.getLocalizedMessage());
                ResponseCode responseCode = response.getResponseCode();
                if (responseCode.equals((Object)ResponseCode.OK)) {
                    ObjectData objectData = response.getResponseData();
                    objectData.updateNiagaraComponent(this, requestedComponent, false);
                    successfullyAddedComponents.add(requestedComponent);
                    continue;
                }
                lastError = responseCode;
            }
            LOGGER.fine(logMessage.toString());
            if (!lastError.equals((Object)ResponseCode.OK)) {
                String title = LEX.get("ADD_ERROR_TITLE", "Component Creation Error");
                Object notification = componentsToAdd.size() == 1 ? BMessageNotification.make(BMessageTypeEnum.error, title, userMessage.toString()) : BMessageNotification.make(BMessageTypeEnum.error, title, LEX.getText("ADD_RESPONSE_ERROR_SUMMARY", new Object[]{componentsToAdd.size(), successfullyAddedComponents.size()}));
                ((BMessageNotification)((Object)notification)).raise((Context)newComponents.getCallContext());
                ComponentListHelper.removeIfIdMatches(componentsToAdd, successfullyAddedComponents);
            } else {
                componentsToAdd.clear();
            }
            Set failedOrds = componentsToAdd.stream().map(BComponent::getNavOrd).collect(Collectors.toSet());
            for (Map.Entry entry : linkMap.entrySet()) {
                if (failedOrds.contains(entry.getKey())) continue;
                ArrayList linkInfos = (ArrayList)entry.getValue();
                for (BNiagaraLinkInfo linkInfo : linkInfos) {
                    if (failedOrds.contains(linkInfo.getSourceComponentNavOrd())) continue;
                    this.doHandleNanoLinkCreation(linkInfo.toBNanoLinkInfoArg());
                }
            }
            for (BNanoBaseComponent bNanoBaseComponent : componentsToAdd) {
                BNanoBaseComponent parent = (BNanoBaseComponent)bNanoBaseComponent.getParent();
                if (parent == null) continue;
                parent.remove(bNanoBaseComponent.getPropertyInParent(), Context.decoding);
            }
        }
        finally {
            this.doEnablePolling(wasPollingEnabled);
            this.doEnableSubscriptionHandling(wasSubscriptionEnabled);
            for (BNanoBaseComponent component : successfullyAddedComponents) {
                component.requestNanoSubscription();
            }
        }
    }

    public void doHandleNanoComponentDeletion(BNanoBaseComponent deletedComponent) {
        DeleteRequest request = DeleteRequest.make(this, deletedComponent);
        LOGGER.fine(request.getLocalizedMessage());
        DeleteResponse response = request.postRequest(this.remoteDevice);
        String message = response.getLocalizedMessage();
        LOGGER.fine(message);
        switch (response.getResponseCode()) {
            case OK: {
                BNanoBaseComponent[] descendants;
                for (BNanoBaseComponent component : descendants = deletedComponent.getDescendants(BNanoBaseComponent.class, true, false)) {
                    this.componentCache.remove(component);
                }
                break;
            }
            default: {
                throw new LocalizableRuntimeException(BNe2DeviceExt.LEX.module.getModuleName(), message);
            }
        }
    }

    public void doHandleNanoComponentRename(BNanoComponentRenameArg renameArg) {
        RenameRequest request = RenameRequest.make(this, renameArg);
        LOGGER.fine(request.getLocalizedMessage());
        RenameResponse response = request.postRequest(this.remoteDevice);
        String message = response.getLocalizedMessage();
        LOGGER.fine(message);
        switch (response.getResponseCode()) {
            case OK: {
                return;
            }
            case NOT_CONNECTED: 
            case ERROR: 
            case NO_RESPONSE: 
            case INVALID_RESPONSE: {
                throw new LocalizableRuntimeException(BNe2DeviceExt.LEX.module.getModuleName(), message);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doHandleNanoExtensionCreation(BNanoAddExtensionArg extensionArg, Context context) {
        BBoolean wasPollingEnabled = BBoolean.make((boolean)this.getPollScheduler().getPollEnabled());
        this.doEnablePolling(BBoolean.FALSE);
        try {
            AddExtensionRequest request = AddExtensionRequest.make(this, extensionArg);
            LOGGER.fine(request.getLocalizedMessage());
            AddExtensionResponse response = request.postRequest(this.remoteDevice);
            String message = response.getLocalizedMessage();
            LOGGER.fine(message);
            BNanoBaseComponent parent = extensionArg.getExtensionParent();
            switch (response.getResponseCode()) {
                case OK: {
                    ObjectData objectData = response.getResponseData();
                    objectData.updateNiagaraComponent(this, parent, true);
                    return;
                }
                case NOT_CONNECTED: 
                case ERROR: 
                case NO_RESPONSE: 
                case INVALID_RESPONSE: {
                    parent.remove(extensionArg.getExtension().getPropertyInParent(), Context.decoding);
                    String title = LEX.get("ADD_EXTENSION_ERROR_TITLE", "Extension Creation Error");
                    BMessageNotification errorNotification = BMessageNotification.make(BMessageTypeEnum.error, title, message);
                    errorNotification.raise((Context)extensionArg.getCallContext());
                    return;
                }
            }
            return;
        }
        finally {
            Clock.schedule((BComponent)this, (BAbsTime)BAbsTime.make((long)250L), (Action)enablePolling, (BValue)wasPollingEnabled);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doHandleNanoExtensionDeletion(BNanoDeleteExtensionArg extensionArg) {
        BBoolean wasPollingEnabled = BBoolean.make((boolean)this.getPollScheduler().getPollEnabled());
        this.enablePolling(BBoolean.FALSE);
        try {
            DeleteExtensionRequest request = DeleteExtensionRequest.make(this, extensionArg);
            LOGGER.fine(request.getLocalizedMessage());
            DeleteExtensionResponse response = request.postRequest(this.remoteDevice);
            String message = response.getLocalizedMessage();
            LOGGER.fine(message);
            switch (response.getResponseCode()) {
                case OK: {
                    ObjectData objectData = response.getResponseData();
                    BNanoBaseComponent extensionHost = extensionArg.getExtensionParent();
                    objectData.removeExtensionSlots(extensionHost, extensionArg.getExtension(), (Context)extensionArg.getCallContext());
                    return;
                }
                case ERROR: {
                    return;
                }
                case NOT_CONNECTED: 
                case NO_RESPONSE: 
                case INVALID_RESPONSE: {
                    throw new LocalizableRuntimeException(BNe2DeviceExt.LEX.module.getModuleName(), message);
                }
            }
            return;
        }
        finally {
            Clock.schedule((BComponent)this, (BAbsTime)BAbsTime.make((long)250L), (Action)enablePolling, (BValue)wasPollingEnabled);
        }
    }

    public void doHandleNanoScheduleChanged(BNanoScheduleChangedArg scheduleChangedArg) {
        this.setProcessingPatchRequest(true);
        ScheduleRequest request = ScheduleRequest.make(this, scheduleChangedArg.getPersistentId(), scheduleChangedArg.getSchedule());
        LOGGER.fine(request.getLocalizedMessage());
        ScheduleResponse response = request.postRequest(this.remoteDevice);
        String message = response.getLocalizedMessage();
        LOGGER.fine(message);
        switch (response.getResponseCode()) {
            case OK: {
                break;
            }
            case NOT_CONNECTED: 
            case ERROR: 
            case NO_RESPONSE: 
            case INVALID_RESPONSE: {
                throw new LocalizableRuntimeException(BNe2DeviceExt.LEX.module.getModuleName(), message);
            }
        }
        this.setProcessingPatchRequest(false);
        this.poll();
    }

    public void doSetNanoTime(BNanoTimeChangeArg nanoTimeChangeArg) {
        BNanoBaseComponent platform = (BNanoBaseComponent)this.getNanoComponentByName(BString.make((String)"Platform"));
        platform.loadSlots();
        BNanoComponent sourceComponent = (BNanoComponent)platform.get("Time");
        BNanoInvocationArg invocationArg = new BNanoInvocationArg();
        invocationArg.setActionSourceComponentOrd(sourceComponent.getNavOrd());
        invocationArg.setActionName("SetUTCTime");
        invocationArg.setHasActionParameter(true);
        invocationArg.setActionParameterRaw((BValue)BString.make((String)String.valueOf(ScheduleUtils.niagaraTimeToNanoUtcTicks(nanoTimeChangeArg.getDesiredTime()))));
        InvokeRequest invokeRequest = InvokeRequest.make(this, invocationArg);
        LOGGER.fine(invokeRequest.getLocalizedMessage());
        InvokeResponse invokeResponse = invokeRequest.postRequest(this.remoteDevice);
        String message = invokeResponse.getLocalizedMessage();
        LOGGER.fine(message);
        block0 : switch (invokeResponse.getResponseCode()) {
            case OK: {
                Property changedProperty = sourceComponent.getNanoSlot(sourceComponent.getNanoSlotId("timezone"));
                BValue oldValue = sourceComponent.get("timezone").newCopy();
                String zoneId = nanoTimeChangeArg.getDesiredTimezone().replaceAll("\\(.*?\\)", "").trim();
                BStatusString pendingValue = new BStatusString(ScheduleUtils.timeZoneToPosix(BTimeZone.getTimeZone((String)zoneId), (Context)nanoTimeChangeArg.getCallContext()));
                BNanoPropertyChangedArg changedArg = new BNanoPropertyChangedArg(sourceComponent, changedProperty, oldValue, (BValue)pendingValue);
                WriteRequest writeRequest = WriteRequest.make(this, changedArg);
                LOGGER.fine(writeRequest.getLocalizedMessage());
                WriteResponse writeResponse = writeRequest.postRequest(this.remoteDevice);
                message = writeResponse.getLocalizedMessage();
                LOGGER.fine(message);
                switch (writeResponse.getResponseCode()) {
                    case OK: {
                        if (!nanoTimeChangeArg.getRestartDevice()) break block0;
                        this.getSoftwareManager().restartDevice();
                        break;
                    }
                    default: {
                        BNanoBaseComponent comp = changedArg.getSourceComponent();
                        Property changedProp = changedArg.getChangedProperty();
                        comp.set(changedProp, changedArg.getOldValue().newCopy(), Context.decoding);
                        String title = LEX.get("TIMEZONE_CHANGE_ERROR_TITLE", "Timezone Change Error");
                        BMessageNotification notification = BMessageNotification.make(BMessageTypeEnum.error, title, message);
                        notification.raise((Context)changedArg.getCallContext());
                        break;
                    }
                }
                break;
            }
            default: {
                LOGGER.info(message);
                String title = LEX.get("SET_TIME_ERROR_TITLE", "Set Time Error");
                BMessageNotification notification = BMessageNotification.make(BMessageTypeEnum.error, title, message);
                notification.raise((Context)nanoTimeChangeArg.getCallContext());
            }
        }
    }

    public void doHandleNanoLabelsUpdate(BDynamicChoiceRangeChangedArg changeArg, Context context) {
        LabelsUpdateRequest request = LabelsUpdateRequest.make(this, changeArg);
        LOGGER.fine(request.getLocalizedMessage());
        LabelsUpdateResponse response = request.postRequest(this.remoteDevice);
        String message = response.getLocalizedMessage();
        switch (response.getResponseCode()) {
            case OK: {
                BNanoBaseComponent component = changeArg.getSourceComponent();
                component.set(changeArg.getPendingValue().getId(), (BValue)changeArg.getPendingValue());
                BRefreshNotification refreshNotification = BRefreshNotification.make(BRefreshTargets.propertySheet, component);
                refreshNotification.raise(context);
                LOGGER.info(message);
                break;
            }
            default: {
                LOGGER.info(message);
                String title = LEX.get("LABELS_UPDATE_ERROR_TITLE", "Label Update Error");
                BMessageNotification notification = BMessageNotification.make(BMessageTypeEnum.error, title, message);
                notification.raise(context);
            }
        }
    }

    public ArrayList<BNiagaraLinkInfo> getLinkInfos(BNanoBaseComponent mountedComponent) {
        BLink[] links;
        ArrayList<BNiagaraLinkInfo> linkInfos = new ArrayList<BNiagaraLinkInfo>();
        for (BLink link : links = mountedComponent.getLinks()) {
            linkInfos.add(new BNiagaraLinkInfo(link));
        }
        return linkInfos;
    }

    public BString doGetLocalLibraries() throws IOException {
        BIFile[] librariesFiles;
        BListOfLibraryFiles localLibraries = new BListOfLibraryFiles();
        OrdQuery[] queries = LIBRARIES_FILE_ORD.normalize().parse();
        FilePath filePath = (FilePath)queries[queries.length - 1];
        BDirectory librariesFolder = BFileSystem.INSTANCE.makeDir(filePath);
        for (BIFile file : librariesFiles = librariesFolder.listFiles()) {
            if (!(file instanceof BDirectory)) continue;
            for (BIFile libraryFile : ((BDirectory)file).listFiles()) {
                String fileName = libraryFile.getFileName().substring(0, libraryFile.getFileName().indexOf(libraryFile.getExtension()) - 1);
                String[] libNameAndVersion = fileName.split("-");
                BLibrary library = new BLibrary();
                library.setId(0);
                library.setNanoName(libNameAndVersion[0]);
                library.setVersion(libNameAndVersion[1]);
                localLibraries.addLibraryFile(library);
            }
        }
        return localLibraries.encodeToString();
    }

    public BString doGetOsLibraries() throws IOException {
        BListOfLibraryFiles osLibraries = new BListOfLibraryFiles();
        try {
            OrdQuery[] queries = OS_FILE_ORD.normalize().parse();
            FilePath filePath = (FilePath)queries[queries.length - 1];
            BDirectory librariesFolder = BFileSystem.INSTANCE.makeDir(filePath);
            for (BIFile file : librariesFolder.listFiles()) {
                if (!file.getExtension().equals("bin")) continue;
                try {
                    String fileName = file.getFileName().substring(0, file.getFileName().indexOf(file.getExtension()) - 1);
                    String[] libNameAndVersion = fileName.split("-");
                    BLibrary library = new BLibrary();
                    library.setId(0);
                    library.setNanoName(libNameAndVersion[0].toUpperCase());
                    library.setVersion(libNameAndVersion[1]);
                    osLibraries.addLibraryFile(library);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            Arrays.asList(librariesFolder.listFiles()).stream().filter(f -> f.getExtension().equals("json")).forEach(f -> {
                try {
                    String fileName = f.getFileName().substring(0, f.getFileName().indexOf(f.getExtension()) - 1);
                    String libVersion = fileName.split("-")[1];
                    BIFile jsonFile = f;
                    InputStream is = jsonFile.getInputStream();
                    byte[] fileContent = new byte[is.available()];
                    is.read(fileContent);
                    is.close();
                    JSONArray jsonArray = new JSONArray(new String(fileContent));
                    for (int i = 0; i < jsonArray.length(); ++i) {
                        JSONObject obj = (JSONObject)jsonArray.get(i);
                        if (!obj.getString("Name").contains("Framework.SDK") && (!obj.getString("Name").contains("Library") || obj.getString("Name").contains("SDK"))) continue;
                        BLibrary library = new BLibrary(0, obj.getString("Name"), libVersion);
                        osLibraries.addLibraryFile(library);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
        return osLibraries.encodeToString();
    }

    public BString doGetBackups(BBackupRestoreArgs backupRestoreArgs) throws IOException {
        BListOfBackupFiles backupFiles = new BListOfBackupFiles();
        if (backupRestoreArgs.getTakeFromDevice()) {
            if (this.remoteDevice != null && this.remoteDevice.Remote.isConnected()) {
                BBackupRestoreManager backupRestoreManager = new BBackupRestoreManager(this);
                backupFiles = backupRestoreManager.doGetOnDeviceBackups();
            } else {
                LOGGER.severe("Remote device is not connected! Please connect to device first before invoking this action!");
                BMessageNotification notification = BMessageNotification.make(BMessageTypeEnum.deviceDisconnected);
                notification.raise((Context)backupRestoreArgs.getCallContext());
            }
        } else {
            BIFile[] backupsFiles;
            OrdQuery[] queries = BACKUPS_FILE_ORD.normalize().parse();
            FilePath filePath = (FilePath)queries[queries.length - 1];
            BDirectory backupsFolder = BFileSystem.INSTANCE.makeDir(filePath);
            for (BIFile backup : backupsFiles = backupsFolder.listFiles()) {
                BBackupFile backupFile = new BBackupFile();
                backupFile.setBackupName(backup.getFileName());
                backupFile.setTimestamp(backup.getLastModified().toTimeString(null));
                backupFile.setDeviceModel(this.getSoftwareManager().getModel());
                backupFiles.addBackupFile(backupFile);
            }
        }
        return backupFiles.encodeToString();
    }

    public void doDownloadBackup(BBackupRestoreArgs backupRestoreArgs) throws Exception {
        if (this.remoteDevice != null && this.remoteDevice.Remote.isConnected()) {
            BNanoComponent backups = (BNanoComponent)this.doGetNanoComponentByName(BString.make((String)"Backups"));
            Property downloadProp = backups.getProperty("download");
            if (null == backups.get("download")) {
                backups.add("download", (BValue)BBackupStatus.make(BBackupStatus.DEFAULT.getOrdinal()), 5);
                downloadProp = backups.getProperty("download");
            }
            backups.set(downloadProp, (BValue)BBackupStatus.InProgress);
            BBackupRestoreManager backupRestoreManager = new BBackupRestoreManager(this, backupRestoreArgs.getBackupFile(), false, false);
            backupRestoreManager.downloadBackup(backupRestoreArgs.getBackupFile());
            backups.set(downloadProp, (BValue)BBackupStatus.none);
        } else {
            LOGGER.severe("Remote device is not connected! Please connect to device first before invoking this action!");
            BMessageNotification notification = BMessageNotification.make(BMessageTypeEnum.deviceDisconnected);
            notification.raise((Context)backupRestoreArgs.getCallContext());
        }
    }

    /*
     * Unable to fully structure code
     */
    public BBoolean doDeleteBackup(BBackupRestoreArgs backupRestoreArgs) {
        block10: {
            block8: {
                block9: {
                    ok = BBoolean.DEFAULT;
                    if (!backupRestoreArgs.getTakeFromDevice()) break block8;
                    if (this.remoteDevice == null || !this.remoteDevice.Remote.isConnected()) break block9;
                    folderData = new Object[]{"/system/backup"};
                    request = new SerializableForm(DataMarker.FolderData, folderData);
                    response = this.remoteDevice.Remote.Folder(new SerializableForm[]{request});
                    if (response == null) break block10;
                    files = new HashMap<String, LocalDateTime>();
                    for (SerializableForm responseElem : response) {
                        for (SerializableForm elem : responseElem.elements.toSerializableForms()) {
                            marker = elem.marker;
                            value = (String)elem.data[0];
                            for (SerializableForm folderItem : elem.elements.toSerializableForms()) {
                                marker = (DataMarker)folderItem.data[0];
                                file = (String)folderItem.data[1];
                                localDateTime = (LocalDateTime)folderItem.data[2];
                                files.put(file, localDateTime);
                            }
                        }
                    }
                    for (String file : files.keySet()) {
                        fileData = new Object[]{"/system/backup/" + file};
                        request = new SerializableForm(DataMarker.FileData, fileData);
                        response = this.remoteDevice.Remote.FileDelete(request);
                        if (response == null) continue;
                        for (SerializableForm resp : response) {
                            for (SerializableForm respElem : resp.elements.toSerializableForms()) {
                                if (respElem.marker == DataMarker.ErrorData) continue;
                                ok = BBoolean.TRUE;
                            }
                        }
                    }
                    break block10;
                }
                BNe2DeviceExt.LOGGER.severe("Remote device is not connected! Please connect to device first before invoking this action!");
                notification = BMessageNotification.make(BMessageTypeEnum.deviceDisconnected);
                notification.raise((Context)backupRestoreArgs.getCallContext());
                break block10;
            }
            try {
                queries = BNe2DeviceExt.BACKUPS_FILE_ORD.normalize().parse();
                filePath = (FilePath)queries[queries.length - 1];
                backupsFolder = BFileSystem.INSTANCE.makeDir(filePath);
                file = Arrays.stream(backupsFolder.listFiles()).filter((Predicate<BIFile>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$doDeleteBackup$5(com.miratech.nE2Link.actions.BBackupRestoreArgs javax.baja.file.BIFile ), (Ljavax/baja/file/BIFile;)Z)((BBackupRestoreArgs)backupRestoreArgs)).findFirst();
                if (!file.isPresent()) ** GOTO lbl53
                file.get().delete();
                ok = BBoolean.TRUE;
            }
            catch (Exception var3_6) {
                // empty catch block
            }
        }
        return ok;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void doRestoreBackup(BBackupRestoreArgs backupRestoreArgs) {
        if (this.remoteDevice != null && this.remoteDevice.Remote.isConnected()) {
            String[] s = backupRestoreArgs.getBackupFile().split(":");
            String backupFileName = s[0];
            boolean withIpSettings = BBoolean.make((String)s[1]).getBoolean();
            BBackupRestoreManager backupRestoreManager = new BBackupRestoreManager(this, backupFileName, withIpSettings, backupRestoreArgs.getTakeFromDevice());
            try {
                BDirectory tempDirectory = backupRestoreManager.prepareTemporaryCopy();
                if (!OsUpdateHelper.isOSUpdateInBackup(tempDirectory) && !OsUpdateHelper.createOSUpdate(this, tempDirectory)) {
                    throw new Exception("Preparation of update.bin file for restore failed.");
                }
                backupRestoreManager.getManifestHelper().prepareNewVersionOfManifest();
                if (!backupRestoreManager.transferFilesIntoDevice()) {
                    throw new Exception("Transferring files into device failed.");
                }
                BNanoInvocationArg invocationArg = new BNanoInvocationArg();
                BNanoComponent backups = (BNanoComponent)this.doGetNanoComponentByName(BString.make((String)"Backups"));
                invocationArg.setActionSourceComponentOrd(backups.getNavOrd());
                invocationArg.setActionName("RestoreBackup");
                InvokeRequest request = InvokeRequest.make(this, invocationArg);
                LOGGER.fine(request.getLocalizedMessage());
                InvokeResponse response = request.postRequest(this.remoteDevice);
                String message = response.getLocalizedMessage();
                LOGGER.fine(message);
                switch (response.getResponseCode()) {
                    case OK: {
                        return;
                    }
                    default: {
                        LOGGER.info(message);
                        String title = LEX.get("RESTORE_ERROR_TITLE", "Restore Backup Error");
                        BMessageNotification notification = BMessageNotification.make(BMessageTypeEnum.error, title, message);
                        notification.raise((Context)backupRestoreArgs.getCallContext());
                        return;
                    }
                }
            }
            catch (Exception ex) {
                System.out.println("Restore of selected backup at remote device has failed.");
                return;
            }
            finally {
                backupRestoreManager.prepareArchiveTempDir();
            }
        } else {
            LOGGER.severe("Remote device is not connected! Please connect to device first before invoking this action!");
            BMessageNotification notification = BMessageNotification.make(BMessageTypeEnum.deviceDisconnected);
            notification.raise((Context)backupRestoreArgs.getCallContext());
        }
    }

    public boolean isProcessingPatchRequest() {
        return processingPatchRequest;
    }

    public void setProcessingPatchRequest(boolean processingPatchRequest) {
        BNe2DeviceExt.processingPatchRequest = processingPatchRequest;
    }

    public RemoteDevice getRemoteDevice() {
        return this.remoteDevice;
    }

    public XmlLinkCache getXmlLinkCache() {
        return this.xmlLinkCache;
    }

    public LinkCache getLinkCache() {
        return this.linkCache;
    }

    public ComponentCache getComponentCache() {
        return this.componentCache;
    }

    private static /* synthetic */ boolean lambda$doDeleteBackup$5(BBackupRestoreArgs backupRestoreArgs, BIFile m) {
        return m.getFileName().equals(backupRestoreArgs.getBackupFile());
    }

    public static class ComponentListHelper {
        public static boolean removeIfIdMatches(List<BNanoBaseComponent> listToCheck, List<BNanoBaseComponent> listToRemove) {
            List idsToRemove = listToRemove.stream().mapToInt(component -> component.getGlobalIndex()).boxed().collect(Collectors.toList());
            return listToCheck.removeIf(component -> idsToRemove.contains(component.getGlobalIndex()));
        }

        public static boolean removeIfIdMatches(List<BNanoBaseComponent> listToCheck, BNanoBaseComponent toRemove) {
            return listToCheck.removeIf(component -> component.getGlobalIndex() == toRemove.getGlobalIndex());
        }
    }

    public class LinkCache {
        private HashMap<BNanoBaseComponent, ArrayList<ExistingLinkData>> linkInfoCache = new HashMap();

        public void clear() {
            this.linkInfoCache.clear();
        }

        public void put(BNanoBaseComponent linkTargetComponent, ExistingLinkData linkInfo) {
            ArrayList<ExistingLinkData> linkData;
            BNanoBaseComponent key = linkTargetComponent;
            if (!this.linkInfoCache.containsKey((Object)key)) {
                this.linkInfoCache.put(key, new ArrayList());
            }
            if (!(linkData = this.linkInfoCache.get((Object)key)).contains(linkInfo)) {
                linkData.add(linkInfo);
            }
        }

        public void put(BNanoBaseComponent linkTargetComponent, ArrayList<ExistingLinkData> linkInfos) {
            this.linkInfoCache.put(linkTargetComponent, linkInfos);
        }

        public void put(BNanoBaseComponent linkTargetComponent) {
            BLink[] links;
            for (BLink link : links = linkTargetComponent.getLinks()) {
                ExistingLinkData linkData = ExistingLinkData.make(link);
                this.put(linkTargetComponent, linkData);
            }
        }

        public ArrayList<ExistingLinkData> get(BNanoBaseComponent linkTargetComponent) {
            return this.linkInfoCache.get((Object)linkTargetComponent);
        }

        public void remove(BNanoBaseComponent linkTargetComponent) {
            if (this.linkInfoCache.get((Object)linkTargetComponent) != null) {
                this.linkInfoCache.remove((Object)linkTargetComponent);
            }
        }

        public void createLinks() {
            Iterator<BNanoBaseComponent> cacheIterator = this.linkInfoCache.keySet().iterator();
            while (cacheIterator.hasNext()) {
                this.createLinks(cacheIterator.next());
                cacheIterator.remove();
            }
        }

        public void createLinks(BNanoBaseComponent targetComponent) {
            ArrayList<ExistingLinkData> linkInfos = this.linkInfoCache.get((Object)targetComponent);
            if (linkInfos != null) {
                for (ExistingLinkData linkInfo : linkInfos) {
                    Property targetSlot = targetComponent.getNanoSlot(linkInfo.getTargetSlotId());
                    if (targetSlot == null) {
                        LOGGER.severe(String.format("Unable to create link: targetComponent '%s', slotId=%d: No such slot.", new Object[]{targetComponent, linkInfo.getTargetSlotId()}));
                        continue;
                    }
                    BNanoBaseComponent sourceComponent = BNe2DeviceExt.this.componentCache.get(linkInfo.getSourceObjectId());
                    if (sourceComponent == null) {
                        LOGGER.severe(String.format("Unable to create link to targetComponent '%s', slotId=%d from sourceComponent id=%d: No such source component found.", new Object[]{targetComponent, linkInfo.getTargetSlotId(), linkInfo.getSourceObjectId()}));
                        continue;
                    }
                    Property sourceSlot = sourceComponent.getNanoSlot(linkInfo.getSourceSlotId());
                    if (sourceSlot == null) {
                        LOGGER.severe(String.format("Unable to create link to targetComponent '%s', slotId=%d from sourceComponentId=%d, sourceSlotId=%d: No such source slot found on source component.", new Object[]{targetComponent, linkInfo.getTargetSlotId(), linkInfo.getSourceObjectId(), linkInfo.getSourceSlotId()}));
                        continue;
                    }
                    targetComponent.addLink(sourceComponent, (Slot)sourceSlot, (Slot)targetSlot);
                }
            }
        }
    }

    public class ComponentCache {
        private HashMap<Integer, BNanoBaseComponent> components = new HashMap();

        private void init() {
            BNe2DeviceExt thisProgramExt = BNe2DeviceExt.this;
            BComponentSpace componentSpace = thisProgramExt.getComponentSpace();
            this.components = (HashMap)Arrays.stream(componentSpace.getAllComponents()).filter(component -> component instanceof BNanoBaseComponent && ((BNanoBaseComponent)((Object)component)).getGlobalIndex() >= 0 && ((BNanoBaseComponent)((Object)component)).getNe2DeviceExt().equals(BNe2DeviceExt.this)).map(component -> (BNanoBaseComponent)((Object)component)).collect(Collectors.toMap(BNanoBaseComponent::getGlobalIndex, Function.identity()));
            this.components.putAll(this.components);
        }

        private void clear() {
            this.components.clear();
        }

        public boolean put(BNanoBaseComponent componentToCache) {
            if (componentToCache == null) {
                return false;
            }
            int globalIndex = componentToCache.getGlobalIndex();
            if (globalIndex == -1) {
                return false;
            }
            this.components.put(globalIndex, componentToCache);
            return true;
        }

        public BNanoBaseComponent remove(BNanoBaseComponent component) {
            return this.components.remove(component.getGlobalIndex());
        }

        public BNanoBaseComponent remove(int globalIndex) {
            return this.components.remove(globalIndex);
        }

        public BNanoBaseComponent get(int globalIndex) {
            return this.components.get(globalIndex);
        }

        public BNanoBaseComponent get(String persistentId) {
            for (Integer index : this.components.keySet()) {
                BNanoBaseComponent component = this.components.get(index);
                if (!component.getPersistentId().equals(persistentId)) continue;
                return component;
            }
            return null;
        }

        public BNanoBaseComponent getValidParent(BNanoBaseComponent component) {
            BNanoBaseComponent parent = this.components.get(component.getParentGlobalIndex());
            if (!component.isInvisibleInTree()) {
                while (parent != null && parent.isInvisibleInTree() && parent.getParentGlobalIndex() != -1) {
                    parent = this.components.get(parent.getParentGlobalIndex());
                }
            }
            return parent;
        }
    }

    public class XmlLinkCache {
        private HashMap<BNanoBaseComponent, ArrayList<BLinkInfo>> linkInfoCache = new HashMap();
        private HashMap<String, BNanoBaseComponent> resolvedSourceComponentsCache = new HashMap();

        public void clear() {
            this.linkInfoCache.clear();
            this.resolvedSourceComponentsCache.clear();
        }

        public void put(BNanoBaseComponent linkTargetComponent, BLinkInfo linkInfo) {
            if (!this.linkInfoCache.containsKey((Object)linkTargetComponent)) {
                this.linkInfoCache.put(linkTargetComponent, new ArrayList());
            }
            this.linkInfoCache.get((Object)linkTargetComponent).add(linkInfo);
        }

        public void createLinks(BComponent searchRoot) {
            Iterator<BNanoBaseComponent> cacheIterator = this.linkInfoCache.keySet().iterator();
            while (cacheIterator.hasNext()) {
                BNanoBaseComponent targetComponent = cacheIterator.next();
                ArrayList<BLinkInfo> linkInfos = this.linkInfoCache.get((Object)targetComponent);
                for (BLinkInfo linkInfo : linkInfos) {
                    Slot sourceSlot;
                    Slot targetSlot = targetComponent.getSlot(linkInfo.getTargetSlotName());
                    if (targetSlot == null) {
                        LOGGER.severe("Unable to create link to '" + (Object)((Object)targetComponent) + "." + linkInfo.getTargetSlotName() + "'.\nTarget slot does not exist on component");
                        continue;
                    }
                    String sourceComponentPersistentId = linkInfo.getSourceComponentPersistentId();
                    BNanoBaseComponent sourceComponent = this.resolvedSourceComponentsCache.get(sourceComponentPersistentId);
                    if (sourceComponent == null) {
                        BITable queryResult;
                        String bqlQuery = "bql:select from " + BNanoBaseComponent.TYPE.getTypeSpec().toString() + " where persistentId.value=" + sourceComponentPersistentId;
                        if (searchRoot.isMounted()) {
                            bqlQuery = BNe2DeviceExt.this.getSlotPath() + "|" + bqlQuery;
                            BOrd queryOrd = BOrd.make((String)bqlQuery);
                            queryResult = (BITable)queryOrd.resolve((BObject)BNe2DeviceExt.this).get();
                        } else {
                            OrdTarget target = OrdTarget.unmounted((BObject)searchRoot);
                            queryResult = (BITable)BqlQuery.make((String)bqlQuery).resolve(target).get();
                        }
                        TableCursor c = queryResult.cursor();
                        int sourceCount = 0;
                        while (c.next()) {
                            sourceComponent = (BNanoBaseComponent)((Object)c.get());
                            ++sourceCount;
                        }
                        if (sourceCount == 0) {
                            LOGGER.severe("Unable to create link to '" + (Object)((Object)targetComponent) + "." + linkInfo.getTargetSlotName() + "'.\nSource component with persistentId '" + sourceComponentPersistentId + "' cannot be found in application tree");
                            continue;
                        }
                        if (sourceCount > 1) {
                            LOGGER.severe("Unable to create link to '" + (Object)((Object)targetComponent) + "." + linkInfo.getTargetSlotName() + "'.\nMultiple source components with persistentId '" + sourceComponentPersistentId + "'exist in application tree");
                            continue;
                        }
                        this.resolvedSourceComponentsCache.put(sourceComponentPersistentId, sourceComponent);
                    }
                    if ((sourceSlot = sourceComponent.getSlot(linkInfo.getSourceSlotName())) == null) {
                        LOGGER.severe("Unable to create link to '" + (Object)((Object)targetComponent) + "." + linkInfo.getTargetSlotName() + "'.\nSource slot does not exist on source component '" + (Object)((Object)sourceComponent) + "." + linkInfo.getSourceSlotName() + "'.");
                        continue;
                    }
                    targetComponent.addLink(sourceComponent, sourceSlot, targetSlot);
                }
                cacheIterator.remove();
            }
            this.resolvedSourceComponentsCache.clear();
        }
    }

    public class NanoSubscriptionHandler {
        private final List<BNanoBaseComponent> toSubscribe = new ArrayList<BNanoBaseComponent>();
        private final List<BNanoBaseComponent> toUnsubscribe = new ArrayList<BNanoBaseComponent>();
        private final List<BNanoBaseComponent> toSubscribePermanently = new ArrayList<BNanoBaseComponent>();
        private final ArrayList<BNanoBaseComponent> toUnsubscribePermanently = new ArrayList();
        private final ScheduledExecutorService scheduledSubscriptionExecutor = Executors.newSingleThreadScheduledExecutor();
        private BNanoBaseComponent lastParentSubscribed;
        private final ExecutorService cleanupExecutor = Executors.newSingleThreadExecutor();
        private ScheduledFuture lastSubscriptionExecutionResult;
        private BAbsTime lastSubscriptionExecutionTime = BAbsTime.DEFAULT;
        private BAbsTime lastUnsubscriptionExecutionTime = BAbsTime.DEFAULT;
        private BNanoBaseComponent[] pendingSubscriptions;
        private final long DEVICE_SUBSCRIPTION_NOTIFICATION_DELAY = 250L;

        public void shutdown() {
            this.scheduledSubscriptionExecutor.shutdown();
        }

        public BNanoBaseComponent getLastParentSubscribed() {
            return this.lastParentSubscribed;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void subscribeComponentsPermanently(BNanoPermanentSubscriptionArg componentsToSubscribe) {
            Object object = BNe2DeviceExt.this.subscriptionLock;
            synchronized (object) {
                if (componentsToSubscribe == null || componentsToSubscribe.size() == 0) {
                    return;
                }
                this.toSubscribePermanently.sort(Comparator.comparing(BNanoBaseComponent::getGlobalIndex));
                BNanoBaseComponent[] existingPermanentSubscriptions = this.toSubscribePermanently.toArray(new BNanoBaseComponent[0]);
                for (int i = 0; i < componentsToSubscribe.size(); ++i) {
                    BNanoBaseComponent componentToSubscribe = componentsToSubscribe.getComponent(i);
                    if (this.toSubscribePermanently.contains((Object)componentToSubscribe)) continue;
                    this.toSubscribePermanently.add(componentToSubscribe);
                    this.toUnsubscribe.remove((Object)componentToSubscribe);
                }
                this.removeNonExistingComponents(this.toSubscribePermanently);
                this.toSubscribePermanently.sort(Comparator.comparing(BNanoBaseComponent::getGlobalIndex));
                BNanoBaseComponent[] newPermanentSubscriptions = this.toSubscribePermanently.toArray(new BNanoBaseComponent[0]);
                if (!newPermanentSubscriptions.equals(existingPermanentSubscriptions)) {
                    System.out.println("### PERMANENT SUBSCRIPTION STATUS ####\nRequested permanent subscriptions: " + this.toSubscribePermanently);
                    BNe2DeviceExt.this.doHandleNanoSubscription(newPermanentSubscriptions);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unsubscribeComponentsPermanently(BNanoPermanentUnsubscriptionArg componentsToUnsubscribe) {
            Object object = BNe2DeviceExt.this.subscriptionLock;
            synchronized (object) {
                if (componentsToUnsubscribe == null || componentsToUnsubscribe.size() == 0) {
                    return;
                }
                this.toUnsubscribePermanently.sort(Comparator.comparing(BNanoBaseComponent::getGlobalIndex));
                BNanoBaseComponent[] previousUnsubscriptions = this.toUnsubscribePermanently.toArray(new BNanoBaseComponent[0]);
                for (int i = 0; i < componentsToUnsubscribe.size(); ++i) {
                    try {
                        BNanoBaseComponent componentToUnsubscribe = componentsToUnsubscribe.getComponent(i);
                        this.toSubscribePermanently.remove((Object)componentToUnsubscribe);
                        if (this.toSubscribe.contains((Object)componentToUnsubscribe)) continue;
                        this.toUnsubscribePermanently.add(componentToUnsubscribe);
                        continue;
                    }
                    catch (UnresolvedException componentToUnsubscribe) {
                        // empty catch block
                    }
                }
                this.removeNonExistingComponents(this.toUnsubscribePermanently);
                this.toSubscribePermanently.sort(Comparator.comparing(BNanoBaseComponent::getGlobalIndex));
                BNanoBaseComponent[] newPermanentUnsubscriptions = this.toUnsubscribePermanently.toArray(new BNanoBaseComponent[0]);
                if (!newPermanentUnsubscriptions.equals(previousUnsubscriptions)) {
                    System.out.println("### PERMANENT UNSUBSCRIPTION STATUS ####\nRequested permanent unsubscriptions: " + this.toUnsubscribePermanently);
                    List<BNanoBaseComponent> successfullyUnsubscribed = BNe2DeviceExt.this.doHandleNanoUnsubscription(newPermanentUnsubscriptions);
                    this.toUnsubscribePermanently.removeAll(successfullyUnsubscribed);
                    this.removeNonExistingComponents(this.toUnsubscribePermanently);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unsubscribeAllPermanently() {
            Object object = BNe2DeviceExt.this.subscriptionLock;
            synchronized (object) {
                for (BNanoBaseComponent componentToUnsubscribe : this.toSubscribePermanently) {
                    if (this.toSubscribe.contains((Object)componentToUnsubscribe)) continue;
                    this.toUnsubscribePermanently.add(componentToUnsubscribe);
                }
                this.toSubscribePermanently.clear();
                System.out.println("### PERMANENT UNSUBSCRIPTION STATUS ####\nRequested permanent unsubscriptions: " + this.toUnsubscribePermanently);
                BNanoBaseComponent[] newPermanentUnsubscriptions = this.toUnsubscribePermanently.toArray(new BNanoBaseComponent[0]);
                List<BNanoBaseComponent> successfullyUnsubscribed = BNe2DeviceExt.this.doHandleNanoUnsubscription(newPermanentUnsubscriptions);
                this.toUnsubscribePermanently.removeAll(successfullyUnsubscribed);
                this.removeNonExistingComponents(this.toUnsubscribePermanently);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void subscribeComponent(BNanoBaseComponent componentToSubscribe) {
            if (!componentToSubscribe.isMounted()) {
                return;
            }
            if (componentToSubscribe.getType().is(BNanoExtension.TYPE)) {
                return;
            }
            Object object = BNe2DeviceExt.this.subscriptionLock;
            synchronized (object) {
                if (componentToSubscribe.getGlobalIndex() == -1 || this.isSubscribed(componentToSubscribe)) {
                    return;
                }
                BNanoBaseComponent requiredParent = null;
                if (!componentToSubscribe.isNanoChildOf(this.lastParentSubscribed) && !componentToSubscribe.equals((Object)this.lastParentSubscribed)) {
                    BNanoBaseComponent bNanoBaseComponent = requiredParent = componentToSubscribe.getParent().getType().is(BNanoBaseComponent.TYPE) ? (BNanoBaseComponent)componentToSubscribe.getParent() : null;
                }
                if (requiredParent != null) {
                    if (!this.toSubscribe.contains((Object)requiredParent)) {
                        this.toSubscribe.add(requiredParent);
                    }
                    this.toUnsubscribe.remove((Object)requiredParent);
                    if (this.lastParentSubscribed != null) {
                        this.toSubscribe.remove((Object)this.lastParentSubscribed);
                        if (!this.toUnsubscribe.contains((Object)this.lastParentSubscribed) && !this.isPermanentlySubscribed(this.lastParentSubscribed)) {
                            this.toUnsubscribe.add(this.lastParentSubscribed);
                        }
                    }
                    this.lastParentSubscribed = requiredParent;
                }
                ListIterator<BNanoBaseComponent> iterSubscribe = this.toSubscribe.listIterator();
                while (iterSubscribe.hasNext()) {
                    BNanoBaseComponent subscribedComponent = iterSubscribe.next();
                    if (subscribedComponent.isMounted() && (subscribedComponent.equals((Object)componentToSubscribe) || subscribedComponent.isNanoParentOf(componentToSubscribe) || subscribedComponent.isNanoChildOf(componentToSubscribe) || subscribedComponent.isNanoChildOf(this.lastParentSubscribed))) continue;
                    if (!subscribedComponent.isMounted() && componentToSubscribe.isMounted() && subscribedComponent.getGlobalIndex() == componentToSubscribe.getGlobalIndex()) {
                        iterSubscribe.remove();
                        continue;
                    }
                    iterSubscribe.remove();
                    if (this.toUnsubscribe.contains((Object)subscribedComponent) || this.isPermanentlySubscribed(subscribedComponent)) continue;
                    this.toUnsubscribe.add(subscribedComponent);
                }
                if (!this.toSubscribe.contains((Object)componentToSubscribe)) {
                    this.toSubscribe.add(componentToSubscribe);
                }
                ComponentListHelper.removeIfIdMatches(this.toUnsubscribe, componentToSubscribe);
                this.removeNonExistingComponents(this.toSubscribe);
                this.removeNonExistingComponents(this.toUnsubscribe);
                this.toSubscribe.sort(Comparator.comparing(BNanoBaseComponent::getGlobalIndex));
                this.toUnsubscribe.sort(Comparator.comparing(BNanoBaseComponent::getGlobalIndex));
                BNanoBaseComponent[] newSubscriptions = this.toSubscribe.toArray(new BNanoBaseComponent[0]);
                BNanoBaseComponent[] newUnsubscriptions = this.toUnsubscribe.toArray(new BNanoBaseComponent[0]);
                if (!Arrays.equals((Object[])newSubscriptions, (Object[])this.pendingSubscriptions)) {
                    this.pendingSubscriptions = newSubscriptions;
                    System.out.println("### SUBSCRIPTION STATUS ####\nRequested subscriptions: " + this.toSubscribe + "\nRequested unsubscriptions: " + this.toUnsubscribe + "\n############################");
                    boolean pendingSubscriptionCancelled = true;
                    if (this.lastSubscriptionExecutionResult != null) {
                        pendingSubscriptionCancelled = this.lastSubscriptionExecutionResult.cancel(false);
                    }
                    this.lastSubscriptionExecutionResult = this.scheduledSubscriptionExecutor.schedule(new NanoSubscriptionInvocation(newSubscriptions, newUnsubscriptions), 250L, TimeUnit.MILLISECONDS);
                    this.lastSubscriptionExecutionTime = BAbsTime.now();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clearSubscriberLists() {
            Object object = BNe2DeviceExt.this.subscriptionLock;
            synchronized (object) {
                this.toSubscribe.clear();
                this.toUnsubscribe.clear();
                this.toSubscribePermanently.clear();
                this.toUnsubscribePermanently.clear();
                this.lastParentSubscribed = null;
            }
        }

        public boolean isSubscribed(BNanoBaseComponent component) {
            return this.toSubscribe.contains((Object)component);
        }

        public boolean isPermanentlySubscribed(BNanoBaseComponent component) {
            return this.toSubscribePermanently.contains((Object)component);
        }

        private void removeNonExistingComponents(List<BNanoBaseComponent> list) {
            List nonExistent = list.stream().filter(component -> BNe2DeviceExt.this.componentCache.get(component.getGlobalIndex()) == null).collect(Collectors.toList());
            list.removeAll(nonExistent);
        }

        private class NanoSubscriptionInvocation
        implements Runnable {
            BNanoBaseComponent[] newSubscriptions;
            BNanoBaseComponent[] newUnsubscriptions;

            NanoSubscriptionInvocation(BNanoBaseComponent[] newSubscriptions, BNanoBaseComponent[] newUnsubscriptions) {
                this.newSubscriptions = newSubscriptions;
                this.newUnsubscriptions = newUnsubscriptions;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block5: {
                    try {
                        BNe2DeviceExt.this.doHandleNanoSubscription(this.newSubscriptions);
                        if (this.newUnsubscriptions == null || this.newUnsubscriptions.length <= 0) break block5;
                        List<BNanoBaseComponent> successfullyUnsubscribed = BNe2DeviceExt.this.doHandleNanoUnsubscription(this.newUnsubscriptions);
                        Object object = BNe2DeviceExt.this.subscriptionLock;
                        synchronized (object) {
                            NanoSubscriptionHandler.this.toUnsubscribe.removeAll(successfullyUnsubscribed);
                            NanoSubscriptionHandler.this.removeNonExistingComponents(NanoSubscriptionHandler.this.toUnsubscribe);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }
}

