/*
 * Decompiled with CFR 0.152.
 */
package com.miratech.nE2Link;

import com.miratech.nE2Link.BNanoBaseComponent;
import com.miratech.nE2Link.actions.BNanoLinkInfoArg;
import java.util.logging.Logger;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BLink;
import javax.baja.sys.BObject;
import javax.baja.sys.BStruct;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="sourceComponentNavOrd", type="BOrd", defaultValue="BOrd.NULL"), @NiagaraProperty(name="targetComponentNavOrd", type="BOrd", defaultValue="BOrd.NULL"), @NiagaraProperty(name="sourceSlotName", type="String", defaultValue="\"\""), @NiagaraProperty(name="targetSlotName", type="String", defaultValue="\"\"")})
public class BNiagaraLinkInfo
extends BStruct {
    public static final Property sourceComponentNavOrd = BNiagaraLinkInfo.newProperty((int)0, (BValue)BOrd.NULL, null);
    public static final Property targetComponentNavOrd = BNiagaraLinkInfo.newProperty((int)0, (BValue)BOrd.NULL, null);
    public static final Property sourceSlotName = BNiagaraLinkInfo.newProperty((int)0, (String)"", null);
    public static final Property targetSlotName = BNiagaraLinkInfo.newProperty((int)0, (String)"", null);
    public static final Type TYPE = Sys.loadType(BNiagaraLinkInfo.class);
    public static Logger LOGGER = Logger.getLogger(TYPE.getTypeSpec().getModuleName());

    public BOrd getSourceComponentNavOrd() {
        return (BOrd)this.get(sourceComponentNavOrd);
    }

    public void setSourceComponentNavOrd(BOrd v) {
        this.set(sourceComponentNavOrd, (BValue)v, null);
    }

    public BOrd getTargetComponentNavOrd() {
        return (BOrd)this.get(targetComponentNavOrd);
    }

    public void setTargetComponentNavOrd(BOrd v) {
        this.set(targetComponentNavOrd, (BValue)v, null);
    }

    public String getSourceSlotName() {
        return this.getString(sourceSlotName);
    }

    public void setSourceSlotName(String v) {
        this.setString(sourceSlotName, v, null);
    }

    public String getTargetSlotName() {
        return this.getString(targetSlotName);
    }

    public void setTargetSlotName(String v) {
        this.setString(targetSlotName, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BNiagaraLinkInfo() {
    }

    public BNiagaraLinkInfo(BLink link) {
        this((BNanoBaseComponent)link.getSourceComponent(), link.getSourceSlotName(), (BNanoBaseComponent)link.getTargetComponent(), link.getTargetSlotName());
    }

    public BNiagaraLinkInfo(BNanoBaseComponent sourceComponent, String sourceSlotName, BNanoBaseComponent targetComponent, String targetSlotName) {
        if (sourceComponent != null) {
            this.setSourceComponentNavOrd(sourceComponent.getNavOrd());
        }
        if (targetComponent != null) {
            this.setTargetComponentNavOrd(targetComponent.getNavOrd());
        }
        this.setSourceSlotName(sourceSlotName);
        this.setTargetSlotName(targetSlotName);
    }

    public BNanoBaseComponent getSourceComponent() {
        return (BNanoBaseComponent)this.getSourceComponentNavOrd().resolve((BObject)Sys.getStation()).get();
    }

    public BNanoBaseComponent getTargetComponent() {
        return (BNanoBaseComponent)this.getTargetComponentNavOrd().resolve((BObject)Sys.getStation()).get();
    }

    public BNanoLinkInfoArg toBNanoLinkInfoArg() {
        BNanoBaseComponent sourceComponent = this.getSourceComponent();
        if (sourceComponent == null) {
            return null;
        }
        int sourceComponentId = sourceComponent.getGlobalIndex();
        if (sourceComponentId == -1) {
            return null;
        }
        int sourceSlotId = sourceComponent.getNanoSlotId(this.getSourceSlotName());
        if (sourceSlotId == -1) {
            return null;
        }
        BNanoBaseComponent targetComponent = this.getTargetComponent();
        if (targetComponent == null) {
            return null;
        }
        int targetComponentId = targetComponent.getGlobalIndex();
        if (targetComponentId == -1) {
            return null;
        }
        int targetSlotId = targetComponent.getNanoSlotId(this.getTargetSlotName());
        if (targetSlotId == -1) {
            return null;
        }
        return new BNanoLinkInfoArg(sourceComponentId, sourceSlotId, targetComponentId, targetSlotId);
    }

    public BLink createLinkInNiagara() {
        Property targetSlot;
        BNanoBaseComponent targetComponent;
        Property sourceSlot;
        boolean dataComplete = true;
        BNanoBaseComponent sourceComponent = this.getSourceComponent();
        if (sourceComponent == null) {
            dataComplete = false;
        }
        Property property = sourceSlot = sourceComponent != null ? sourceComponent.getProperty(this.getSourceSlotName()) : null;
        if (sourceSlot == null) {
            dataComplete = false;
        }
        if ((targetComponent = this.getTargetComponent()) == null) {
            dataComplete = false;
        }
        Property property2 = targetSlot = targetComponent != null ? targetComponent.getProperty(this.getTargetSlotName()) : null;
        if (targetSlot == null) {
            dataComplete = false;
        }
        if (dataComplete) {
            return targetComponent.addLink(sourceComponent, (Slot)sourceSlot, (Slot)targetSlot);
        }
        LOGGER.severe(String.format("Failed to create link from '%s/%s' to '%s/%s'", this.getSourceComponentNavOrd(), this.getSourceSlotName(), this.getTargetComponentNavOrd(), this.getTargetSlotName()));
        return null;
    }
}

