/*
 * Decompiled with CFR 0.152.
 */
package com.miratech.nE2Link.choice;

import com.miratech.nE2Link.choice.BDynamicChoice;
import com.miratech.serialization.DataMarker;
import com.miratech.serialization.SerializableForm;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Objects;
import java.util.function.Function;
import java.util.logging.Logger;
import javax.baja.data.BIDataValue;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BDouble;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIBoolean;
import javax.baja.sys.BIEnum;
import javax.baja.sys.BInteger;
import javax.baja.sys.BLong;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.InvalidEnumException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;

@NiagaraType
public final class BDynamicChoiceRange
extends BSimple {
    public static final Logger LOGGER = Logger.getLogger("nE2Link");
    static final BSimple[] noKeys = new BSimple[0];
    static final String[] noTags = new String[0];
    static final HashMap<BSimple, String> noByKey = new HashMap();
    static final HashMap<String, BSimple> noByTag = new HashMap();
    static final String FACET_DISPLAY_NAME_INVALID_KEY = "displayNameInvalidKey";
    static final String LEX_KEY_DYNAMIC_CHOICE = "DynamicChoice.";
    static final String LEX_KEY_EMPTY_DYNAMIC_CHOICE = "DynamicChoice.empty";
    static final String OWNER_PERSISTENT_ID_TAG = "opId";
    static final String OWNER_SLOT_ID_TAG = "osId";
    static final String ID_TAG = "id";
    public static final String FACET_NAME_LEXICON = "lexicon";
    public static final String FACET_NAME_RANGE_AS_SUBFORM = "rangeAsSubform";
    public static final String FACET_VALUE_NANO_TYPE_BOOLEAN = "booleanRange";
    public static final String FACET_VALUE_NANO_TYPE_MULTISTATE = "multistateRange";
    private static final String DEFAULT_DISPLAY_NAME_INVALID_KEY = "null";
    private static final String DEFAULT_LEXICON_NAME = "nE2Link";
    public static final BDynamicChoiceRange NULL = new BDynamicChoiceRange(null, -1, null, noByKey, noByTag, noKeys, "null", 0, BFacets.DEFAULT);
    public static final BDynamicChoiceRange DEFAULT = new BDynamicChoiceRange(null, -1, null, noByKey, noByTag, noKeys, "null", 0, BFacets.DEFAULT);
    private final HashMap<BSimple, String> byKey;
    private final HashMap<String, BSimple> byTag;
    private final BSimple[] keys;
    private final String ownerPersistentId;
    private final int ownerSlotId;
    private final String id;
    private final String displayNameForInvalidKey;
    private final BFacets options;
    private BFacets booleanFacets;
    private BFacets enumFacets;
    private final int flags;
    private final String lexicon;
    private String encodedString;
    private String toString;
    private int hashCode = -1;
    static Comparator<BSimple> compareKeysAscending = (key1, key2) -> {
        String keyStr2;
        if (key1 == null && key2 == null) {
            return 0;
        }
        if (key1 == null && key2 != null) {
            return -1;
        }
        if (key1 != null && key2 == null) {
            return 1;
        }
        BigDecimal keyDec1 = BDynamicChoice.keyToBigDecimal(key1);
        BigDecimal keyDec2 = BDynamicChoice.keyToBigDecimal(key2);
        String keyStr1 = keyDec1 == null ? BDynamicChoice.keyToString(key1) : null;
        String string = keyStr2 = keyDec2 == null ? BDynamicChoice.keyToString(key1) : null;
        if (keyDec1 != null && keyDec2 != null) {
            return keyDec1.compareTo(keyDec2);
        }
        if (keyStr1 != null && keyStr2 != null) {
            return keyStr1.compareTo(keyStr2);
        }
        if (keyDec1 != null && keyStr2 != null) {
            return -1;
        }
        if (keyDec2 != null && keyStr1 != null) {
            return 1;
        }
        throw new IllegalStateException(String.format("not possible to compare key '%s' with key '%s'.", key1, key2));
    };
    static Function<BSimple, Object> simpleToObject = simple -> {
        if (simple.getType().is(BDouble.TYPE)) {
            return ((BDouble)simple).getDouble();
        }
        if (simple.getType().is(BLong.TYPE)) {
            return ((BLong)simple).getLong();
        }
        if (simple.getType().is(BString.TYPE)) {
            return ((BString)simple).getString();
        }
        if (simple.getType().is(BBoolean.TYPE)) {
            return ((BBoolean)simple).getBoolean();
        }
        return null;
    };
    public static final Type TYPE = Sys.loadType(BDynamicChoiceRange.class);

    public Type getType() {
        return TYPE;
    }

    public static BDynamicChoiceRange make(String id) {
        return BDynamicChoiceRange.make(null, -1, id, noKeys, noTags, DEFAULT_DISPLAY_NAME_INVALID_KEY, 0);
    }

    public static BDynamicChoiceRange make(String ownerPersistentId, int ownerSlotId, String id, Object[] keys, String[] tags, String nameForInvalidKey) {
        return BDynamicChoiceRange.make(ownerPersistentId, ownerSlotId, id, keys, tags, nameForInvalidKey, 0, (BFacets)null);
    }

    public static BDynamicChoiceRange make(String ownerPersistentId, int ownerSlotId, String id, Object[] keys, String[] tags, String nameForInvalidKey, int flags) {
        return BDynamicChoiceRange.make(ownerPersistentId, ownerSlotId, id, keys, tags, nameForInvalidKey, flags, (BFacets)null);
    }

    public static BDynamicChoiceRange make(String ownerPersistentId, int ownerSlotId, String id, Object[] keys, String[] tags, String nameForInvalidKey, int flags, String lexiconModuleName) {
        if (lexiconModuleName == null || lexiconModuleName.isEmpty()) {
            return BDynamicChoiceRange.make(ownerPersistentId, ownerSlotId, id, keys, tags, nameForInvalidKey, flags, (BFacets)null);
        }
        return BDynamicChoiceRange.make(ownerPersistentId, ownerSlotId, id, keys, tags, nameForInvalidKey, flags, BFacets.make((String)FACET_NAME_LEXICON, (String)lexiconModuleName));
    }

    private static BDynamicChoiceRange make(String ownerPersistentId, int ownerSlotId, String id, Object[] keys, String[] tags, String displayNameForInvalidKey, int flags, BFacets options) {
        if (options == null) {
            options = BFacets.DEFAULT;
        }
        if (keys == null) {
            keys = noKeys;
        }
        if (tags == null) {
            tags = noTags;
        }
        if (displayNameForInvalidKey == null) {
            displayNameForInvalidKey = DEFAULT_DISPLAY_NAME_INVALID_KEY;
        }
        HashMap<BSimple, String> byKey = new HashMap<BSimple, String>();
        HashMap<String, BSimple> byTag = new HashMap<String, BSimple>();
        ArrayList<BSimple> sortedKeyList = new ArrayList<BSimple>();
        boolean isCalendar = id.equals("calendars");
        for (int i = 0; i < keys.length; ++i) {
            String tag;
            Object obj = keys[i];
            BSimple key = BDynamicChoiceRange.makeKeyFromObject(keys[i]);
            String string = tag = isCalendar && !tags[i].endsWith("_" + key) ? SlotPath.escape((String)(tags[i] + "_" + key)) : SlotPath.escape((String)tags[i]);
            if (byKey.get(key) != null) {
                throw new IllegalArgumentException("Duplicate key[" + i + "]: Tag " + tag + "= Key " + key);
            }
            if (byTag.get(tag) != null) {
                throw new IllegalArgumentException("Duplicate tag[" + i + "]: Tag " + tag + "= Key " + key);
            }
            byKey.put(key, tag);
            byTag.put(tag, key);
            sortedKeyList.add(key);
        }
        sortedKeyList.sort(compareKeysAscending);
        return (BDynamicChoiceRange)new BDynamicChoiceRange(ownerPersistentId, ownerSlotId, id, byKey, byTag, sortedKeyList.toArray(new BSimple[0]), displayNameForInvalidKey, flags, options).intern();
    }

    private BDynamicChoiceRange(String ownerPersistentId, int ownerSlotId, String id, HashMap<BSimple, String> byKey, HashMap<String, BSimple> byTag, BSimple[] sortedKeyList, String displayNameForInvalidKey, int flags, BFacets options) {
        this.ownerPersistentId = ownerPersistentId != null ? ownerPersistentId : "";
        this.ownerSlotId = ownerSlotId;
        this.id = id != null ? id : "";
        this.displayNameForInvalidKey = displayNameForInvalidKey;
        this.flags = flags;
        this.options = options;
        this.byKey = byKey;
        this.byTag = byTag;
        this.keys = sortedKeyList;
        String lex = options.gets(FACET_NAME_LEXICON, null);
        this.lexicon = lex == null ? DEFAULT_LEXICON_NAME : lex;
    }

    public static BSimple makeKeyFromObject(Object key) {
        if (key == null) {
            return null;
        }
        if (key instanceof Double) {
            return BDouble.make((double)((Double)key));
        }
        if (key instanceof Long) {
            return BLong.make((long)((Long)key));
        }
        if (key instanceof String) {
            return BString.make((String)((String)key));
        }
        if (key instanceof Boolean) {
            return BBoolean.make((boolean)((Boolean)key));
        }
        if (key instanceof Integer) {
            return BInteger.make((int)((Integer)key));
        }
        if (key instanceof BigInteger) {
            return BString.make((String)key.toString());
        }
        if (key instanceof BDouble || key instanceof BLong || key instanceof BString || key instanceof BBoolean || key instanceof BInteger) {
            return (BSimple)key;
        }
        throw new IllegalArgumentException("Key for BDynamicChoiceRange must be != null and of type Double, Boolean, Integer or String");
    }

    private static BDouble makeDoubleKey(BSimple key) {
        BDouble dblKey = null;
        if (BBoolean.FALSE.equals((Object)key)) {
            dblKey = BDouble.make((double)0.0);
        } else if (BBoolean.TRUE.equals((Object)key)) {
            dblKey = BDouble.make((double)1.0);
        }
        return dblKey;
    }

    private static boolean isEditable(SerializableForm serializedDynamicChoice, String choiceId) {
        if (!choiceId.contains("labels") || serializedDynamicChoice.data.length < 6) {
            return true;
        }
        return (Boolean)serializedDynamicChoice.data[6];
    }

    public static BDynamicChoiceRange parse(SerializableForm serializedDynamicChoice, String ownerPersistentId) {
        return BDynamicChoiceRange.parse(serializedDynamicChoice, ownerPersistentId, true);
    }

    public static BDynamicChoiceRange parse(SerializableForm serializedDynamicChoice, String ownerPersistentId, boolean log) {
        try {
            int ownerIndex;
            DataMarker marker = serializedDynamicChoice.marker;
            if (marker != DataMarker.DynamicChoice) {
                if (log) {
                    LOGGER.severe(String.format("[DynamicChoiceRange.parse()]: Unexpected Data type: Expected marker: '%s', Received marker: '%s'.\nSkipping data processing.", new Object[]{DataMarker.SlotsValuesData, marker}));
                }
                return null;
            }
            if (ownerPersistentId == null) {
                ownerPersistentId = "";
            }
            if ((ownerIndex = Byte.toUnsignedInt((Byte)serializedDynamicChoice.data[0])) == 255) {
                ownerIndex = -1;
            }
            String id = (String)serializedDynamicChoice.data[1];
            String displayNameForInvalidKey = (String)serializedDynamicChoice.data[2];
            Object[] keys = serializedDynamicChoice.data[3] instanceof Array ? ((Array)serializedDynamicChoice.data[3]).array() : null;
            String[] displayNames = serializedDynamicChoice.data[4] instanceof Array ? (String[])((Array)serializedDynamicChoice.data[4]).array() : null;
            int flags = BDynamicChoiceRange.isEditable(serializedDynamicChoice, id) ? 0 : 1;
            return BDynamicChoiceRange.make(ownerPersistentId, ownerIndex, id, keys, displayNames, displayNameForInvalidKey, flags);
        }
        catch (Exception e) {
            if (log) {
                LOGGER.severe(String.format("[DynamicChoiceRange.parse()]: Failed to parse dynamic choice data. Skipping data processing.\nException: %s\nStacktrace: %s", e.getMessage(), e.getStackTrace()));
            }
            return null;
        }
    }

    public String getLexiconModuleName() {
        return this.lexicon;
    }

    public BSimple[] getKeys() {
        return this.keys;
    }

    public boolean isKey(BSimple key) {
        return this.byKey.get(key) != null;
    }

    public boolean isKey(Object key) {
        try {
            return this.isKey(BDynamicChoiceRange.makeKeyFromObject(key));
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public String getTag(BSimple key) {
        String tag = this.byKey.get(key);
        if (tag == null) {
            tag = this.byKey.get(BDynamicChoiceRange.makeDoubleKey(key));
        }
        return tag;
    }

    public String getTag(Object key) {
        String tag = null;
        try {
            tag = this.getTag(BDynamicChoiceRange.makeKeyFromObject(key));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return tag;
    }

    public String getDisplayTag(Object key, Context cx) {
        try {
            return this.getDisplayTag(BDynamicChoiceRange.makeKeyFromObject(key), cx);
        }
        catch (IllegalArgumentException e) {
            return this.displayNameForInvalidKey;
        }
    }

    public String getDisplayTag(BSimple key, Context cx) {
        Lexicon lex = Lexicon.make((String)this.lexicon, (Context)cx);
        if (key == null) {
            return this.displayNameForInvalidKey;
        }
        if (this.byKey.size() == 0 && key != null) {
            return key.toString(cx);
        }
        String tag = this.byKey.get(key);
        if (tag == null && key instanceof BBoolean) {
            BDouble dblKey = BDynamicChoiceRange.makeDoubleKey(key);
            tag = this.byKey.get(dblKey);
        }
        if (tag != null) {
            String lexKey = LEX_KEY_DYNAMIC_CHOICE + (!this.getId().isEmpty() ? this.getId() + "." : "") + tag;
            String lexDisplayName = lex.get(lexKey, null);
            return lexDisplayName != null ? lexDisplayName : SlotPath.unescape((String)tag);
        }
        return this.displayNameForInvalidKey;
    }

    public boolean isTag(String tag) {
        return this.byTag.get(tag) != null;
    }

    public String getGenuineId() {
        return null == this.id || this.id.isEmpty() ? String.valueOf(this.ownerSlotId) : this.id;
    }

    public String getOwnerPersistentId() {
        return this.ownerPersistentId;
    }

    public int getOwnerSlotId() {
        return this.ownerSlotId;
    }

    public String getId() {
        return this.id;
    }

    public String getDisplayNameForInvalidKey() {
        return this.displayNameForInvalidKey;
    }

    public int getFlags() {
        return this.flags;
    }

    public boolean isReadOnly() {
        return (this.getFlags() & 1) != 0;
    }

    public BDynamicChoice getChoiceForKey(Object key) {
        return BDynamicChoice.make(key, this);
    }

    public BDynamicChoice getChoiceForKey(BSimple key) {
        return BDynamicChoice.make(key, this);
    }

    public BDynamicChoice getChoiceForTag(String tag) {
        if (this.byTag.get(tag) != null) {
            return BDynamicChoice.make(this.byTag.get(tag), this);
        }
        throw new InvalidEnumException(tag);
    }

    public BFacets getOptions() {
        return this.options;
    }

    public static boolean isKeyEmpty(Object key) {
        if (key == null) {
            return true;
        }
        if (key instanceof String) {
            return ((String)key).isEmpty();
        }
        if (key instanceof BString) {
            return ((BString)key).getString().isEmpty();
        }
        return false;
    }

    public static boolean isKeyValid(Object key) {
        return key instanceof BString || key instanceof BDouble || key instanceof BBoolean || key instanceof String || key instanceof Double || key instanceof Boolean;
    }

    public static void validateKey(Object key) {
        if (key == null) {
            throw new IllegalArgumentException("Invalid null key: key= null");
        }
        if (!BDynamicChoiceRange.isKeyValid(key)) {
            throw new IllegalArgumentException("Invalid key type: key= " + key + " [" + key.getClass() + "]");
        }
    }

    public int length() {
        return this.keys.length;
    }

    public boolean isNull() {
        return this.keys.length == 0;
    }

    public int hashCode() {
        try {
            if (this.hashCode == -1) {
                this.hashCode = this.encodeToString().hashCode();
            }
            return this.hashCode;
        }
        catch (Exception e) {
            return System.identityHashCode((Object)this);
        }
    }

    public boolean equals(Object o) {
        if (o instanceof BDynamicChoiceRange) {
            BDynamicChoiceRange x = (BDynamicChoiceRange)((Object)o);
            return this.byKey.equals(x.byKey) && Objects.equals(this.ownerPersistentId, x.ownerPersistentId) && this.ownerSlotId == x.ownerSlotId && Objects.equals(this.id, x.id) && this.displayNameForInvalidKey.equals(x.displayNameForInvalidKey) && Objects.equals(this.lexicon, x.lexicon);
        }
        return false;
    }

    public String toString(Context context) {
        try {
            if (this.toString == null) {
                StringBuilder s = new StringBuilder("{");
                for (int i = 0; i < this.keys.length; ++i) {
                    BSimple key = this.keys[i];
                    if (i > 0) {
                        s.append(',');
                    }
                    s.append(key.encodeToString()).append('=').append(this.getDisplayTag(key, context));
                }
                s.append('}');
                this.toString = s.toString();
            }
            return this.toString;
        }
        catch (IOException e) {
            return super.toString(context);
        }
    }

    public void encode(DataOutput out) throws IOException {
        out.writeUTF(this.encodeToString());
    }

    public BDynamicChoiceRange decode(DataInput in) throws IOException {
        return this.decodeFromString(in.readUTF());
    }

    public String encodeToString() throws IOException {
        if (this.encodedString == null) {
            StringBuilder s = new StringBuilder();
            s.append(OWNER_SLOT_ID_TAG).append('=').append(String.valueOf(this.ownerSlotId));
            if (this.id != null && !this.id.isEmpty()) {
                s.append(';').append(ID_TAG).append('=').append(this.id);
            }
            if (this.ownerPersistentId != null && !this.ownerPersistentId.isEmpty()) {
                s.append(';').append(OWNER_PERSISTENT_ID_TAG).append('=').append(this.ownerPersistentId);
            }
            s.append('{');
            for (int i = 0; i < this.keys.length; ++i) {
                BSimple key = this.keys[i];
                String tag = this.byKey.get(key);
                if (i > 0) {
                    s.append(',');
                }
                s.append(tag).append('=').append(key.encodeToString()).append("[").append(key.getType().getTypeSpec().encodeToString()).append("]");
            }
            s.append('}');
            s.append('!');
            s.append(this.displayNameForInvalidKey);
            if (!this.options.isNull() || this.flags != 0) {
                s.append('?');
                if (!this.options.isNull()) {
                    s.append("x=\"").append(this.options.encodeToString()).append("\"");
                    if (this.flags != 0) {
                        s.append(",");
                    }
                }
                if (this.flags != 0) {
                    s.append("f=\"").append(Flags.encodeToString((int)this.flags)).append("\"");
                }
            }
            this.encodedString = s.toString();
        }
        return this.encodedString;
    }

    public static BSimple decodeKeyFromString(String keyStr) throws IOException {
        BSimple key = null;
        String[] valueType = keyStr.split("\\[");
        IOException malformedKey = new IOException("Malformed format for key '" + keyStr + "'. Expected: key[BTypeSpec]");
        if (valueType.length != 2) {
            throw malformedKey;
        }
        String valueStr = valueType[0];
        String datatype = valueType[1];
        if (!datatype.endsWith("]")) {
            throw malformedKey;
        }
        datatype = datatype.substring(0, datatype.length() - 1);
        try {
            BTypeSpec typeSpec = BTypeSpec.make((String)datatype);
            if (!typeSpec.equals((Object)BTypeSpec.NULL)) {
                key = (BSimple)typeSpec.getInstance();
                key = valueStr != DEFAULT_DISPLAY_NAME_INVALID_KEY ? (BSimple)key.decodeFromString(valueStr) : null;
                return key;
            }
            throw new IOException("Invalid TypeSpec for key '" + keyStr + "'");
        }
        catch (RuntimeException e) {
            throw new IOException(e);
        }
    }

    public BDynamicChoiceRange decodeFromString(String s) throws IOException {
        try {
            if (s.equals("osId=-1{}!")) {
                return NULL;
            }
            if (s.equals("osId=-1{}!null")) {
                return DEFAULT;
            }
            BFacets facets = null;
            int flags = 0;
            int question = s.lastIndexOf(63);
            if (question > 0) {
                String[] options;
                for (String option : options = s.substring(question + 1).split(",")) {
                    System.out.println("DYNAMIC CHOICE OPTION: " + option);
                    option = option.replaceAll("\"", "");
                    if (option.startsWith("f=")) {
                        option = option.replaceFirst("f=", "");
                        flags = Flags.decodeFromString((String)option);
                        continue;
                    }
                    if (!option.startsWith("x=")) continue;
                    option = option.replaceFirst("x=", "");
                    facets = BFacets.make((String)option);
                }
                s = s.substring(0, question);
            }
            String displayNameForInvalidKey = "";
            int exclamation = s.lastIndexOf(33);
            if (exclamation <= 0) {
                throw new IOException("Missing ! in serialized BDynamicChoiceRange");
            }
            displayNameForInvalidKey = exclamation < s.length() - 1 ? s.substring(exclamation + 1) : "";
            s = s.substring(0, exclamation);
            int ownerSlotId = -1;
            String id = "";
            String ownerPersistentId = "";
            int openingBrace = s.indexOf(123);
            if (openingBrace > 0) {
                String ids = s.substring(0, openingBrace);
                String[] idTokenArray = ids.split(";");
                if (idTokenArray.length < 1) {
                    throw new IOException("Missing ownerSlotId in serialized BDynamicChoiceRange");
                }
                block16: for (String idToken : idTokenArray) {
                    String[] idKeyValue = idToken.split("=");
                    switch (idKeyValue[0]) {
                        case "id": {
                            id = idKeyValue[1];
                            continue block16;
                        }
                        case "osId": {
                            try {
                                ownerSlotId = Integer.parseInt(idKeyValue[1]);
                                continue block16;
                            }
                            catch (Exception e) {
                                throw new IOException("Failed parsing ownerSlotId into integer", e);
                            }
                        }
                        case "opId": {
                            ownerPersistentId = idKeyValue[1];
                            continue block16;
                        }
                        default: {
                            throw new IOException("Invalid id tag in serialized BDynamicChoiceRange");
                        }
                    }
                }
            } else {
                throw new IOException("Missing opening delimiter '{' for key/value pairs in serialized BDynamicChoiceRange");
            }
            s = s.substring(openingBrace);
            if (s.charAt(s.length() - 1) != '}') {
                throw new IOException("Missing closing delimiter '}' for key/value pairs in serialized BDynamicChoiceRange");
            }
            s = s.substring(1, s.length() - 1).trim();
            Object[] keys = null;
            String[] tags = null;
            if (!s.isEmpty()) {
                String[] pairs = s.split(",");
                keys = new BSimple[pairs.length];
                tags = new String[pairs.length];
                for (int i = 0; i < pairs.length; ++i) {
                    BSimple key;
                    String[] pair = pairs[i].split("=");
                    if (pair.length != 2) {
                        throw new IOException("Malformed 'value=key' pairs in serialized BDynamicChoiceRange");
                    }
                    tags[i] = SlotPath.unescape((String)pair[0]);
                    if (id.equals("labels") && pair[1].contains("baja:Integer")) {
                        pair[1] = pair[1].replace("[baja:Integer]", ".0[baja:Double]");
                    }
                    if ((key = BDynamicChoiceRange.decodeKeyFromString(pair[1])) == null) {
                        throw new IOException("Illegal null key in serialized BDynamicChoiceRange");
                    }
                    keys[i] = key;
                }
            }
            return BDynamicChoiceRange.make(ownerPersistentId, ownerSlotId, id, keys, tags, displayNameForInvalidKey, flags, facets);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOException(s);
        }
    }

    public SerializableForm getSerializableForm() {
        return this.getSerializableForm(null);
    }

    public SerializableForm getSerializableForm(String ownerPersistentId) {
        return this.getSerializableForm(ownerPersistentId, false);
    }

    public SerializableForm getSerializableForm(String ownerPersistentId, boolean createReadOnlyInfo) {
        Object[] objectArraySortedKeys = Arrays.stream(this.getKeys()).sorted(compareKeysAscending).map(simpleToObject).toArray();
        Object[] stringArrayTags = (String[])Arrays.stream(objectArraySortedKeys).map(key -> this.getDisplayTag(key, null)).toArray(String[]::new);
        Array keysArray = new Array(Object.class, objectArraySortedKeys.length);
        keysArray.addAll(objectArraySortedKeys);
        Array displayNamesArray = new Array(String.class, objectArraySortedKeys.length);
        displayNamesArray.addAll(stringArrayTags);
        BigInteger persistentId = ownerPersistentId == null || ownerPersistentId.isEmpty() ? BigInteger.ZERO : new BigInteger(ownerPersistentId);
        SerializableForm serializedDynamicChoiceRange = null;
        serializedDynamicChoiceRange = !createReadOnlyInfo ? new SerializableForm(DataMarker.DynamicChoice, new Object[]{(byte)this.getOwnerSlotId(), this.getId(), this.displayNameForInvalidKey, keysArray, displayNamesArray, persistentId}) : new SerializableForm(DataMarker.DynamicChoice, new Object[]{(byte)this.getOwnerSlotId(), this.getId(), this.displayNameForInvalidKey, keysArray, displayNamesArray, persistentId, !this.isReadOnly()});
        return serializedDynamicChoiceRange;
    }

    public BFacets asFacets(Type facetType, Context cx) {
        BSimple[] keys = this.getKeys();
        if (facetType.is(BIBoolean.TYPE)) {
            if (this.booleanFacets != null) {
                return this.booleanFacets;
            }
            String trueText = "true";
            String falseText = "false";
            for (BSimple key : keys) {
                if (key.getType().is(BDouble.TYPE)) {
                    if (((BDouble)key).getNumeric() == 1.0) {
                        trueText = this.getDisplayTag(key, cx);
                        continue;
                    }
                    if (((BDouble)key).getNumeric() != 0.0) continue;
                    falseText = this.getDisplayTag(key, cx);
                    continue;
                }
                if (!key.getType().is(BIBoolean.TYPE)) continue;
                if (((BIBoolean)key).getBoolean()) {
                    trueText = this.getDisplayTag(key, cx);
                    continue;
                }
                falseText = this.getDisplayTag(key, cx);
            }
            this.booleanFacets = BFacets.make((BFacets)BFacets.makeBoolean((String)trueText, (String)falseText), (String)FACET_DISPLAY_NAME_INVALID_KEY, (BIDataValue)BString.make((String)this.displayNameForInvalidKey));
            return this.booleanFacets;
        }
        if (facetType.is(BIEnum.TYPE)) {
            if (this.enumFacets != null) {
                return this.enumFacets;
            }
            String[] tagsArray = new String[keys.length];
            for (int i = 0; i < keys.length; ++i) {
                tagsArray[i] = this.getTag(keys[i]);
            }
            int[] keyArray = Arrays.stream(keys).filter(e -> e.getType().is(BDouble.TYPE)).mapToInt(e -> ((BDouble)e).getInt()).toArray();
            BEnumRange range = BEnumRange.make((int[])keyArray, (String[])tagsArray);
            this.enumFacets = this.enumFacets = BFacets.make((BFacets)BFacets.makeEnum((BEnumRange)range), (String)FACET_DISPLAY_NAME_INVALID_KEY, (BIDataValue)BString.make((String)this.displayNameForInvalidKey));
            return this.enumFacets;
        }
        return BFacets.NULL;
    }
}

